/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.backend;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jangaroo.jooc.CodeGenerator;
import net.jangaroo.jooc.Debug;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.SyntacticKeywords;
import net.jangaroo.jooc.ast.Annotation;
import net.jangaroo.jooc.ast.AnnotationParameter;
import net.jangaroo.jooc.ast.ApplyExpr;
import net.jangaroo.jooc.ast.ArrayIndexExpr;
import net.jangaroo.jooc.ast.ArrayLiteral;
import net.jangaroo.jooc.ast.AsExpr;
import net.jangaroo.jooc.ast.AssignmentOpExpr;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.BlockStatement;
import net.jangaroo.jooc.ast.BreakStatement;
import net.jangaroo.jooc.ast.CaseStatement;
import net.jangaroo.jooc.ast.Catch;
import net.jangaroo.jooc.ast.ClassBody;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.ContinueStatement;
import net.jangaroo.jooc.ast.Declaration;
import net.jangaroo.jooc.ast.DefaultStatement;
import net.jangaroo.jooc.ast.Directive;
import net.jangaroo.jooc.ast.DoStatement;
import net.jangaroo.jooc.ast.DotExpr;
import net.jangaroo.jooc.ast.EmptyDeclaration;
import net.jangaroo.jooc.ast.EmptyStatement;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.Extends;
import net.jangaroo.jooc.ast.ForInStatement;
import net.jangaroo.jooc.ast.ForInitializer;
import net.jangaroo.jooc.ast.ForStatement;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.FunctionExpr;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.IdeExpr;
import net.jangaroo.jooc.ast.IdeWithTypeParam;
import net.jangaroo.jooc.ast.IfStatement;
import net.jangaroo.jooc.ast.Implements;
import net.jangaroo.jooc.ast.ImportDirective;
import net.jangaroo.jooc.ast.InfixOpExpr;
import net.jangaroo.jooc.ast.Initializer;
import net.jangaroo.jooc.ast.LabeledStatement;
import net.jangaroo.jooc.ast.LiteralExpr;
import net.jangaroo.jooc.ast.NamespaceDeclaration;
import net.jangaroo.jooc.ast.NamespacedIde;
import net.jangaroo.jooc.ast.NewExpr;
import net.jangaroo.jooc.ast.ObjectField;
import net.jangaroo.jooc.ast.ObjectLiteral;
import net.jangaroo.jooc.ast.PackageDeclaration;
import net.jangaroo.jooc.ast.Parameter;
import net.jangaroo.jooc.ast.Parameters;
import net.jangaroo.jooc.ast.ParenthesizedExpr;
import net.jangaroo.jooc.ast.QualifiedIde;
import net.jangaroo.jooc.ast.ReturnStatement;
import net.jangaroo.jooc.ast.SemicolonTerminatedStatement;
import net.jangaroo.jooc.ast.Statement;
import net.jangaroo.jooc.ast.SuperConstructorCallStatement;
import net.jangaroo.jooc.ast.SwitchStatement;
import net.jangaroo.jooc.ast.ThrowStatement;
import net.jangaroo.jooc.ast.TryStatement;
import net.jangaroo.jooc.ast.Type;
import net.jangaroo.jooc.ast.TypeRelation;
import net.jangaroo.jooc.ast.Typed;
import net.jangaroo.jooc.ast.UseNamespaceDirective;
import net.jangaroo.jooc.ast.VariableDeclaration;
import net.jangaroo.jooc.ast.VectorLiteral;
import net.jangaroo.jooc.ast.WhileStatement;
import net.jangaroo.jooc.backend.ApiModelGenerator;
import net.jangaroo.jooc.backend.CodeGeneratorBase;
import net.jangaroo.jooc.config.DebugMode;
import net.jangaroo.jooc.config.JoocConfiguration;
import net.jangaroo.jooc.json.Code;
import net.jangaroo.jooc.json.JsonArray;
import net.jangaroo.jooc.json.JsonObject;
import net.jangaroo.jooc.model.AnnotationModel;
import net.jangaroo.jooc.model.AnnotationPropertyModel;
import net.jangaroo.jooc.model.CompilationUnitModel;
import net.jangaroo.jooc.model.FieldModel;
import net.jangaroo.jooc.model.MemberModel;
import net.jangaroo.jooc.model.MethodModel;
import net.jangaroo.jooc.model.MethodType;
import net.jangaroo.jooc.model.PropertyModel;
import net.jangaroo.jooc.mxml.MxmlUtils;
import net.jangaroo.jooc.util.MessageFormat;
import net.jangaroo.utils.CompilerUtils;

public class JsCodeGenerator
extends CodeGeneratorBase {
    private static final JooSymbol SYM_VAR = new JooSymbol(38, "var");
    private static final JooSymbol SYM_SEMICOLON = new JooSymbol(71, ";");
    private static final JooSymbol SYM_LBRACE = new JooSymbol(90, "{");
    private static final JooSymbol SYM_RBRACE = new JooSymbol(91, "}");
    public static final Set<String> PRIMITIVES = new HashSet<String>(4);
    public static final List<String> ANNOTATIONS_TO_TRIGGER_AT_RUNTIME = Arrays.asList("SWF", "ExtConfig");
    public static final List<String> ANNOTATIONS_FOR_COMPILER_ONLY = Arrays.asList("Embed", "Native", "Accessor");
    public static final String DEFAULT_ANNOTATION_PARAMETER_NAME = "";
    public static final String PROPERTIES_CLASS_SUFFIX = "_properties";
    private boolean expressionMode = false;
    private Map<String, String> imports = new HashMap<String, String>();
    private ClassDefinitionBuilder primaryClassDefinitionBuilder = new ClassDefinitionBuilder();
    private int staticCodeCounter = 0;
    private ClassDefinitionBuilder secondaryClassDefinitionBuilder;
    private CompilationUnit compilationUnit;
    private LinkedList<Metadata> currentMetadata = new LinkedList();
    private final MessageFormat VAR_$NAME_EQUALS_ARGUMENTS_SLICE_$INDEX = new MessageFormat("var {0}=Array.prototype.slice.call(arguments{1,choice,0#|0<,{1}});");
    private final MessageFormat COMPILATION_UNIT_ACCESS_MESSAGE_FORMAT = new MessageFormat("{0}._");
    private final CodeGenerator ARGUMENT_TO_ARRAY_CODE_GENERATOR = new CodeGenerator(){

        @Override
        public void generate(JsWriter out, boolean first) throws IOException {
            JsCodeGenerator.this.generateToArrayCode("arguments", 0);
        }
    };
    private final MessageFormat IF_ARGUMENT_LENGTH_LTE_$N = new MessageFormat("if(arguments.length<={0})");
    private final MessageFormat SWITCH_$INDEX = new MessageFormat("switch({0,choice,0#arguments.length|0<Math.max(arguments.length,{0})})");
    private final MessageFormat CASE_$N = new MessageFormat("case {0}:");
    private static final CodeGenerator ALIAS_THIS_CODE_GENERATOR;

    private void generateToArrayCode(String paramName, int paramIndex) throws IOException {
        this.out.write(this.VAR_$NAME_EQUALS_ARGUMENTS_SLICE_$INDEX.format(paramName, paramIndex));
    }

    public JsCodeGenerator(JsWriter out) {
        super(out);
    }

    private Map<String, PropertyDefinition> membersOrStaticMembers(Declaration memberDeclaration) {
        ClassDefinitionBuilder classDefinitionBuilder = this.getClassDefinitionBuilder(memberDeclaration);
        return memberDeclaration.isStatic() ? classDefinitionBuilder.staticMembers : classDefinitionBuilder.members;
    }

    private ClassDefinitionBuilder getClassDefinitionBuilder(Declaration memberDeclaration) {
        return memberDeclaration.getClassDeclaration() == null || memberDeclaration.getClassDeclaration().isPrimaryDeclaration() ? this.primaryClassDefinitionBuilder : this.secondaryClassDefinitionBuilder;
    }

    private static boolean isAssignmentLHS(Ide ide) {
        AstNode containingExpr;
        AstNode parentNode = ide.getParentNode();
        if ((parentNode instanceof IdeExpr || parentNode instanceof DotExpr && ((DotExpr)parentNode).getIde() == ide) && (containingExpr = parentNode.getParentNode()) instanceof AssignmentOpExpr) {
            Expr arg1 = ((AssignmentOpExpr)containingExpr).getArg1();
            if (arg1 instanceof IdeExpr) {
                arg1 = ((IdeExpr)arg1).getNormalizedExpr();
            }
            if (arg1 == parentNode) {
                return true;
            }
        }
        return false;
    }

    private String compilationUnitAccessCode(IdeDeclaration primaryDeclaration) {
        if (primaryDeclaration.getCompilationUnit() == this.compilationUnit) {
            return primaryDeclaration.getName();
        }
        String primaryDeclarationName = this.imports.get(primaryDeclaration.getQualifiedNameStr());
        Debug.assertTrue(primaryDeclarationName != null, "QName not found in imports: " + primaryDeclaration.getQualifiedNameStr());
        return primaryDeclarationName;
    }

    @Override
    public void visitDotExpr(DotExpr dotExpr) throws IOException {
        IdeDeclaration type;
        IdeDeclaration memberDeclaration = null;
        Expr arg = dotExpr.getArg();
        JooSymbol symDot = dotExpr.getOp();
        Ide ide = dotExpr.getIde();
        if (arg instanceof IdeExpr) {
            arg = ((IdeExpr)arg).getNormalizedExpr();
        }
        if ((type = arg.getType()) == null && arg instanceof IdeExpr) {
            Ide argIde = ((IdeExpr)arg).getIde();
            IdeDeclaration ideDeclaration = argIde.getDeclaration(false);
            if (ideDeclaration instanceof ClassDeclaration) {
                memberDeclaration = ((ClassDeclaration)ideDeclaration).getStaticMemberDeclaration(ide.getName());
            } else {
                type = ideDeclaration;
            }
        }
        if (type != null) {
            memberDeclaration = Ide.resolveMember(type, ide);
        }
        String memberName = ide.getName();
        if (memberDeclaration != null && memberDeclaration.isPrivateStatic()) {
            this.out.beginComment();
            arg.visit(this);
            this.out.writeSymbol(symDot);
            this.out.endComment();
            this.writeSymbolReplacement(ide.getIde(), memberName + "$static");
            return;
        }
        if (memberDeclaration != null && JsCodeGenerator.usePrivateMemberName(ide, memberDeclaration)) {
            memberName = memberName + "$" + ide.getScope().getClassDeclaration().getInheritanceLevel();
        }
        String separatorToken = ".";
        String closingToken = DEFAULT_ANNOTATION_PARAMETER_NAME;
        if (ide.isBound()) {
            this.out.writeToken("AS3.bind(");
            separatorToken = ",";
            memberName = CompilerUtils.quote((String)memberName);
            closingToken = ")";
        } else if (memberDeclaration != null && !JsCodeGenerator.isAssignmentLHS(ide)) {
            String bindableEvent;
            String getter = JsCodeGenerator.resolveAccessor(ide, MethodType.GET, memberDeclaration.getClassDeclaration());
            if (getter != null) {
                memberName = getter;
                closingToken = "()";
            }
            if ((bindableEvent = this.resolveBindable(ide, MethodType.GET, memberDeclaration.getClassDeclaration())) != null) {
                this.out.writeToken("AS3.getBindable(");
                memberName = CompilerUtils.quote((String)memberName);
                separatorToken = ",";
                closingToken = "," + CompilerUtils.quote((String)bindableEvent) + ")";
            }
        } else if (memberName.startsWith("@")) {
            separatorToken = "[";
            memberName = CompilerUtils.quote((String)memberName);
            closingToken = "]";
        }
        arg.visit(this);
        this.writeSymbolReplacement(symDot, separatorToken);
        this.writeSymbolReplacement(ide.getIde(), memberName);
        if (!closingToken.isEmpty()) {
            this.out.writeToken(closingToken);
        }
    }

    private static boolean usePrivateMemberName(Ide ide, IdeDeclaration memberDeclaration) {
        return ide.isQualifiedBySuper() && ide.getScope().getClassDeclaration().getMemberDeclaration(ide.getName()) != null || memberDeclaration.isPrivate();
    }

    @Override
    public void visitTypeRelation(TypeRelation typeRelation) throws IOException {
        this.out.beginCommentWriteSymbol(typeRelation.getSymRelation());
        typeRelation.getType().getIde().visit(this);
        this.out.endComment();
    }

    @Override
    public void visitAnnotationParameter(AnnotationParameter annotationParameter) throws IOException {
        Object value;
        String name;
        Ide optName = annotationParameter.getOptName();
        this.visitIfNotNull(optName);
        this.writeOptSymbol(annotationParameter.getOptSymEq());
        AstNode optValue = annotationParameter.getValue();
        this.visitIfNotNull(optValue);
        String string = name = optName == null ? DEFAULT_ANNOTATION_PARAMETER_NAME : optName.getName();
        if (optValue instanceof LiteralExpr) {
            value = ((LiteralExpr)optValue).getValue().getJooValue();
        } else if (optValue instanceof Ide) {
            IdeDeclaration ideDeclaration = ((Ide)optValue).getDeclaration();
            value = JsonObject.code(this.compilationUnitAccessCode(ideDeclaration));
        } else {
            value = null;
        }
        this.currentMetadata.getLast().args.add(new MetadataArgument(name, value));
    }

    @Override
    public void visitExtends(Extends anExtends) throws IOException {
        this.out.writeSymbol(anExtends.getSymExtends());
        anExtends.getSuperClass().visit(this);
    }

    @Override
    public void visitInitializer(Initializer initializer) throws IOException {
        this.out.writeSymbol(initializer.getSymEq());
        initializer.getValue().visit(this);
    }

    @Override
    public void visitObjectField(ObjectField objectField) throws IOException {
        objectField.getLabel().visit(this);
        this.out.writeSymbol(objectField.getSymColon());
        objectField.getValue().visit(this);
    }

    @Override
    public void visitForInitializer(ForInitializer forInitializer) throws IOException {
        if (forInitializer.getDecl() != null) {
            forInitializer.getDecl().visit(this);
        } else {
            this.visitIfNotNull(forInitializer.getExpr());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitCompilationUnit(CompilationUnit compilationUnit) throws IOException {
        void var6_17;
        IdeDeclaration primaryDeclaration = compilationUnit.getPrimaryDeclaration();
        boolean isInterface = primaryDeclaration instanceof ClassDeclaration && ((ClassDeclaration)primaryDeclaration).isInterface();
        this.out.write("define(\"");
        this.out.write(JsCodeGenerator.getModuleName(compilationUnit));
        this.out.write("\",[\"module\",");
        if (!isInterface) {
            this.out.write("\"exports\",");
        }
        this.out.write("\"as3-rt/AS3\"");
        Map<String, String> amdNameToVar = this.collectDependencies(compilationUnit);
        for (String string : amdNameToVar.keySet()) {
            this.out.write("," + CompilerUtils.quote((String)string));
        }
        for (String string : compilationUnit.getResourceDependencies()) {
            this.out.write(",\"" + string + "\"");
        }
        for (Annotation annotation : compilationUnit.getAnnotations()) {
            if (!"ResourceBundle".equals(annotation.getMetaName())) continue;
            AstNode bundleNameNode = annotation.getValue();
            if (bundleNameNode instanceof LiteralExpr) {
                String bundleName = ((LiteralExpr)bundleNameNode).getValue().getJooValue().toString();
                this.out.write(String.format(",\"bundle!%s\"", bundleName));
                continue;
            }
            Jooc.warning(annotation.getSymbol(), "[ResourceBundle] annotation without value; ignored.");
        }
        for (String string : compilationUnit.getUsedAnnotations()) {
            if (!ANNOTATIONS_TO_TRIGGER_AT_RUNTIME.contains(string)) continue;
            this.out.write(",\"metadata/" + string + "\"");
        }
        this.out.write("], function($module,");
        if (!isInterface) {
            this.out.write("$exports,");
        }
        this.out.write("AS3");
        for (String string : amdNameToVar.values()) {
            this.out.write("," + string);
        }
        int resourceDependencyCount = compilationUnit.getResourceDependencies().size();
        boolean bl = false;
        while (var6_17 < resourceDependencyCount) {
            this.out.write(",$resource_" + (int)var6_17);
            ++var6_17;
        }
        this.out.write(") { ");
        if (isInterface) {
            this.out.write("return AS3.interface_($module,");
        } else {
            this.out.write("AS3.compilationUnit($module,$exports,function($primaryDeclaration){");
        }
        this.compilationUnit = compilationUnit;
        this.out.beginComment();
        compilationUnit.getPackageDeclaration().visit(this);
        this.out.writeSymbol(compilationUnit.getLBrace());
        this.visitAll(compilationUnit.getDirectives());
        this.out.endComment();
        primaryDeclaration.visit(this);
        this.out.beginComment();
        this.out.writeSymbol(compilationUnit.getRBrace());
        this.out.write("\n");
        this.out.endComment();
        if (primaryDeclaration instanceof ClassDeclaration) {
            ClassDeclaration classDeclaration = (ClassDeclaration)primaryDeclaration;
            this.out.beginComment();
            this.out.write("\n============================================== Jangaroo part ==============================================");
            this.out.endComment();
            if (isInterface) {
                JsonObject interfaceDefinition = this.createInterfaceDefinition(classDeclaration);
                this.out.write("\n" + interfaceDefinition.toString(2, 0) + "\n);});\n");
                return;
            }
            ClassDefinitionBuilder classDefinitionBuilder = this.primaryClassDefinitionBuilder;
            JsonObject classDefinition = this.createClassDefinition(classDeclaration, classDefinitionBuilder);
            this.out.write("\n    $primaryDeclaration(AS3.class_($module, " + classDefinition.toString(2, 4) + "));\n");
            ClassDeclaration superTypeDeclaration = classDeclaration.getSuperTypeDeclaration();
            if (superTypeDeclaration != null && superTypeDeclaration.getCompilationUnit().getAnnotation("Native") != null && (superTypeDeclaration.getQualifiedNameStr().startsWith("com.sencha.") || superTypeDeclaration.getQualifiedNameStr().startsWith("ext."))) {
                this.out.write("    Super=Super.prototype.constructor;\n");
            }
            this.out.write(classDefinitionBuilder.staticCode.toString());
        } else {
            this.out.write("\n");
        }
        this.out.write("  });\n");
        this.out.write("});\n");
    }

    private JsonObject createInterfaceDefinition(ClassDeclaration interfaceDeclaration) {
        JsonObject interfaceDefinition = new JsonObject(new Object[0]);
        this.addOptImplements(interfaceDeclaration, interfaceDefinition);
        return interfaceDefinition;
    }

    private void addOptImplements(ClassDeclaration classDeclaration, JsonObject classDefinition) {
        Implements optImplements = classDeclaration.getOptImplements();
        if (optImplements != null) {
            ArrayList<Code> superInterfaces = new ArrayList<Code>();
            for (CommaSeparatedList<Ide> superTypes = optImplements.getSuperTypes(); superTypes != null; superTypes = superTypes.getTail()) {
                IdeDeclaration superInterface = superTypes.getHead().getDeclaration(false);
                if (superInterface == null) {
                    System.err.println("ignoring unresolvable interface " + superTypes.getHead().getQualifiedNameStr());
                    continue;
                }
                superInterfaces.add(JsonObject.code(this.compilationUnitAccessCode(superInterface)));
            }
            classDefinition.set(classDeclaration.isInterface() ? "extends_" : "implements_", new JsonArray(superInterfaces.toArray()));
        }
    }

    private Map<String, String> collectDependencies(CompilationUnit compilationUnit) throws IOException {
        Set<String> useQName = this.computeUseQName(compilationUnit);
        IdeDeclaration primaryDeclaration = compilationUnit.getPrimaryDeclaration();
        ArrayList<CompilationUnit> dependentCompilationUnits = new ArrayList<CompilationUnit>(compilationUnit.getDependenciesAsCompilationUnits());
        String qCUName = primaryDeclaration.getQualifiedNameStr();
        LinkedHashMap<String, String> amdMapping = new LinkedHashMap<String, String>();
        for (CompilationUnit dependentCU : dependentCompilationUnits) {
            IdeDeclaration dependentDeclaration = dependentCU.getPrimaryDeclaration();
            String qName = dependentDeclaration.getQualifiedNameStr();
            String amdName = JsCodeGenerator.computeAmdName(dependentCU);
            String amdVar = null;
            if (amdName != null) {
                if (qName.endsWith(PROPERTIES_CLASS_SUFFIX) && !qCUName.startsWith(qName)) {
                    amdName = "localize!" + amdName;
                }
                amdVar = (String)amdMapping.get(amdName);
            }
            String importedName = null;
            String dependentDeclarationQName = dependentDeclaration.getQualifiedNameStr();
            Annotation nativeAnnotation = dependentCU.getAnnotation("Native");
            if (nativeAnnotation != null) {
                importedName = (String)JsCodeGenerator.getAnnotationParameterValue(nativeAnnotation, null, null);
                if (importedName == null) {
                    if (amdName == null) {
                        importedName = dependentDeclarationQName;
                    }
                } else if (amdName != null) {
                    if (amdVar == null) {
                        amdVar = compilationUnit.createAmdVar();
                    }
                    importedName = amdVar + "." + importedName;
                }
            }
            if (amdName != null) {
                if (amdVar == null) {
                    amdVar = useQName.contains(dependentDeclaration.getName()) ? dependentDeclarationQName.replace(".", "$") : dependentDeclaration.getName();
                    amdVar = this.convertIdentifier(amdVar);
                }
                amdMapping.put(amdName, amdVar);
                if (importedName == null) {
                    importedName = amdVar;
                }
                if (!(nativeAnnotation != null || dependentDeclaration instanceof ClassDeclaration && ((ClassDeclaration)dependentDeclaration).isInterface())) {
                    importedName = this.COMPILATION_UNIT_ACCESS_MESSAGE_FORMAT.format(importedName);
                }
            }
            Debug.assertTrue(importedName != null, "Imported name of compilation unit " + dependentDeclarationQName + " could not be determined.");
            this.imports.put(dependentDeclarationQName, importedName);
        }
        return amdMapping;
    }

    private Set<String> computeUseQName(CompilationUnit compilationUnit) {
        HashSet<String> useQName = new HashSet<String>();
        HashSet<String> shortNames = new HashSet<String>();
        shortNames.add(compilationUnit.getPrimaryDeclaration().getName());
        for (CompilationUnit dependentCU : compilationUnit.getDependenciesAsCompilationUnits()) {
            String dependentPrimaryDeclarationName = dependentCU.getPrimaryDeclaration().getName();
            if (shortNames.add(dependentPrimaryDeclarationName)) continue;
            useQName.add(dependentPrimaryDeclarationName);
        }
        return useQName;
    }

    private static Object getAnnotationParameterValue(Annotation nativeAnnotation, String name, Object defaultValue) {
        for (CommaSeparatedList<AnnotationParameter> annotationParameters = nativeAnnotation.getOptAnnotationParameters(); annotationParameters != null; annotationParameters = annotationParameters.getTail()) {
            AnnotationParameter annotationParameter = annotationParameters.getHead();
            Ide optName = annotationParameter.getOptName();
            if ((optName == null || name == null || !name.equals(optName.getName())) && (optName != null || name != null)) continue;
            AstNode value = annotationParameter.getValue();
            return value == null ? defaultValue : value.getSymbol().getJooValue();
        }
        return null;
    }

    private static String computeAmdName(CompilationUnit compilationUnit) {
        Annotation nativeAnnotation = compilationUnit.getAnnotation("Native");
        String moduleName = JsCodeGenerator.getModuleName(compilationUnit);
        return nativeAnnotation == null ? moduleName : (String)JsCodeGenerator.getAnnotationParameterValue(nativeAnnotation, "amd", moduleName);
    }

    private static String getModuleName(CompilationUnit compilationUnit) {
        String qName = compilationUnit.getPrimaryDeclaration().getQualifiedNameStr();
        return "as3/" + CompilerUtils.fileNameFromQName((String)qName, (char)'/', (String)DEFAULT_ANNOTATION_PARAMETER_NAME);
    }

    private JsonObject createClassDefinition(ClassDeclaration classDeclaration, ClassDefinitionBuilder classDefinitionBuilder) throws IOException {
        JsonObject classDefinition = new JsonObject(new Object[0]);
        if (!classDefinitionBuilder.metadata.isEmpty()) {
            classDefinition.set("metadata", classDefinitionBuilder.metadata);
        }
        if (classDeclaration.getInheritanceLevel() > 1) {
            ClassDeclaration superTypeDeclaration = classDeclaration.getSuperTypeDeclaration();
            this.out.write("\n    var Super=" + this.compilationUnitAccessCode(superTypeDeclaration) + ";");
            if (classDefinitionBuilder.super$Used) {
                this.out.write("\n    var super$=Super.prototype;");
            }
            classDefinition.set("extends_", JsonObject.code("Super"));
        }
        this.addOptImplements(classDeclaration, classDefinition);
        if (!classDefinitionBuilder.members.isEmpty()) {
            classDefinition.set("members", this.convertMembers(classDefinitionBuilder.members));
        }
        if (!classDefinitionBuilder.staticMembers.isEmpty()) {
            classDefinition.set("staticMembers", this.convertMembers(classDefinitionBuilder.staticMembers));
        }
        classDefinitionBuilder.staticCode.insert(0, classDefinitionBuilder.staticInitializerCode.toString());
        return classDefinition;
    }

    private JsonObject convertMembers(Map<String, PropertyDefinition> members) {
        JsonObject membersDefinition = new JsonObject(new Object[0]);
        for (Map.Entry<String, PropertyDefinition> entry : members.entrySet()) {
            membersDefinition.set(entry.getKey(), entry.getValue().asAbbreviatedJson());
        }
        return membersDefinition;
    }

    @Override
    public void visitIde(Ide ide) throws IOException {
        this.out.writeSymbolWhitespace(ide.getIde());
        String ideText = ide.getIde().getText();
        if (!this.out.isWritingComment()) {
            if (this.expressionMode) {
                if (ide.isSuper()) {
                    ideText = "this";
                }
                if ("this".equals(ideText) && ide.isRewriteThis()) {
                    ideText = "this$";
                } else {
                    ideText = this.convertIdentifier(ideText);
                    IdeDeclaration ideDeclaration = ide.getDeclaration(false);
                    if (ideDeclaration != null) {
                        if (ideDeclaration.isPrimaryDeclaration()) {
                            ideText = this.compilationUnitAccessCode(ideDeclaration);
                        } else if (ideDeclaration.isPrivateStatic()) {
                            ideText = ideText + "$static";
                        }
                    }
                }
            } else {
                ideText = this.convertIdentifier(ideText);
            }
        }
        this.out.writeToken(ideText);
    }

    private String convertIdentifier(String identifier) {
        return SyntacticKeywords.RESERVED_WORDS.contains(identifier) ? identifier + "_" : identifier;
    }

    @Override
    public void visitQualifiedIde(QualifiedIde qualifiedIde) throws IOException {
        if (this.out.isWritingComment()) {
            qualifiedIde.getQualifier().visit(this);
            this.out.writeSymbol(qualifiedIde.getSymDot());
            this.visitIde(qualifiedIde);
        } else {
            this.out.writeSymbolWhitespace(qualifiedIde.getQualifier().getSymbol());
            IdeDeclaration ideDeclaration = qualifiedIde.getDeclaration();
            String compilationUnitAccessCode = this.compilationUnitAccessCode(ideDeclaration);
            String ideName = qualifiedIde.getName();
            if (compilationUnitAccessCode.equals(this.COMPILATION_UNIT_ACCESS_MESSAGE_FORMAT.format(ideName)) && !qualifiedIde.getScope().lookupDeclaration(new Ide(ideName), false).isPrimaryDeclaration()) {
                this.out.write(qualifiedIde.getQualifiedNameStr());
            } else {
                this.out.write(compilationUnitAccessCode);
            }
        }
    }

    @Override
    public void visitIdeWithTypeParam(IdeWithTypeParam ideWithTypeParam) throws IOException {
        this.visitIde(ideWithTypeParam);
        this.out.beginComment();
        this.out.writeSymbol(ideWithTypeParam.getSymDotLt());
        ideWithTypeParam.getType().visit(this);
        this.out.writeSymbol(ideWithTypeParam.getSymGt());
        this.out.endComment();
    }

    @Override
    public void visitNamespacedIde(NamespacedIde namespacedIde) throws IOException {
        this.out.beginComment();
        this.out.writeSymbol(namespacedIde.getNamespace().getSymbol());
        this.out.writeSymbol(namespacedIde.getSymNamespaceSep());
        this.out.endComment();
        this.visitIde(namespacedIde);
    }

    @Override
    public void visitImplements(Implements anImplements) throws IOException {
        this.out.writeSymbol(anImplements.getSymImplements());
        this.generateImplements(anImplements.getSuperTypes());
    }

    private void generateImplements(CommaSeparatedList<Ide> superTypes) throws IOException {
        this.out.writeSymbol(superTypes.getHead().getSymbol());
        if (superTypes.getSymComma() != null) {
            this.out.writeSymbol(superTypes.getSymComma());
            this.generateImplements(superTypes.getTail());
        }
    }

    @Override
    public void visitType(Type type) throws IOException {
        type.getIde().visit(this);
    }

    @Override
    public void visitObjectLiteral(ObjectLiteral objectLiteral) throws IOException {
        this.out.writeSymbol(objectLiteral.getLBrace());
        this.visitIfNotNull(objectLiteral.getFields());
        this.writeOptSymbol(objectLiteral.getOptComma());
        this.out.writeSymbol(objectLiteral.getRBrace());
    }

    @Override
    public void visitIdeExpression(IdeExpr ideExpr) throws IOException {
        this.visitInExpressionMode(ideExpr.getIde());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitInExpressionMode(AstNode expr) throws IOException {
        boolean oldExpressionMode = this.expressionMode;
        this.expressionMode = !this.out.isWritingComment();
        try {
            expr.visit(this);
        }
        finally {
            this.expressionMode = oldExpressionMode;
        }
    }

    @Override
    public <T extends Expr> void visitParenthesizedExpr(ParenthesizedExpr<T> parenthesizedExpr) throws IOException {
        this.out.writeSymbol(parenthesizedExpr.getLParen());
        this.visitIfNotNull((AstNode)parenthesizedExpr.getExpr());
        this.out.writeSymbol(parenthesizedExpr.getRParen());
    }

    @Override
    public void visitArrayLiteral(ArrayLiteral arrayLiteral) throws IOException {
        this.visitParenthesizedExpr(arrayLiteral);
    }

    @Override
    public void visitAssignmentOpExpr(AssignmentOpExpr assignmentOpExpr) throws IOException {
        Expr leftHandSide = assignmentOpExpr.getArg1();
        if (assignmentOpExpr.getOp().sym == 86 || assignmentOpExpr.getOp().sym == 87) {
            leftHandSide.visit(this);
            this.out.writeSymbolWhitespace(assignmentOpExpr.getOp());
            this.out.writeToken("=");
            JoocConfiguration options = (JoocConfiguration)this.out.getOptions();
            DebugMode mode = options.getDebugMode();
            options.setDebugMode(null);
            leftHandSide.visit(this);
            options.setDebugMode(mode);
            this.out.writeToken(assignmentOpExpr.getOp().sym == 86 ? "&&" : "||");
            this.out.writeToken("(");
            assignmentOpExpr.getArg2().visit(this);
            this.out.writeToken(")");
        } else {
            String setter = null;
            Expr dotExprArg = null;
            JooSymbol symDot = null;
            if (leftHandSide instanceof IdeExpr) {
                leftHandSide = ((IdeExpr)leftHandSide).getNormalizedExpr();
            }
            if (leftHandSide instanceof DotExpr) {
                DotExpr dotExpr = (DotExpr)leftHandSide;
                setter = JsCodeGenerator.resolveAccessor(dotExpr, MethodType.SET);
                dotExprArg = dotExpr.getArg();
                symDot = dotExpr.getOp();
            }
            if (setter != null && dotExprArg != null) {
                this.visitInExpressionMode(dotExprArg);
                this.out.writeSymbol(symDot);
                this.out.write(setter);
                this.writeSymbolReplacement(assignmentOpExpr.getOp(), "(");
                assignmentOpExpr.getArg2().visit(this);
                this.out.writeToken(")");
                return;
            }
            this.visitBinaryOpExpr(assignmentOpExpr);
        }
    }

    private static String resolveAccessor(DotExpr dotExpr, MethodType methodType) throws IOException {
        IdeDeclaration typeDeclaration;
        TypeRelation typeRelation;
        IdeDeclaration lhsType = dotExpr.getArg().getType();
        if (lhsType instanceof ClassDeclaration) {
            return JsCodeGenerator.resolveAccessor(dotExpr.getIde(), methodType, (ClassDeclaration)lhsType);
        }
        if (lhsType instanceof Typed && (typeRelation = ((Typed)((Object)lhsType)).getOptTypeRelation()) != null && (typeDeclaration = typeRelation.getType().resolveDeclaration()) instanceof ClassDeclaration) {
            return JsCodeGenerator.resolveAccessor(dotExpr.getIde(), methodType, (ClassDeclaration)typeDeclaration);
        }
        return null;
    }

    private static String resolveAccessor(Ide qIde, MethodType methodType, ClassDeclaration typeDeclaration) throws IOException {
        List<AnnotationModel> accessorAnnotations;
        String memberName = qIde.getIde().getText();
        MemberModel member = JsCodeGenerator.lookupPropertyDeclaration(typeDeclaration, memberName, methodType);
        if (member != null && (accessorAnnotations = member.getAnnotations("Accessor")).size() > 0) {
            AnnotationPropertyModel accessorAnnotation = accessorAnnotations.get(0).getPropertiesByName().get(null);
            if (accessorAnnotation == null) {
                return (methodType == MethodType.GET && "Boolean".equals(((MethodModel)member).getReturnModel().getType()) ? "is" : methodType) + MxmlUtils.capitalize(memberName);
            }
            return accessorAnnotation.getStringValue();
        }
        return null;
    }

    private String resolveBindable(Ide qIde, MethodType methodType, ClassDeclaration typeDeclaration) throws IOException {
        List<AnnotationModel> bindableAnnotations;
        String memberName = qIde.getIde().getText();
        MemberModel member = JsCodeGenerator.lookupPropertyDeclaration(typeDeclaration, memberName, methodType);
        if (member != null && (bindableAnnotations = member.getAnnotations("Bindable")).size() > 0) {
            AnnotationPropertyModel eventAnnotation = bindableAnnotations.get(0).getPropertiesByName().get("event");
            return eventAnnotation == null ? memberName.toLowerCase() + "change" : eventAnnotation.getStringValue();
        }
        return null;
    }

    private static MemberModel lookupPropertyDeclaration(ClassDeclaration classDeclaration, String memberName, MethodType methodType) throws IOException {
        MemberModel member;
        ClassDeclaration superDeclaration = classDeclaration.getSuperTypeDeclaration();
        if (superDeclaration != null && (member = JsCodeGenerator.lookupPropertyDeclaration(superDeclaration, memberName, methodType)) != null) {
            return member;
        }
        CompilationUnitModel compilationUnitModel = new ApiModelGenerator(false).generateModel(classDeclaration.getCompilationUnit());
        member = compilationUnitModel.getClassModel().getMember(memberName);
        if (member instanceof PropertyModel) {
            member = ((PropertyModel)member).getMethod(methodType);
        } else if (!(member instanceof FieldModel) || methodType == MethodType.SET && ((FieldModel)member).isConst()) {
            member = null;
        }
        return member;
    }

    @Override
    public void visitInfixOpExpr(InfixOpExpr infixOpExpr) throws IOException {
        this.out.writeToken("AS3.");
        this.out.writeSymbolToken(infixOpExpr.getOp());
        this.out.write(40);
        infixOpExpr.getArg1().visit(this);
        this.out.write(44);
        this.out.writeSymbolWhitespace(infixOpExpr.getOp());
        infixOpExpr.getArg2().visit(this);
        this.out.write(41);
    }

    @Override
    public void visitAsExpr(AsExpr asExpr) throws IOException {
        this.visitInfixOpExpr(asExpr);
    }

    @Override
    public void visitArrayIndexExpr(ArrayIndexExpr arrayIndexExpr) throws IOException {
        arrayIndexExpr.getArray().visit(this);
        arrayIndexExpr.getIndexExpr().visit(this);
    }

    @Override
    public void visitParameters(Parameters parameters) throws IOException {
        this.visitIfNotNull((AstNode)parameters.getHead());
        if (parameters.getSymComma() != null) {
            if (((Parameter)parameters.getTail().getHead()).isRest()) {
                this.out.beginCommentWriteSymbol(parameters.getSymComma());
                parameters.getTail().visit(this);
                this.out.endComment();
            } else {
                this.out.writeSymbol(parameters.getSymComma());
                parameters.getTail().visit(this);
            }
        }
    }

    @Override
    public void visitFunctionExpr(FunctionExpr functionExpr) throws IOException {
        this.out.writeSymbol(functionExpr.getSymFunction());
        if (functionExpr.getIde() != null) {
            this.out.writeToken(functionExpr.getIde().getName());
        } else if (this.out.getKeepSource()) {
            this.out.writeToken(this.getFunctionNameAsIde(functionExpr));
        }
        this.generateFunTailCode(functionExpr);
    }

    public String getFunctionNameAsIde(FunctionExpr functionExpr) {
        IdeDeclaration classDeclaration = functionExpr.getClassDeclaration();
        String classNameAsIde = DEFAULT_ANNOTATION_PARAMETER_NAME;
        if (classDeclaration != null) {
            classNameAsIde = this.out.getQualifiedNameAsIde(classDeclaration);
        }
        JooSymbol sym2 = functionExpr.getSymbol();
        return classNameAsIde + "$" + sym2.getLine() + "_" + sym2.getColumn();
    }

    public void generateFunTailCode(FunctionExpr functionExpr) throws IOException {
        Parameters params = functionExpr.getParams();
        if (functionExpr.hasBody()) {
            if (functionExpr.isArgumentsUsedAsArray()) {
                functionExpr.getBody().addBlockStartCodeGenerator(this.ARGUMENT_TO_ARRAY_CODE_GENERATOR);
            }
            if (params != null) {
                functionExpr.getBody().addBlockStartCodeGenerator(this.getParameterInitializerCodeGenerator(params));
            }
        }
        this.generateSignatureJsCode(functionExpr);
        if (functionExpr.hasBody()) {
            functionExpr.getBody().visit(this);
        }
    }

    public CodeGenerator getParameterInitializerCodeGenerator(final Parameters params) {
        return new CodeGenerator(){

            @Override
            public void generate(JsWriter out, boolean first) throws IOException {
                int restParamIndex = -1;
                Parameter restParam = null;
                HashMap<Integer, Parameter> paramByIndex = new HashMap<Integer, Parameter>();
                int paramIndex = 0;
                for (Parameters parameters = params; parameters != null; parameters = parameters.getTail()) {
                    Parameter param = (Parameter)parameters.getHead();
                    if (param.isRest()) {
                        restParamIndex = paramIndex;
                        restParam = param;
                        break;
                    }
                    if (param.hasInitializer()) {
                        paramByIndex.put(paramIndex, param);
                    }
                    ++paramIndex;
                }
                JsCodeGenerator.this.generateParameterInitializers(out, paramByIndex);
                if (restParam != null) {
                    JsCodeGenerator.this.generateRestParamCode(restParam, restParamIndex);
                }
            }
        };
    }

    private void generateParameterInitializers(JsWriter out, Map<Integer, Parameter> paramByIndex) throws IOException {
        Iterator<Map.Entry<Integer, Parameter>> paramByIndexIterator = paramByIndex.entrySet().iterator();
        if (paramByIndexIterator.hasNext()) {
            Map.Entry<Integer, Parameter> indexAndParam = paramByIndexIterator.next();
            Integer firstParamIndex = indexAndParam.getKey();
            if (!paramByIndexIterator.hasNext()) {
                out.write(this.IF_ARGUMENT_LENGTH_LTE_$N.format(firstParamIndex));
                this.generateBodyInitializerCode(indexAndParam.getValue());
            } else {
                out.write(this.SWITCH_$INDEX.format(firstParamIndex));
                out.write("{");
                while (true) {
                    out.write(this.CASE_$N.format(indexAndParam.getKey()));
                    this.generateBodyInitializerCode(indexAndParam.getValue());
                    if (!paramByIndexIterator.hasNext()) break;
                    indexAndParam = paramByIndexIterator.next();
                }
                out.write("}");
            }
        }
    }

    public void generateRestParamCode(Parameter param, int paramIndex) throws IOException {
        String paramName = param.getName();
        if (!(paramName == null || paramName.equals("arguments") && paramIndex == 0)) {
            this.generateToArrayCode(paramName, paramIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateBodyInitializerCode(Parameter param) throws IOException {
        this.out.setSuppressWhitespace(true);
        try {
            this.out.writeToken(param.getName());
            this.out.writeSymbol(param.getOptInitializer().getSymEq());
            param.getOptInitializer().getValue().visit(this);
            this.out.write(";");
        }
        finally {
            this.out.setSuppressWhitespace(false);
        }
    }

    public void generateSignatureJsCode(FunctionExpr functionExpr) throws IOException {
        this.out.writeSymbol(functionExpr.getLParen());
        this.visitIfNotNull(functionExpr.getParams());
        this.out.writeSymbol(functionExpr.getRParen());
        this.visitIfNotNull(functionExpr.getOptTypeRelation());
    }

    @Override
    public void visitVectorLiteral(VectorLiteral vectorLiteral) throws IOException {
        this.out.beginComment();
        this.out.writeSymbol(vectorLiteral.getSymNew());
        this.out.writeSymbol(vectorLiteral.getSymLt());
        vectorLiteral.getVectorType().visit(this);
        this.out.writeSymbol(vectorLiteral.getSymGt());
        this.out.endComment();
        vectorLiteral.getArrayLiteral().visit(this);
    }

    @Override
    public void visitApplyExpr(ApplyExpr applyExpr) throws IOException {
        if (applyExpr.getArgs() != null && applyExpr.getFun() instanceof IdeExpr && "assert".equals(applyExpr.getFun().getSymbol().getText())) {
            applyExpr.getFun().visit(this);
            JooSymbol symKeyword = applyExpr.getFun().getSymbol();
            this.out.writeSymbol(applyExpr.getArgs().getLParen());
            applyExpr.getArgs().getExpr().visit(this);
            this.out.writeToken(", ");
            this.out.writeString(new File(symKeyword.getFileName()).getName());
            this.out.writeToken(", ");
            this.out.writeInt(symKeyword.getLine());
            this.out.write(", ");
            this.out.writeInt(symKeyword.getColumn());
            this.out.writeSymbol(applyExpr.getArgs().getRParen());
        } else {
            this.generateFunJsCode(applyExpr);
            this.visitIfNotNull(applyExpr.getArgs());
        }
    }

    private void generateFunJsCode(ApplyExpr applyExpr) throws IOException {
        if (applyExpr.isTypeCast()) {
            this.out.beginComment();
            applyExpr.getFun().visit(this);
            this.out.endComment();
        } else {
            applyExpr.getFun().visit(this);
        }
    }

    @Override
    public void visitNewExpr(NewExpr newExpr) throws IOException {
        this.out.writeSymbol(newExpr.getSymNew());
        newExpr.getApplyConstructor().visit(this);
    }

    @Override
    public void visitClassBody(ClassBody classBody) throws IOException {
        this.out.beginComment();
        this.out.writeSymbol(classBody.getLBrace());
        this.out.endComment();
        boolean inStaticInitializerBlock = false;
        for (Directive directive : classBody.getDirectives()) {
            boolean isStaticInitializer = directive instanceof Statement && !(directive instanceof Declaration);
            inStaticInitializerBlock = isStaticInitializer ? this.beginStaticInitializer(this.out, inStaticInitializerBlock) : this.endStaticInitializer(this.out, inStaticInitializerBlock);
            directive.visit(this);
        }
        this.endStaticInitializer(this.out, inStaticInitializerBlock);
        this.out.beginComment();
        this.out.writeSymbol(classBody.getRBrace());
        this.out.endComment();
    }

    private boolean beginStaticInitializer(JsWriter out, boolean inStaticInitializerBlock) throws IOException {
        if (!inStaticInitializerBlock) {
            String staticFunctionName = "static$" + this.staticCodeCounter++;
            out.writeToken(String.format("function %s(){", staticFunctionName));
            this.primaryClassDefinitionBuilder.staticCode.append("    ").append(staticFunctionName).append("();\n");
        }
        return true;
    }

    private boolean endStaticInitializer(JsWriter out, boolean inStaticInitializerBlock) throws IOException {
        if (inStaticInitializerBlock) {
            out.writeToken("}");
        }
        return false;
    }

    @Override
    public void visitBlockStatement(BlockStatement blockStatement) throws IOException {
        this.out.writeSymbol(blockStatement.getLBrace());
        boolean first = true;
        for (CodeGenerator codeGenerator : blockStatement.getBlockStartCodeGenerators()) {
            codeGenerator.generate(this.out, first);
            first = false;
        }
        this.visitAll(blockStatement.getDirectives());
        this.out.writeSymbol(blockStatement.getRBrace());
    }

    @Override
    public void visitDefaultStatement(DefaultStatement defaultStatement) throws IOException {
        this.out.writeSymbol(defaultStatement.getSymDefault());
        this.out.writeSymbol(defaultStatement.getSymColon());
    }

    @Override
    public void visitLabeledStatement(LabeledStatement labeledStatement) throws IOException {
        labeledStatement.getIde().visit(this);
        this.out.writeSymbol(labeledStatement.getSymColon());
        labeledStatement.getStatement().visit(this);
    }

    @Override
    public void visitIfStatement(IfStatement ifStatement) throws IOException {
        this.out.writeSymbol(ifStatement.getSymKeyword());
        ifStatement.getCond().visit(this);
        ifStatement.getIfTrue().visit(this);
        if (ifStatement.getSymElse() != null) {
            this.out.writeSymbol(ifStatement.getSymElse());
            ifStatement.getIfFalse().visit(this);
        }
    }

    @Override
    public void visitCaseStatement(CaseStatement caseStatement) throws IOException {
        this.out.writeSymbol(caseStatement.getSymKeyword());
        caseStatement.getExpr().visit(this);
        this.out.writeSymbol(caseStatement.getSymColon());
    }

    @Override
    public void visitTryStatement(TryStatement tryStatement) throws IOException {
        this.out.writeSymbol(tryStatement.getSymKeyword());
        tryStatement.getBlock().visit(this);
        this.visitAll(tryStatement.getCatches());
        if (tryStatement.getSymFinally() != null) {
            this.out.writeSymbol(tryStatement.getSymFinally());
            tryStatement.getFinallyBlock().visit(this);
        }
    }

    @Override
    public void visitCatch(Catch aCatch) throws IOException {
        List<Catch> catches = aCatch.getParentTryStatement().getCatches();
        Catch firstCatch = catches.get(0);
        boolean isFirst = aCatch.equals(firstCatch);
        boolean isLast = aCatch.equals(catches.get(catches.size() - 1));
        TypeRelation typeRelation = aCatch.getParam().getOptTypeRelation();
        boolean hasCondition = aCatch.hasCondition();
        if (!hasCondition && !isLast) {
            throw Jooc.error(aCatch.getRParen(), "Only last catch clause may be untyped.");
        }
        JooSymbol errorVar = firstCatch.getParam().getIde().getIde();
        JooSymbol localErrorVar = aCatch.getParam().getIde().getIde();
        this.out.writeSymbolWhitespace(aCatch.getSymKeyword());
        if (isFirst) {
            this.out.writeSymbolToken(aCatch.getSymKeyword());
            this.out.writeSymbol(aCatch.getLParen(), !hasCondition);
            this.out.writeSymbol(errorVar, !hasCondition);
            if (!hasCondition && typeRelation != null) {
                typeRelation.visit(this);
            }
            this.out.writeSymbol(aCatch.getRParen(), !hasCondition);
            if (hasCondition || !isLast) {
                this.out.writeToken("{");
            }
        } else {
            this.out.writeToken("else");
        }
        if (hasCondition) {
            this.out.writeToken("if(AS3.is");
            this.out.writeSymbol(aCatch.getLParen());
            this.out.writeSymbolWhitespace(localErrorVar);
            this.out.writeSymbolToken(errorVar);
            this.out.writeSymbolWhitespace(typeRelation.getSymRelation());
            this.out.writeToken(",");
            Ide typeIde = typeRelation.getType().getIde();
            this.out.writeSymbolWhitespace(typeIde.getIde());
            this.out.writeToken(this.compilationUnitAccessCode(typeIde.getDeclaration()));
            this.out.writeSymbol(aCatch.getRParen());
            this.out.writeToken(")");
        }
        if (!localErrorVar.getText().equals(errorVar.getText())) {
            aCatch.getBlock().addBlockStartCodeGenerator(new VarCodeGenerator(localErrorVar, errorVar));
        }
        aCatch.getBlock().visit(this);
        if (isLast) {
            if (hasCondition) {
                this.out.writeToken("else throw");
                this.out.writeSymbolToken(errorVar);
                this.out.writeToken(";");
            }
            if (!isFirst || hasCondition) {
                this.out.writeToken("}");
            }
        }
    }

    @Override
    public void visitForInStatement(final ForInStatement forInStatement) throws IOException {
        boolean isForEach;
        boolean iterateArrayMode;
        final Ide exprAuxIde = forInStatement.getExprAuxIde();
        IdeDeclaration exprType = forInStatement.getExpr().getType();
        String exprTypeName = exprType != null ? exprType.getQualifiedNameStr() : DEFAULT_ANNOTATION_PARAMETER_NAME;
        boolean bl = iterateArrayMode = "Array".equals(exprTypeName) || "Vector$object".equals(exprTypeName);
        if (exprAuxIde != null && !iterateArrayMode) {
            new SemicolonTerminatedStatement(new VariableDeclaration(SYM_VAR, exprAuxIde, null, null), SYM_SEMICOLON).visit(this);
        }
        this.out.writeSymbol(forInStatement.getSymKeyword());
        boolean bl2 = isForEach = forInStatement.getSymEach() != null;
        if (isForEach) {
            this.out.beginComment();
            this.out.writeSymbol(forInStatement.getSymEach());
            this.out.endComment();
        }
        this.out.writeSymbol(forInStatement.getLParen());
        if (isForEach || iterateArrayMode) {
            new VariableDeclaration(SYM_VAR, forInStatement.getAuxIde(), null, null).visit(this);
        } else if (forInStatement.getDecl() != null) {
            forInStatement.getDecl().visit(this);
        } else {
            forInStatement.getLValue().visit(this);
        }
        if (iterateArrayMode) {
            String indexVarName = forInStatement.getAuxIde().getName();
            this.out.write("=0");
            if (exprAuxIde != null) {
                this.out.write(",");
                this.out.writeToken(exprAuxIde.getName());
                this.out.writeToken("=");
                this.out.beginComment();
                this.out.writeSymbol(forInStatement.getSymIn());
                this.out.endComment();
                forInStatement.getExpr().visit(this);
            }
            this.out.write(";");
            this.out.write(indexVarName);
            this.out.write("<");
            if (exprAuxIde != null) {
                this.out.writeToken(exprAuxIde.getName());
            } else {
                this.out.beginComment();
                this.out.writeSymbol(forInStatement.getSymIn());
                this.out.endComment();
                forInStatement.getExpr().visit(this);
            }
            this.out.write(".length;");
            this.out.write("++" + indexVarName);
        } else {
            this.out.writeSymbol(forInStatement.getSymIn());
            if (exprAuxIde != null) {
                this.out.writeToken(exprAuxIde.getName());
                this.out.writeToken("=");
            }
            forInStatement.getExpr().visit(this);
        }
        this.out.writeSymbol(forInStatement.getRParen());
        if (isForEach || iterateArrayMode) {
            if (!(forInStatement.getBody() instanceof BlockStatement)) {
                forInStatement.setBody(new BlockStatement(SYM_LBRACE, Arrays.asList(forInStatement.getBody()), SYM_RBRACE));
            }
            ((BlockStatement)forInStatement.getBody()).addBlockStartCodeGenerator(new CodeGenerator(){

                @Override
                public void generate(JsWriter out, boolean first) throws IOException {
                    if (forInStatement.getDecl() != null) {
                        forInStatement.getDecl().visit(JsCodeGenerator.this);
                    } else {
                        forInStatement.getLValue().visit(JsCodeGenerator.this);
                    }
                    out.writeToken("=");
                    if (!isForEach) {
                        out.write("String(" + forInStatement.getAuxIde().getName() + ")");
                    } else {
                        if (exprAuxIde == null) {
                            forInStatement.getExpr().visit(JsCodeGenerator.this);
                        } else {
                            out.write(exprAuxIde.getName());
                        }
                        out.write("[" + forInStatement.getAuxIde().getName() + "]");
                    }
                    out.write(";");
                }
            });
        }
        forInStatement.getBody().visit(this);
    }

    @Override
    public void visitWhileStatement(WhileStatement whileStatement) throws IOException {
        this.out.writeSymbol(whileStatement.getSymKeyword());
        this.visitIfNotNull(whileStatement.getOptCond());
        whileStatement.getBody().visit(this);
    }

    @Override
    public void visitForStatement(ForStatement forStatement) throws IOException {
        this.out.writeSymbol(forStatement.getSymKeyword());
        this.out.writeSymbol(forStatement.getLParen());
        this.visitIfNotNull(forStatement.getForInit());
        this.out.writeSymbol(forStatement.getSymSemicolon1());
        this.visitIfNotNull(forStatement.getOptCond());
        this.out.writeSymbol(forStatement.getSymSemicolon2());
        this.visitIfNotNull(forStatement.getOptStep());
        this.out.writeSymbol(forStatement.getRParen());
        forStatement.getBody().visit(this);
    }

    @Override
    public void visitDoStatement(DoStatement doStatement) throws IOException {
        this.out.writeSymbol(doStatement.getSymKeyword());
        doStatement.getBody().visit(this);
        this.out.writeSymbol(doStatement.getSymWhile());
        doStatement.getOptCond().visit(this);
        this.out.writeSymbol(doStatement.getSymSemicolon());
    }

    @Override
    public void visitSwitchStatement(SwitchStatement switchStatement) throws IOException {
        this.out.writeSymbol(switchStatement.getSymKeyword());
        switchStatement.getCond().visit(this);
        switchStatement.getBlock().visit(this);
    }

    @Override
    public void visitSemicolonTerminatedStatement(SemicolonTerminatedStatement semicolonTerminatedStatement) throws IOException {
        this.visitIfNotNull(semicolonTerminatedStatement.getOptStatement());
        this.writeOptSymbol(semicolonTerminatedStatement.getOptSymSemicolon());
    }

    @Override
    public void visitContinueStatement(ContinueStatement continueStatement) throws IOException {
        this.out.writeSymbol(continueStatement.getSymKeyword());
        this.visitIfNotNull(continueStatement.getOptStatement());
        this.visitIfNotNull(continueStatement.getOptLabel());
        this.writeOptSymbol(continueStatement.getOptSymSemicolon());
    }

    @Override
    public void visitBreakStatement(BreakStatement breakStatement) throws IOException {
        this.out.writeSymbol(breakStatement.getSymKeyword());
        this.visitIfNotNull(breakStatement.getOptStatement());
        this.visitIfNotNull(breakStatement.getOptLabel());
        this.writeOptSymbol(breakStatement.getOptSymSemicolon());
    }

    @Override
    public void visitThrowStatement(ThrowStatement throwStatement) throws IOException {
        this.out.writeSymbol(throwStatement.getSymKeyword());
        this.visitIfNotNull(throwStatement.getOptStatement());
        this.writeOptSymbol(throwStatement.getOptSymSemicolon());
    }

    @Override
    public void visitReturnStatement(ReturnStatement returnStatement) throws IOException {
        this.out.writeSymbol(returnStatement.getSymKeyword());
        this.visitIfNotNull(returnStatement.getOptStatement());
        this.writeOptSymbol(returnStatement.getOptSymSemicolon());
    }

    @Override
    public void visitEmptyStatement(EmptyStatement emptyStatement) throws IOException {
        this.visitSemicolonTerminatedStatement(emptyStatement);
    }

    @Override
    public void visitEmptyDeclaration(EmptyDeclaration emptyDeclaration) throws IOException {
        this.out.writeSymbolWhitespace(emptyDeclaration.getSymSemicolon());
    }

    @Override
    public void visitParameter(Parameter parameter) throws IOException {
        Debug.assertTrue(parameter.getModifiers() == 0, "Parameters must not have any modifiers");
        boolean isRest = parameter.isRest();
        if (parameter.getOptSymConstOrRest() != null) {
            this.out.beginCommentWriteSymbol(parameter.getOptSymConstOrRest());
            if (isRest) {
                parameter.getIde().visit(this);
            }
            this.out.endComment();
        }
        if (!isRest) {
            parameter.getIde().visit(this);
        }
        this.visitIfNotNull(parameter.getOptTypeRelation());
        if (parameter.getOptInitializer() != null) {
            this.out.beginComment();
            parameter.getOptInitializer().visit(this);
            this.out.endComment();
        }
    }

    @Override
    public void visitVariableDeclaration(VariableDeclaration variableDeclaration) throws IOException {
        if (variableDeclaration.hasPreviousVariableDeclaration()) {
            Debug.assertTrue(variableDeclaration.getOptSymConstOrVar() != null && variableDeclaration.getOptSymConstOrVar().sym == 72, "Additional variable declarations must start with a COMMA.");
        }
        if (variableDeclaration.isClassMember() && !variableDeclaration.isPrivateStatic()) {
            if (!variableDeclaration.isPrimaryDeclaration() && !this.currentMetadata.isEmpty()) {
                this.getClassDefinitionBuilder(variableDeclaration).storeCurrentMetadata(variableDeclaration.getIde().getName() + (variableDeclaration.isPrivate() ? "$" + variableDeclaration.getClassDeclaration().getInheritanceLevel() : DEFAULT_ANNOTATION_PARAMETER_NAME), this.currentMetadata);
            }
            this.out.beginComment();
            this.writeModifiers(this.out, variableDeclaration);
            this.writeOptSymbol(variableDeclaration.getOptSymConstOrVar());
            variableDeclaration.getIde().visit(this);
            this.visitIfNotNull(variableDeclaration.getOptTypeRelation());
            if (this.mustInitializeInStaticCode(variableDeclaration)) {
                this.out.endComment();
                this.generateFieldInitializerCode(variableDeclaration);
            } else {
                this.visitIfNotNull(variableDeclaration.getOptInitializer());
                this.out.endComment();
            }
            this.registerField(variableDeclaration);
            this.visitIfNotNull(variableDeclaration.getOptNextVariableDeclaration());
            this.generateFieldEndCode(variableDeclaration);
        } else {
            if (variableDeclaration.hasPreviousVariableDeclaration()) {
                this.writeOptSymbol(variableDeclaration.getOptSymConstOrVar());
            } else {
                this.generateVarStartCode(variableDeclaration);
            }
            this.visitInExpressionMode(variableDeclaration.getIde());
            this.visitIfNotNull(variableDeclaration.getOptTypeRelation());
            Initializer optInitializer = variableDeclaration.getOptInitializer();
            if (optInitializer == null) {
                if (variableDeclaration.isPrimaryDeclaration() || variableDeclaration.isPrivateStatic()) {
                    String value = this.getValueFromEmbedMetadata();
                    if (value == null) {
                        TypeRelation typeRelation = variableDeclaration.getOptTypeRelation();
                        value = VariableDeclaration.getDefaultValue(typeRelation);
                    }
                    if (value != null) {
                        this.out.write("=" + value);
                    }
                }
            } else if (variableDeclaration.isPrivateStatic() && this.mustInitializeInStaticCode(variableDeclaration)) {
                this.out.writeToken(";");
                this.generateFieldInitializerCode(variableDeclaration);
                this.registerField(variableDeclaration);
            } else {
                optInitializer.visit(this);
            }
            this.visitIfNotNull(variableDeclaration.getOptNextVariableDeclaration());
            this.writeOptSymbol(variableDeclaration.getOptSymSemicolon());
            if (variableDeclaration.isPrimaryDeclaration()) {
                PropertyDefinition propertyDefinition = new PropertyDefinition(variableDeclaration.getName(), !variableDeclaration.isConst());
                this.out.write(" $primaryDeclaration(" + propertyDefinition.asJson().toString(-1, -1) + ");");
            }
        }
        this.resetCurrentMetadata(variableDeclaration);
    }

    private void resetCurrentMetadata(IdeDeclaration declaration) {
        if (declaration.isClassMember() || declaration.isPrimaryDeclaration()) {
            this.currentMetadata = new LinkedList();
        }
    }

    private String getValueFromEmbedMetadata() {
        Metadata embedMetadata = Metadata.find(this.currentMetadata, "Embed");
        if (embedMetadata != null) {
            String source = (String)embedMetadata.getArgumentValue("source");
            String assetType = CompilationUnit.guessAssetType(source);
            int index = this.compilationUnit.getResourceDependencies().indexOf(assetType + "!" + source);
            String assetFactory = "new String";
            if ("image".equals(assetType)) {
                assetFactory = this.imports.get("flash.display.Bitmap") + ".fromImg";
            }
            return String.format("function(){return %s($resource_%d)}", assetFactory, index);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerField(VariableDeclaration variableDeclaration) {
        String variableName = variableDeclaration.getName();
        if (this.mustInitializeInStaticCode(variableDeclaration)) {
            if (variableDeclaration.isStatic()) {
                this.primaryClassDefinitionBuilder.staticInitializerCode.append("    ").append(variableName);
                if (variableDeclaration.isStatic()) {
                    this.primaryClassDefinitionBuilder.staticInitializerCode.append("$static");
                }
                this.primaryClassDefinitionBuilder.staticInitializerCode.append("_();\n");
            }
        } else {
            String value;
            if (variableDeclaration.getOptInitializer() != null) {
                Expr initialValue = variableDeclaration.getOptInitializer().getValue();
                JsWriter originalOut = this.out;
                StringWriter initialValueWriter = new StringWriter();
                this.out = new JsWriter(initialValueWriter);
                this.out.setOptions(originalOut.getOptions());
                try {
                    initialValue.visit(this);
                }
                catch (IOException e) {
                }
                finally {
                    this.out = originalOut;
                }
                value = initialValueWriter.toString().trim();
            } else {
                value = this.getValueFromEmbedMetadata();
                if (value == null) {
                    TypeRelation typeRelation = variableDeclaration.getOptTypeRelation();
                    value = VariableDeclaration.getDefaultValue(typeRelation);
                }
            }
            if (variableDeclaration.isPrivate() && !variableDeclaration.isStatic()) {
                variableName = variableName + "$" + ((ClassDeclaration)this.compilationUnit.getPrimaryDeclaration()).getInheritanceLevel();
            }
            this.membersOrStaticMembers(variableDeclaration).put(variableName, new PropertyDefinition(value, !variableDeclaration.isConst()));
        }
    }

    protected void generateVarStartCode(VariableDeclaration variableDeclaration) throws IOException {
        this.out.beginComment();
        this.writeModifiers(this.out, variableDeclaration);
        this.out.endComment();
        if (variableDeclaration.getOptSymConstOrVar() != null) {
            if (variableDeclaration.isConst()) {
                this.out.beginCommentWriteSymbol(variableDeclaration.getOptSymConstOrVar());
                this.out.endComment();
                this.out.writeToken("var");
            } else {
                this.out.writeSymbol(variableDeclaration.getOptSymConstOrVar());
            }
        }
    }

    protected void generateFieldInitializerCode(VariableDeclaration variableDeclaration) throws IOException {
        Initializer initializer = variableDeclaration.getOptInitializer();
        this.out.beginComment();
        this.out.writeSymbol(initializer.getSymEq());
        this.out.endComment();
        String variableName = variableDeclaration.getName();
        this.out.writeToken("function");
        this.out.writeToken(variableName + (variableDeclaration.isStatic() ? "$static" : DEFAULT_ANNOTATION_PARAMETER_NAME) + "_");
        this.out.writeToken("(){");
        if (variableDeclaration.isPrivateStatic()) {
            this.out.write(variableName + "$static=(");
            initializer.getValue().visit(this);
        } else {
            String target = variableDeclaration.isStatic() ? variableDeclaration.getClassDeclaration().getName() : "this";
            String slotName = variableName + (variableDeclaration.isPrivate() ? "$" + variableDeclaration.getClassDeclaration().getInheritanceLevel() : DEFAULT_ANNOTATION_PARAMETER_NAME);
            if (variableDeclaration.isConst()) {
                this.out.write("Object.defineProperty(" + target + ",\"" + slotName + "\",{value:");
                initializer.getValue().visit(this);
                this.out.writeToken("}");
            } else {
                this.out.write(target + "." + slotName + "=(");
                initializer.getValue().visit(this);
            }
        }
        this.out.writeToken(");}");
    }

    private boolean mustInitializeInStaticCode(VariableDeclaration variableDeclaration) {
        return variableDeclaration.getOptInitializer() != null && !variableDeclaration.getOptInitializer().getValue().isRuntimeConstant();
    }

    protected void generateFieldEndCode(VariableDeclaration variableDeclaration) throws IOException {
        if (!variableDeclaration.hasPreviousVariableDeclaration()) {
            Debug.assertTrue(variableDeclaration.getOptSymSemicolon() != null, "optSymSemicolon != null");
            this.out.beginComment();
            this.out.writeSymbol(variableDeclaration.getOptSymSemicolon());
            this.out.endComment();
        }
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclaration functionDeclaration) throws IOException {
        boolean isPrimaryDeclaration = functionDeclaration.equals(this.compilationUnit.getPrimaryDeclaration());
        assert (functionDeclaration.isClassMember() || !functionDeclaration.isNative() && !functionDeclaration.isAbstract());
        if (functionDeclaration.isThisAliased()) {
            functionDeclaration.getBody().addBlockStartCodeGenerator(ALIAS_THIS_CODE_GENERATOR);
        }
        if (functionDeclaration.isConstructor() && !functionDeclaration.containsSuperConstructorCall() && functionDeclaration.hasBody()) {
            functionDeclaration.getBody().addBlockStartCodeGenerator(new SuperCallCodeGenerator(functionDeclaration.getClassDeclaration()));
        }
        if (!functionDeclaration.isClassMember() && !isPrimaryDeclaration) {
            functionDeclaration.getFun().visit(this);
        } else {
            if (!isPrimaryDeclaration && !this.currentMetadata.isEmpty()) {
                this.getClassDefinitionBuilder(functionDeclaration).storeCurrentMetadata(functionDeclaration.getIde().getName(), this.currentMetadata);
            }
            this.out.beginComment();
            this.writeModifiers(this.out, functionDeclaration);
            if (functionDeclaration.isAbstract() || functionDeclaration.isNative()) {
                this.out.writeSymbol(functionDeclaration.getFun().getFunSymbol());
                this.writeOptSymbol(functionDeclaration.getSymGetOrSet());
                functionDeclaration.getIde().visit(this);
                this.generateSignatureJsCode(functionDeclaration.getFun());
                this.writeOptSymbol(functionDeclaration.getOptSymSemicolon());
                this.out.endComment();
            } else {
                Metadata accessorAnnotation;
                String functionName;
                this.out.endComment();
                this.out.writeSymbol(functionDeclaration.getFun().getFunSymbol());
                JooSymbol functionSymbol = functionDeclaration.getIde().getSymbol();
                String methodName = functionName = this.convertIdentifier(functionSymbol.getText());
                boolean isAccessor = functionDeclaration.isGetterOrSetter();
                if (isAccessor && (accessorAnnotation = Metadata.find(this.currentMetadata, "Accessor")) != null) {
                    String accessorPrefix = functionDeclaration.getSymGetOrSet().getText();
                    String accessorName = (String)accessorAnnotation.getArgumentValue(DEFAULT_ANNOTATION_PARAMETER_NAME);
                    if (accessorName != null) {
                        methodName = accessorName;
                    } else {
                        TypeRelation typeRelation = functionDeclaration.getOptTypeRelation();
                        String methodPrefix = functionDeclaration.isGetter() && typeRelation != null && "Boolean".equals(typeRelation.getType().getIde().getName()) ? "is" : accessorPrefix;
                        methodName = methodPrefix + MxmlUtils.capitalize(functionName);
                    }
                    functionName = accessorPrefix + "$" + functionName;
                    isAccessor = false;
                }
                String overriddenMethodName = null;
                PropertyDefinition overriddenPropertyDefinition = null;
                if (functionDeclaration.isOverride() || functionDeclaration.isPrivate() && !functionDeclaration.isStatic()) {
                    String privateMethodName = methodName + "$" + functionDeclaration.getClassDeclaration().getInheritanceLevel();
                    if (functionDeclaration.isOverride()) {
                        overriddenMethodName = privateMethodName;
                        this.getClassDefinitionBuilder((Declaration)functionDeclaration).super$Used = true;
                    } else {
                        methodName = privateMethodName;
                    }
                } else if (functionDeclaration.isStatic()) {
                    functionName = functionName + "$static";
                }
                Map<String, PropertyDefinition> members = this.membersOrStaticMembers(functionDeclaration);
                if (isAccessor) {
                    this.out.writeSymbolWhitespace(functionDeclaration.getIde().getSymbol());
                    this.out.writeSymbolWhitespace(functionDeclaration.getSymGetOrSet());
                    String accessorPrefix = functionDeclaration.getSymGetOrSet().getText() + "$";
                    String accessorName = accessorPrefix + functionName;
                    this.out.writeToken(accessorName);
                    if (!functionDeclaration.isPrivateStatic()) {
                        PropertyDefinition accessorDefinition = members.get(methodName);
                        if (accessorDefinition == null) {
                            accessorDefinition = new PropertyDefinition();
                            members.put(methodName, accessorDefinition);
                        }
                        if (functionDeclaration.isGetter()) {
                            accessorDefinition.get = accessorName;
                            if (functionDeclaration.isOverride() && accessorDefinition.set == null) {
                                accessorDefinition.set = "super$.__lookupSetter__('" + methodName + "')";
                            }
                        } else {
                            accessorDefinition.set = accessorName;
                            if (functionDeclaration.isOverride() && accessorDefinition.get == null) {
                                accessorDefinition.get = "super$.__lookupGetter__('" + methodName + "')";
                            }
                        }
                        if (overriddenMethodName != null) {
                            overriddenPropertyDefinition = new PropertyDefinition();
                            overriddenPropertyDefinition.get = "super$.__lookupGetter__('" + methodName + "')";
                            overriddenPropertyDefinition.set = "super$.__lookupSetter__('" + methodName + "')";
                        }
                    }
                } else {
                    this.out.writeSymbolWhitespace(functionSymbol);
                    this.out.writeToken(functionName);
                    if (!functionDeclaration.isPrimaryDeclaration() && !functionDeclaration.isPrivateStatic()) {
                        members.put(functionDeclaration.isConstructor() ? "constructor" : methodName, new PropertyDefinition(functionName));
                        if (overriddenMethodName != null) {
                            overriddenPropertyDefinition = new PropertyDefinition("super$." + methodName);
                        }
                    }
                }
                if (overriddenMethodName != null) {
                    members.put(overriddenMethodName, overriddenPropertyDefinition);
                }
                this.generateFunTailCode(functionDeclaration.getFun());
            }
            if (functionDeclaration.isPrimaryDeclaration()) {
                this.out.write(String.format(" $primaryDeclaration(%s);", functionDeclaration.getName()));
            }
        }
        this.resetCurrentMetadata(functionDeclaration);
    }

    @Override
    public void visitClassDeclaration(ClassDeclaration classDeclaration) throws IOException {
        ClassDefinitionBuilder classDefinitionBuilder = classDeclaration.isPrimaryDeclaration() ? this.primaryClassDefinitionBuilder : (this.secondaryClassDefinitionBuilder = new ClassDefinitionBuilder());
        classDefinitionBuilder.storeCurrentMetadata(DEFAULT_ANNOTATION_PARAMETER_NAME, this.currentMetadata);
        this.currentMetadata = new LinkedList();
        this.out.beginComment();
        this.writeModifiers(this.out, classDeclaration);
        this.out.writeSymbol(classDeclaration.getSymClass());
        classDeclaration.getIde().visit(this);
        this.visitIfNotNull(classDeclaration.getOptExtends());
        this.visitIfNotNull(classDeclaration.getOptImplements());
        this.out.endComment();
        classDeclaration.getBody().visit(this);
        for (IdeDeclaration secondaryDeclaration : classDeclaration.getSecondaryDeclarations()) {
            String secondaryDeclarationName = secondaryDeclaration.getName();
            if (secondaryDeclaration instanceof ClassDeclaration) {
                ClassDeclaration secondaryClassDeclaration = (ClassDeclaration)secondaryDeclaration;
                this.out.write(new MessageFormat("function {0}_()'{").format(secondaryDeclarationName));
                secondaryClassDeclaration.visit(this);
                JsonObject secondaryClassDefinition = this.createClassDefinition(secondaryClassDeclaration, this.secondaryClassDefinitionBuilder);
                this.out.write("return AS3.class_({id:\"as3/" + secondaryClassDeclaration.getQualifiedNameStr() + "\"}," + secondaryClassDefinition.toString(-1, -1) + ");");
                this.out.write("}");
                this.primaryClassDefinitionBuilder.staticCode.append(new MessageFormat("    var {0}$static={0}_();\n").format(secondaryDeclarationName));
                continue;
            }
            secondaryDeclaration.visit(this);
        }
        if (!classDeclaration.isInterface() && classDeclaration.getConstructor() == null) {
            this.out.write("function " + classDeclaration.getName() + "() {");
            new SuperCallCodeGenerator(classDeclaration).generate(this.out, true);
            this.out.write("}");
            classDefinitionBuilder.members.put("constructor", new PropertyDefinition(classDeclaration.getName()));
        }
    }

    private void generateFieldInitCode(ClassDeclaration classDeclaration, boolean startWithSemicolon) throws IOException {
        Iterator<VariableDeclaration> iterator = classDeclaration.getFieldsWithInitializer().iterator();
        if (iterator.hasNext()) {
            if (startWithSemicolon) {
                this.out.write(";");
            }
            do {
                VariableDeclaration field = iterator.next();
                this.generateInitCode(field, true);
            } while (iterator.hasNext());
        }
    }

    public void generateInitCode(VariableDeclaration field, boolean endWithSemicolon) throws IOException {
        this.out.write(field.getName() + "_.call(this)");
        if (endWithSemicolon) {
            this.out.write(";");
        }
    }

    @Override
    public void visitNamespaceDeclaration(NamespaceDeclaration namespaceDeclaration) throws IOException {
        this.out.beginString();
        this.writeModifiers(this.out, namespaceDeclaration);
        this.out.writeSymbol(namespaceDeclaration.getSymNamespace());
        namespaceDeclaration.getIde().visit(this);
        this.out.endString();
        this.out.writeSymbolWhitespace(namespaceDeclaration.getOptInitializer().getSymEq());
        this.out.writeToken(",");
        namespaceDeclaration.getOptInitializer().getValue().visit(this);
        this.writeSymbolReplacement(namespaceDeclaration.getOptSymSemicolon(), ",[]");
    }

    @Override
    public void visitPackageDeclaration(PackageDeclaration packageDeclaration) throws IOException {
        this.out.beginComment();
        this.out.writeSymbol(packageDeclaration.getSymPackage());
        this.visitIfNotNull(packageDeclaration.getIde());
        this.out.endComment();
    }

    @Override
    public void visitSuperConstructorCallStatement(SuperConstructorCallStatement superConstructorCallStatement) throws IOException {
        if (superConstructorCallStatement.getClassDeclaration().getInheritanceLevel() > 1) {
            this.out.writeSymbolWhitespace(superConstructorCallStatement.getSymbol());
            this.generateSuperConstructorCallCode(superConstructorCallStatement.getArgs());
            this.generateFieldInitCode(superConstructorCallStatement.getClassDeclaration(), true);
        } else {
            this.out.beginComment();
            this.out.writeSymbol(superConstructorCallStatement.getSymbol());
            this.visitIfNotNull(superConstructorCallStatement.getArgs());
            this.out.endComment();
            this.generateFieldInitCode(superConstructorCallStatement.getClassDeclaration(), false);
        }
        this.out.writeSymbol(superConstructorCallStatement.getSymSemicolon());
    }

    private void generateSuperConstructorCallCode(ParenthesizedExpr<CommaSeparatedList<Expr>> args) throws IOException {
        this.out.write("Super.call");
        if (args == null) {
            this.out.writeToken("(this)");
        } else {
            this.out.writeSymbol(args.getLParen());
            this.out.writeToken("this");
            CommaSeparatedList<Expr> arguments = args.getExpr();
            if (arguments != null) {
                if (arguments.getHead() != null) {
                    this.out.writeToken(",");
                }
                arguments.visit(this);
            }
            this.out.writeSymbol(args.getRParen());
        }
    }

    @Override
    public void visitAnnotation(Annotation annotation) throws IOException {
        this.currentMetadata.add(new Metadata(annotation.getIde().getName()));
        this.out.beginComment();
        this.out.writeSymbol(annotation.getLeftBracket());
        annotation.getIde().visit(this);
        this.writeOptSymbol(annotation.getOptLeftParen());
        this.visitIfNotNull(annotation.getOptAnnotationParameters());
        this.writeOptSymbol(annotation.getOptRightParen());
        this.out.writeSymbol(annotation.getRightBracket());
        this.out.endComment();
    }

    @Override
    public void visitUseNamespaceDirective(UseNamespaceDirective useNamespaceDirective) throws IOException {
        this.out.beginComment();
        this.out.writeSymbol(useNamespaceDirective.getUseKeyword());
        this.out.writeSymbol(useNamespaceDirective.getNamespaceKeyword());
        useNamespaceDirective.getNamespace().visit(this);
        this.out.writeSymbol(useNamespaceDirective.getSymSemicolon());
        this.out.endComment();
    }

    @Override
    public void visitImportDirective(ImportDirective importDirective) throws IOException {
        if (importDirective.isExplicit()) {
            this.out.beginComment();
            this.out.writeSymbol(importDirective.getImportKeyword());
            importDirective.getIde().visit(this);
            this.out.writeSymbol(importDirective.getSymSemicolon());
            this.out.endComment();
        }
    }

    static {
        PRIMITIVES.add("Boolean");
        PRIMITIVES.add("String");
        PRIMITIVES.add("Number");
        PRIMITIVES.add("int");
        PRIMITIVES.add("uint");
        PRIMITIVES.add("Object");
        PRIMITIVES.add("RegExp");
        PRIMITIVES.add("Date");
        PRIMITIVES.add("Array");
        PRIMITIVES.add("Error");
        PRIMITIVES.add("Vector");
        PRIMITIVES.add("Class");
        PRIMITIVES.add("Function");
        PRIMITIVES.add("XML");
        ALIAS_THIS_CODE_GENERATOR = new CodeGenerator(){

            @Override
            public void generate(JsWriter out, boolean first) throws IOException {
                out.write("var this$=this;");
            }
        };
    }

    private static class ClassDefinitionBuilder {
        JsonObject metadata = new JsonObject(new Object[0]);
        Map<String, PropertyDefinition> members = new LinkedHashMap<String, PropertyDefinition>();
        Map<String, PropertyDefinition> staticMembers = new LinkedHashMap<String, PropertyDefinition>();
        StringBuilder staticInitializerCode = new StringBuilder();
        StringBuilder staticCode = new StringBuilder();
        boolean super$Used = false;

        private ClassDefinitionBuilder() {
        }

        void storeCurrentMetadata(String memberName, LinkedList<Metadata> currentMetadata) {
            Object memberMetadata = this.metadata.get(memberName);
            List<Object> allMetadata = memberMetadata instanceof JsonArray ? ((JsonArray)memberMetadata).getItems() : new LinkedList();
            allMetadata.addAll(this.compress(currentMetadata));
            if (!allMetadata.isEmpty()) {
                this.metadata.set(memberName, new JsonArray(allMetadata.toArray()));
            }
        }

        public List<Object> compress(List<Metadata> metadataList) {
            ArrayList<Object> comressedMetadataList = new ArrayList<Object>();
            for (Metadata metadata : metadataList) {
                if (ANNOTATIONS_FOR_COMPILER_ONLY.contains(metadata.name)) continue;
                comressedMetadataList.add(metadata.name);
                if (metadata.args.isEmpty()) continue;
                ArrayList<Object> argNameValues = new ArrayList<Object>();
                for (MetadataArgument metadataArgument : metadata.args) {
                    argNameValues.add(metadataArgument.name);
                    argNameValues.add(metadataArgument.value);
                }
                comressedMetadataList.add(new JsonArray(argNameValues.toArray()));
            }
            return comressedMetadataList;
        }
    }

    private static class MetadataArgument {
        String name;
        Object value;

        private MetadataArgument(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }

    private static class Metadata {
        String name;
        List<MetadataArgument> args = new ArrayList<MetadataArgument>();

        static Metadata find(List<Metadata> metadataList, String name) {
            for (Metadata metadata : metadataList) {
                if (!metadata.name.equals(name)) continue;
                return metadata;
            }
            return null;
        }

        private Metadata(String name) {
            this.name = name;
        }

        public Object getArgumentValue(String argumentName) {
            for (MetadataArgument arg : this.args) {
                if (!arg.name.equals(argumentName)) continue;
                return arg.value;
            }
            return null;
        }
    }

    private static class PropertyDefinition {
        String value;
        boolean writable;
        boolean configurable;
        String get;
        String set;

        private PropertyDefinition() {
        }

        private PropertyDefinition(String value) {
            this.value = value;
        }

        private PropertyDefinition(String value, boolean writable) {
            this.value = value;
            this.writable = writable;
        }

        JsonObject asJson() {
            JsonObject result = new JsonObject(new Object[0]);
            if (this.value != null) {
                result.set("value", JsonObject.code(this.value));
            }
            if (this.get != null) {
                result.set("get", JsonObject.code(this.get));
            }
            if (this.set != null) {
                result.set("set", JsonObject.code(this.set));
            }
            if (this.writable) {
                result.set("writable", true);
            }
            if (this.configurable) {
                result.set("configurable", true);
            }
            return result;
        }

        Object asAbbreviatedJson() {
            if (this.isValueOnly()) {
                return JsonObject.code(this.value);
            }
            return this.asJson();
        }

        boolean isValueOnly() {
            return !this.writable && !this.configurable && this.get == null && this.set == null;
        }
    }

    private class SuperCallCodeGenerator
    implements CodeGenerator {
        private ClassDeclaration classDeclaration;

        public SuperCallCodeGenerator(ClassDeclaration classDeclaration) {
            this.classDeclaration = classDeclaration;
        }

        @Override
        public void generate(JsWriter out, boolean first) throws IOException {
            int inheritanceLevel = this.classDeclaration.getInheritanceLevel();
            if (inheritanceLevel > 1) {
                JsCodeGenerator.this.generateSuperConstructorCallCode(null);
                out.writeToken(";");
            }
            JsCodeGenerator.this.generateFieldInitCode(this.classDeclaration, false);
        }
    }

    private static class VarCodeGenerator
    implements CodeGenerator {
        private final JooSymbol localErrorVar;
        private final JooSymbol errorVar;

        public VarCodeGenerator(JooSymbol localErrorVar, JooSymbol errorVar) {
            this.localErrorVar = localErrorVar;
            this.errorVar = errorVar;
        }

        @Override
        public void generate(JsWriter out, boolean first) throws IOException {
            out.writeToken("var");
            out.writeSymbolToken(this.localErrorVar);
            out.writeToken("=");
            out.writeSymbolToken(this.errorVar);
            out.writeToken(";");
        }
    }
}

