/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.List;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.IdeExpr;
import net.jangaroo.jooc.ast.PostfixOpExpr;
import net.jangaroo.jooc.ast.TypeRelation;
import net.jangaroo.jooc.ast.Typed;

public class DotExpr
extends PostfixOpExpr {
    private Ide ide;

    public DotExpr(Expr expr, JooSymbol symDot, Ide ide) {
        super(symDot, expr);
        this.ide = ide;
    }

    void setOriginal(IdeExpr ideExpr) {
        this.getIde().setBound(ideExpr.getIde().isBound());
        this.scope(ideExpr.getIde().getScope());
        this.analyze(ideExpr.getParentNode());
        if (this.getType() == null) {
            this.setType(ideExpr.getType());
        }
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(super.getChildren(), this.ide);
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitDotExpr(this);
    }

    public Ide getIde() {
        return this.ide;
    }

    @Override
    public void scope(Scope scope) {
        super.scope(scope);
        this.getIde().scope(scope);
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        this.ide.analyze(this);
        IdeDeclaration qualiferType = this.getArg().getType();
        if (qualiferType != null) {
            TypeRelation typeRelation;
            IdeDeclaration memberDeclaration = this.getArg().getType().resolvePropertyDeclaration(this.getIde().getName());
            if (memberDeclaration != null && memberDeclaration.isStatic()) {
                throw Jooc.error(this.getIde().getIde(), "static member used in dynamic context");
            }
            if (memberDeclaration instanceof Typed && (typeRelation = ((Typed)((Object)memberDeclaration)).getOptTypeRelation()) != null) {
                memberDeclaration = typeRelation.getType().getIde().getDeclaration();
            }
            this.setType(memberDeclaration);
        }
    }
}

