/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.Annotation;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.ImportDirective;
import net.jangaroo.jooc.ast.NamespaceDeclaration;
import net.jangaroo.jooc.ast.NodeImplBase;
import net.jangaroo.jooc.ast.PackageDeclaration;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.utils.AS3Type;
import net.jangaroo.utils.CompilerUtils;

public class CompilationUnit
extends NodeImplBase {
    private PackageDeclaration packageDeclaration;
    private JooSymbol lBrace;
    private List<AstNode> directives;
    private IdeDeclaration primaryDeclaration;
    private JooSymbol rBrace;
    private Map<String, CompilationUnit> dependencies = new LinkedHashMap<String, CompilationUnit>();
    private List<String> resourceDependencies = new ArrayList<String>();
    private Set<String> publicApiDependencies = new HashSet<String>();
    private InputSource source;
    private JangarooParser compiler;
    private static final Collection<String> IMAGE_EXTENSIONS = Arrays.asList("png", "gif", "bmp", "jpg", "jpeg");
    private int amdVarCounter = 0;

    public CompilationUnit(PackageDeclaration packageDeclaration, JooSymbol lBrace, List<AstNode> directives, IdeDeclaration primaryDeclaration, JooSymbol rBrace, List<IdeDeclaration> secondaryDeclarations) {
        this.packageDeclaration = packageDeclaration;
        this.lBrace = lBrace;
        this.directives = directives;
        this.primaryDeclaration = primaryDeclaration;
        if (primaryDeclaration instanceof ClassDeclaration) {
            ((ClassDeclaration)primaryDeclaration).setSecondaryDeclarations(secondaryDeclarations);
        }
        this.rBrace = rBrace;
    }

    @Override
    public List<? extends AstNode> getChildren() {
        ArrayList<AstNode> result = new ArrayList<AstNode>(this.makeChildren(super.getChildren(), this.packageDeclaration, this.directives, this.primaryDeclaration));
        if (this.primaryDeclaration instanceof ClassDeclaration) {
            result.addAll(((ClassDeclaration)this.primaryDeclaration).getSecondaryDeclarations());
        }
        return result;
    }

    public List<AstNode> getDirectives() {
        return this.directives;
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitCompilationUnit(this);
    }

    private void addStarImport(Ide packageIde) {
        ImportDirective importDirective = new ImportDirective(packageIde, AS3Type.ANY.toString());
        this.directives.add(0, importDirective);
    }

    @Override
    public void scope(Scope scope) {
        this.withNewDeclarationScope(this, scope, new NodeImplBase.Scoped(){

            @Override
            public void run(Scope scope) {
                Ide packageIde = CompilationUnit.this.packageDeclaration.getIde();
                CompilationUnit.this.packageDeclaration.scope(scope);
                if (packageIde != null) {
                    CompilationUnit.this.addStarImport(packageIde);
                }
                CompilationUnit.this.addStarImport(null);
                for (AstNode node : CompilationUnit.this.getDirectives()) {
                    node.scope(scope);
                }
                CompilationUnit.this.withNewDeclarationScope(CompilationUnit.this.packageDeclaration, scope, new NodeImplBase.Scoped(){

                    @Override
                    public void run(Scope scope) {
                        CompilationUnit.this.primaryDeclaration.scope(scope);
                    }
                });
            }
        });
    }

    public PackageDeclaration getPackageDeclaration() {
        return this.packageDeclaration;
    }

    public IdeDeclaration getPrimaryDeclaration() {
        return this.primaryDeclaration;
    }

    public JooSymbol getLBrace() {
        return this.lBrace;
    }

    public JooSymbol getRBrace() {
        return this.rBrace;
    }

    public Set<String> getDependencies() {
        return this.dependencies.keySet();
    }

    public List<String> getResourceDependencies() {
        return this.resourceDependencies;
    }

    public Set<String> getPublicApiDependencies() {
        return this.publicApiDependencies;
    }

    public Collection<CompilationUnit> getDependenciesAsCompilationUnits() {
        return this.dependencies.values();
    }

    public JangarooParser getCompiler() {
        return this.compiler;
    }

    public void setCompiler(JangarooParser compiler) {
        this.compiler = compiler;
    }

    public void setSource(InputSource source) {
        this.source = source;
    }

    public InputSource getSource() {
        return this.source;
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        this.packageDeclaration.analyze(this);
        this.analyze(this.packageDeclaration, this.directives);
        this.primaryDeclaration.analyze(this);
    }

    public Set<String> getUsedAnnotations() {
        LinkedHashSet<String> usedAnnotations = new LinkedHashSet<String>();
        for (Annotation annotation : this.getAnnotations()) {
            usedAnnotations.add(annotation.getMetaName());
        }
        return usedAnnotations;
    }

    public List<Annotation> getAnnotations() {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (AstNode directive : this.getDirectives()) {
            if (!(directive instanceof Annotation)) continue;
            annotations.add((Annotation)directive);
        }
        return annotations;
    }

    public Annotation getAnnotation(String name) {
        for (Annotation annotation : this.getAnnotations()) {
            if (!name.equals(annotation.getMetaName())) continue;
            return annotation;
        }
        return null;
    }

    @Override
    public JooSymbol getSymbol() {
        return this.packageDeclaration.getSymbol();
    }

    public void addDependency(String otherUnitQName) {
        this.addDependency(this.getCompiler().getCompilationUnit(otherUnitQName));
    }

    public void addDependency(CompilationUnit otherUnit) {
        if (otherUnit != null && otherUnit != this) {
            String qname = otherUnit.getPrimaryDeclaration().getQualifiedNameStr();
            this.dependencies.put(qname, otherUnit);
        }
    }

    public void addPublicApiDependency(CompilationUnit otherUnit) {
        String qname;
        IdeDeclaration otherUnitPrimaryDeclaration;
        if (otherUnit != null && otherUnit != this && ((otherUnitPrimaryDeclaration = otherUnit.getPrimaryDeclaration()) instanceof ClassDeclaration || otherUnitPrimaryDeclaration instanceof NamespaceDeclaration) && (qname = otherUnitPrimaryDeclaration.getQualifiedNameStr()).indexOf(46) != -1) {
            this.publicApiDependencies.add(qname);
        }
    }

    public String addResourceDependency(String relativePath) {
        String path;
        String string = path = relativePath.startsWith("/") || relativePath.startsWith("\\") ? relativePath : new File(this.source.getParent().getRelativePath(), relativePath).getPath().replace('\\', '/');
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String assetType = CompilationUnit.guessAssetType(path);
        this.resourceDependencies.add(assetType + "!" + path);
        if ("image".equals(assetType)) {
            this.addDependency("flash.display.Bitmap");
        }
        return path;
    }

    public static String guessAssetType(String path) {
        String extension = CompilerUtils.extension((String)path);
        String assetType = "text";
        if (IMAGE_EXTENSIONS.contains(extension)) {
            assetType = "image";
        }
        return assetType;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getPrimaryDeclaration().getQualifiedNameStr() + ")";
    }

    public String createAmdVar() {
        return "$$" + ++this.amdVarCounter;
    }
}

