/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.backend;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.TreeSet;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.ast.Annotation;
import net.jangaroo.jooc.ast.AnnotationParameter;
import net.jangaroo.jooc.ast.ApplyExpr;
import net.jangaroo.jooc.ast.ArrayIndexExpr;
import net.jangaroo.jooc.ast.ArrayLiteral;
import net.jangaroo.jooc.ast.AsExpr;
import net.jangaroo.jooc.ast.AssignmentOpExpr;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.BinaryOpExpr;
import net.jangaroo.jooc.ast.BlockStatement;
import net.jangaroo.jooc.ast.BreakStatement;
import net.jangaroo.jooc.ast.CaseStatement;
import net.jangaroo.jooc.ast.Catch;
import net.jangaroo.jooc.ast.ClassBody;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.ConditionalExpr;
import net.jangaroo.jooc.ast.ContinueStatement;
import net.jangaroo.jooc.ast.Declaration;
import net.jangaroo.jooc.ast.DefaultStatement;
import net.jangaroo.jooc.ast.Directive;
import net.jangaroo.jooc.ast.DoStatement;
import net.jangaroo.jooc.ast.DotExpr;
import net.jangaroo.jooc.ast.EmptyDeclaration;
import net.jangaroo.jooc.ast.EmptyStatement;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.Extends;
import net.jangaroo.jooc.ast.ForInStatement;
import net.jangaroo.jooc.ast.ForInitializer;
import net.jangaroo.jooc.ast.ForStatement;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.FunctionExpr;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeExpr;
import net.jangaroo.jooc.ast.IdeWithTypeParam;
import net.jangaroo.jooc.ast.IfStatement;
import net.jangaroo.jooc.ast.Implements;
import net.jangaroo.jooc.ast.ImportDirective;
import net.jangaroo.jooc.ast.InfixOpExpr;
import net.jangaroo.jooc.ast.Initializer;
import net.jangaroo.jooc.ast.IsExpr;
import net.jangaroo.jooc.ast.LabeledStatement;
import net.jangaroo.jooc.ast.LiteralExpr;
import net.jangaroo.jooc.ast.NamespaceDeclaration;
import net.jangaroo.jooc.ast.NamespacedIde;
import net.jangaroo.jooc.ast.NewExpr;
import net.jangaroo.jooc.ast.ObjectField;
import net.jangaroo.jooc.ast.ObjectLiteral;
import net.jangaroo.jooc.ast.PackageDeclaration;
import net.jangaroo.jooc.ast.Parameter;
import net.jangaroo.jooc.ast.Parameters;
import net.jangaroo.jooc.ast.ParenthesizedExpr;
import net.jangaroo.jooc.ast.PostfixOpExpr;
import net.jangaroo.jooc.ast.PredefinedTypeDeclaration;
import net.jangaroo.jooc.ast.PrefixOpExpr;
import net.jangaroo.jooc.ast.QualifiedIde;
import net.jangaroo.jooc.ast.ReturnStatement;
import net.jangaroo.jooc.ast.SemicolonTerminatedStatement;
import net.jangaroo.jooc.ast.SuperConstructorCallStatement;
import net.jangaroo.jooc.ast.SwitchStatement;
import net.jangaroo.jooc.ast.ThrowStatement;
import net.jangaroo.jooc.ast.TryStatement;
import net.jangaroo.jooc.ast.Type;
import net.jangaroo.jooc.ast.TypeRelation;
import net.jangaroo.jooc.ast.TypedIdeDeclaration;
import net.jangaroo.jooc.ast.UseNamespaceDirective;
import net.jangaroo.jooc.ast.VariableDeclaration;
import net.jangaroo.jooc.ast.VectorLiteral;
import net.jangaroo.jooc.ast.WhileStatement;
import net.jangaroo.jooc.model.ActionScriptModel;
import net.jangaroo.jooc.model.AnnotatedModel;
import net.jangaroo.jooc.model.AnnotationModel;
import net.jangaroo.jooc.model.AnnotationPropertyModel;
import net.jangaroo.jooc.model.ClassModel;
import net.jangaroo.jooc.model.CompilationUnitModel;
import net.jangaroo.jooc.model.DocumentedModel;
import net.jangaroo.jooc.model.FieldModel;
import net.jangaroo.jooc.model.MemberModel;
import net.jangaroo.jooc.model.MethodModel;
import net.jangaroo.jooc.model.MethodType;
import net.jangaroo.jooc.model.NamedModel;
import net.jangaroo.jooc.model.NamespaceModel;
import net.jangaroo.jooc.model.NamespacedModel;
import net.jangaroo.jooc.model.ParamModel;
import net.jangaroo.jooc.model.TypedModel;
import net.jangaroo.jooc.model.ValuedModel;

public class ApiModelGenerator {
    private boolean excludeClassByDefault = false;

    public ApiModelGenerator(boolean excludeClassByDefault) {
        this.excludeClassByDefault = excludeClassByDefault;
    }

    public boolean isExcludeClassByDefault() {
        return this.excludeClassByDefault;
    }

    public CompilationUnitModel generateModel(CompilationUnit compilationUnit) throws IOException {
        ApiModelGeneratingAstVisitor visitor = new ApiModelGeneratingAstVisitor();
        compilationUnit.visit(visitor);
        return (CompilationUnitModel)visitor.getCurrent(CompilationUnitModel.class);
    }

    private static String trimAsdoc(String asdoc) {
        int oldLength;
        do {
            oldLength = asdoc.length();
            if ((asdoc = asdoc.trim()).startsWith("*")) {
                asdoc = asdoc.substring(1);
            }
            if (!asdoc.endsWith("*")) continue;
            asdoc = asdoc.substring(0, asdoc.length() - 1);
        } while (asdoc.length() < oldLength);
        return asdoc;
    }

    private class ApiModelGeneratingAstVisitor
    implements AstVisitor {
        private Deque<ActionScriptModel> modelStack;
        private StringBuilder code;
        private StringBuilder asdoc = new StringBuilder();
        private List<AnnotationModel> annotationModels = new ArrayList<AnnotationModel>();

        private ApiModelGeneratingAstVisitor() {
        }

        @Override
        public void visitTypeRelation(TypeRelation typeRelation) throws IOException {
            this.startRecordingCode();
            typeRelation.getType().visit(this);
            ((TypedModel)this.modelStack.peek()).setType(this.consumeRecordedCode());
        }

        @Override
        public void visitAnnotationParameter(AnnotationParameter annotationParameter) throws IOException {
            AnnotationPropertyModel annotationPropertyModel = new AnnotationPropertyModel();
            this.modelStack.push(annotationPropertyModel);
            this.visitIfNotNull(annotationParameter.getOptName());
            this.startRecordingCode();
            this.visitIfNotNull(annotationParameter.getValue());
            annotationPropertyModel.setValue(this.consumeRecordedCode());
            this.modelStack.pop();
            ((AnnotationModel)this.modelStack.peek()).addProperty(annotationPropertyModel);
        }

        @Override
        public void visitExtends(Extends anExtends) throws IOException {
            this.getCurrent(ClassModel.class).setSuperclass(anExtends.getSuperClass().getQualifiedNameStr());
        }

        @Override
        public void visitInitializer(Initializer initializer) throws IOException {
            if (initializer.getValue().isCompileTimeConstant()) {
                this.startRecordingCode();
                initializer.getValue().visit(this);
                ((ValuedModel)this.modelStack.peek()).setValue(this.consumeRecordedCode());
            }
        }

        @Override
        public void visitObjectField(ObjectField objectField) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visitForInitializer(ForInitializer forInitializer) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visitCompilationUnit(CompilationUnit compilationUnit) throws IOException {
            this.modelStack = new ArrayDeque<ActionScriptModel>();
            this.code = null;
            CompilationUnitModel compilationUnitModel = new CompilationUnitModel("");
            this.modelStack.push(compilationUnitModel);
            compilationUnit.getPackageDeclaration().visit(this);
            for (String publicApiDependency : new TreeSet<String>(compilationUnit.getPublicApiDependencies())) {
                compilationUnitModel.addImport(publicApiDependency);
            }
            this.visitAll(compilationUnit.getDirectives());
            compilationUnit.getPrimaryDeclaration().visit(this);
        }

        @Override
        public void visitIde(Ide ide) throws IOException {
            if (this.code != null) {
                this.recordCode(ide.getQualifiedNameStr());
            } else {
                ((NamedModel)this.modelStack.peek()).setName(ide.getQualifiedNameStr());
            }
        }

        @Override
        public void visitQualifiedIde(QualifiedIde qualifiedIde) throws IOException {
            this.visitIde(qualifiedIde);
        }

        @Override
        public void visitIdeWithTypeParam(IdeWithTypeParam ideWithTypeParam) throws IOException {
            this.recordCode(ideWithTypeParam.getOriginalIde().getText() + ideWithTypeParam.getSymDotLt().getText());
            ideWithTypeParam.getType().visit(this);
            this.recordCode(ideWithTypeParam.getSymGt().getText());
        }

        @Override
        public void visitNamespacedIde(NamespacedIde namespacedIde) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visitImplements(Implements anImplements) throws IOException {
            for (CommaSeparatedList<Ide> superTypes = anImplements.getSuperTypes(); superTypes != null; superTypes = superTypes.getTail()) {
                this.getCurrent(ClassModel.class).addInterface(superTypes.getHead().getQualifiedNameStr());
            }
        }

        @Override
        public void visitType(Type type) throws IOException {
            type.getIde().visit(this);
        }

        @Override
        public void visitObjectLiteral(ObjectLiteral objectLiteral) throws IOException {
            throw this.shouldOnlyBeCalledForCompileTimeConstants();
        }

        private IllegalStateException shouldOnlyBeCalledForCompileTimeConstants() {
            return new IllegalStateException("should only be called for compile time constants");
        }

        @Override
        public void visitIdeExpression(IdeExpr ideExpr) throws IOException {
            ideExpr.getIde().visit(this);
        }

        @Override
        public <T extends Expr> void visitParenthesizedExpr(ParenthesizedExpr<T> parenthesizedExpr) throws IOException {
            throw this.shouldOnlyBeCalledForCompileTimeConstants();
        }

        @Override
        public void visitArrayLiteral(ArrayLiteral arrayLiteral) throws IOException {
            throw this.shouldOnlyBeCalledForCompileTimeConstants();
        }

        @Override
        public void visitAssignmentOpExpr(AssignmentOpExpr assignmentOpExpr) throws IOException {
            throw this.shouldOnlyBeCalledForCompileTimeConstants();
        }

        @Override
        public void visitInfixOpExpr(InfixOpExpr infixOpExpr) throws IOException {
            this.visitBinaryOpExpr(infixOpExpr);
        }

        private void consumeRecordedAnnotations() {
            this.getCurrent(AnnotatedModel.class).setAnnotations(this.annotationModels);
            this.annotationModels = new ArrayList<AnnotationModel>();
        }

        private void recordAsdoc(JooSymbol symbol) {
            String whitespace;
            int startPos;
            if (symbol != null && (startPos = (whitespace = symbol.getWhitespace()).indexOf("/**")) != -1) {
                int endPos = whitespace.indexOf("*/", startPos);
                if (this.asdoc.length() > 0) {
                    this.asdoc.append('\n');
                }
                this.asdoc.append(whitespace.substring(startPos + 2, endPos - 1));
            }
        }

        private void recordAsdoc(Declaration declaration) {
            for (JooSymbol symbol : declaration.getSymModifiers()) {
                this.recordAsdoc(symbol);
            }
        }

        private void consumeRecordedAsdoc() {
            ((DocumentedModel)this.modelStack.peek()).setAsdoc(ApiModelGenerator.trimAsdoc(this.asdoc.toString()));
            this.asdoc.setLength(0);
        }

        private void startRecordingCode() {
            this.code = new StringBuilder();
        }

        private void recordCode(JooSymbol symbol) {
            this.recordCode(symbol.getText());
        }

        private void recordCode(String text) {
            this.code.append(text);
        }

        private String consumeRecordedCode() {
            String recordedCode = this.code.toString();
            this.code = null;
            return recordedCode;
        }

        @Override
        public void visitAsExpr(AsExpr asExpr) throws IOException {
            this.visitInfixOpExpr(asExpr);
        }

        @Override
        public void visitArrayIndexExpr(ArrayIndexExpr arrayIndexExpr) throws IOException {
            throw this.shouldOnlyBeCalledForCompileTimeConstants();
        }

        @Override
        public void visitFunctionExpr(FunctionExpr functionExpr) throws IOException {
            throw this.shouldOnlyBeCalledForCompileTimeConstants();
        }

        @Override
        public void visitVectorLiteral(VectorLiteral vectorLiteral) throws IOException {
            throw this.shouldOnlyBeCalledForCompileTimeConstants();
        }

        @Override
        public void visitApplyExpr(ApplyExpr applyExpr) throws IOException {
            throw this.shouldOnlyBeCalledForCompileTimeConstants();
        }

        @Override
        public void visitNewExpr(NewExpr newExpr) throws IOException {
            throw this.shouldOnlyBeCalledForCompileTimeConstants();
        }

        @Override
        public void visitClassBody(ClassBody classBody) throws IOException {
            for (Directive directive : classBody.getDirectives()) {
                directive.visit(this);
            }
        }

        @Override
        public void visitBlockStatement(BlockStatement blockStatement) throws IOException {
        }

        @Override
        public void visitDefaultStatement(DefaultStatement defaultStatement) throws IOException {
        }

        @Override
        public void visitLabeledStatement(LabeledStatement labeledStatement) throws IOException {
        }

        @Override
        public void visitIfStatement(IfStatement ifStatement) throws IOException {
        }

        @Override
        public void visitCaseStatement(CaseStatement caseStatement) throws IOException {
        }

        @Override
        public void visitTryStatement(TryStatement tryStatement) throws IOException {
        }

        @Override
        public void visitCatch(Catch aCatch) throws IOException {
            throw new IllegalStateException("should not occur, because we are omitting try statements");
        }

        @Override
        public void visitForInStatement(ForInStatement forInStatement) throws IOException {
        }

        @Override
        public void visitWhileStatement(WhileStatement whileStatement) throws IOException {
        }

        @Override
        public void visitForStatement(ForStatement forStatement) throws IOException {
        }

        @Override
        public void visitDoStatement(DoStatement doStatement) throws IOException {
        }

        @Override
        public void visitSwitchStatement(SwitchStatement switchStatement) throws IOException {
        }

        @Override
        public void visitSemicolonTerminatedStatement(SemicolonTerminatedStatement semicolonTerminatedStatement) throws IOException {
        }

        @Override
        public void visitContinueStatement(ContinueStatement continueStatement) throws IOException {
        }

        @Override
        public void visitBreakStatement(BreakStatement breakStatement) throws IOException {
        }

        @Override
        public void visitThrowStatement(ThrowStatement throwStatement) throws IOException {
        }

        @Override
        public void visitReturnStatement(ReturnStatement returnStatement) throws IOException {
        }

        @Override
        public void visitEmptyStatement(EmptyStatement emptyStatement) throws IOException {
        }

        @Override
        public void visitEmptyDeclaration(EmptyDeclaration emptyDeclaration) throws IOException {
        }

        protected void visitIfNotNull(AstNode args) throws IOException {
            if (args != null) {
                args.visit(this);
            }
        }

        @Override
        public void visitParameter(Parameter parameter) throws IOException {
            ParamModel paramModel = new ParamModel();
            paramModel.setRest(parameter.isRest());
            this.modelStack.push(paramModel);
            parameter.getIde().visit(this);
            this.visitIfNotNull(parameter.getOptTypeRelation());
            this.visitIfNotNull(parameter.getOptInitializer());
            this.modelStack.pop();
            ((MethodModel)this.modelStack.peek()).addParam(paramModel);
        }

        private void generateVisibility(Declaration declaration) {
            Ide namespace;
            NamespacedModel namespacedModel = (NamespacedModel)this.modelStack.peek();
            if (namespacedModel instanceof MemberModel) {
                ((MemberModel)namespacedModel).setStatic(declaration.isStatic());
            }
            if (declaration instanceof TypedIdeDeclaration && (namespace = ((TypedIdeDeclaration)declaration).getNamespace()) != null) {
                namespacedModel.setNamespace(namespace.getQualifiedNameStr());
                return;
            }
            namespacedModel.setNamespace(declaration.isProtected() ? "protected" : "public");
        }

        private void generateStaticFlag(Declaration declaration) {
            MemberModel memberModel = (MemberModel)this.modelStack.peek();
            memberModel.setStatic(declaration.isStatic());
        }

        private void generateMemberModifiers(Declaration declaration) {
            this.generateVisibility(declaration);
            this.generateStaticFlag(declaration);
        }

        @Override
        public void visitVariableDeclaration(VariableDeclaration variableDeclaration) throws IOException {
            boolean isTopLevelDeclaration = this.modelStack.peek() instanceof CompilationUnitModel;
            if (variableDeclaration.isPublicApi() || isTopLevelDeclaration) {
                FieldModel fieldModel = new FieldModel();
                this.modelStack.push(fieldModel);
                this.consumeRecordedAnnotations();
                if (isTopLevelDeclaration) {
                    this.handleExcludeClassByDefault(fieldModel);
                }
                this.recordAsdoc(variableDeclaration);
                this.recordAsdoc(variableDeclaration.getOptSymConstOrVar());
                this.consumeRecordedAsdoc();
                this.generateMemberModifiers(variableDeclaration);
                fieldModel.setConst(variableDeclaration.isConst());
                variableDeclaration.getIde().visit(this);
                TypeRelation optTypeRelation = variableDeclaration.getOptTypeRelation();
                if (optTypeRelation != null) {
                    optTypeRelation.visit(this);
                }
                if (variableDeclaration.isConst()) {
                    this.visitIfNotNull(variableDeclaration.getOptInitializer());
                }
                this.popMember();
                this.visitIfNotNull(variableDeclaration.getOptNextVariableDeclaration());
            }
        }

        @Override
        public void visitFunctionDeclaration(FunctionDeclaration functionDeclaration) throws IOException {
            boolean isTopLevelDeclaration = this.modelStack.peek() instanceof CompilationUnitModel;
            if (functionDeclaration.isPublicApi() || isTopLevelDeclaration) {
                MethodModel methodModel = new MethodModel();
                this.modelStack.push(methodModel);
                this.consumeRecordedAnnotations();
                if (isTopLevelDeclaration) {
                    this.handleExcludeClassByDefault(methodModel);
                }
                this.recordAsdoc(functionDeclaration);
                this.recordAsdoc(functionDeclaration.getSymbol());
                this.consumeRecordedAsdoc();
                this.generateMemberModifiers(functionDeclaration);
                methodModel.setOverride(functionDeclaration.isOverride());
                methodModel.setFinal(functionDeclaration.isFinal());
                methodModel.setMethodType(functionDeclaration.isGetter() ? MethodType.GET : (functionDeclaration.isSetter() ? MethodType.SET : null));
                functionDeclaration.getIde().visit(this);
                this.generateSignatureAsApiCode(functionDeclaration.getFun());
                if (functionDeclaration.isConstructor() && !functionDeclaration.isNative()) {
                    FunctionDeclaration superConstructor;
                    ClassDeclaration superType;
                    StringBuilder superCallCode = new StringBuilder();
                    superCallCode.append("super(");
                    if (functionDeclaration.getClassDeclaration() != null && (superType = functionDeclaration.getClassDeclaration().getSuperTypeDeclaration()) != null && (superConstructor = superType.getConstructor()) != null) {
                        boolean first = true;
                        for (Parameters superParameters = superConstructor.getParams(); superParameters != null && ((Parameter)superParameters.getHead()).getOptInitializer() == null; superParameters = superParameters.getTail()) {
                            if (first) {
                                first = false;
                            } else {
                                superCallCode.append(", ");
                            }
                            superCallCode.append(VariableDeclaration.getDefaultValue(((Parameter)superParameters.getHead()).getOptTypeRelation()));
                        }
                    }
                    superCallCode.append(");");
                    ((MethodModel)this.modelStack.peek()).setBody(superCallCode.toString());
                }
                this.popMember();
            }
        }

        private void popMember() {
            MemberModel member = (MemberModel)this.modelStack.pop();
            ActionScriptModel current = this.modelStack.peek();
            if (current instanceof ClassModel) {
                ((ClassModel)current).addMember(member);
            } else if (current instanceof CompilationUnitModel) {
                ((CompilationUnitModel)current).setPrimaryDeclaration(member);
            } else {
                throw new IllegalArgumentException("Members outside class or package not allowed.");
            }
        }

        public void generateSignatureAsApiCode(FunctionExpr fun) throws IOException {
            this.visitIfNotNull(fun.getParams());
            this.visitIfNotNull(fun.getOptTypeRelation());
        }

        protected void visitAll(Iterable<? extends AstNode> nodes) throws IOException {
            for (AstNode astNode : nodes) {
                astNode.visit(this);
            }
        }

        @Override
        public void visitClassDeclaration(ClassDeclaration classDeclaration) throws IOException {
            ClassModel classModel = new ClassModel();
            this.getCurrent(CompilationUnitModel.class).setPrimaryDeclaration(classModel);
            this.modelStack.push(classModel);
            this.recordAsdoc(classDeclaration);
            this.recordAsdoc(classDeclaration.getSymClass());
            this.consumeRecordedAsdoc();
            classModel.setFinal(classDeclaration.isFinal());
            classModel.setDynamic(classDeclaration.isDynamic());
            this.generateVisibility(classDeclaration);
            this.consumeRecordedAnnotations();
            this.handleExcludeClassByDefault(classModel);
            classDeclaration.getIde().visit(this);
            classModel.setInterface(classDeclaration.isInterface());
            this.visitIfNotNull(classDeclaration.getOptExtends());
            this.visitIfNotNull(classDeclaration.getOptImplements());
            classDeclaration.getBody().visit(this);
            this.modelStack.pop();
        }

        private void handleExcludeClassByDefault(AnnotatedModel annotatedModel) {
            if (ApiModelGenerator.this.isExcludeClassByDefault()) {
                boolean needsExcludeClassAnnotation = true;
                for (AnnotationModel annotationModel : annotatedModel.getAnnotations()) {
                    String metaName = annotationModel.getName();
                    needsExcludeClassAnnotation = needsExcludeClassAnnotation && !"PublicApi".equals(metaName) && !"ExcludeClass".equals(metaName);
                }
                if (needsExcludeClassAnnotation) {
                    annotatedModel.addAnnotation(new AnnotationModel("ExcludeClass"));
                }
            }
        }

        @Override
        public void visitNamespaceDeclaration(NamespaceDeclaration namespaceDeclaration) throws IOException {
            NamespaceModel namespaceModel = new NamespaceModel();
            this.modelStack.push(namespaceModel);
            this.consumeRecordedAnnotations();
            this.handleExcludeClassByDefault(namespaceModel);
            this.recordAsdoc(namespaceDeclaration);
            this.recordAsdoc(namespaceDeclaration.getSymNamespace());
            this.consumeRecordedAsdoc();
            this.generateVisibility(namespaceDeclaration);
            namespaceDeclaration.getIde().visit(this);
            this.visitIfNotNull(namespaceDeclaration.getOptInitializer());
            this.modelStack.pop();
            this.getCurrent(CompilationUnitModel.class).setPrimaryDeclaration(namespaceModel);
        }

        @Override
        public void visitPackageDeclaration(PackageDeclaration packageDeclaration) throws IOException {
            Ide packageIde = packageDeclaration.getIde();
            if (packageIde != null) {
                this.getCurrent(CompilationUnitModel.class).setPackage(packageIde.getQualifiedNameStr());
            }
        }

        @Override
        public void visitSuperConstructorCallStatement(SuperConstructorCallStatement superConstructorCallStatement) throws IOException {
        }

        @Override
        public void visitAnnotation(Annotation annotation) throws IOException {
            AnnotationModel annotationModel = new AnnotationModel();
            this.modelStack.push(annotationModel);
            this.recordAsdoc(annotation.getLeftBracket());
            this.consumeRecordedAsdoc();
            annotation.getIde().visit(this);
            this.visitIfNotNull(annotation.getOptAnnotationParameters());
            this.modelStack.pop();
            this.annotationModels.add(annotationModel);
        }

        @Override
        public void visitUseNamespaceDirective(UseNamespaceDirective useNamespaceDirective) throws IOException {
        }

        @Override
        public void visitImportDirective(ImportDirective importDirective) throws IOException {
        }

        @Override
        public void visitLiteralExpr(LiteralExpr literalExpr) throws IOException {
            this.recordCode(literalExpr.getValue());
        }

        @Override
        public void visitPostfixOpExpr(PostfixOpExpr postfixOpExpr) throws IOException {
            postfixOpExpr.getArg().visit(this);
            this.recordCode(postfixOpExpr.getOp());
        }

        @Override
        public void visitDotExpr(DotExpr dotExpr) throws IOException {
            dotExpr.getArg().visit(this);
            this.recordCode(dotExpr.getOp());
            this.recordCode(dotExpr.getIde().getName());
        }

        @Override
        public void visitPrefixOpExpr(PrefixOpExpr prefixOpExpr) throws IOException {
            this.recordCode(prefixOpExpr.getOp());
            prefixOpExpr.getArg().visit(this);
        }

        @Override
        public void visitBinaryOpExpr(BinaryOpExpr binaryOpExpr) throws IOException {
            binaryOpExpr.getArg1().visit(this);
            this.recordCode(binaryOpExpr.getOp());
            binaryOpExpr.getArg2().visit(this);
        }

        @Override
        public void visitIsExpr(IsExpr isExpr) throws IOException {
            this.visitBinaryOpExpr(isExpr);
        }

        @Override
        public void visitConditionalExpr(ConditionalExpr conditionalExpr) throws IOException {
            conditionalExpr.getCond().visit(this);
            this.recordCode(conditionalExpr.getSymQuestion());
            conditionalExpr.getIfTrue().visit(this);
            this.recordCode(conditionalExpr.getSymColon());
            conditionalExpr.getIfFalse().visit(this);
        }

        @Override
        public <T extends AstNode> void visitCommaSeparatedList(CommaSeparatedList<T> commaSeparatedList) throws IOException {
            this.visitIfNotNull((AstNode)commaSeparatedList.getHead());
            if (commaSeparatedList.getSymComma() != null) {
                this.visitIfNotNull(commaSeparatedList.getTail());
            }
        }

        @Override
        public void visitParameters(Parameters parameters) throws IOException {
            this.visitCommaSeparatedList(parameters);
        }

        @Override
        public void visitPredefinedTypeDeclaration(PredefinedTypeDeclaration predefinedTypeDeclaration) throws IOException {
            throw new IllegalStateException("there should be no code generation for predefined types");
        }

        private <T extends ActionScriptModel> T getCurrent(Class<T> targetClass) {
            return (T)((ActionScriptModel)targetClass.cast(this.modelStack.peek()));
        }
    }
}

