/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.List;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeExpr;
import net.jangaroo.jooc.ast.LoopStatement;
import net.jangaroo.jooc.ast.Statement;
import net.jangaroo.jooc.ast.VariableDeclaration;

public class ForInStatement
extends LoopStatement {
    private JooSymbol symEach;
    private JooSymbol lParen;
    private VariableDeclaration decl;
    private Expr lValue;
    private JooSymbol symIn;
    private Expr expr;
    private JooSymbol rParen;
    private Ide auxIde;
    private Ide exprAuxIde;

    public ForInStatement(JooSymbol symFor, JooSymbol symEach, JooSymbol lParen, VariableDeclaration decl, JooSymbol symIn, Expr expr, JooSymbol rParen, Statement body) {
        this(symFor, symEach, lParen, decl, null, symIn, expr, rParen, body);
    }

    public ForInStatement(JooSymbol symFor, JooSymbol symEach, JooSymbol lParen, Expr lValue, JooSymbol symIn, Expr expr, JooSymbol rParen, Statement body) {
        this(symFor, symEach, lParen, null, lValue, symIn, expr, rParen, body);
    }

    private ForInStatement(JooSymbol symFor, JooSymbol symEach, JooSymbol lParen, VariableDeclaration decl, Expr lValue, JooSymbol symIn, Expr expr, JooSymbol rParen, Statement body) {
        super(symFor, body);
        if (symEach != null && !"each".equals(symEach.getText())) {
            throw Jooc.error(symEach, "'for' must be followed by '(' or 'each'.");
        }
        this.symEach = symEach;
        this.lParen = lParen;
        this.decl = decl;
        this.lValue = lValue;
        this.symIn = symIn;
        this.expr = expr;
        this.rParen = rParen;
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(super.getChildren(), this.decl, this.lValue, this.expr);
    }

    public JooSymbol getSymEach() {
        return this.symEach;
    }

    public JooSymbol getLParen() {
        return this.lParen;
    }

    public VariableDeclaration getDecl() {
        return this.decl;
    }

    public Expr getLValue() {
        return this.lValue;
    }

    public JooSymbol getSymIn() {
        return this.symIn;
    }

    public Expr getExpr() {
        return this.expr;
    }

    public JooSymbol getRParen() {
        return this.rParen;
    }

    public Ide getAuxIde() {
        return this.auxIde;
    }

    public Ide getExprAuxIde() {
        return this.exprAuxIde;
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitForInStatement(this);
    }

    @Override
    public void scope(Scope scope) {
        super.scope(scope);
        this.auxIde = scope.createAuxVar(scope);
        this.auxIde.scope(scope);
        if (this.symEach != null && !(this.getExpr() instanceof IdeExpr)) {
            this.exprAuxIde = scope.createAuxVar(scope);
            this.exprAuxIde.scope(scope);
        }
        if (this.decl != null) {
            this.decl.scope(scope);
        } else {
            this.lValue.scope(scope);
        }
        this.expr.scope(scope);
    }

    @Override
    protected void analyzeLoopHeader() {
        if (this.decl != null) {
            this.decl.analyze(this);
        } else {
            this.lValue.analyze(this);
        }
        this.expr.analyze(this);
    }
}

