/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java_cup.runtime.Symbol;
import net.jangaroo.jooc.CompilerError;
import net.jangaroo.jooc.DeclarationScope;
import net.jangaroo.jooc.JooParser;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scanner;
import net.jangaroo.jooc.ScannerBase;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.api.CompileLog;
import net.jangaroo.jooc.api.FilePosition;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.ImportDirective;
import net.jangaroo.jooc.ast.PredefinedTypeDeclaration;
import net.jangaroo.jooc.ast.VariableDeclaration;
import net.jangaroo.jooc.config.ParserOptions;
import net.jangaroo.jooc.config.SemicolonInsertionMode;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.utils.AS3Type;
import net.jangaroo.utils.BOMStripperInputStream;
import net.jangaroo.utils.CompilerUtils;

public class JangarooParser {
    public static final String JOO_API_IN_JAR_DIRECTORY_PREFIX = "META-INF/joo-api/";
    protected CompileLog log;
    private static ThreadLocal<CompileLog> defaultLog = new ThreadLocal();
    private InputSource sourcePathInputSource;
    private InputSource classPathInputSource;
    private ParserOptions config;
    private Map<String, CompilationUnit> compilationUnitsByQName = new LinkedHashMap<String, CompilationUnit>();
    protected final Scope globalScope = new DeclarationScope(null, null);

    public JangarooParser() {
        JangarooParser.declareType(this.globalScope, AS3Type.VOID.toString());
        JangarooParser.declareType(this.globalScope, AS3Type.ANY.toString());
    }

    public JangarooParser(ParserOptions config, CompileLog log) {
        JangarooParser.declareType(this.globalScope, AS3Type.VOID.toString());
        JangarooParser.declareType(this.globalScope, AS3Type.ANY.toString());
        this.config = config;
        this.log = log;
    }

    public static CompilerError error(String msg) {
        return new CompilerError(msg);
    }

    public static CompilerError error(String msg, File file) {
        return new CompilerError(new FilePositionImpl(file), msg);
    }

    public static CompilerError error(FilePosition symbol, String msg) {
        return new CompilerError(symbol, msg);
    }

    public static CompilerError error(AstNode node, String msg) {
        return JangarooParser.error(node.getSymbol(), msg);
    }

    public static CompilerError error(String msg, File file, Throwable t) {
        return new CompilerError(new FilePositionImpl(file), msg, t);
    }

    public static void warning(FilePosition symbol, String msg) {
        defaultLog.get().warning(symbol, msg);
    }

    public static void warning(String msg, File file) {
        defaultLog.get().warning((FilePosition)new FilePositionImpl(file), msg);
    }

    public static void warning(String msg) {
        defaultLog.get().warning(msg);
    }

    public ParserOptions getConfig() {
        return this.config;
    }

    public void setConfig(ParserOptions config) {
        this.config = config;
    }

    public CompileLog getLog() {
        return this.log;
    }

    public void setLog(CompileLog log) {
        this.log = log;
    }

    public static CompilationUnit doParse(InputSource in, CompileLog log, SemicolonInsertionMode semicolonInsertionMode) {
        Scanner s;
        try {
            s = new Scanner(new InputStreamReader((InputStream)new BOMStripperInputStream(in.getInputStream()), "UTF-8"));
        }
        catch (IOException e) {
            throw new CompilerError("Cannot read input file: " + in.getPath(), e);
        }
        s.setInputSource(in);
        JooParser p = new JooParser(s);
        p.setCompileLog(log);
        p.setSemicolonInsertionMode(semicolonInsertionMode);
        try {
            Symbol tree = p.parse();
            return (CompilationUnit)tree.value;
        }
        catch (ScannerBase.ScanError se) {
            log.error((FilePosition)se.getSym(), se.getMessage());
            return null;
        }
        catch (JooParser.FatalSyntaxError e) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not parse Jangaroo source", e);
        }
    }

    private static String nameWithoutExtension(InputSource input) {
        String name = input.getName();
        int lastDot = name.lastIndexOf(46);
        return lastDot >= 0 ? name.substring(0, lastDot) : name;
    }

    private static void declareType(Scope scope, String identifier) {
        PredefinedTypeDeclaration decl = new PredefinedTypeDeclaration(identifier);
        decl.scope(scope);
    }

    protected static void declareValues(Scope scope, String[] identifiers) {
        for (String identifier : identifiers) {
            Ide ide = new Ide(new JooSymbol(identifier));
            VariableDeclaration decl = new VariableDeclaration(new JooSymbol("var"), ide, null, null);
            ((IdeDeclaration)decl).scope(scope);
        }
    }

    protected InputSource findSource(String qname) {
        InputSource result = this.sourcePathInputSource.getChild(JangarooParser.getInputSourceFileName(qname, this.sourcePathInputSource, ".as"));
        if (result == null) {
            result = this.classPathInputSource.getChild(JangarooParser.getInputSourceFileName(qname, this.classPathInputSource, ".as"));
        }
        return result;
    }

    public static String getInputSourceFileName(String qname, InputSource is, String extension) {
        return CompilerUtils.fileNameFromQName((String)qname, (char)is.getFileSeparatorChar(), (String)extension);
    }

    public CompilationUnit importSource(InputSource source) {
        CompilationUnit unit = this.parse(source);
        if (unit != null) {
            unit.scope(this.globalScope);
            String prefix = unit.getPackageDeclaration().getQualifiedNameStr();
            String qname = CompilerUtils.qName((String)prefix, (String)unit.getPrimaryDeclaration().getIde().getName());
            this.checkValidFileName(qname, unit, source);
            this.compilationUnitsByQName.put(qname, unit);
        }
        return unit;
    }

    public IdeDeclaration resolveImport(ImportDirective importDirective) {
        String qname = importDirective.getQualifiedName();
        CompilationUnit compilationUnit = this.getCompilationUnit(qname);
        if (compilationUnit == null) {
            throw JangarooParser.error(importDirective.getSymbol(), "unable to resolve import of " + qname);
        }
        return compilationUnit.getPrimaryDeclaration();
    }

    public CompilationUnit getCompilationUnit(String qname) {
        CompilationUnit compilationUnit = this.compilationUnitsByQName.get(qname);
        if (compilationUnit == null) {
            InputSource source = this.findSource(qname);
            if (source == null) {
                return null;
            }
            compilationUnit = this.importSource(source);
        }
        return compilationUnit;
    }

    private void checkValidFileName(String qname, CompilationUnit unit, InputSource source) {
        String expectedPath;
        String path = source.getRelativePath();
        if (path != null && !(expectedPath = JangarooParser.getInputSourceFileName(qname, source, ".as")).equals(path)) {
            JangarooParser.warning(unit.getSymbol(), String.format("expected '%s' as the file name for %s, found: '%s'. -sourcepath not set (correctly)?", expectedPath, qname, path));
        }
    }

    protected CompilationUnit parse(InputSource in) {
        CompilationUnit unit;
        if (!in.getName().endsWith(".as")) {
            throw JangarooParser.error("Input file must end with '.as': " + in.getName());
        }
        if (this.config.isVerbose()) {
            System.out.println("Parsing " + in.getPath() + " (" + (in.isInSourcePath() ? "source" : "class") + "path)");
        }
        if ((unit = JangarooParser.doParse(in, this.log, this.config.getSemicolonInsertionMode())) != null) {
            unit.setCompiler(this);
            unit.setSource(in);
        }
        return unit;
    }

    public List<String> getPackageIdes(String packageName) {
        ArrayList<String> result = new ArrayList<String>(10);
        this.addPackageFolderSymbols(result, packageName, this.sourcePathInputSource);
        this.addPackageFolderSymbols(result, packageName, this.classPathInputSource);
        return result;
    }

    private void addPackageFolderSymbols(List<String> result, String packageName, InputSource path) {
        this.addPackageFolderSymbols(path.getChild(JangarooParser.getInputSourceFileName(packageName, path, "")), result);
    }

    private void addPackageFolderSymbols(InputSource folder, List<String> list) {
        if (folder != null) {
            for (InputSource inputSource : folder.list()) {
                if (inputSource.isDirectory() || !inputSource.getName().endsWith(".as")) continue;
                list.add(JangarooParser.nameWithoutExtension(inputSource));
            }
        }
    }

    private void buildGlobalScope() {
        JangarooParser.declareValues(this.globalScope, new String[]{"this"});
    }

    public void setUp(InputSource sourcePathInputSource, InputSource classPathInputSource) {
        defaultLog.set(this.log);
        this.sourcePathInputSource = sourcePathInputSource;
        this.classPathInputSource = classPathInputSource;
        this.buildGlobalScope();
    }

    public void tearDown() {
        defaultLog.remove();
    }

    private static class FilePositionImpl
    implements FilePosition {
        private final File file;

        public FilePositionImpl(File file) {
            this.file = file;
        }

        public String getFileName() {
            return this.file.getAbsolutePath();
        }

        public int getLine() {
            return -1;
        }

        public int getColumn() {
            return -1;
        }
    }
}

