/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.utils;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.regex.Pattern;
import net.jangaroo.utils.AS3Type;

public final class CompilerUtils {
    private CompilerUtils() {
    }

    public static String qName(String packageName, String className) {
        return packageName.length() == 0 ? className : packageName + "." + className;
    }

    public static String packageName(String qName) {
        int lastDotPos = qName.lastIndexOf(46);
        return lastDotPos == -1 ? "" : qName.substring(0, lastDotPos);
    }

    public static String uncapitalize(String name) {
        int capitalCount;
        if (name == null) {
            return name;
        }
        for (capitalCount = 0; capitalCount < name.length() && Character.isUpperCase(name.charAt(capitalCount)); ++capitalCount) {
        }
        int toLowerCount = capitalCount <= 1 || capitalCount == name.length() ? capitalCount : capitalCount - 1;
        return new StringBuffer(name.length()).append(name.substring(0, toLowerCount).toLowerCase(Locale.ROOT)).append(name.substring(toLowerCount)).toString();
    }

    public static String className(String qName) {
        int lastDotPos = qName.lastIndexOf(46);
        return lastDotPos == -1 ? qName : qName.substring(lastDotPos + 1);
    }

    public static File fileFromQName(String packageName, String className, File baseDirectory, String extension) {
        return CompilerUtils.fileFromQName(CompilerUtils.qName(packageName, className), baseDirectory, extension);
    }

    public static File fileFromQName(String qName, File baseDirectory, String extension) {
        char separatorChar = File.separatorChar;
        return new File(baseDirectory, CompilerUtils.fileNameFromQName(qName, separatorChar, extension));
    }

    public static String fileNameFromQName(String qName, char separatorChar, String extension) {
        return qName.replace('.', separatorChar) + extension;
    }

    public static String qNameFromFile(File baseDirectory, File file) {
        int lastDotPos;
        String relativePath = CompilerUtils.getRelativePath(baseDirectory, file);
        if (relativePath != null && (lastDotPos = relativePath.lastIndexOf(46)) != -1 && lastDotPos > relativePath.lastIndexOf(File.separatorChar)) {
            return relativePath.substring(0, lastDotPos).replace(File.separatorChar, '.');
        }
        return null;
    }

    public static String getRelativePath(File baseDirectory, File file) {
        return CompilerUtils.getRelativePath(baseDirectory, file, true);
    }

    public static String getRelativePath(File baseDirectory, File file, boolean onlyBelowBaseDirectory) {
        try {
            return CompilerUtils.getRelativePath(baseDirectory.getCanonicalPath() + File.separator, file.getCanonicalPath(), File.separator, onlyBelowBaseDirectory);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("could not determine qualified name from file; the strange file is called " + file + " in " + baseDirectory, e);
        }
    }

    static String getRelativePathBelow(String canonicalBasePath, String canonicalPath) {
        if (canonicalPath.length() > canonicalBasePath.length() && canonicalPath.startsWith(canonicalBasePath)) {
            return canonicalPath.substring(canonicalBasePath.length());
        }
        return null;
    }

    static String getRelativePath(String canonicalBasePath, String canonicalPath, String fileSeparator, boolean onlyBelowBaseDirectory) {
        String relativePath = CompilerUtils.getRelativePathBelow(canonicalBasePath, canonicalPath);
        if (relativePath == null && !onlyBelowBaseDirectory) {
            int i;
            String fileSeparatorAsRegExp = Pattern.quote(fileSeparator);
            String[] basePathParts = canonicalBasePath.split(fileSeparatorAsRegExp);
            String[] pathParts = canonicalPath.split(fileSeparatorAsRegExp, -1);
            int samePartCount = basePathParts.length;
            for (int i2 = 0; i2 < basePathParts.length; ++i2) {
                if (basePathParts[i2].equals(pathParts[i2])) continue;
                samePartCount = i2;
                break;
            }
            StringBuffer builder = new StringBuffer();
            for (i = samePartCount; i < basePathParts.length; ++i) {
                builder.append("..").append(fileSeparator);
            }
            for (i = samePartCount; i < pathParts.length; ++i) {
                builder.append(pathParts[i]);
                if (i >= pathParts.length - 1) continue;
                builder.append(fileSeparator);
            }
            relativePath = builder.toString();
        }
        return relativePath;
    }

    public static String dirname(String filename) {
        int i = filename.lastIndexOf(File.separator);
        return i >= 0 ? filename.substring(0, i) : "";
    }

    public static String removeExtension(String filename) {
        String ext = CompilerUtils.extension(filename);
        if ("".equals(ext)) {
            return filename;
        }
        int index = filename.lastIndexOf(ext) - 1;
        return filename.substring(0, index);
    }

    public static String extension(String filename) {
        int lastDot;
        int lastSep = filename.lastIndexOf(File.separatorChar);
        if (lastSep < 0) {
            lastDot = filename.lastIndexOf(46);
        } else {
            lastDot = filename.substring(lastSep + 1).lastIndexOf(46);
            if (lastDot >= 0) {
                lastDot += lastSep + 1;
            }
        }
        if (lastDot >= 0 && lastDot > lastSep) {
            return filename.substring(lastDot + 1);
        }
        return "";
    }

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public static AS3Type guessType(String attributeValue) {
        try {
            long l = Long.parseLong(attributeValue);
            return l >= 0L ? AS3Type.UINT : AS3Type.INT;
        }
        catch (NumberFormatException e) {
            try {
                Double.parseDouble(attributeValue);
                return AS3Type.NUMBER;
            }
            catch (NumberFormatException numberFormatException) {
                if ("false".equalsIgnoreCase(attributeValue) || "true".equalsIgnoreCase(attributeValue)) {
                    return AS3Type.BOOLEAN;
                }
                return null;
            }
        }
    }
}

