/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.input;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.jooc.input.ZipFileInputSource;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipEntryInputSource
implements InputSource {
    private ZipFileInputSource zipFileInputSource;
    private ZipEntry zipEntry;
    private String name;
    private String relativePath;

    public ZipEntryInputSource(ZipFileInputSource zipFileInputSource, ZipEntry zipEntry, String relativePath) {
        this.zipFileInputSource = zipFileInputSource;
        this.zipEntry = zipEntry;
        this.relativePath = relativePath;
        this.name = zipEntry.getName();
        int lastSlash = this.name.lastIndexOf(47);
        if (lastSlash >= 0) {
            this.name = this.name.substring(lastSlash + 1);
        }
    }

    @Override
    public boolean isInSourcePath() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return new StringBuffer().append(this.zipFileInputSource.getPath()).append("!").append(this.zipEntry.getName()).toString();
    }

    @Override
    public InputSource getParent() {
        String path = this.getPath();
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash < 0) {
            return null;
        }
        String parentPath = path.substring(0, lastSlash);
        return this.zipFileInputSource.getChild(parentPath);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.zipFileInputSource.getZipFile().getInputStream(this.zipEntry);
    }

    @Override
    public boolean isDirectory() {
        return this.zipEntry.isDirectory();
    }

    public List<InputSource> list() {
        return this.zipFileInputSource.list(this);
    }

    @Override
    public InputSource getChild(String path) {
        if (path.startsWith("../")) {
            return this.getParent().getChild(path.substring(3));
        }
        String p = this.getRelativePath();
        if (!p.isEmpty()) {
            p = new StringBuffer().append(p).append('/').toString();
        }
        p = new StringBuffer().append(p).append(path).toString();
        return this.zipFileInputSource.getChild(p);
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public void close() throws IOException {
        this.zipFileInputSource.close();
    }

    @Override
    public char getFileSeparatorChar() {
        return '/';
    }
}

