/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.model;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.jangaroo.jooc.backend.ActionScriptCodeGeneratingModelVisitor;
import net.jangaroo.jooc.model.ClassModel;
import net.jangaroo.jooc.model.CompilationUnitModel;
import net.jangaroo.jooc.model.MemberModel;
import net.jangaroo.jooc.model.MethodModel;
import net.jangaroo.jooc.model.MethodType;
import net.jangaroo.jooc.model.ParamModel;
import net.jangaroo.jooc.model.PropertyModel;
import net.jangaroo.utils.AS3Type;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationUnitModelRegistry {
    private Map<String, CompilationUnitModel> registry = new LinkedHashMap<String, CompilationUnitModel>(500);
    private final ActionScriptCodeGeneratingModelVisitor DEBUG_CODE_GENERATOR = new ActionScriptCodeGeneratingModelVisitor(new PrintWriter(System.err), true);
    private static final CompilationUnitModel ERROR_COMPILATION_UNIT = new CompilationUnitModel("", CompilationUnitModelRegistry.createErrorClass());

    public void register(CompilationUnitModel compilationUnitModel) {
        String qName = compilationUnitModel.getQName();
        if (this.registry.containsKey(qName)) {
            throw new IllegalArgumentException(new StringBuffer().append("Attempt to redefine ").append(qName).toString());
        }
        this.registry.put(qName, compilationUnitModel);
    }

    public Collection<CompilationUnitModel> getCompilationUnitModels() {
        return this.registry.values();
    }

    private static ClassModel createErrorClass() {
        ClassModel errorClass = new ClassModel("Error");
        errorClass.addMember(new MethodModel("Error", "Error", new ParamModel[]{new ParamModel("msg", "String", "null")}));
        errorClass.addMember(new MethodModel("toString", "String"));
        return errorClass;
    }

    public CompilationUnitModel resolveCompilationUnit(String qName) {
        if ("Error".equals(qName)) {
            return ERROR_COMPILATION_UNIT;
        }
        return this.registry.get(qName);
    }

    public MethodModel resolveConstructor(ClassModel classModel) {
        return this.resolveMethod(classModel, null, null);
    }

    private CompilationUnitModel resolveDefiningType(CompilationUnitModel classModel, String methodName) {
        return this.resolveDefiningType(classModel, null, methodName);
    }

    private CompilationUnitModel resolveDefiningType(CompilationUnitModel classModel, MethodType methodType, String name) {
        CompilationUnitModel definingType = null;
        if (classModel != null && (definingType = this.resolveDefiningInterface(classModel, methodType, name)) == null) {
            definingType = this.resolveDefiningClass(classModel, methodType, name);
        }
        return definingType;
    }

    private CompilationUnitModel resolveDefiningInterface(CompilationUnitModel compilationUnitModel, MethodType methodType, String methodName) {
        CompilationUnitModel definingInterface = null;
        ClassModel classModel = compilationUnitModel.getClassModel();
        CompilationUnitModel superclass = this.getSuperclassCompilationUnit(classModel);
        if (superclass != null) {
            definingInterface = this.resolveDefiningInterface(superclass, methodType, methodName);
        }
        for (String interfaceName : classModel.getInterfaces()) {
            CompilationUnitModel anInterface = this.resolveCompilationUnit(interfaceName);
            CompilationUnitModel recursionResult = this.resolveDefiningInterface(anInterface, methodType, methodName);
            if (recursionResult == null || definingInterface != null && !this.implementsInterface(definingInterface.getClassModel(), recursionResult.getQName())) continue;
            definingInterface = recursionResult;
        }
        if (definingInterface == null && classModel.isInterface() && classModel.getMethod(methodType, methodName) != null) {
            definingInterface = compilationUnitModel;
        }
        return definingInterface;
    }

    private CompilationUnitModel resolveDefiningClass(CompilationUnitModel classCompilationUnit, MethodType methodType, String methodName) {
        CompilationUnitModel definingClass = null;
        CompilationUnitModel currentCompilationUnit = classCompilationUnit;
        while (currentCompilationUnit != null) {
            ClassModel classModel = currentCompilationUnit.getClassModel();
            MethodModel method = classModel.getMethod(methodType, methodName == null ? classModel.getName() : methodName);
            if (method != null) {
                definingClass = currentCompilationUnit;
            }
            currentCompilationUnit = this.getSuperclassCompilationUnit(classModel);
        }
        return definingClass;
    }

    public MethodModel resolveMethod(ClassModel classModel, String methodName) {
        return this.resolveMethod(classModel, null, methodName);
    }

    public MethodModel resolveMethod(ClassModel classModel, MethodType methodType, String methodName) {
        ClassModel currentClass = classModel;
        while (currentClass != null) {
            MethodModel method = currentClass.getMethod(methodType, methodName == null ? currentClass.getName() : methodName);
            if (method != null) {
                return method;
            }
            currentClass = this.getSuperclass(currentClass);
        }
        return null;
    }

    public void complementOverrides() {
        ClassModel classModel;
        for (CompilationUnitModel compilationUnitModel : this.getCompilationUnitModels()) {
            classModel = compilationUnitModel.getClassModel();
            if (classModel == null || classModel.isInterface()) continue;
            ClassModel superclass = this.getSuperclass(classModel);
            for (String anInterface : classModel.getInterfaces()) {
                if (this.implementsInterface(superclass, anInterface)) continue;
                CompilationUnitModel interfaceModel = this.resolveCompilationUnit(anInterface);
                for (MemberModel memberModel : interfaceModel.getClassModel().getMembers()) {
                    if (memberModel.isMethod()) {
                        this.addImplementingMethod(classModel, (MethodModel)memberModel);
                        continue;
                    }
                    PropertyModel propertyModel = (PropertyModel)memberModel;
                    if (propertyModel.isReadable()) {
                        this.addImplementingMethod(classModel, propertyModel.getGetter());
                    }
                    if (!propertyModel.isWritable()) continue;
                    this.addImplementingMethod(classModel, propertyModel.getSetter());
                }
            }
        }
        for (CompilationUnitModel compilationUnitModel : this.getCompilationUnitModels()) {
            classModel = compilationUnitModel.getClassModel();
            if (classModel == null || this.getSuperclass(classModel) == null) continue;
            MethodModel constructor = this.complementConstructor(classModel);
            for (MemberModel memberModel : classModel.getMembers()) {
                if (memberModel == constructor || memberModel.isField() || memberModel.isStatic()) continue;
                if (memberModel.isMethod()) {
                    this.complementOverridingMethod(compilationUnitModel, (MethodModel)memberModel);
                    continue;
                }
                this.complementOverridingProperty(compilationUnitModel, (PropertyModel)memberModel);
            }
        }
    }

    private void addImplementingMethod(ClassModel classModel, MethodModel methodModel) {
        String memberName = methodModel.getName();
        if (this.resolveMethod(classModel, methodModel.getMethodType(), memberName) == null) {
            MethodModel implementingMethod = methodModel.duplicate();
            implementingMethod.setAsdoc("@inheritDoc");
            classModel.addMember(implementingMethod);
        }
    }

    private boolean implementsInterface(ClassModel classModel, String anInterface) {
        if (classModel == null) {
            return false;
        }
        if (classModel.isInterface() && anInterface.equals(classModel.getName())) {
            return true;
        }
        for (String interfaceName : classModel.getInterfaces()) {
            if (!this.implementsInterface(this.resolveCompilationUnit(interfaceName).getClassModel(), anInterface)) continue;
            return true;
        }
        return this.implementsInterface(this.getSuperclass(classModel), anInterface);
    }

    private MethodModel complementConstructor(ClassModel classModel) {
        if (classModel.isInterface()) {
            return null;
        }
        ClassModel superclass = this.getSuperclass(classModel);
        MethodModel constructor = classModel.getConstructor();
        MethodModel superclassConstructor = this.resolveConstructor(superclass);
        if (superclassConstructor != null) {
            List<ParamModel> params = superclassConstructor.getParams();
            StringBuffer superCallValues = new StringBuffer();
            for (ParamModel superParam : params) {
                if (superParam.isOptional()) break;
                if (superCallValues.length() > 0) {
                    superCallValues.append(", ");
                }
                superCallValues.append(AS3Type.getDefaultValue(superParam.getType()));
            }
            if (constructor == null) {
                constructor = classModel.createConstructor();
                constructor.setAsdoc("@inheritDoc");
                for (ParamModel superParam : params) {
                    ParamModel paramModel = superParam.duplicate();
                    paramModel.setOptional(true);
                    constructor.addParam(paramModel);
                }
            }
            constructor.setBody(new StringBuffer().append("super(").append((Object)superCallValues).append(");").toString());
        }
        if (constructor != null && constructor.getBody() == null) {
            constructor.setBody("super();");
        }
        return constructor;
    }

    private void complementOverridingMethod(CompilationUnitModel compilationUnitModel, MethodModel methodModel) {
        MethodModel methodSignature;
        CompilationUnitModel definingType;
        ClassModel classModel = compilationUnitModel.getClassModel();
        String methodName = methodModel.getName();
        MethodModel superclassMethod = this.resolveMethod(this.getSuperclass(classModel), methodName);
        if (superclassMethod != null) {
            methodModel.setOverride(true);
        }
        if (!(definingType = this.resolveDefiningType(compilationUnitModel, methodName)).equals(compilationUnitModel) && !(methodSignature = definingType.getClassModel().getMethod(methodName)).equals(methodModel)) {
            this.logMethodSignatureCorrection(definingType, methodSignature, compilationUnitModel, methodModel);
            methodModel.setParams(methodSignature.getParams());
            methodModel.setType(methodSignature.getType());
        }
    }

    private void complementOverridingProperty(CompilationUnitModel compilationUnitModel, PropertyModel propertyModel) {
        if (propertyModel.isReadable()) {
            this.complementOverridingProperty(compilationUnitModel, propertyModel, MethodType.GET);
        }
        if (propertyModel.isWritable()) {
            this.complementOverridingProperty(compilationUnitModel, propertyModel, MethodType.SET);
        }
    }

    private void complementOverridingProperty(CompilationUnitModel compilationUnitModel, PropertyModel propertyModel, MethodType methodType) {
        CompilationUnitModel definingType;
        ClassModel classModel = compilationUnitModel.getClassModel();
        String propertyName = propertyModel.getName();
        MethodModel superclassAccessor = this.resolveMethod(this.getSuperclass(classModel), methodType, propertyName);
        MethodModel accessor = propertyModel.getMethod(methodType);
        if (superclassAccessor != null) {
            accessor.setOverride(true);
        }
        if (!(definingType = this.resolveDefiningType(compilationUnitModel, methodType, propertyName)).equals(compilationUnitModel)) {
            PropertyModel superPropertyModel = definingType.getClassModel().getProperty(propertyModel.isStatic(), propertyName);
            if (!accessor.getType().equals(superPropertyModel.getType())) {
                this.logMethodSignatureCorrection(definingType, definingType.getClassModel().getMethod(methodType, propertyName), compilationUnitModel, accessor);
                propertyModel.setType(superPropertyModel.getType());
            }
        }
    }

    private void logMethodSignatureCorrection(CompilationUnitModel definingType, MethodModel methodSignature, CompilationUnitModel classModel, MethodModel methodModel) {
        if ((methodModel.getType().equals(methodSignature.getType()) || "void".equals(methodModel.getType())) && methodModel.getParams().isEmpty()) {
            return;
        }
        System.err.println(new StringBuffer().append("*** corrected ERROR in ").append((Object)methodSignature.getMethodType()).append(" signature of ").append(classModel.getQName()).append(".").append(methodSignature.getName()).append(" deviates from definition in ").append(definingType.getQName()).append(".").toString());
        System.err.printf(" %s:%n", definingType.getQName());
        this.DEBUG_CODE_GENERATOR.setCompilationUnitModel(definingType);
        methodSignature.visit(this.DEBUG_CODE_GENERATOR);
        this.DEBUG_CODE_GENERATOR.flush();
        System.err.printf(" %s:%n", classModel.getQName());
        this.DEBUG_CODE_GENERATOR.setCompilationUnitModel(classModel);
        methodModel.visit(this.DEBUG_CODE_GENERATOR);
        this.DEBUG_CODE_GENERATOR.flush();
    }

    public CompilationUnitModel getSuperclassCompilationUnit(ClassModel classModel) {
        return this.resolveCompilationUnit(classModel.getSuperclass());
    }

    public ClassModel getSuperclass(ClassModel classModel) {
        CompilationUnitModel superclassCompilationUnit = this.getSuperclassCompilationUnit(classModel);
        return superclassCompilationUnit == null ? null : superclassCompilationUnit.getClassModel();
    }

    public void complementImports() {
        for (CompilationUnitModel compilationUnitModel : this.getCompilationUnitModels()) {
            compilationUnitModel.addImplicitImports();
        }
    }
}

