/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.backend;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jangaroo.jooc.CodeGenerator;
import net.jangaroo.jooc.Debug;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.JoocProperties;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.SyntacticKeywords;
import net.jangaroo.jooc.ast.Annotation;
import net.jangaroo.jooc.ast.AnnotationParameter;
import net.jangaroo.jooc.ast.ApplyExpr;
import net.jangaroo.jooc.ast.ArrayIndexExpr;
import net.jangaroo.jooc.ast.ArrayLiteral;
import net.jangaroo.jooc.ast.AsExpr;
import net.jangaroo.jooc.ast.AssignmentOpExpr;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.BlockStatement;
import net.jangaroo.jooc.ast.BreakStatement;
import net.jangaroo.jooc.ast.CaseStatement;
import net.jangaroo.jooc.ast.Catch;
import net.jangaroo.jooc.ast.ClassBody;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.ContinueStatement;
import net.jangaroo.jooc.ast.Declaration;
import net.jangaroo.jooc.ast.DefaultStatement;
import net.jangaroo.jooc.ast.Directive;
import net.jangaroo.jooc.ast.DoStatement;
import net.jangaroo.jooc.ast.DotExpr;
import net.jangaroo.jooc.ast.EmptyDeclaration;
import net.jangaroo.jooc.ast.EmptyStatement;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.Extends;
import net.jangaroo.jooc.ast.ForInStatement;
import net.jangaroo.jooc.ast.ForInitializer;
import net.jangaroo.jooc.ast.ForStatement;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.FunctionExpr;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.IdeExpr;
import net.jangaroo.jooc.ast.IdeWithTypeParam;
import net.jangaroo.jooc.ast.IfStatement;
import net.jangaroo.jooc.ast.Implements;
import net.jangaroo.jooc.ast.ImportDirective;
import net.jangaroo.jooc.ast.InfixOpExpr;
import net.jangaroo.jooc.ast.Initializer;
import net.jangaroo.jooc.ast.LabeledStatement;
import net.jangaroo.jooc.ast.NamespacedDeclaration;
import net.jangaroo.jooc.ast.NamespacedIde;
import net.jangaroo.jooc.ast.NewExpr;
import net.jangaroo.jooc.ast.ObjectField;
import net.jangaroo.jooc.ast.ObjectLiteral;
import net.jangaroo.jooc.ast.PackageDeclaration;
import net.jangaroo.jooc.ast.Parameter;
import net.jangaroo.jooc.ast.Parameters;
import net.jangaroo.jooc.ast.ParenthesizedExpr;
import net.jangaroo.jooc.ast.QualifiedIde;
import net.jangaroo.jooc.ast.ReturnStatement;
import net.jangaroo.jooc.ast.SemicolonTerminatedStatement;
import net.jangaroo.jooc.ast.Statement;
import net.jangaroo.jooc.ast.SuperConstructorCallStatement;
import net.jangaroo.jooc.ast.SwitchStatement;
import net.jangaroo.jooc.ast.ThrowStatement;
import net.jangaroo.jooc.ast.TryStatement;
import net.jangaroo.jooc.ast.Type;
import net.jangaroo.jooc.ast.TypeRelation;
import net.jangaroo.jooc.ast.TypedIdeDeclaration;
import net.jangaroo.jooc.ast.UseNamespaceDirective;
import net.jangaroo.jooc.ast.VariableDeclaration;
import net.jangaroo.jooc.ast.VectorLiteral;
import net.jangaroo.jooc.ast.WhileStatement;
import net.jangaroo.jooc.backend.CodeGeneratorBase;
import net.jangaroo.jooc.config.DebugMode;
import net.jangaroo.jooc.config.JoocConfiguration;
import net.jangaroo.jooc.util.MessageFormat;
import net.jangaroo.utils.CompilerUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsCodeGenerator
extends CodeGeneratorBase {
    private static final JooSymbol SYM_VAR;
    private static final JooSymbol SYM_EQ;
    private static final JooSymbol SYM_SEMICOLON;
    private static final JooSymbol SYM_LBRACE;
    private static final JooSymbol SYM_RBRACE;
    private static final JooSymbol SYM_LBRACK;
    private static final JooSymbol SYM_RBRACK;
    public static final Set<String> PRIMITIVES;
    private boolean expressionMode = false;
    private static final MessageFormat IF_ARGUMENT_LENGTH_LTE_$N;
    private static final MessageFormat SWITCH_$INDEX;
    private static final MessageFormat CASE_$N;
    private static final MessageFormat VAR_$NAME_EQUALS_ARGUMENTS_SLICE_$INDEX;
    private static final CodeGenerator ALIAS_THIS_CODE_GENERATOR;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$net$jangaroo$jooc$backend$JsCodeGenerator;

    public JsCodeGenerator(JsWriter out) {
        super(out);
    }

    private void writeThis(Ide ide) throws IOException {
        this.out.writeToken(ide.isRewriteThis() ? "this$" : "this");
    }

    private void generateIdeCodeAsExpr(Ide ide) throws IOException {
        IdeDeclaration decl;
        if (this.out.isWritingComment()) {
            this.out.writeSymbol(ide.getIde());
            return;
        }
        this.out.writeSymbolWhitespace(ide.getIde());
        if (ide.isSuper()) {
            this.writeThis(ide);
            return;
        }
        if (!ide.isThis() && (decl = ide.getDeclaration(false)) != null) {
            if (decl.isClassMember()) {
                if (!decl.isPrivateStatic()) {
                    if (decl.isStatic()) {
                        this.out.writeToken(decl.getClassDeclaration().getQualifiedNameStr());
                    } else {
                        if (ide.isBound()) {
                            this.writeBoundMethodAccess(ide, null, null, decl);
                            return;
                        }
                        this.writeThis(ide);
                    }
                }
                this.writeMemberAccess(decl, null, ide, false);
                return;
            }
            if (ide.getPackagePrefix().length() > 0) {
                this.out.writeToken(ide.getPackagePrefix());
            }
        }
        if (SyntacticKeywords.RESERVED_WORDS.contains(ide.getIde().getText())) {
            this.out.writeToken(new StringBuffer().append("$$").append(ide.getIde().getText()).toString());
        } else {
            this.out.writeSymbol(ide.getIde(), false);
        }
    }

    private void writeBoundMethodAccess(Ide ide, Ide optIde, JooSymbol optSymDot, IdeDeclaration decl) throws IOException {
        this.out.writeToken("$$bound(");
        if (optIde != null) {
            optIde.visit(this);
        } else {
            this.writeThis(ide);
        }
        if (optSymDot != null) {
            this.out.writeSymbolWhitespace(optSymDot);
        }
        this.out.writeToken(",");
        this.out.beginString();
        if (ide.usePrivateMemberName(decl)) {
            this.out.writeToken(new StringBuffer().append(ide.getName()).append("$").append(ide.getScope().getClassDeclaration().getInheritanceLevel()).toString());
        } else {
            this.out.writeToken(ide.getName());
        }
        this.out.endString();
        this.out.writeToken(")");
    }

    @Override
    public void visitDotExpr(DotExpr dotExpr) throws IOException {
        dotExpr.getArg().visit(this);
        this.writeMemberAccess(Ide.resolveMember(dotExpr.getArg().getType(), dotExpr.getIde()), dotExpr.getOp(), dotExpr.getIde(), true);
    }

    private void writeMemberAccess(IdeDeclaration memberDeclaration, JooSymbol optSymDot, Ide memberIde, boolean writeMemberWhitespace) throws IOException {
        if (memberDeclaration != null && memberIde.usePrivateMemberName(memberDeclaration)) {
            this.writePrivateMemberAccess(optSymDot, memberIde, writeMemberWhitespace, memberDeclaration.isStatic());
            return;
        }
        if (optSymDot == null && memberDeclaration != null && !memberDeclaration.isConstructor()) {
            optSymDot = new JooSymbol(".");
        }
        boolean quote = false;
        if (optSymDot != null) {
            if (memberIde.getIde().getText().startsWith("@")) {
                quote = true;
                this.out.writeSymbolWhitespace(optSymDot);
                this.out.writeToken("['");
            } else {
                this.out.writeSymbol(optSymDot);
            }
        }
        this.out.writeSymbol(memberIde.getIde(), writeMemberWhitespace);
        if (quote) {
            this.out.writeToken("']");
        }
    }

    private void writePrivateMemberAccess(JooSymbol optSymDot, Ide memberIde, boolean writeMemberWhitespace, boolean isStatic) throws IOException {
        if (writeMemberWhitespace) {
            this.out.writeSymbolWhitespace(memberIde.getIde());
        }
        if (isStatic) {
            this.out.writeToken("$$private");
            if (optSymDot != null) {
                this.out.writeSymbol(optSymDot);
            } else {
                this.out.writeToken(".");
            }
            this.out.writeSymbol(memberIde.getIde(), false);
        } else {
            if (optSymDot != null) {
                this.out.writeSymbol(optSymDot);
            } else {
                this.out.writeToken(".");
            }
            this.out.writeToken(new StringBuffer().append(memberIde.getName()).append("$").append(memberIde.getScope().getClassDeclaration().getInheritanceLevel()).toString());
        }
    }

    @Override
    public void visitTypeRelation(TypeRelation typeRelation) throws IOException {
        this.out.beginCommentWriteSymbol(typeRelation.getSymRelation());
        typeRelation.getType().getIde().visit(this);
        this.out.endComment();
    }

    @Override
    public void visitAnnotationParameter(AnnotationParameter annotationParameter) throws IOException {
        this.visitIfNotNull(annotationParameter.getOptName(), "$value");
        this.writeSymbolReplacement(annotationParameter.getOptSymEq(), ":");
        this.visitIfNotNull(annotationParameter.getValue(), "null");
    }

    @Override
    public void visitExtends(Extends anExtends) throws IOException {
        this.out.writeSymbol(anExtends.getSymExtends());
        this.writeQName(anExtends.getSuperClass());
    }

    private void writeQName(Ide classIde) throws IOException {
        this.out.writeSymbolWhitespace(classIde.getSymbol());
        String classQName = classIde.getDeclaration().getQualifiedNameStr();
        this.out.writeToken(classQName);
    }

    @Override
    public void visitInitializer(Initializer initializer) throws IOException {
        this.out.writeSymbol(initializer.getSymEq());
        initializer.getValue().visit(this);
    }

    @Override
    public void visitObjectField(ObjectField objectField) throws IOException {
        objectField.getLabel().visit(this);
        this.out.writeSymbol(objectField.getSymColon());
        objectField.getValue().visit(this);
    }

    @Override
    public void visitForInitializer(ForInitializer forInitializer) throws IOException {
        if (forInitializer.getDecl() != null) {
            forInitializer.getDecl().visit(this);
        } else {
            this.visitIfNotNull(forInitializer.getExpr());
        }
    }

    @Override
    public void visitCompilationUnit(CompilationUnit compilationUnit) throws IOException {
        this.out.write("joo.classLoader.prepare(");
        compilationUnit.getPackageDeclaration().visit(this);
        this.out.beginComment();
        this.out.writeSymbol(compilationUnit.getLBrace());
        this.out.endComment();
        compilationUnit.getPrimaryDeclaration().visit(this);
        this.out.write(",[");
        boolean first = true;
        for (String qname : compilationUnit.getDependencies()) {
            if (first) {
                first = false;
            } else {
                this.out.write(",");
            }
            this.out.write(new StringBuffer().append('\"').append(qname).append('\"').toString());
        }
        this.out.write("]");
        this.out.write(new StringBuffer().append(", \"").append(JoocProperties.getRuntimeVersion()).append("\"").toString());
        this.out.write(new StringBuffer().append(", \"").append(JoocProperties.getVersion()).append("\"").toString());
        this.out.writeSymbolWhitespace(compilationUnit.getRBrace());
        this.out.write(");");
    }

    @Override
    public void visitIde(Ide ide) throws IOException {
        if (this.expressionMode) {
            this.generateIdeCodeAsExpr(ide);
            return;
        }
        this.out.writeSymbolWhitespace(ide.getIde());
        if (!this.out.isWritingComment() && SyntacticKeywords.RESERVED_WORDS.contains(ide.getIde().getText())) {
            this.out.writeToken(new StringBuffer().append("$$").append(ide.getIde().getText()).toString());
        } else {
            this.out.writeSymbol(ide.getIde(), false);
        }
    }

    private void generateQualifiedIdeCodeAsExpr(QualifiedIde qualifiedIde) throws IOException {
        boolean commentOutQualifierCode = false;
        IdeDeclaration memberDeclaration = null;
        IdeDeclaration qualifierDeclaration = qualifiedIde.getQualifier().getDeclaration(false);
        if (qualifierDeclaration != null && qualifierDeclaration.isConstructor()) {
            qualifierDeclaration = qualifierDeclaration.getClassDeclaration();
        }
        if (qualifierDeclaration != null && qualifierDeclaration.equals(qualifiedIde.getScope().getClassDeclaration())) {
            memberDeclaration = ((ClassDeclaration)qualifierDeclaration).getStaticMemberDeclaration(qualifiedIde.getName());
            boolean bl = commentOutQualifierCode = memberDeclaration != null && memberDeclaration.isPrivateStatic();
        }
        if (memberDeclaration == null) {
            IdeDeclaration type = qualifiedIde.getQualifier().resolveDeclaration();
            memberDeclaration = Ide.resolveMember(type, qualifiedIde);
        }
        if (qualifiedIde.isBound()) {
            this.writeBoundMethodAccess(qualifiedIde, qualifiedIde.getQualifier(), qualifiedIde.getSymDot(), memberDeclaration);
            return;
        }
        if (commentOutQualifierCode) {
            this.out.beginComment();
        }
        qualifiedIde.getQualifier().visit(this);
        if (commentOutQualifierCode) {
            this.out.endComment();
        }
        this.writeMemberAccess(memberDeclaration, qualifiedIde.getSymDot(), qualifiedIde, true);
    }

    @Override
    public void visitQualifiedIde(QualifiedIde qualifiedIde) throws IOException {
        if (this.expressionMode) {
            this.generateQualifiedIdeCodeAsExpr(qualifiedIde);
            return;
        }
        qualifiedIde.getQualifier().visit(this);
        this.out.writeSymbol(qualifiedIde.getSymDot());
        this.visitIde(qualifiedIde);
    }

    @Override
    public void visitIdeWithTypeParam(IdeWithTypeParam ideWithTypeParam) throws IOException {
        this.visitIde(ideWithTypeParam);
        this.out.beginComment();
        this.out.writeSymbol(ideWithTypeParam.getSymDotLt());
        ideWithTypeParam.getType().visit(this);
        this.out.writeSymbol(ideWithTypeParam.getSymGt());
        this.out.endComment();
    }

    @Override
    public void visitNamespacedIde(NamespacedIde namespacedIde) throws IOException {
        this.out.beginComment();
        this.out.writeSymbol(namespacedIde.getNamespace());
        this.out.writeSymbol(namespacedIde.getSymNamespaceSep());
        this.out.endComment();
        this.visitIde(namespacedIde);
    }

    @Override
    public void visitImplements(Implements anImplements) throws IOException {
        this.out.writeSymbol(anImplements.getSymImplements());
        this.generateImplements(anImplements.getSuperTypes());
    }

    private void generateImplements(CommaSeparatedList<Ide> superTypes) throws IOException {
        this.writeQName(superTypes.getHead());
        if (superTypes.getSymComma() != null) {
            this.out.writeSymbol(superTypes.getSymComma());
            this.generateImplements(superTypes.getTail());
        }
    }

    @Override
    public void visitType(Type type) throws IOException {
        type.getIde().visit(this);
    }

    @Override
    public void visitObjectLiteral(ObjectLiteral objectLiteral) throws IOException {
        this.out.writeSymbol(objectLiteral.getLBrace());
        this.visitIfNotNull(objectLiteral.getFields());
        this.writeOptSymbol(objectLiteral.getOptComma());
        this.out.writeSymbol(objectLiteral.getRBrace());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitIdeExpression(IdeExpr ideExpr) throws IOException {
        this.expressionMode = true;
        try {
            ideExpr.getIde().visit(this);
        }
        finally {
            this.expressionMode = false;
        }
    }

    @Override
    public <T extends Expr> void visitParenthesizedExpr(ParenthesizedExpr<T> parenthesizedExpr) throws IOException {
        this.out.writeSymbol(parenthesizedExpr.getLParen());
        this.visitIfNotNull((AstNode)parenthesizedExpr.getExpr());
        this.out.writeSymbol(parenthesizedExpr.getRParen());
    }

    @Override
    public void visitArrayLiteral(ArrayLiteral arrayLiteral) throws IOException {
        this.visitParenthesizedExpr(arrayLiteral);
    }

    @Override
    public void visitAssignmentOpExpr(AssignmentOpExpr assignmentOpExpr) throws IOException {
        if (assignmentOpExpr.getOp().sym == 86 || assignmentOpExpr.getOp().sym == 87) {
            assignmentOpExpr.getArg1().visit(this);
            this.out.writeSymbolWhitespace(assignmentOpExpr.getOp());
            this.out.writeToken("=");
            JoocConfiguration options = (JoocConfiguration)this.out.getOptions();
            DebugMode mode = options.getDebugMode();
            options.setDebugMode(null);
            assignmentOpExpr.getArg1().visit(this);
            options.setDebugMode(mode);
            this.out.writeToken(assignmentOpExpr.getOp().sym == 86 ? "&&" : "||");
            this.out.writeToken("(");
            assignmentOpExpr.getArg2().visit(this);
            this.out.writeToken(")");
        } else {
            this.visitBinaryOpExpr(assignmentOpExpr);
        }
    }

    @Override
    public void visitInfixOpExpr(InfixOpExpr infixOpExpr) throws IOException {
        this.out.writeSymbolToken(infixOpExpr.getOp());
        this.out.write(40);
        infixOpExpr.getArg1().visit(this);
        this.out.write(44);
        this.out.writeSymbolWhitespace(infixOpExpr.getOp());
        infixOpExpr.getArg2().visit(this);
        this.out.write(41);
    }

    @Override
    public void visitAsExpr(AsExpr asExpr) throws IOException {
        this.visitInfixOpExpr(asExpr);
    }

    @Override
    public void visitArrayIndexExpr(ArrayIndexExpr arrayIndexExpr) throws IOException {
        arrayIndexExpr.getArray().visit(this);
        arrayIndexExpr.getIndexExpr().visit(this);
    }

    @Override
    public void visitParameters(Parameters parameters) throws IOException {
        this.visitIfNotNull((AstNode)parameters.getHead());
        if (parameters.getSymComma() != null) {
            if (((Parameter)parameters.getTail().getHead()).isRest()) {
                this.out.beginCommentWriteSymbol(parameters.getSymComma());
                parameters.getTail().visit(this);
                this.out.endComment();
            } else {
                this.out.writeSymbol(parameters.getSymComma());
                parameters.getTail().visit(this);
            }
        }
    }

    @Override
    public void visitFunctionExpr(FunctionExpr functionExpr) throws IOException {
        this.out.writeSymbol(functionExpr.getSymFunction());
        if (functionExpr.getIde() != null) {
            this.out.writeToken(functionExpr.getIde().getName());
        } else if (this.out.getKeepSource()) {
            this.out.writeToken(this.getFunctionNameAsIde(functionExpr));
        }
        this.generateFunTailCode(functionExpr);
    }

    public String getFunctionNameAsIde(FunctionExpr functionExpr) {
        IdeDeclaration classDeclaration = functionExpr.getClassDeclaration();
        String classNameAsIde = "";
        if (classDeclaration != null) {
            classNameAsIde = this.out.getQualifiedNameAsIde(classDeclaration);
        }
        JooSymbol sym2 = functionExpr.getSymbol();
        return new StringBuffer().append(classNameAsIde).append("$").append(sym2.getLine()).append("_").append(sym2.getColumn()).toString();
    }

    public void generateFunTailCode(FunctionExpr functionExpr) throws IOException {
        Parameters params = functionExpr.getParams();
        if (params != null && functionExpr.hasBody()) {
            functionExpr.getBody().addBlockStartCodeGenerator(this.getParameterInitializerCodeGenerator(params));
        }
        this.generateSignatureJsCode(functionExpr);
        if (functionExpr.hasBody()) {
            functionExpr.getBody().visit(this);
        }
    }

    public CodeGenerator getParameterInitializerCodeGenerator(final Parameters params) {
        return new CodeGenerator(){

            public void generate(JsWriter out, boolean first) throws IOException {
                int restParamIndex = -1;
                Parameter restParam = null;
                HashMap<Integer, Parameter> paramByIndex = new HashMap<Integer, Parameter>();
                int paramIndex = 0;
                for (Parameters parameters = params; parameters != null; parameters = parameters.getTail()) {
                    Parameter param = (Parameter)parameters.getHead();
                    if (param.isRest()) {
                        restParamIndex = paramIndex;
                        restParam = param;
                        break;
                    }
                    if (param.hasInitializer()) {
                        paramByIndex.put(paramIndex, param);
                    }
                    ++paramIndex;
                }
                JsCodeGenerator.this.generateParameterInitializers(out, paramByIndex);
                if (restParam != null) {
                    JsCodeGenerator.this.generateRestParamCode(restParam, restParamIndex);
                }
            }
        };
    }

    private void generateParameterInitializers(JsWriter out, Map<Integer, Parameter> paramByIndex) throws IOException {
        Iterator<Map.Entry<Integer, Parameter>> paramByIndexIterator = paramByIndex.entrySet().iterator();
        if (paramByIndexIterator.hasNext()) {
            Map.Entry<Integer, Parameter> indexAndParam = paramByIndexIterator.next();
            Integer firstParamIndex = indexAndParam.getKey();
            if (!paramByIndexIterator.hasNext()) {
                out.write(IF_ARGUMENT_LENGTH_LTE_$N.format(new Object[]{firstParamIndex}));
                this.generateBodyInitializerCode(indexAndParam.getValue());
            } else {
                out.write(SWITCH_$INDEX.format(new Object[]{firstParamIndex}));
                out.write("{");
                while (true) {
                    out.write(CASE_$N.format(new Object[]{indexAndParam.getKey()}));
                    this.generateBodyInitializerCode(indexAndParam.getValue());
                    if (!paramByIndexIterator.hasNext()) break;
                    indexAndParam = paramByIndexIterator.next();
                }
                out.write("}");
            }
        }
    }

    public void generateRestParamCode(Parameter param, int paramIndex) throws IOException {
        String paramName = param.getName();
        if (!(paramName == null || paramName.equals("arguments") && paramIndex == 0)) {
            this.out.write(VAR_$NAME_EQUALS_ARGUMENTS_SLICE_$INDEX.format(new Object[]{paramName, paramIndex}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateBodyInitializerCode(Parameter param) throws IOException {
        this.out.setSuppressWhitespace(true);
        try {
            this.out.writeToken(param.getName());
            this.out.writeSymbol(param.getOptInitializer().getSymEq());
            param.getOptInitializer().getValue().visit(this);
            this.out.write(";");
        }
        finally {
            this.out.setSuppressWhitespace(false);
        }
    }

    public void generateSignatureJsCode(FunctionExpr functionExpr) throws IOException {
        this.out.writeSymbol(functionExpr.getLParen());
        this.visitIfNotNull(functionExpr.getParams());
        this.out.writeSymbol(functionExpr.getRParen());
        this.visitIfNotNull(functionExpr.getOptTypeRelation());
    }

    @Override
    public void visitVectorLiteral(VectorLiteral vectorLiteral) throws IOException {
        this.out.beginComment();
        this.out.writeSymbol(vectorLiteral.getSymNew());
        this.out.writeSymbol(vectorLiteral.getSymLt());
        vectorLiteral.getVectorType().visit(this);
        this.out.writeSymbol(vectorLiteral.getSymGt());
        this.out.endComment();
        vectorLiteral.getArrayLiteral().visit(this);
    }

    @Override
    public void visitApplyExpr(ApplyExpr applyExpr) throws IOException {
        this.generateFunJsCode(applyExpr);
        if (applyExpr.getArgs() != null) {
            boolean isAssert;
            boolean bl = isAssert = applyExpr.getFun() instanceof IdeExpr && "assert".equals(applyExpr.getFun().getSymbol().getText());
            if (isAssert) {
                JooSymbol symKeyword = applyExpr.getFun().getSymbol();
                this.out.writeSymbol(applyExpr.getArgs().getLParen());
                applyExpr.getArgs().getExpr().visit(this);
                this.out.writeToken(", ");
                this.out.writeString(new File(symKeyword.getFileName()).getName());
                this.out.writeToken(", ");
                this.out.writeInt(symKeyword.getLine());
                this.out.write(", ");
                this.out.writeInt(symKeyword.getColumn());
                this.out.writeSymbol(applyExpr.getArgs().getRParen());
            } else {
                applyExpr.getArgs().visit(this);
            }
        }
    }

    private void generateFunJsCode(ApplyExpr applyExpr) throws IOException {
        if (applyExpr.isTypeCast()) {
            this.out.beginComment();
            applyExpr.getFun().visit(this);
            this.out.endComment();
        } else {
            applyExpr.getFun().visit(this);
        }
    }

    @Override
    public void visitNewExpr(NewExpr newExpr) throws IOException {
        this.out.writeSymbol(newExpr.getSymNew());
        newExpr.getApplyConstructor().visit(this);
    }

    @Override
    public void visitClassBody(ClassBody classBody) throws IOException {
        this.out.writeSymbolWhitespace(classBody.getLBrace());
        boolean inStaticInitializerBlock = false;
        for (Directive directive : classBody.getDirectives()) {
            boolean isStaticInitializer = directive instanceof Statement && !(directive instanceof Declaration);
            inStaticInitializerBlock = isStaticInitializer ? this.beginStaticInitializer(this.out, inStaticInitializerBlock) : this.endStaticInitializer(this.out, inStaticInitializerBlock);
            directive.visit(this);
        }
        this.endStaticInitializer(this.out, inStaticInitializerBlock);
        this.out.writeSymbolWhitespace(classBody.getRBrace());
    }

    private boolean beginStaticInitializer(JsWriter out, boolean inStaticInitializerBlock) throws IOException {
        if (!inStaticInitializerBlock) {
            out.writeToken("function(){");
        }
        return true;
    }

    private boolean endStaticInitializer(JsWriter out, boolean inStaticInitializerBlock) throws IOException {
        if (inStaticInitializerBlock) {
            out.writeToken("},");
        }
        return false;
    }

    @Override
    public void visitBlockStatement(BlockStatement blockStatement) throws IOException {
        this.out.writeSymbol(blockStatement.getLBrace());
        boolean first = true;
        for (CodeGenerator codeGenerator : blockStatement.getBlockStartCodeGenerators()) {
            codeGenerator.generate(this.out, first);
            first = false;
        }
        this.visitAll(blockStatement.getDirectives());
        this.out.writeSymbol(blockStatement.getRBrace());
    }

    @Override
    public void visitDefaultStatement(DefaultStatement defaultStatement) throws IOException {
        this.out.writeSymbol(defaultStatement.getSymDefault());
        this.out.writeSymbol(defaultStatement.getSymColon());
    }

    @Override
    public void visitLabeledStatement(LabeledStatement labeledStatement) throws IOException {
        labeledStatement.getIde().visit(this);
        this.out.writeSymbol(labeledStatement.getSymColon());
        labeledStatement.getStatement().visit(this);
    }

    @Override
    public void visitIfStatement(IfStatement ifStatement) throws IOException {
        this.out.writeSymbol(ifStatement.getSymKeyword());
        ifStatement.getCond().visit(this);
        ifStatement.getIfTrue().visit(this);
        if (ifStatement.getSymElse() != null) {
            this.out.writeSymbol(ifStatement.getSymElse());
            ifStatement.getIfFalse().visit(this);
        }
    }

    @Override
    public void visitCaseStatement(CaseStatement caseStatement) throws IOException {
        this.out.writeSymbol(caseStatement.getSymKeyword());
        caseStatement.getExpr().visit(this);
        this.out.writeSymbol(caseStatement.getSymColon());
    }

    @Override
    public void visitTryStatement(TryStatement tryStatement) throws IOException {
        this.out.writeSymbol(tryStatement.getSymKeyword());
        tryStatement.getBlock().visit(this);
        this.visitAll(tryStatement.getCatches());
        if (tryStatement.getSymFinally() != null) {
            this.out.writeSymbol(tryStatement.getSymFinally());
            tryStatement.getFinallyBlock().visit(this);
        }
    }

    @Override
    public void visitCatch(Catch aCatch) throws IOException {
        List<Catch> catches = aCatch.getParentTryStatement().getCatches();
        Catch firstCatch = catches.get(0);
        boolean isFirst = aCatch.equals(firstCatch);
        boolean isLast = aCatch.equals(catches.get(catches.size() - 1));
        TypeRelation typeRelation = aCatch.getParam().getOptTypeRelation();
        boolean hasCondition = aCatch.hasCondition();
        if (!hasCondition && !isLast) {
            throw Jooc.error(aCatch.getRParen(), "Only last catch clause may be untyped.");
        }
        JooSymbol errorVar = firstCatch.getParam().getIde().getIde();
        JooSymbol localErrorVar = aCatch.getParam().getIde().getIde();
        this.out.writeSymbolWhitespace(aCatch.getSymKeyword());
        if (isFirst) {
            this.out.writeSymbolToken(aCatch.getSymKeyword());
            this.out.writeSymbol(aCatch.getLParen(), !hasCondition);
            this.out.writeSymbol(errorVar, !hasCondition);
            if (!hasCondition && typeRelation != null) {
                typeRelation.visit(this);
            }
            this.out.writeSymbol(aCatch.getRParen(), !hasCondition);
            if (hasCondition || !isLast) {
                this.out.writeToken("{");
            }
        } else {
            this.out.writeToken("else");
        }
        if (hasCondition) {
            this.out.writeToken("if(is");
            this.out.writeSymbol(aCatch.getLParen());
            this.out.writeSymbolWhitespace(localErrorVar);
            this.out.writeSymbolToken(errorVar);
            this.out.writeSymbolWhitespace(typeRelation.getSymRelation());
            this.out.writeToken(",");
            Ide typeIde = typeRelation.getType().getIde();
            this.out.writeSymbolWhitespace(typeIde.getIde());
            this.out.writeToken(typeIde.getDeclaration().getQualifiedNameStr());
            this.out.writeSymbol(aCatch.getRParen());
            this.out.writeToken(")");
        }
        if (!localErrorVar.getText().equals(errorVar.getText())) {
            aCatch.getBlock().addBlockStartCodeGenerator(new VarCodeGenerator(localErrorVar, errorVar));
        }
        aCatch.getBlock().visit(this);
        if (isLast) {
            if (hasCondition) {
                this.out.writeToken("else throw");
                this.out.writeSymbolToken(errorVar);
                this.out.writeToken(";");
            }
            if (!isFirst || hasCondition) {
                this.out.writeToken("}");
            }
        }
    }

    @Override
    public void visitForInStatement(ForInStatement forInStatement) throws IOException {
        Ide exprAuxIde = forInStatement.getExprAuxIde();
        if (exprAuxIde != null) {
            new SemicolonTerminatedStatement(new VariableDeclaration(SYM_VAR, exprAuxIde, null, null), SYM_SEMICOLON).visit(this);
        }
        this.out.writeSymbol(forInStatement.getSymKeyword());
        if (forInStatement.getSymEach() != null) {
            this.out.beginComment();
            this.out.writeSymbol(forInStatement.getSymEach());
            this.out.endComment();
        }
        this.out.writeSymbol(forInStatement.getLParen());
        if (forInStatement.getSymEach() != null) {
            new VariableDeclaration(SYM_VAR, forInStatement.getAuxIde(), null, null).visit(this);
        } else if (forInStatement.getDecl() != null) {
            forInStatement.getDecl().visit(this);
        } else {
            forInStatement.getLValue().visit(this);
        }
        this.out.writeSymbol(forInStatement.getSymIn());
        if (exprAuxIde != null) {
            this.out.writeToken(exprAuxIde.getName());
            this.out.writeToken("=");
        }
        forInStatement.getExpr().visit(this);
        this.out.writeSymbol(forInStatement.getRParen());
        if (forInStatement.getSymEach() != null) {
            Expr expr = exprAuxIde == null ? forInStatement.getExpr() : new IdeExpr(exprAuxIde);
            ArrayIndexExpr indexExpr = new ArrayIndexExpr(expr, SYM_LBRACK, new CommaSeparatedList<IdeExpr>(new IdeExpr(forInStatement.getAuxIde())), SYM_RBRACK);
            SemicolonTerminatedStatement assignment = new SemicolonTerminatedStatement(forInStatement.getDecl() != null ? new VariableDeclaration(SYM_VAR, forInStatement.getDecl().getIde(), forInStatement.getDecl().getOptTypeRelation(), new Initializer(SYM_EQ, indexExpr)) : new AssignmentOpExpr(forInStatement.getLValue(), SYM_EQ, indexExpr), SYM_SEMICOLON);
            if (forInStatement.getBody() instanceof BlockStatement) {
                ((BlockStatement)forInStatement.getBody()).getDirectives().add(0, assignment);
            } else {
                forInStatement.setBody(new BlockStatement(SYM_LBRACE, Arrays.asList(assignment, forInStatement.getBody()), SYM_RBRACE));
            }
        }
        forInStatement.getBody().visit(this);
    }

    @Override
    public void visitWhileStatement(WhileStatement whileStatement) throws IOException {
        this.out.writeSymbol(whileStatement.getSymKeyword());
        this.visitIfNotNull(whileStatement.getOptCond());
        whileStatement.getBody().visit(this);
    }

    @Override
    public void visitForStatement(ForStatement forStatement) throws IOException {
        this.out.writeSymbol(forStatement.getSymKeyword());
        this.out.writeSymbol(forStatement.getLParen());
        this.visitIfNotNull(forStatement.getForInit());
        this.out.writeSymbol(forStatement.getSymSemicolon1());
        this.visitIfNotNull(forStatement.getOptCond());
        this.out.writeSymbol(forStatement.getSymSemicolon2());
        this.visitIfNotNull(forStatement.getOptStep());
        this.out.writeSymbol(forStatement.getRParen());
        forStatement.getBody().visit(this);
    }

    @Override
    public void visitDoStatement(DoStatement doStatement) throws IOException {
        this.out.writeSymbol(doStatement.getSymKeyword());
        doStatement.getBody().visit(this);
        this.out.writeSymbol(doStatement.getSymWhile());
        doStatement.getOptCond().visit(this);
        this.out.writeSymbol(doStatement.getSymSemicolon());
    }

    @Override
    public void visitSwitchStatement(SwitchStatement switchStatement) throws IOException {
        this.out.writeSymbol(switchStatement.getSymKeyword());
        switchStatement.getCond().visit(this);
        switchStatement.getBlock().visit(this);
    }

    @Override
    public void visitSemicolonTerminatedStatement(SemicolonTerminatedStatement semicolonTerminatedStatement) throws IOException {
        this.visitIfNotNull(semicolonTerminatedStatement.getOptStatement());
        this.writeOptSymbol(semicolonTerminatedStatement.getOptSymSemicolon());
    }

    @Override
    public void visitContinueStatement(ContinueStatement continueStatement) throws IOException {
        this.out.writeSymbol(continueStatement.getSymKeyword());
        this.visitIfNotNull(continueStatement.getOptStatement());
        this.visitIfNotNull(continueStatement.getOptLabel());
        this.writeOptSymbol(continueStatement.getOptSymSemicolon());
    }

    @Override
    public void visitBreakStatement(BreakStatement breakStatement) throws IOException {
        this.out.writeSymbol(breakStatement.getSymKeyword());
        this.visitIfNotNull(breakStatement.getOptStatement());
        this.visitIfNotNull(breakStatement.getOptLabel());
        this.writeOptSymbol(breakStatement.getOptSymSemicolon());
    }

    @Override
    public void visitThrowStatement(ThrowStatement throwStatement) throws IOException {
        this.out.writeSymbol(throwStatement.getSymKeyword());
        this.visitIfNotNull(throwStatement.getOptStatement());
        this.writeOptSymbol(throwStatement.getOptSymSemicolon());
    }

    @Override
    public void visitReturnStatement(ReturnStatement returnStatement) throws IOException {
        this.out.writeSymbol(returnStatement.getSymKeyword());
        this.visitIfNotNull(returnStatement.getOptStatement());
        this.writeOptSymbol(returnStatement.getOptSymSemicolon());
    }

    @Override
    public void visitEmptyStatement(EmptyStatement emptyStatement) throws IOException {
        this.visitSemicolonTerminatedStatement(emptyStatement);
    }

    @Override
    public void visitEmptyDeclaration(EmptyDeclaration emptyDeclaration) throws IOException {
        this.out.writeSymbolWhitespace(emptyDeclaration.getSymSemicolon());
    }

    @Override
    public void visitParameter(Parameter parameter) throws IOException {
        Debug.assertTrue(parameter.getModifiers() == 0, "Parameters must not have any modifiers");
        boolean isRest = parameter.isRest();
        if (parameter.getOptSymConstOrRest() != null) {
            this.out.beginCommentWriteSymbol(parameter.getOptSymConstOrRest());
            if (isRest) {
                parameter.getIde().visit(this);
            }
            this.out.endComment();
        }
        if (!isRest) {
            parameter.getIde().visit(this);
        }
        this.visitIfNotNull(parameter.getOptTypeRelation());
        if (parameter.getOptInitializer() != null) {
            this.out.beginComment();
            parameter.getOptInitializer().visit(this);
            this.out.endComment();
        }
    }

    @Override
    public void visitVariableDeclaration(VariableDeclaration variableDeclaration) throws IOException {
        if (variableDeclaration.hasPreviousVariableDeclaration()) {
            Debug.assertTrue(variableDeclaration.getOptSymConstOrVar() != null && variableDeclaration.getOptSymConstOrVar().sym == 72, "Additional variable declarations must start with a COMMA.");
            this.out.writeSymbol(variableDeclaration.getOptSymConstOrVar());
        } else {
            this.generateVariableDeclarationStartCode(variableDeclaration);
        }
        variableDeclaration.getIde().visit(this);
        this.visitIfNotNull(variableDeclaration.getOptTypeRelation());
        this.generateVariableDeclarationInitializerCode(variableDeclaration);
        this.visitIfNotNull(variableDeclaration.getOptNextVariableDeclaration());
        this.generateVariableDeclarationEndCode(variableDeclaration);
    }

    protected void generateVariableDeclarationStartCode(VariableDeclaration variableDeclaration) throws IOException {
        if (variableDeclaration.isClassMember()) {
            this.generateFieldStartCode(variableDeclaration);
        } else {
            this.generateVarStartCode(variableDeclaration);
        }
    }

    protected void generateVarStartCode(VariableDeclaration variableDeclaration) throws IOException {
        this.out.beginComment();
        this.writeModifiers(this.out, variableDeclaration);
        this.out.endComment();
        if (variableDeclaration.getOptSymConstOrVar() != null) {
            if (variableDeclaration.isConst()) {
                this.out.beginCommentWriteSymbol(variableDeclaration.getOptSymConstOrVar());
                this.out.endComment();
                this.out.writeToken("var");
            } else {
                this.out.writeSymbol(variableDeclaration.getOptSymConstOrVar());
            }
        }
    }

    protected void generateFieldStartCode(VariableDeclaration variableDeclaration) throws IOException {
        this.out.beginString();
        this.writeModifiers(this.out, variableDeclaration);
        this.writeOptSymbol(variableDeclaration.getOptSymConstOrVar());
        this.out.endString();
        this.out.write(",{");
    }

    protected void generateVariableDeclarationInitializerCode(VariableDeclaration variableDeclaration) throws IOException {
        if (variableDeclaration.isClassMember()) {
            this.generateFieldInitializerCode(variableDeclaration);
        } else {
            this.visitIfNotNull(variableDeclaration.getOptInitializer());
        }
    }

    protected void generateFieldInitializerCode(VariableDeclaration variableDeclaration) throws IOException {
        if (variableDeclaration.getOptInitializer() != null) {
            boolean mustEvaluateAtRuntime;
            this.out.writeSymbolWhitespace(variableDeclaration.getOptInitializer().getSymEq());
            this.out.write(58);
            boolean bl = mustEvaluateAtRuntime = !variableDeclaration.getOptInitializer().getValue().isRuntimeConstant();
            if (mustEvaluateAtRuntime) {
                this.out.writeToken("function(){return(");
            }
            variableDeclaration.getOptInitializer().getValue().visit(this);
            if (mustEvaluateAtRuntime) {
                this.out.writeToken(");}");
            }
        } else {
            TypeRelation typeRelation = variableDeclaration.getOptTypeRelation();
            String emptyValue = VariableDeclaration.getDefaultValue(typeRelation);
            this.out.write(new StringBuffer().append(":").append(emptyValue).toString());
        }
    }

    protected void generateVariableDeclarationEndCode(VariableDeclaration variableDeclaration) throws IOException {
        if (variableDeclaration.isClassMember()) {
            this.generateFieldEndCode(variableDeclaration);
        } else {
            this.writeOptSymbol(variableDeclaration.getOptSymSemicolon());
        }
    }

    protected void generateFieldEndCode(VariableDeclaration variableDeclaration) throws IOException {
        if (!variableDeclaration.hasPreviousVariableDeclaration()) {
            this.out.write(125);
            Debug.assertTrue(variableDeclaration.getOptSymSemicolon() != null, "optSymSemicolon != null");
            this.out.writeSymbolWhitespace(variableDeclaration.getOptSymSemicolon());
            this.out.writeToken(",");
        }
    }

    @Override
    public void visitFunctionDeclaration(FunctionDeclaration functionDeclaration) throws IOException {
        if (!$assertionsDisabled && !functionDeclaration.isClassMember() && (functionDeclaration.isNative() || functionDeclaration.isAbstract())) {
            throw new AssertionError();
        }
        if (functionDeclaration.isThisAliased()) {
            functionDeclaration.getBody().addBlockStartCodeGenerator(ALIAS_THIS_CODE_GENERATOR);
        }
        if (functionDeclaration.isConstructor() && !functionDeclaration.containsSuperConstructorCall() && functionDeclaration.hasBody()) {
            functionDeclaration.getBody().addBlockStartCodeGenerator(new SuperCallCodeGenerator(functionDeclaration.getClassDeclaration()));
        }
        if (!functionDeclaration.isClassMember()) {
            functionDeclaration.getFun().visit(this);
        } else {
            if (functionDeclaration.isAbstract()) {
                this.out.beginComment();
                this.writeModifiers(this.out, functionDeclaration);
                this.out.writeSymbol(functionDeclaration.getFun().getFunSymbol());
                functionDeclaration.getIde().visit(this);
            } else {
                this.out.beginString();
                this.writeModifiers(this.out, functionDeclaration);
                this.out.writeSymbol(functionDeclaration.getFun().getFunSymbol());
                if (functionDeclaration.isGetterOrSetter()) {
                    this.out.writeSymbol(functionDeclaration.getSymGetOrSet());
                }
                functionDeclaration.getIde().visit(this);
                this.out.endString();
                if (functionDeclaration.isNative()) {
                    this.out.beginComment();
                } else {
                    this.out.writeToken(",");
                    this.out.writeToken("function");
                    if (this.out.getKeepSource()) {
                        String functionName = functionDeclaration.getIde().getName();
                        if (functionDeclaration.getSymGetOrSet() != null) {
                            this.out.writeToken(new StringBuffer().append(functionName).append("$").append(functionDeclaration.getSymGetOrSet().getText()).toString());
                        } else {
                            this.out.writeToken(functionName);
                        }
                    }
                }
            }
            this.generateFunTailCode(functionDeclaration.getFun());
            if (functionDeclaration.isClassMember()) {
                if (functionDeclaration.isAbstract() || functionDeclaration.isNative()) {
                    this.out.endComment();
                }
                this.out.write(44);
            }
        }
    }

    @Override
    public void visitClassDeclaration(ClassDeclaration classDeclaration) throws IOException {
        this.visitAll(classDeclaration.getDirectives());
        this.out.beginString();
        this.writeModifiers(this.out, classDeclaration);
        this.out.writeSymbol(classDeclaration.getSymClass());
        classDeclaration.getIde().visit(this);
        this.visitIfNotNull(classDeclaration.getOptExtends());
        this.visitIfNotNull(classDeclaration.getOptImplements());
        this.out.endString();
        this.out.write(",");
        this.out.write(new StringBuffer().append(classDeclaration.getInheritanceLevel()).append(",").toString());
        this.out.write("function($$private){");
        this.writeAliases(classDeclaration);
        this.out.write("return[");
        this.generateClassInits(classDeclaration);
        classDeclaration.getBody().visit(this);
        if (classDeclaration.getConstructor() == null && !classDeclaration.getFieldsWithInitializer().isEmpty()) {
            this.out.write(new StringBuffer().append("\"public function ").append(classDeclaration.getName()).append("\",function ").append(classDeclaration.getName()).append("$(){").toString());
            new SuperCallCodeGenerator(classDeclaration).generate(this.out, true);
            this.out.write("},");
        }
        for (IdeDeclaration secondaryDeclaration : classDeclaration.getSecondaryDeclarations()) {
            secondaryDeclaration.visit(this);
            this.out.writeToken(",");
        }
        this.out.write("undefined];},");
        this.generateStaticMethodList(classDeclaration);
    }

    private void generateFieldInitCode(ClassDeclaration classDeclaration, boolean startWithSemicolon, boolean preventFirefox9Bug) throws IOException {
        Iterator<VariableDeclaration> iterator = classDeclaration.getFieldsWithInitializer().iterator();
        if (iterator.hasNext()) {
            if (startWithSemicolon) {
                this.out.write(";");
            }
            if (preventFirefox9Bug) {
                this.out.writeToken("if(0===0){");
            }
            do {
                VariableDeclaration field = iterator.next();
                this.generateInitCode(field, true);
            } while (iterator.hasNext());
            if (preventFirefox9Bug) {
                this.out.write("}");
            }
        }
    }

    public void generateInitCode(VariableDeclaration field, boolean endWithSemicolon) throws IOException {
        String accessCode = new StringBuffer().append("this.").append(field.getName()).append(field.isPrivate() ? new StringBuffer().append("$").append(field.getClassDeclaration().getInheritanceLevel()).toString() : "").toString();
        this.out.write(new StringBuffer().append(accessCode).append("=").append(accessCode).append("()").toString());
        if (endWithSemicolon) {
            this.out.write(";");
        }
    }

    private void generateStaticMethodList(ClassDeclaration classDeclaration) throws IOException {
        this.out.write("[");
        boolean isFirst = true;
        for (TypedIdeDeclaration memberDeclaration : classDeclaration.getStaticMembers().values()) {
            if (!memberDeclaration.isMethod() || memberDeclaration.isPrivate() || memberDeclaration.isProtected() || !memberDeclaration.isStatic() || memberDeclaration.isNative()) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                this.out.write(",");
            }
            this.out.write(34);
            this.out.write(memberDeclaration.getName());
            this.out.write(34);
        }
        this.out.write("]");
    }

    private void writeAliases(ClassDeclaration classDeclaration) throws IOException {
        boolean first = true;
        for (Map.Entry<String, String> entry : classDeclaration.getAuxVarDeclarations().entrySet()) {
            if (first) {
                this.out.writeToken("var");
                first = false;
            } else {
                this.out.writeToken(",");
            }
            this.out.writeToken(entry.getKey());
            this.out.writeToken("=");
            this.out.writeToken(entry.getValue());
        }
        if (!first) {
            this.out.writeToken(";");
        }
    }

    private void generateClassInits(ClassDeclaration classDeclaration) throws IOException {
        boolean first = true;
        Set<String> classInit = classDeclaration.getClassInit();
        for (String qualifiedNameStr : classInit) {
            if (PRIMITIVES.contains(qualifiedNameStr)) continue;
            if (first) {
                first = false;
                this.out.write("function(){joo.classLoader.init(");
            } else {
                this.out.write(",");
            }
            this.out.write(qualifiedNameStr);
        }
        if (!first) {
            this.out.write(");},");
        }
    }

    @Override
    public void visitNamespacedDeclaration(NamespacedDeclaration namespacedDeclaration) throws IOException {
        this.out.beginString();
        this.writeModifiers(this.out, namespacedDeclaration);
        this.out.writeSymbol(namespacedDeclaration.getSymNamespace());
        namespacedDeclaration.getIde().visit(this);
        this.out.endString();
        this.out.writeSymbolWhitespace(namespacedDeclaration.getOptInitializer().getSymEq());
        this.out.writeToken(",");
        namespacedDeclaration.getOptInitializer().getValue().visit(this);
        this.writeSymbolReplacement(namespacedDeclaration.getOptSymSemicolon(), ",[]");
    }

    @Override
    public void visitPackageDeclaration(PackageDeclaration packageDeclaration) throws IOException {
        this.out.beginString();
        this.out.writeSymbol(packageDeclaration.getSymPackage());
        this.visitIfNotNull(packageDeclaration.getIde());
        this.out.endString();
        this.out.write(",");
    }

    @Override
    public void visitSuperConstructorCallStatement(SuperConstructorCallStatement superConstructorCallStatement) throws IOException {
        if (superConstructorCallStatement.getClassDeclaration().getInheritanceLevel() > 1) {
            this.generateSuperConstructorCallCode(superConstructorCallStatement);
            this.generateFieldInitCode(superConstructorCallStatement.getClassDeclaration(), true, false);
        } else {
            this.out.beginComment();
            this.out.writeSymbol(superConstructorCallStatement.getSymbol());
            this.visitIfNotNull(superConstructorCallStatement.getArgs());
            this.out.endComment();
            this.generateFieldInitCode(superConstructorCallStatement.getClassDeclaration(), false, true);
        }
        this.out.writeSymbol(superConstructorCallStatement.getSymSemicolon());
    }

    private void generateSuperConstructorCallCode(SuperConstructorCallStatement superConstructorCallStatement) throws IOException {
        this.out.writeSymbolWhitespace(superConstructorCallStatement.getSymbol());
        this.generateSuperConstructorCallCode(superConstructorCallStatement.getClassDeclaration(), superConstructorCallStatement.getArgs());
    }

    private void generateSuperConstructorCallCode(ClassDeclaration classDeclaration, ParenthesizedExpr<CommaSeparatedList<Expr>> args) throws IOException {
        String superClassQName = classDeclaration.getSuperTypeDeclaration().getQualifiedNameStr();
        if ("Error".equals(superClassQName)) {
            this.out.write("joo.Error");
        } else {
            Ide superClassIde = classDeclaration.getSuperType().getIde();
            this.out.writeSymbolWhitespace(superClassIde.getSymbol());
            IdeDeclaration superClassDeclaration = superClassIde.getDeclaration();
            String packageName = superClassDeclaration.getPackageDeclaration().getQualifiedNameStr();
            String qName = superClassDeclaration.getName();
            if (packageName.length() > 0) {
                String packageAuxVar = classDeclaration.getAuxVarForPackage(packageName);
                qName = CompilerUtils.qName(packageAuxVar, qName);
            }
            this.out.write(qName);
        }
        this.out.writeToken(".call");
        if (args == null) {
            this.out.writeToken("(this)");
        } else {
            this.out.writeSymbol(args.getLParen());
            this.out.writeToken("this");
            CommaSeparatedList<Expr> arguments = args.getExpr();
            if (arguments != null) {
                if (arguments.getHead() != null) {
                    this.out.writeToken(",");
                }
                arguments.visit(this);
            }
            this.out.writeSymbol(args.getRParen());
        }
    }

    @Override
    public void visitAnnotation(Annotation annotation) throws IOException {
        this.out.writeSymbolWhitespace(annotation.getLeftBracket());
        this.out.writeToken("{");
        annotation.getIde().visit(this);
        this.out.writeToken(":");
        this.writeSymbolReplacement(annotation.getOptLeftParen(), "{");
        this.visitIfNotNull(annotation.getOptAnnotationParameters());
        this.writeSymbolReplacement(annotation.getOptRightParen(), "}");
        this.out.writeSymbolWhitespace(annotation.getRightBracket());
        this.out.writeToken("},");
    }

    @Override
    public void visitUseNamespaceDirective(UseNamespaceDirective useNamespaceDirective) throws IOException {
        this.out.beginComment();
        this.out.writeSymbol(useNamespaceDirective.getUseKeyword());
        this.out.writeSymbol(useNamespaceDirective.getNamespaceKeyword());
        useNamespaceDirective.getNamespace().visit(this);
        this.out.writeSymbol(useNamespaceDirective.getSymSemicolon());
        this.out.endComment();
    }

    @Override
    public void visitImportDirective(ImportDirective importDirective) throws IOException {
        if (importDirective.isExplicit()) {
            this.out.beginComment();
            this.out.writeSymbol(importDirective.getImportKeyword());
            importDirective.getIde().visit(this);
            this.out.writeSymbol(importDirective.getSymSemicolon());
            this.out.endComment();
        }
    }

    static {
        Class<?> clazz = class$net$jangaroo$jooc$backend$JsCodeGenerator;
        if (clazz == null) {
            clazz = class$net$jangaroo$jooc$backend$JsCodeGenerator = new JsCodeGenerator[0].getClass().getComponentType();
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        SYM_VAR = new JooSymbol(38, "var");
        SYM_EQ = new JooSymbol(58, "=");
        SYM_SEMICOLON = new JooSymbol(71, ";");
        SYM_LBRACE = new JooSymbol(90, "{");
        SYM_RBRACE = new JooSymbol(91, "}");
        SYM_LBRACK = new JooSymbol(92, "[");
        SYM_RBRACK = new JooSymbol(93, "]");
        PRIMITIVES = new HashSet<String>(4);
        PRIMITIVES.add("Boolean");
        PRIMITIVES.add("String");
        PRIMITIVES.add("Number");
        PRIMITIVES.add("int");
        PRIMITIVES.add("uint");
        PRIMITIVES.add("Object");
        PRIMITIVES.add("RegExp");
        PRIMITIVES.add("Date");
        PRIMITIVES.add("Array");
        PRIMITIVES.add("Error");
        PRIMITIVES.add("Vector");
        PRIMITIVES.add("Class");
        PRIMITIVES.add("XML");
        IF_ARGUMENT_LENGTH_LTE_$N = new MessageFormat("if(arguments.length<={0})");
        SWITCH_$INDEX = new MessageFormat("switch({0,choice,0#arguments.length|0<Math.max(arguments.length,{0})})");
        CASE_$N = new MessageFormat("case {0}:");
        VAR_$NAME_EQUALS_ARGUMENTS_SLICE_$INDEX = new MessageFormat("var {0}=Array.prototype.slice.call(arguments{1,choice,0#|0<,{1}});");
        ALIAS_THIS_CODE_GENERATOR = new CodeGenerator(){

            public void generate(JsWriter out, boolean first) throws IOException {
                out.write("var this$=this;");
            }
        };
    }

    private class SuperCallCodeGenerator
    implements CodeGenerator {
        private ClassDeclaration classDeclaration;

        public SuperCallCodeGenerator(ClassDeclaration classDeclaration) {
            this.classDeclaration = classDeclaration;
        }

        public void generate(JsWriter out, boolean first) throws IOException {
            int inheritanceLevel = this.classDeclaration.getInheritanceLevel();
            if (inheritanceLevel > 1) {
                JsCodeGenerator.this.generateSuperConstructorCallCode(this.classDeclaration, null);
                out.writeToken(";");
                first = false;
            }
            JsCodeGenerator.this.generateFieldInitCode(this.classDeclaration, false, first);
        }
    }

    private static class VarCodeGenerator
    implements CodeGenerator {
        private final JooSymbol localErrorVar;
        private final JooSymbol errorVar;

        public VarCodeGenerator(JooSymbol localErrorVar, JooSymbol errorVar) {
            this.localErrorVar = localErrorVar;
            this.errorVar = errorVar;
        }

        public void generate(JsWriter out, boolean first) throws IOException {
            out.writeToken("var");
            out.writeSymbolToken(this.localErrorVar);
            out.writeToken("=");
            out.writeSymbolToken(this.errorVar);
            out.writeToken(";");
        }
    }
}

