/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.backend;

import java.io.IOException;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.BinaryOpExpr;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.ConditionalExpr;
import net.jangaroo.jooc.ast.Declaration;
import net.jangaroo.jooc.ast.DotExpr;
import net.jangaroo.jooc.ast.IsExpr;
import net.jangaroo.jooc.ast.LiteralExpr;
import net.jangaroo.jooc.ast.Parameters;
import net.jangaroo.jooc.ast.PostfixOpExpr;
import net.jangaroo.jooc.ast.PredefinedTypeDeclaration;
import net.jangaroo.jooc.ast.PrefixOpExpr;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CodeGeneratorBase
implements AstVisitor {
    protected final JsWriter out;

    public CodeGeneratorBase(JsWriter out) {
        this.out = out;
    }

    protected void writeModifiers(JsWriter out, Declaration declaration) throws IOException {
        for (JooSymbol modifier : declaration.getSymModifiers()) {
            out.writeSymbol(modifier);
        }
    }

    @Override
    public final void visitLiteralExpr(LiteralExpr literalExpr) throws IOException {
        this.out.writeSymbol(literalExpr.getValue());
    }

    @Override
    public final void visitPostfixOpExpr(PostfixOpExpr postfixOpExpr) throws IOException {
        postfixOpExpr.getArg().visit(this);
        this.out.writeSymbol(postfixOpExpr.getOp());
    }

    @Override
    public void visitDotExpr(DotExpr dotExpr) throws IOException {
        this.visitPostfixOpExpr(dotExpr);
        dotExpr.getIde().visit(this);
    }

    @Override
    public final void visitPrefixOpExpr(PrefixOpExpr prefixOpExpr) throws IOException {
        this.out.writeSymbol(prefixOpExpr.getOp());
        prefixOpExpr.getArg().visit(this);
    }

    @Override
    public final void visitBinaryOpExpr(BinaryOpExpr binaryOpExpr) throws IOException {
        binaryOpExpr.getArg1().visit(this);
        this.out.writeSymbol(binaryOpExpr.getOp());
        binaryOpExpr.getArg2().visit(this);
    }

    @Override
    public final void visitIsExpr(IsExpr isExpr) throws IOException {
        this.visitInfixOpExpr(isExpr);
    }

    @Override
    public final void visitConditionalExpr(ConditionalExpr conditionalExpr) throws IOException {
        conditionalExpr.getCond().visit(this);
        this.out.writeSymbol(conditionalExpr.getSymQuestion());
        conditionalExpr.getIfTrue().visit(this);
        this.out.writeSymbol(conditionalExpr.getSymColon());
        conditionalExpr.getIfFalse().visit(this);
    }

    @Override
    public final <T extends AstNode> void visitCommaSeparatedList(CommaSeparatedList<T> commaSeparatedList) throws IOException {
        this.visitIfNotNull((AstNode)commaSeparatedList.getHead());
        if (commaSeparatedList.getSymComma() != null) {
            this.out.writeSymbol(commaSeparatedList.getSymComma());
            this.visitIfNotNull(commaSeparatedList.getTail());
        }
    }

    @Override
    public void visitParameters(Parameters parameters) throws IOException {
        this.visitCommaSeparatedList(parameters);
    }

    @Override
    public final void visitPredefinedTypeDeclaration(PredefinedTypeDeclaration predefinedTypeDeclaration) throws IOException {
        throw new IllegalStateException("there should be no code generation for predefined types");
    }

    protected void writeOptSymbol(JooSymbol symbol2) throws IOException {
        if (symbol2 != null) {
            this.out.writeSymbol(symbol2);
        }
    }

    protected void writeOptSymbol(JooSymbol optSymbol, String defaultToken) throws IOException {
        if (optSymbol != null) {
            this.out.writeSymbol(optSymbol);
        } else {
            this.out.writeToken(defaultToken);
        }
    }

    protected void writeSymbolReplacement(JooSymbol symbol2, String replacementToken) throws IOException {
        if (symbol2 != null) {
            this.out.writeSymbolWhitespace(symbol2);
        }
        this.out.writeToken(replacementToken);
    }

    protected void visitIfNotNull(AstNode args) throws IOException {
        if (args != null) {
            args.visit(this);
        }
    }

    protected void visitIfNotNull(AstNode args, String replacementToken) throws IOException {
        if (args != null) {
            args.visit(this);
        } else {
            this.out.writeToken(replacementToken);
        }
    }

    protected void visitAll(Iterable<? extends AstNode> nodes) throws IOException {
        for (AstNode astNode : nodes) {
            astNode.visit(this);
        }
    }
}

