/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.util.List;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.NamespacedIde;
import net.jangaroo.jooc.ast.TypeRelation;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypedIdeDeclaration
extends IdeDeclaration {
    private JooSymbol namespace;
    private TypeRelation optTypeRelation;

    public TypedIdeDeclaration(JooSymbol[] modifiers, Ide ide, TypeRelation optTypeRelation) {
        super(modifiers, ide);
        this.namespace = this.findNamespace(modifiers);
        this.optTypeRelation = optTypeRelation;
    }

    private JooSymbol findNamespace(JooSymbol[] modifiers) {
        for (JooSymbol modifier : modifiers) {
            if (this.getModifierFlag(modifier) != 512) continue;
            return modifier;
        }
        return null;
    }

    public JooSymbol getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean isPublicApi() {
        return super.isPublicApi() || this.getNamespace() != null;
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(new Object[]{super.getChildren(), this.optTypeRelation});
    }

    @Override
    public String getName() {
        return new StringBuffer().append(NamespacedIde.getNamespacePrefix(this.namespace)).append(super.getName()).toString();
    }

    @Override
    public void scope(Scope scope) {
        if (this.getOptTypeRelation() != null) {
            this.getOptTypeRelation().scope(scope);
        }
        ClassDeclaration classDeclaration = scope.getClassDeclaration();
        super.scope(scope);
        if (this.isClassMember() && classDeclaration != null) {
            classDeclaration.registerMember(this);
        }
    }

    protected void addPublicApiDependencyOn(TypeRelation optTypeRelation) {
        if (optTypeRelation != null) {
            optTypeRelation.getType().getIde().addPublicApiDependency();
        }
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        if (this.isPublicApi()) {
            this.addPublicApiDependencyOn(this.optTypeRelation);
        }
    }

    @Override
    boolean allowDuplicates(Scope scope) {
        return scope.getClassDeclaration() == null || super.allowDuplicates(scope);
    }

    @Override
    public IdeDeclaration resolveDeclaration() {
        if (this.getOptTypeRelation() == null) {
            return null;
        }
        if (this.getOptTypeRelation().getType().getIde().equals(this.getIde())) {
            throw Jooc.error(this.getSymbol(), new StringBuffer().append("Type was not found or was not a compile-time constant: ").append(this.getIde().getSymbol().getText()).toString());
        }
        return this.getOptTypeRelation().getType().resolveDeclaration();
    }

    public TypeRelation getOptTypeRelation() {
        return this.optTypeRelation;
    }
}

