/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import net.jangaroo.jooc.DeclarationScope;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.FunctionExpr;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.ImportDirective;
import net.jangaroo.jooc.ast.LabeledStatement;
import net.jangaroo.jooc.ast.LoopStatement;
import net.jangaroo.jooc.ast.PackageDeclaration;
import net.jangaroo.jooc.ast.Statement;

public abstract class ScopeImplBase
implements Scope {
    private Scope parent;

    public ScopeImplBase(Scope parent) {
        this.parent = parent;
    }

    public Scope getParentScope() {
        return this.parent;
    }

    public void addImport(ImportDirective importDirective) {
        this.mustBeInsideValueScope();
        this.parent.addImport(importDirective);
    }

    public AstNode getDefiningNode() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getDefiningNode();
    }

    public IdeDeclaration declareIde(IdeDeclaration decl) {
        this.mustBeInsideValueScope();
        return this.parent.declareIde(decl);
    }

    private void mustBeInsideValueScope() {
        if (this.parent == null) {
            throw new UnsupportedOperationException("this scope must be wrapped by a ValueScope");
        }
    }

    public LabeledStatement lookupLabel(Ide ide) {
        if (this.parent == null) {
            throw Jooc.error(ide, "undeclared label '" + ide.getName() + "'");
        }
        return this.parent.lookupLabel(ide);
    }

    public IdeDeclaration lookupDeclaration(Ide ide) {
        return this.parent == null ? null : this.parent.lookupDeclaration(ide);
    }

    public boolean isDeclared(Ide ide) {
        return this.parent != null && this.getParentScope().isDeclared(ide);
    }

    public Ide findFreeAuxVar() {
        return this.parent == null ? null : this.parent.findFreeAuxVar();
    }

    public Ide createAuxVar(Scope lookupScope) {
        return this.parent.createAuxVar(lookupScope);
    }

    public LoopStatement getCurrentLoop() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getCurrentLoop();
    }

    public Statement getCurrentLoopOrSwitch() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getCurrentLoopOrSwitch();
    }

    public CompilationUnit getCompilationUnit() {
        return this.parent == null ? null : this.parent.getCompilationUnit();
    }

    public PackageDeclaration getPackageDeclaration() {
        return this.parent == null ? null : this.parent.getPackageDeclaration();
    }

    public ClassDeclaration getClassDeclaration() {
        return this.parent == null ? null : this.parent.getClassDeclaration();
    }

    public DeclarationScope getPackageDeclarationScope() {
        return this.parent == null ? null : this.parent.getPackageDeclarationScope();
    }

    public FunctionDeclaration getMethodDeclaration() {
        return this.parent == null ? null : this.parent.getMethodDeclaration();
    }

    public FunctionExpr getFunctionExpr() {
        return this.parent == null ? null : this.parent.getFunctionExpr();
    }

    public boolean isPackage(String fullyQualifiedName) {
        return this.parent != null && this.parent.isPackage(fullyQualifiedName);
    }
}

