/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jangaroo.jooc.CompilerError;
import net.jangaroo.jooc.DeclarationScope;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.ClassBody;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.Extends;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.Implements;
import net.jangaroo.jooc.ast.ImportDirective;
import net.jangaroo.jooc.ast.NodeImplBase;
import net.jangaroo.jooc.ast.Type;
import net.jangaroo.jooc.ast.TypedIdeDeclaration;
import net.jangaroo.jooc.ast.VariableDeclaration;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDeclaration
extends IdeDeclaration {
    private JooSymbol symClass;
    private Extends optExtends;
    private Map<String, TypedIdeDeclaration> members = new LinkedHashMap<String, TypedIdeDeclaration>();
    private Map<String, TypedIdeDeclaration> staticMembers = new LinkedHashMap<String, TypedIdeDeclaration>();
    private Set<String> classInit = new HashSet<String>();
    private ClassBody body;
    private FunctionDeclaration constructor = null;
    private Type thisType;
    private Type superType;
    private List<VariableDeclaration> fieldsWithInitializer = new ArrayList<VariableDeclaration>();
    private List<IdeDeclaration> secondaryDeclarations = Collections.EMPTY_LIST;
    private int inheritanceLevel = -1;
    private Implements optImplements;
    private Scope scope;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$net$jangaroo$jooc$ast$ClassDeclaration;

    public ClassDeclaration(JooSymbol[] modifiers, JooSymbol cls, Ide ide, Extends ext, Implements impl, ClassBody body) {
        super(modifiers, ide);
        this.symClass = cls;
        this.optExtends = ext;
        this.optImplements = impl;
        this.body = body;
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(new Object[]{super.getChildren(), this.optExtends, this.optImplements, this.body});
    }

    public FunctionDeclaration getConstructor() {
        return this.constructor;
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitClassDeclaration(this);
    }

    @Override
    protected int getAllowedModifiers() {
        return 895;
    }

    public boolean isInterface() {
        return "interface".equals(this.getSymClass().getText());
    }

    @Override
    public boolean isAbstract() {
        return this.isInterface() || super.isAbstract();
    }

    @Override
    public boolean isStatic() {
        return super.isStatic() || !this.isPrimaryDeclaration();
    }

    @Override
    public boolean isClassMember() {
        return super.isClassMember() || !this.isPrimaryDeclaration();
    }

    @Override
    public String getName() {
        return this.getIde().getName();
    }

    public void setConstructor(FunctionDeclaration methodDeclaration) {
        if (this.constructor != null) {
            throw Jooc.error(methodDeclaration, "Only one constructor allowed per class");
        }
        this.constructor = methodDeclaration;
    }

    public JooSymbol getSymClass() {
        return this.symClass;
    }

    public Extends getOptExtends() {
        return this.optExtends;
    }

    public Implements getOptImplements() {
        return this.optImplements;
    }

    public List<VariableDeclaration> getFieldsWithInitializer() {
        return this.fieldsWithInitializer;
    }

    public ClassBody getBody() {
        return this.body;
    }

    public List<IdeDeclaration> getSecondaryDeclarations() {
        return this.secondaryDeclarations;
    }

    public Map<String, TypedIdeDeclaration> getStaticMembers() {
        return this.staticMembers;
    }

    public Set<String> getClassInit() {
        return this.classInit;
    }

    @Override
    public void scope(Scope scope) {
        this.scope = scope;
        super.scope(scope);
        this.thisType = new Type(new Ide(this.getIde().getSymbol()));
        this.superType = "Object".equals(this.getQualifiedNameStr()) ? null : new Type(this.getOptExtends() == null ? new Ide("Object") : this.getOptExtends().getSuperClass());
        this.thisType.scope(scope);
        if (this.superType != null) {
            this.superType.scope(scope);
        }
        if (this.getOptImplements() != null) {
            this.getOptImplements().scope(scope);
        }
        this.withNewDeclarationScope(this, scope, new NodeImplBase.Scoped(){

            public void run(final Scope staticScope) {
                ClassDeclaration.this.withNewDeclarationScope(ClassDeclaration.this, staticScope, new NodeImplBase.Scoped(){

                    public void run(Scope instanceScope) {
                        if (instanceScope instanceof DeclarationScope) {
                            ((DeclarationScope)instanceScope).setIsInstanceScope(true);
                        }
                        ClassDeclaration.this.body.scope(staticScope, instanceScope);
                    }
                });
                Iterator i$ = ClassDeclaration.this.secondaryDeclarations.iterator();
                while (i$.hasNext()) {
                    IdeDeclaration secondaryDeclaration = (IdeDeclaration)i$.next();
                    secondaryDeclaration.scope(staticScope);
                }
            }
        });
    }

    @Override
    public void handleDuplicateDeclaration(Scope scope, AstNode oldNode) {
        if (!(oldNode instanceof ImportDirective)) {
            super.handleDuplicateDeclaration(scope, oldNode);
        }
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        if (this.getOptExtends() != null) {
            this.getOptExtends().analyze(this);
            String packageName = this.getOptExtends().getSuperClass().getDeclaration().getPackageDeclaration().getQualifiedNameStr();
            if (packageName.length() > 0 && parentNode instanceof CompilationUnit) {
                ((CompilationUnit)parentNode).getAuxVarForPackage(this.scope, packageName);
            }
        }
        if (this.getOptImplements() != null) {
            this.getOptImplements().analyze(this);
        }
        this.body.analyze(this);
        for (IdeDeclaration secondaryDeclaration : this.secondaryDeclarations) {
            secondaryDeclaration.analyze(this);
        }
    }

    public void registerMember(TypedIdeDeclaration memberDeclaration) {
        String name = memberDeclaration.getName();
        if (name.length() != 0) {
            (memberDeclaration.isStatic() ? this.staticMembers : this.members).put(name, memberDeclaration);
        }
    }

    public TypedIdeDeclaration getMemberDeclaration(String memberName) {
        return this.members.get(memberName);
    }

    public TypedIdeDeclaration getStaticMemberDeclaration(String memberName) {
        return this.staticMembers.get(memberName);
    }

    public void addInitIfClassOrGlobalVar(Ide ide) {
        CompilationUnit compilationUnit;
        IdeDeclaration decl = ide.getDeclaration(false);
        if (decl != this && (decl instanceof ClassDeclaration || decl instanceof VariableDeclaration) && decl.isPrimaryDeclaration() && (compilationUnit = decl.getIde().getScope().getCompilationUnit()).getAnnotation("Native") == null) {
            this.classInit.add(decl.getQualifiedNameStr());
        }
    }

    public boolean isSubclassOf(ClassDeclaration classDeclaration) {
        ClassDeclaration superTypeDeclaration = this.getSuperTypeDeclaration();
        return superTypeDeclaration != null && (superTypeDeclaration == classDeclaration || superTypeDeclaration.isSubclassOf(classDeclaration));
    }

    public Type getThisType() {
        return this.thisType;
    }

    public Type getSuperType() {
        return this.superType;
    }

    public void setSecondaryDeclarations(List<IdeDeclaration> secondaryDeclarations) {
        this.secondaryDeclarations = secondaryDeclarations;
    }

    @Override
    public IdeDeclaration resolveDeclaration() {
        return this;
    }

    @Override
    public IdeDeclaration resolvePropertyDeclaration(String ide) {
        return this.resolvePropertyDeclaration1(ide, this, new HashSet<ClassDeclaration>(), new LinkedList<ClassDeclaration>());
    }

    private IdeDeclaration resolvePropertyDeclaration1(String ide, ClassDeclaration classDecl, Set<ClassDeclaration> visited, Deque<ClassDeclaration> chain) {
        if (visited.contains(classDecl)) {
            if (chain.contains(classDecl)) {
                throw new CompilerError(classDecl.getSymbol(), "cyclic superclass chain");
            }
            return null;
        }
        visited.add(classDecl);
        int chainSize = chain.size();
        chain.add(classDecl);
        IdeDeclaration declaration = classDecl.getMemberDeclaration(ide);
        if (declaration == null) {
            declaration = classDecl.getStaticMemberDeclaration(ide);
        }
        if (declaration == null && classDecl.getSuperType() != null) {
            declaration = this.resolvePropertyInSuper(ide, classDecl, visited, chain, classDecl.getSuperType().getIde());
        }
        if (declaration == null && classDecl.getOptImplements() != null) {
            for (CommaSeparatedList<Ide> implemented = classDecl.getOptImplements().getSuperTypes(); implemented != null && declaration == null; implemented = implemented.getTail()) {
                declaration = this.resolvePropertyInSuper(ide, classDecl, visited, chain, implemented.getHead());
            }
        }
        chain.removeLast();
        if (!$assertionsDisabled && chainSize != chain.size()) {
            throw new AssertionError();
        }
        return declaration;
    }

    private IdeDeclaration resolvePropertyInSuper(String ide, ClassDeclaration classDecl, Set<ClassDeclaration> visited, Deque<ClassDeclaration> chain, Ide superIde) {
        IdeDeclaration superClassDecl = superIde.getDeclaration(false);
        if (superClassDecl != null) {
            if (!(superClassDecl instanceof ClassDeclaration)) {
                throw new CompilerError(classDecl.getOptExtends().getSuperClass().getSymbol(), "expected class identifier");
            }
            return this.resolvePropertyDeclaration1(ide, (ClassDeclaration)superClassDecl, visited, chain);
        }
        return null;
    }

    public int getInheritanceLevel() {
        if (this.inheritanceLevel < 0) {
            this.inheritanceLevel = this.computeInheritanceLevel();
        }
        return this.inheritanceLevel;
    }

    private int computeInheritanceLevel() {
        if (this.superType == null) {
            return 0;
        }
        if ("Object".equals(this.superType.getIde().getQualifiedNameStr())) {
            return 1;
        }
        IdeDeclaration superClassDecl = this.superType.getIde().getDeclaration();
        if (!(superClassDecl instanceof ClassDeclaration)) {
            throw new CompilerError(this.getOptExtends().getSuperClass().getSymbol(), "expected class identifier");
        }
        return 1 + ((ClassDeclaration)superClassDecl).getInheritanceLevel();
    }

    public ClassDeclaration getSuperTypeDeclaration() {
        return this.superType == null ? null : (ClassDeclaration)this.superType.getIde().getDeclaration();
    }

    public void addFieldWithInitializer(VariableDeclaration fieldDeclaration) {
        this.fieldsWithInitializer.add(fieldDeclaration);
    }

    static {
        Class<?> clazz = class$net$jangaroo$jooc$ast$ClassDeclaration;
        if (clazz == null) {
            clazz = class$net$jangaroo$jooc$ast$ClassDeclaration = new ClassDeclaration[0].getClass().getComponentType();
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

