/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jangaroo.jooc.CompilerError;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ScopeImplBase;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.FunctionDeclaration;
import net.jangaroo.jooc.ast.FunctionExpr;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.ImportDirective;
import net.jangaroo.jooc.ast.PackageDeclaration;
import net.jangaroo.jooc.ast.QualifiedIde;
import net.jangaroo.jooc.ast.VariableDeclaration;
import net.jangaroo.utils.AS3Type;

public class DeclarationScope
extends ScopeImplBase {
    private AstNode definingNode;
    private Set<String> packages = new HashSet<String>();
    private Map<String, IdeDeclaration> ides = new HashMap<String, IdeDeclaration>();
    private Map<String, List<ImportDirective>> importsByName = new HashMap<String, List<ImportDirective>>();
    private Map<String, ImportDirective> importsByQualifiedName = new HashMap<String, ImportDirective>();
    private boolean isInstanceScope = false;

    @Override
    public boolean isPackage(String fullyQualifiedName) {
        return this.packages.contains(fullyQualifiedName) || super.isPackage(fullyQualifiedName);
    }

    public DeclarationScope(AstNode definingNode, Scope parent) {
        super(parent);
        this.definingNode = definingNode;
    }

    @Override
    public AstNode getDefiningNode() {
        return this.definingNode;
    }

    @Override
    public void addImport(ImportDirective importDirective) {
        Ide ide = importDirective.getIde();
        String name = ide.getName();
        Ide packageIde = ide.getQualifier();
        String packageName = "";
        CompilationUnit compilationUnit = this.getCompilationUnit();
        if (packageIde != null) {
            packageName = packageIde.getQualifiedNameStr();
            this.packages.add(packageName);
        }
        if (AS3Type.ANY.toString().equals(name)) {
            List<String> packageIdes = compilationUnit.getCompiler().getPackageIdes(packageName);
            for (String typeToImport : packageIdes) {
                ImportDirective implicitImport = new ImportDirective(packageIde, typeToImport);
                implicitImport.scope(this);
            }
        } else {
            if (this.importsByName.containsKey(name)) {
                List<ImportDirective> directiveList = this.importsByName.get(name);
                if (this.isImportAlreadyAdded(directiveList, importDirective)) {
                    return;
                }
                directiveList.add(importDirective);
            } else {
                LinkedList<ImportDirective> list = new LinkedList<ImportDirective>();
                list.add(importDirective);
                this.importsByName.put(name, list);
            }
            if (this.ides.containsKey(name)) {
                throw new CompilerError(importDirective.getIde().getSymbol(), "attempt to redefine identifier " + name + " by import");
            }
            String qualifiedName = ide.getQualifiedNameStr();
            this.importsByQualifiedName.put(qualifiedName, importDirective);
        }
    }

    private boolean isImportAlreadyAdded(List<ImportDirective> directiveList, ImportDirective importDirective) {
        String qname = importDirective.getQualifiedName();
        for (ImportDirective directive : directiveList) {
            if (!directive.getQualifiedName().equals(qname)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IdeDeclaration declareIde(IdeDeclaration decl) {
        Ide ide = decl.getIde();
        String name = ide.getName();
        if (this.importsByName.containsKey(name)) {
            throw new CompilerError(ide.getSymbol(), "attempt to redefine an imported identifier " + name);
        }
        return this.ides.put(name, decl);
    }

    @Override
    public IdeDeclaration lookupDeclaration(Ide ide) {
        IdeDeclaration decl = null;
        if (ide instanceof QualifiedIde) {
            String qname = ide.getQualifiedNameStr();
            if (this.importsByQualifiedName.containsKey(qname)) {
                return this.resolveImport(this.importsByQualifiedName.get(qname));
            }
            if (ide.isQualifiedByThis()) {
                return this.getClassDeclaration().resolvePropertyDeclaration(ide.getName());
            }
            if (ide.isQualifiedBySuper()) {
                ClassDeclaration superTypeDeclaration = this.getClassDeclaration().getSuperTypeDeclaration();
                return superTypeDeclaration == null ? null : ((IdeDeclaration)superTypeDeclaration).resolvePropertyDeclaration(ide.getName());
            }
        } else {
            String name = ide.getName();
            List<ImportDirective> importsOfThisIde = this.importsByName.get(name);
            if (importsOfThisIde != null) {
                if (importsOfThisIde.size() > 1) {
                    this.ambigousImport(ide, importsOfThisIde);
                }
                return this.resolveImport(importsOfThisIde.get(0));
            }
            decl = this.ides.get(ide.getName());
            if (decl == null && this.getDefiningNode() != null && this.getClassDeclaration() == this.getDefiningNode() && (decl = this.getClassDeclaration().resolvePropertyDeclaration(ide.getName())) != null && !this.isInstanceScope && !decl.isStatic()) {
                throw Jooc.error(ide, "access to instance property in static context: '" + ide.getName() + "'");
            }
        }
        return decl != null ? decl : super.lookupDeclaration(ide);
    }

    private IdeDeclaration resolveImport(ImportDirective importDirective) {
        return this.getCompilationUnit().getCompiler().resolveImport(importDirective);
    }

    private void ambigousImport(Ide ide, Collection<ImportDirective> importsOfThisIde) {
        boolean isFirst = true;
        StringBuilder msg = new StringBuilder();
        msg.append("Can not resolve a multiname reference unambiguously: ");
        for (ImportDirective importDirective : importsOfThisIde) {
            if (!isFirst) {
                msg.append(" and ");
            }
            isFirst = false;
            msg.append(importDirective.getQualifiedName());
            JooSymbol importedIdeSymbol = this.resolveImport(importDirective).getSymbol();
            msg.append("(").append(importedIdeSymbol.getFileName()).append(":").append(importedIdeSymbol.getLine()).append(",").append(importedIdeSymbol.getColumn());
        }
        msg.append(" are available.");
        throw new CompilerError(ide.getSymbol(), msg.toString());
    }

    @Override
    public boolean isDeclared(Ide ide) {
        return this.ides.containsKey(ide.getQualifiedNameStr()) || super.isDeclared(ide);
    }

    @Override
    public Ide createAuxVar() {
        int i = 1;
        while (true) {
            String auxVarName;
            Ide auxVar;
            if (!this.isDeclared(auxVar = new Ide(new JooSymbol(auxVarName = "$" + i)))) {
                new VariableDeclaration(new JooSymbol("var"), auxVar, null, null).scope(this);
                return auxVar;
            }
            ++i;
        }
    }

    @Override
    public CompilationUnit getCompilationUnit() {
        if (this.definingNode instanceof CompilationUnit) {
            return (CompilationUnit)this.definingNode;
        }
        return super.getCompilationUnit();
    }

    @Override
    public PackageDeclaration getPackageDeclaration() {
        if (this.definingNode instanceof PackageDeclaration) {
            return (PackageDeclaration)this.definingNode;
        }
        return super.getPackageDeclaration();
    }

    @Override
    public ClassDeclaration getClassDeclaration() {
        if (this.definingNode instanceof ClassDeclaration) {
            return (ClassDeclaration)this.definingNode;
        }
        return super.getClassDeclaration();
    }

    @Override
    public FunctionDeclaration getMethodDeclaration() {
        FunctionDeclaration functionDeclaration;
        if (this.definingNode instanceof FunctionDeclaration && (functionDeclaration = (FunctionDeclaration)this.definingNode).isClassMember()) {
            return functionDeclaration;
        }
        return super.getMethodDeclaration();
    }

    @Override
    public FunctionExpr getFunctionExpr() {
        if (this.definingNode instanceof FunctionExpr) {
            return (FunctionExpr)this.definingNode;
        }
        return super.getFunctionExpr();
    }

    public void setIsInstanceScope(boolean b) {
        this.isInstanceScope = true;
    }
}

