/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jangaroo.utils.CompilerUtils;
import net.jangaroo.utils.PathHandler;
import net.jangaroo.utils.SourceFilesHandler;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileLocations {
    private List<File> sourcePath = new ArrayList<File>();
    private List<File> sourceFiles = new ArrayList<File>();
    private List<File> classPath = new ArrayList<File>();
    private File outputDirectory;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$net$jangaroo$utils$FileLocations;

    public File findSourceDir(File file) throws IOException {
        File canonicalFile = file.getCanonicalFile();
        for (File sourceDir : this.getSourcePath()) {
            if (CompilerUtils.qNameFromFile(sourceDir, canonicalFile) == null) continue;
            return sourceDir;
        }
        return null;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Option(name="-d", metaVar="DEST_DIR", usage="destination directory for generated files")
    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public List<File> getSourcePath() {
        return this.sourcePath;
    }

    @Option(name="-sourcepath", handler=PathHandler.class, usage="source root directories, separated by the system dependant path separator character (e.g. ':' on Unix systems, ';' on Windows)")
    public void setSourcePath(List<File> sourcePath) throws IOException {
        ArrayList<File> canonicalizedSourcePath = new ArrayList<File>();
        for (File file : sourcePath) {
            canonicalizedSourcePath.add(file.getCanonicalFile());
        }
        this.sourcePath = Collections.unmodifiableList(canonicalizedSourcePath);
    }

    public List<File> getClassPath() {
        return this.classPath;
    }

    @Option(name="-classpath", handler=PathHandler.class, usage="source root directories or jangaroo jars of dependent classes, separated by the system dependent path separator character (e.g. ':' on Unix systems, ';' on Windows)")
    public void setClassPath(List<File> classPath) {
        if (!$assertionsDisabled && classPath == null) {
            throw new AssertionError();
        }
        this.classPath = Collections.unmodifiableList(classPath);
    }

    public List<File> getSourceFiles() {
        return Collections.unmodifiableList(this.sourceFiles);
    }

    @Argument(metaVar="SOURCE_FILES", usage="source files that should be compiled", handler=SourceFilesHandler.class, multiValued=true)
    public void setSourceFiles(List<File> sourceFiles) {
        if (sourceFiles == null) {
            throw new IllegalArgumentException("sourceFiles == null");
        }
        this.sourceFiles = new ArrayList<File>(sourceFiles);
    }

    public void addSourceFile(File source) {
        this.sourceFiles.add(source);
    }

    public void addSourceFile(String sourcepath) {
        this.addSourceFile(new File(sourcepath));
    }

    public String toString() {
        return new StringBuffer().append("FileLocations{sourcePath=").append(this.sourcePath).append(", sourceFiles=").append(this.sourceFiles).append(", classPath=").append(this.classPath).append(", outputDirectory=").append(this.outputDirectory).append('}').toString();
    }

    static {
        Class<?> clazz = class$net$jangaroo$utils$FileLocations;
        if (clazz == null) {
            clazz = class$net$jangaroo$utils$FileLocations = new FileLocations[0].getClass().getComponentType();
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

