/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.TypedIdeDeclaration;

public class QualifiedIde
extends Ide {
    private Ide qualifier;
    private JooSymbol symDot;

    public QualifiedIde(Ide qualifier, JooSymbol symDot, JooSymbol symIde) {
        super(symIde);
        this.qualifier = qualifier;
        this.symDot = symDot;
        qualifier.setQualified(this);
    }

    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitQualifiedIde(this);
    }

    public Ide getQualifier() {
        return this.qualifier;
    }

    public JooSymbol getSymDot() {
        return this.symDot;
    }

    public String[] getQualifiedName() {
        return QualifiedIde.append(this.qualifier.getQualifiedName(), this.getIde().getText());
    }

    static String[] append(String[] prefixName, String ideText) {
        String[] result = new String[prefixName.length + 1];
        System.arraycopy(prefixName, 0, result, 0, prefixName.length);
        result[prefixName.length] = ideText;
        return result;
    }

    public String getQualifiedNameStr() {
        return QualifiedIde.constructQualifiedNameStr(this.getQualifiedName(), ".");
    }

    public JooSymbol getSymbol() {
        return this.qualifier.getSymbol();
    }

    public static String constructQualifiedNameStr(String[] qualifiedName, String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < qualifiedName.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(qualifiedName[i]);
        }
        return sb.toString();
    }

    public Ide qualify(JooSymbol symQualifier, JooSymbol symDot) {
        return this.qualifier.qualify(symQualifier, symDot);
    }

    public boolean addExternalUsage() {
        return this.qualifier.addExternalUsage() || super.addExternalUsage();
    }

    public void scope(Scope scope) {
        this.qualifier.scope(scope);
        super.scope(scope);
    }

    public void analyze(AstNode parentNode) {
        this.qualifier.analyze(this);
        super.analyze(parentNode);
    }

    public void analyzeAsExpr(AstNode exprParent, Expr parentExpr) {
        TypedIdeDeclaration memberDeclaration;
        this.qualifier.analyzeAsExpr(exprParent, parentExpr);
        super.analyzeAsExpr(exprParent, parentExpr);
        IdeDeclaration qualifierDeclaration = this.qualifier.getDeclaration(false);
        if (qualifierDeclaration != null && qualifierDeclaration instanceof ClassDeclaration && (memberDeclaration = ((ClassDeclaration)qualifierDeclaration).getStaticMemberDeclaration(this.getName())) == null) {
            throw Jooc.error(this.getIde(), "unresolved static member " + this.getIde().getText());
        }
    }

    public IdeDeclaration resolveDeclaration() {
        IdeDeclaration result = super.resolveDeclaration();
        return result == null ? this.resolveQualifiedIdeDeclaration() : result;
    }

    public IdeDeclaration getMemberDeclaration() {
        return this.resolveQualifiedIdeDeclaration();
    }

    private IdeDeclaration resolveQualifiedIdeDeclaration() {
        IdeDeclaration prefixDeclaration = this.getQualifier().resolveDeclaration();
        return prefixDeclaration != null ? prefixDeclaration.resolvePropertyDeclaration(this.getName()) : null;
    }

    public void generateCodeAsExpr(JsWriter out) throws IOException {
        boolean commentOutQualifierCode = false;
        IdeDeclaration memberDeclaration = null;
        IdeDeclaration qualifierDeclaration = this.qualifier.getDeclaration(false);
        if (qualifierDeclaration != null && qualifierDeclaration.isConstructor()) {
            qualifierDeclaration = qualifierDeclaration.getClassDeclaration();
        }
        if (qualifierDeclaration != null && qualifierDeclaration.equals(this.getScope().getClassDeclaration())) {
            memberDeclaration = ((ClassDeclaration)qualifierDeclaration).getStaticMemberDeclaration(this.getName());
            boolean bl = commentOutQualifierCode = memberDeclaration != null && memberDeclaration.isPrivateStatic();
        }
        if (memberDeclaration == null) {
            IdeDeclaration type = this.qualifier.resolveDeclaration();
            memberDeclaration = Ide.resolveMember(type, this);
        }
        if (this.isBound()) {
            this.writeBoundMethodAccess(out, this.qualifier, this.symDot, memberDeclaration);
            return;
        }
        if (commentOutQualifierCode) {
            out.beginComment();
        }
        this.qualifier.generateCodeAsExpr(out);
        if (commentOutQualifierCode) {
            out.endComment();
        }
        QualifiedIde.writeMemberAccess(memberDeclaration, this.symDot, this, true, out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        QualifiedIde that = (QualifiedIde)o;
        return this.qualifier == null ? that.qualifier == null : this.qualifier.equals(that.qualifier);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.qualifier != null ? this.qualifier.hashCode() : 0);
        return result;
    }
}

