/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.QualifiedIde;

public class NamespacedIde
extends Ide {
    private JooSymbol namespace;
    private JooSymbol symNamespaceSep;

    public NamespacedIde(JooSymbol namespace, JooSymbol symNamespaceSep, JooSymbol symIde) {
        super(symIde);
        this.namespace = namespace;
        this.symNamespaceSep = symNamespaceSep;
    }

    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitNamespacedIde(this);
    }

    public void analyze(AstNode parentNode) {
        if (this.namespace.sym == 99) {
            Jooc.warning(this.namespace, "namespaces are not yet implemented, ignoring namespace " + this.namespace.getText());
        }
        super.analyze(parentNode);
    }

    static String getNamespacePrefix(JooSymbol namespace) {
        return "";
    }

    public String getName() {
        return NamespacedIde.getNamespacePrefix(this.namespace) + super.getName();
    }

    public String[] getQualifiedName() {
        return new String[]{this.namespace.getText(), this.getIde().getText()};
    }

    public String getQualifiedNameStr() {
        return QualifiedIde.constructQualifiedNameStr(this.getQualifiedName(), "::");
    }

    public JooSymbol getSymbol() {
        return this.namespace;
    }

    public JooSymbol getNamespace() {
        return this.namespace;
    }

    public JooSymbol getSymNamespaceSep() {
        return this.symNamespaceSep;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamespacedIde that = (NamespacedIde)o;
        return this.namespace.getText().equals(that.namespace.getText());
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.namespace.getText().hashCode();
        return result;
    }
}

