/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.Expr;

public class ConditionalExpr
extends Expr {
    private Expr cond;
    private JooSymbol symQuestion;
    private Expr ifTrue;
    private JooSymbol symColon;
    private Expr ifFalse;

    public ConditionalExpr(Expr cond, JooSymbol symQuestion, Expr ifTrue, JooSymbol symColon, Expr ifFalse) {
        this.cond = cond;
        this.symQuestion = symQuestion;
        this.ifTrue = ifTrue;
        this.symColon = symColon;
        this.ifFalse = ifFalse;
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitConditionalExpr(this);
    }

    @Override
    public void scope(Scope scope) {
        this.getCond().scope(scope);
        this.getIfTrue().scope(scope);
        this.getIfFalse().scope(scope);
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        this.getCond().analyze(this);
        this.getIfTrue().analyze(this);
        this.getIfFalse().analyze(this);
    }

    @Override
    public JooSymbol getSymbol() {
        return this.getCond().getSymbol();
    }

    @Override
    public boolean isCompileTimeConstant() {
        return this.getCond().isCompileTimeConstant() && this.getIfTrue().isCompileTimeConstant() && this.getIfFalse().isCompileTimeConstant();
    }

    public Expr getCond() {
        return this.cond;
    }

    public JooSymbol getSymQuestion() {
        return this.symQuestion;
    }

    public Expr getIfTrue() {
        return this.ifTrue;
    }

    public JooSymbol getSymColon() {
        return this.symColon;
    }

    public Expr getIfFalse() {
        return this.ifFalse;
    }
}

