/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.jangaroo.jooc.CompilationResultImpl;
import net.jangaroo.jooc.CompilerError;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.StdOutCompileLog;
import net.jangaroo.jooc.api.CompilationResult;
import net.jangaroo.jooc.api.CompileLog;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.backend.AbstractCompilationUnitSinkFactory;
import net.jangaroo.jooc.backend.CompilationUnitSink;
import net.jangaroo.jooc.backend.CompilationUnitSinkFactory;
import net.jangaroo.jooc.backend.MergedOutputCompilationUnitSinkFactory;
import net.jangaroo.jooc.backend.SingleFileCompilationUnitSinkFactory;
import net.jangaroo.jooc.cli.CommandLineParseException;
import net.jangaroo.jooc.cli.JoocCommandLineParser;
import net.jangaroo.jooc.config.JoocConfiguration;
import net.jangaroo.jooc.config.ParserOptions;
import net.jangaroo.jooc.input.FileInputSource;
import net.jangaroo.jooc.input.PathInputSource;

public class Jooc
extends JangarooParser
implements net.jangaroo.jooc.api.Jooc {
    public static final String CLASS_LOADER_NAME = "classLoader";
    public static final String CLASS_LOADER_PACKAGE_NAME = "joo";
    public static final String CLASS_LOADER_FULLY_QUALIFIED_NAME = "joo.classLoader";
    private List<CompilationUnit> compileQueue = new ArrayList<CompilationUnit>();

    public Jooc() {
    }

    public Jooc(JoocConfiguration config) {
        this(config, (CompileLog)new StdOutCompileLog());
    }

    public Jooc(JoocConfiguration config, CompileLog log) {
        super(config, log);
    }

    public JoocConfiguration getConfig() {
        return (JoocConfiguration)super.getConfig();
    }

    public void setConfig(JoocConfiguration config) {
        super.setConfig(config);
    }

    public CompilationResult run() {
        try {
            return this.run1();
        }
        catch (CompilerError e) {
            if (e.getSymbol() != null) {
                this.log.error(e.getSymbol(), e.getMessage());
            } else {
                this.log.error(e.getMessage());
            }
            return new CompilationResultImpl(1);
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            return new CompilationResultImpl(2);
        }
    }

    private CompilationResult run1() {
        PathInputSource classPathInputSource;
        PathInputSource sourcePathInputSource;
        try {
            sourcePathInputSource = PathInputSource.fromFiles(this.getConfig().getSourcePath(), new String[]{""});
            classPathInputSource = PathInputSource.fromFiles(this.getConfig().getClassPath(), new String[]{"", "META-INF/joo-api/"});
        }
        catch (IOException e) {
            throw new CompilerError("IO Exception occurred", e);
        }
        this.setUp(sourcePathInputSource, classPathInputSource);
        HashMap<File, File> outputFileMap = new HashMap<File, File>();
        try {
            Iterator<File> i$ = this.getConfig().getSourceFiles().iterator();
            while (i$.hasNext()) {
                File sourceFile = i$.next();
                this.processSource(sourceFile);
            }
            CompilationUnitSinkFactory codeSinkFactory = this.createSinkFactory(this.getConfig(), false);
            CompilationUnitSinkFactory apiSinkFactory = null;
            if (this.getConfig().isGenerateApi()) {
                apiSinkFactory = this.createSinkFactory(this.getConfig(), true);
            }
            Iterator<CompilationUnit> i$2 = this.compileQueue.iterator();
            while (i$2.hasNext()) {
                CompilationUnit unit = i$2.next();
                unit.analyze(null);
                File sourceFile = ((FileInputSource)unit.getSource()).getFile();
                File outputFile = this.writeOutput(sourceFile, unit, codeSinkFactory, this.getConfig().isVerbose());
                outputFileMap.put(sourceFile, outputFile);
                if (!this.getConfig().isGenerateApi()) continue;
                this.writeOutput(sourceFile, unit, apiSinkFactory, this.getConfig().isVerbose());
            }
            int result = this.log.hasErrors() ? 1 : 0;
            CompilationResultImpl compilationResultImpl = new CompilationResultImpl(result, outputFileMap);
            return compilationResultImpl;
        }
        catch (IOException e) {
            throw new CompilerError("IO Exception occurred", e);
        }
        finally {
            this.tearDown();
        }
    }

    public File writeOutput(File sourceFile, CompilationUnit compilationUnit, CompilationUnitSinkFactory writerFactory, boolean verbose) throws CompilerError {
        CompilationUnitSink sink = writerFactory.createSink(compilationUnit.getPackageDeclaration(), compilationUnit.getPrimaryDeclaration(), sourceFile, verbose);
        return sink.writeOutput(compilationUnit);
    }

    private CompilationUnitSinkFactory createSinkFactory(JoocConfiguration config, boolean generateActionScriptApi) {
        AbstractCompilationUnitSinkFactory codeSinkFactory;
        if (!generateActionScriptApi && config.isMergeOutput()) {
            codeSinkFactory = new MergedOutputCompilationUnitSinkFactory(config, config.getOutputFile());
        } else {
            File outputDirectory = generateActionScriptApi ? config.getApiOutputDirectory() : config.getOutputDirectory();
            String suffix = generateActionScriptApi ? ".as" : ".js";
            codeSinkFactory = new SingleFileCompilationUnitSinkFactory(config, outputDirectory, generateActionScriptApi, suffix);
        }
        return codeSinkFactory;
    }

    public static String getResultCodeDescription(int resultCode) {
        switch (resultCode) {
            case 0: {
                return "ok";
            }
            case 1: {
                return "compilation failed";
            }
            case 2: {
                return "internal compiler error";
            }
            case 3: {
                return "unrecognized option";
            }
            case 4: {
                return "missing option argument";
            }
            case 5: {
                return "illegal option value";
            }
        }
        return "unknown result code";
    }

    protected void processSource(File file) throws IOException {
        if (file.isDirectory()) {
            throw Jooc.error("Input file is a directory.", file);
        }
        CompilationUnit unit = this.importSource(new FileInputSource(this.getConfig().findSourceDir(file), file));
        if (unit != null) {
            this.compileQueue.add(unit);
        }
    }

    public static int run(String[] argv, CompileLog log) {
        try {
            JoocCommandLineParser commandLineParser = new JoocCommandLineParser();
            JoocConfiguration config = commandLineParser.parse(argv);
            if (config != null) {
                return new Jooc(config, log).run().getResultCode();
            }
        }
        catch (CommandLineParseException e) {
            System.out.println(e.getMessage());
            return e.getExitCode();
        }
        return 0;
    }

    public static void main(String[] argv) {
        int result = Jooc.run(argv, new StdOutCompileLog());
        if (result != 0) {
            System.exit(result);
        }
    }

    public /* synthetic */ ParserOptions getConfig() {
        return this.getConfig();
    }
}

