/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathHandler
extends OptionHandler<List<File>> {
    public PathHandler(CmdLineParser parser2, OptionDef option, Setter<? super List<File>> setter) {
        super(parser2, option, setter);
    }

    @Override
    public int parseArguments(Parameters parameters) throws CmdLineException {
        ArrayList<File> sourcePathFiles = null;
        String sourcePathString = parameters.getParameter(0).trim();
        if (!sourcePathString.isEmpty()) {
            String[] sourceDirs = sourcePathString.split(new StringBuffer().append("\\Q").append(File.pathSeparatorChar).append("\\E").toString());
            sourcePathFiles = new ArrayList(sourceDirs.length);
            for (String sourceDirPath : sourceDirs) {
                File sourceDir = new File(sourceDirPath.replace('/', File.separatorChar));
                if (!sourceDir.exists()) {
                    throw new CmdLineException(this.owner, new StringBuffer().append("directory or file does not exist: ").append(sourceDir.getAbsolutePath()).toString());
                }
                sourcePathFiles.add(sourceDir);
            }
        }
        if (sourcePathFiles == null) {
            sourcePathFiles = new ArrayList<File>();
        }
        this.setter.addValue(sourcePathFiles);
        return 1;
    }

    @Override
    public String getDefaultMetaVariable() {
        return "PATH";
    }
}

