/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class LineRangeReader
extends Reader {
    private BufferedReader delegate;
    private int currentLine;
    private int endLine;

    public LineRangeReader(Reader delegate, int startLine, int endLine) throws IOException {
        this.delegate = new BufferedReader(delegate);
        for (int i = 1; i < startLine; ++i) {
            this.delegate.readLine();
        }
        this.endLine = endLine;
        this.currentLine = startLine;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.currentLine >= this.endLine) {
            return -1;
        }
        int read = this.delegate.read(cbuf, off, len);
        for (int i = 0; i < cbuf.length; ++i) {
            char c = cbuf[i];
            if (c != '\n' && c != '\r') continue;
            ++this.currentLine;
            if (c == '\r' && i + 1 < cbuf.length && cbuf[i + 1] == '\n') {
                ++i;
            }
            if (this.currentLine < this.endLine) continue;
            return i;
        }
        return read;
    }

    public void close() throws IOException {
        this.delegate.close();
    }
}

