/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.input;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.jangaroo.jooc.input.DirectoryInputSource;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.jooc.input.ZipEntryInputSource;

public class ZipFileInputSource
extends DirectoryInputSource {
    private File file;
    private ZipFile zipFile;
    private String[] rootDirs;
    private Map<String, ZipEntryInputSource> entries = new LinkedHashMap<String, ZipEntryInputSource>();

    public ZipFileInputSource(File file, String[] rootDirs) throws IOException {
        this.file = file;
        this.zipFile = new ZipFile(file);
        this.rootDirs = (String[])rootDirs.clone();
        Enumeration<? extends ZipEntry> zipEntryEnum = this.zipFile.entries();
        while (zipEntryEnum.hasMoreElements()) {
            ZipEntry entry = zipEntryEnum.nextElement();
            String relativePath = this.getRelativePath(entry.getName());
            if (relativePath == null || this.entries.containsKey(relativePath)) continue;
            this.entries.put(relativePath, new ZipEntryInputSource(this, entry, relativePath));
        }
    }

    private String getRelativePath(String name) {
        String foundRoot = null;
        for (String rootDir : this.rootDirs) {
            if (!name.startsWith(rootDir) || foundRoot != null && foundRoot.length() >= rootDir.length()) continue;
            foundRoot = rootDir;
        }
        if (foundRoot == null) {
            return null;
        }
        String strippedName = name.substring(foundRoot.length());
        return strippedName.endsWith("/") ? strippedName.substring(0, strippedName.length() - 1) : strippedName;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getPath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public String getRelativePath() {
        return "";
    }

    public List<InputSource> list() {
        return this.list("");
    }

    @Override
    public void close() throws IOException {
        this.zipFile.close();
    }

    @Override
    public char getFileSeparatorChar() {
        return '/';
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    @Override
    public InputSource getChild(String path) {
        return this.entries.get(path);
    }

    List<InputSource> list(ZipEntryInputSource dir) {
        if (!dir.isDirectory()) {
            throw new UnsupportedOperationException("list() is not supported for non-directory input sources");
        }
        return this.list(dir.getRelativePath());
    }

    private List<InputSource> list(String relativePath) {
        ArrayList<InputSource> result = new ArrayList<InputSource>();
        block0: for (Map.Entry<String, ZipEntryInputSource> entry : this.entries.entrySet()) {
            String p2 = entry.getValue().getRelativePath();
            for (String root : this.rootDirs) {
                String p = root + relativePath;
                if (!p2.startsWith(p) || p2.length() <= p.length() || p2.lastIndexOf(47) != (p.isEmpty() ? -1 : p.length())) continue;
                result.add(entry.getValue());
                continue block0;
            }
        }
        return result;
    }
}

