/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.List;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.CommaSeparatedList;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.ObjectField;

public class ObjectLiteral
extends Expr {
    private JooSymbol lBrace;
    private CommaSeparatedList<ObjectField> fields;
    private JooSymbol optComma;
    private JooSymbol rBrace;

    public ObjectLiteral(JooSymbol lBrace, CommaSeparatedList<ObjectField> fields, JooSymbol optComma, JooSymbol rBrace) {
        this.lBrace = lBrace;
        this.fields = fields;
        this.optComma = optComma;
        this.rBrace = rBrace;
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(super.getChildren(), this.fields);
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitObjectLiteral(this);
    }

    @Override
    public void scope(Scope scope) {
        if (this.getFields() != null) {
            this.getFields().scope(scope);
        }
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        if (this.getFields() != null) {
            this.getFields().analyze(this);
        }
    }

    @Override
    public JooSymbol getSymbol() {
        return this.getLBrace();
    }

    public JooSymbol getLBrace() {
        return this.lBrace;
    }

    public CommaSeparatedList<ObjectField> getFields() {
        return this.fields;
    }

    public JooSymbol getOptComma() {
        return this.optComma;
    }

    public JooSymbol getRBrace() {
        return this.rBrace;
    }
}

