/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.jangaroo.jooc.model.MemberModel;
import net.jangaroo.jooc.model.MethodType;
import net.jangaroo.jooc.model.ModelVisitor;
import net.jangaroo.jooc.model.ParamModel;
import net.jangaroo.jooc.model.ReturnModel;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodModel
extends MemberModel {
    public static final List<ParamModel> NO_PARAMS = Collections.EMPTY_LIST;
    private ReturnModel returnModel;
    private List<ParamModel> params;
    private boolean isFinal = false;
    private boolean override = false;
    private MethodType methodType = null;
    private String body = null;
    private boolean hasOptional = false;

    public MethodModel() {
        this(null, null, NO_PARAMS);
    }

    public MethodModel(String name, String returnType) {
        this(name, returnType, NO_PARAMS);
    }

    public MethodModel(MethodType methodType, String name, String type) {
        this(methodType, name, methodType == MethodType.SET ? "void" : type, methodType == MethodType.SET ? Arrays.asList(new ParamModel("value", type, null, "@private")) : NO_PARAMS, null);
    }

    public MethodModel(String name, String returnType, ParamModel[] params) {
        this(null, name, returnType, Arrays.asList(params), null);
    }

    public MethodModel(String name, String returnType, List<ParamModel> params) {
        this(null, name, returnType, params, null);
    }

    private MethodModel(MethodType methodType, String name, String returnType, List<ParamModel> params, String asdoc) {
        super(name, returnType);
        this.methodType = methodType;
        this.setParams(params);
        this.setAsdoc(asdoc);
    }

    @Override
    public boolean isMethod() {
        return true;
    }

    @Override
    public boolean isAccessor() {
        return this.methodType != null;
    }

    @Override
    public boolean isGetter() {
        return this.methodType == MethodType.GET;
    }

    @Override
    public boolean isSetter() {
        return this.methodType == MethodType.SET;
    }

    public boolean isOverride() {
        return this.override;
    }

    public void setOverride(boolean override) {
        this.override = override;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean aFinal) {
        this.isFinal = aFinal;
    }

    public MethodType getMethodType() {
        return this.methodType;
    }

    public void setMethodType(MethodType methodType) {
        this.methodType = methodType;
    }

    public List<ParamModel> getParams() {
        return Collections.unmodifiableList(this.params);
    }

    public void setParams(List<ParamModel> params) {
        this.params = new ArrayList<ParamModel>();
        this.hasOptional = false;
        for (ParamModel param : params) {
            this.addParam(param);
        }
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void addParam(ParamModel paramModel) {
        if (paramModel.isOptional()) {
            this.hasOptional = true;
        } else if (this.hasOptional) {
            paramModel.setOptional(true);
        }
        this.params.add(paramModel);
    }

    public ReturnModel getReturnModel() {
        if (this.returnModel == null) {
            this.returnModel = new ReturnModel(this);
        }
        return this.returnModel;
    }

    @Override
    public void visit(ModelVisitor visitor) {
        visitor.visitMethod(this);
    }

    public MethodModel duplicate() {
        return new MethodModel(this.methodType, this.getName(), this.getType(), this.params, this.getAsdoc());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MethodModel that = (MethodModel)o;
        return this.methodType == that.methodType && ((Object)this.params).equals(that.params) && (this.returnModel == null ? that.returnModel == null : this.returnModel.equals(that.returnModel));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + ((Object)this.params).hashCode();
        result = 31 * result + (this.methodType != null ? this.methodType.hashCode() : 0);
        return result;
    }
}

