/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.util.List;
import java.util.regex.Pattern;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.Declaration;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.PackageDeclaration;
import net.jangaroo.jooc.ast.QualifiedIde;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IdeDeclaration
extends Declaration {
    private static final Pattern PRIVATE_MEMBER_NAME = Pattern.compile("[^$]\\$[0-9]+$");
    private Ide ide;

    protected IdeDeclaration(JooSymbol[] modifiers, Ide ide) {
        super(modifiers);
        this.setIde(ide);
        if (ide != null && PRIVATE_MEMBER_NAME.matcher(ide.getName()).matches()) {
            Jooc.warning(ide.getSymbol(), "Jangaroo identifier must not be an ActionScript identifier postfixed with a dollar sign ('$') followed by a number.");
        }
    }

    protected IdeDeclaration(Ide ide) {
        this(new JooSymbol[0], ide);
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(new Object[]{super.getChildren(), this.ide});
    }

    public Ide getIde() {
        return this.ide;
    }

    @Override
    public JooSymbol getSymbol() {
        return this.getIde().getSymbol();
    }

    public String getName() {
        return this.getIde() == null ? "" : this.getIde().getName();
    }

    public String[] getQualifiedName() {
        AstNode parentDeclaration = this.getParentDeclaration();
        if (!(parentDeclaration instanceof IdeDeclaration)) {
            return this.getIde() == null ? new String[]{} : this.getIde().getQualifiedName();
        }
        String[] prefixName = ((IdeDeclaration)parentDeclaration).getQualifiedName();
        String[] result = new String[prefixName.length + 1];
        System.arraycopy(prefixName, 0, result, 0, prefixName.length);
        result[prefixName.length] = this.getIde().getName();
        return result;
    }

    public String getQualifiedNameStr() {
        return QualifiedIde.constructQualifiedNameStr(this.getQualifiedName(), ".");
    }

    @Override
    public void scope(Scope scope) {
        super.scope(scope);
        if (this.getIde() != null) {
            this.getIde().scope(scope);
            IdeDeclaration oldNode = scope.declareIde(this);
            if (oldNode != null) {
                this.handleDuplicateDeclaration(scope, oldNode);
            }
        }
    }

    public void handleDuplicateDeclaration(Scope scope, AstNode oldNode) {
        String msg = new StringBuffer().append("Duplicate declaration of identifier '").append(this.getName()).append("'").toString();
        if (!this.allowDuplicates(scope)) {
            throw Jooc.error(this.getSymbol(), msg);
        }
        Jooc.warning(this.getSymbol(), msg);
    }

    boolean allowDuplicates(Scope scope) {
        return false;
    }

    public boolean isMethod() {
        return false;
    }

    public boolean isConstructor() {
        return false;
    }

    public IdeDeclaration resolveDeclaration() {
        return null;
    }

    public IdeDeclaration resolvePropertyDeclaration(String ide) {
        return null;
    }

    public String toString() {
        return this.getQualifiedNameStr();
    }

    public boolean isPrimaryDeclaration() {
        return this.getIde() != null && this.getIde().getScope() != null && this.getIde().getScope().getCompilationUnit() != null && this == this.getIde().getScope().getCompilationUnit().getPrimaryDeclaration();
    }

    public boolean isDeclaringCompileTimeConstant() {
        return false;
    }

    public void setIde(Ide ide) {
        this.ide = ide;
    }

    public PackageDeclaration getPackageDeclaration() {
        AstNode parentDeclaration = this.getParentDeclaration();
        return parentDeclaration instanceof IdeDeclaration ? ((IdeDeclaration)parentDeclaration).getPackageDeclaration() : null;
    }
}

