/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.input;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.jangaroo.jooc.input.DirectoryInputSource;
import net.jangaroo.jooc.input.InputSource;
import net.jangaroo.utils.BOMStripperInputStream;
import net.jangaroo.utils.CompilerUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileInputSource
extends DirectoryInputSource {
    private File sourceDir;
    private File file;
    private List<InputSource> children;

    public FileInputSource(File sourceDir, File file) {
        this.sourceDir = sourceDir;
        this.file = file;
    }

    public FileInputSource(File file) {
        this(file, file);
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getPath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.isDirectory() ? super.getInputStream() : new BOMStripperInputStream(new FileInputStream(this.file));
    }

    @Override
    public String getRelativePath() {
        try {
            return this.sourceDir == null ? this.file.getCanonicalPath() : (this.sourceDir.equals(this.file) ? "" : this.file.getCanonicalPath().substring(this.sourceDir.getCanonicalPath().length() + 1));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void close() {
    }

    public File getFile() {
        return this.file;
    }

    public File getSourceDir() {
        return this.sourceDir;
    }

    @Override
    public char getFileSeparatorChar() {
        return File.separatorChar;
    }

    @Override
    public InputSource getParent() {
        return new FileInputSource(this.sourceDir, this.file.getParentFile());
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public List<InputSource> list() {
        if (!this.isDirectory()) {
            throw new UnsupportedOperationException("list() not supported for non-directory input sources");
        }
        if (this.children == null) {
            File[] childFiles;
            this.children = new ArrayList<InputSource>();
            for (File childFile : childFiles = this.file.listFiles()) {
                this.children.add(new FileInputSource(this.sourceDir, childFile));
            }
        }
        return this.children;
    }

    @Override
    public FileInputSource getChild(String path) {
        if (path.length() == 0) {
            return this;
        }
        File sourceFile = new File(this.file, path);
        if (sourceFile.exists()) {
            String realPath;
            String string = realPath = this.file == null ? sourceFile.getPath() : CompilerUtils.getRelativePath(this.file, sourceFile, false);
            if (File.separatorChar != '/') {
                path = path.replace(File.separatorChar, '/');
                realPath = realPath.replace(File.separatorChar, '/');
            }
            if (path.equals(realPath)) {
                return new FileInputSource(this.sourceDir, sourceFile);
            }
        }
        return null;
    }

    @Override
    public /* synthetic */ InputSource getChild(String x0) {
        return this.getChild(x0);
    }
}

