/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.List;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.IdeExpr;
import net.jangaroo.jooc.ast.Initializer;
import net.jangaroo.jooc.ast.TypeRelation;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameter
extends IdeDeclaration {
    private JooSymbol optSymConstOrRest;
    private TypeRelation optTypeRelation;
    private Initializer optInitializer;

    public Parameter(JooSymbol optSymConst, Ide ide, TypeRelation optTypeRelation, Initializer optInitializer) {
        super(ide);
        this.optSymConstOrRest = optSymConst;
        this.optTypeRelation = optTypeRelation;
        this.optInitializer = optInitializer;
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(new Object[]{super.getChildren(), this.optTypeRelation, this.optInitializer});
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitParameter(this);
    }

    @Override
    public void scope(Scope scope) {
        super.scope(scope);
        if (this.getOptTypeRelation() != null) {
            this.getOptTypeRelation().scope(scope);
        }
        if (this.getOptInitializer() != null) {
            this.getOptInitializer().scope(scope);
        }
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        if (this.getOptTypeRelation() != null) {
            this.getOptTypeRelation().analyze(this);
            if (this.isRest() && !"Array".equals(this.getOptTypeRelation().getType().getSymbol().getText())) {
                throw Jooc.error(this.getOptTypeRelation().getSymbol(), "Rest parameter must have Array type.");
            }
        }
        if (this.getOptInitializer() != null) {
            this.getOptInitializer().analyze(this);
            if (!this.getOptInitializer().getValue().isCompileTimeConstant()) {
                throw Jooc.error(this.getOptInitializer().getSymbol(), "Parameter initializer must be compile-time constant.");
            }
        }
    }

    public boolean isRest() {
        return this.getOptSymConstOrRest() != null && this.getOptSymConstOrRest().sym == 42;
    }

    public boolean hasInitializer() {
        return this.getOptInitializer() != null && (!(this.getOptInitializer().getValue() instanceof IdeExpr) || !((IdeExpr)this.getOptInitializer().getValue()).getIde().getName().equals("undefined"));
    }

    @Override
    public IdeDeclaration resolveDeclaration() {
        return this.getOptTypeRelation() == null ? null : this.getOptTypeRelation().getType().resolveDeclaration();
    }

    public JooSymbol getOptSymConstOrRest() {
        return this.optSymConstOrRest;
    }

    public TypeRelation getOptTypeRelation() {
        return this.optTypeRelation;
    }

    public Initializer getOptInitializer() {
        return this.optInitializer;
    }
}

