/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.backend;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.ast.CompilationUnit;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.PackageDeclaration;
import net.jangaroo.jooc.backend.AbstractCompilationUnitSinkFactory;
import net.jangaroo.jooc.backend.CompilationUnitSink;
import net.jangaroo.jooc.backend.JsCodeGenerator;
import net.jangaroo.jooc.config.JoocOptions;

public class MergedOutputCompilationUnitSinkFactory
extends AbstractCompilationUnitSinkFactory {
    private File outputFile;
    private CompilationUnitSink sink;

    public MergedOutputCompilationUnitSinkFactory(JoocOptions options, final File outputFile) {
        super(options, outputFile.getAbsoluteFile().getParentFile());
        this.outputFile = outputFile;
        this.createOutputDirs(outputFile);
        if (outputFile.exists() && !outputFile.delete()) {
            throw Jooc.error("error deleting file: '" + outputFile.getAbsolutePath() + "'", outputFile);
        }
        this.sink = new CompilationUnitSink(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public File writeOutput(CompilationUnit compilationUnit) {
                try {
                    JsWriter out = new JsWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile, true), "UTF-8"));
                    try {
                        try {
                            out.setOptions(MergedOutputCompilationUnitSinkFactory.this.getOptions());
                            compilationUnit.visit(new JsCodeGenerator(out));
                        }
                        finally {
                            out.close();
                        }
                    }
                    catch (IOException e) {
                        outputFile.delete();
                        throw Jooc.error("error writing file: '" + outputFile.getAbsolutePath() + "'", outputFile, e);
                    }
                }
                catch (IOException e) {
                    throw Jooc.error("cannot open output file for writing: '" + outputFile.getAbsolutePath() + "'", outputFile, e);
                }
                return outputFile;
            }
        };
    }

    public CompilationUnitSink createSink(PackageDeclaration packageDeclaration, IdeDeclaration primaryDeclaration, File sourceFile, boolean verbose) {
        if (verbose) {
            System.out.println("writing " + primaryDeclaration.getName() + " to file: '" + this.outputFile.getAbsolutePath() + "'");
        }
        return this.sink;
    }
}

