/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.List;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.TypedIdeDeclaration;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QualifiedIde
extends Ide {
    private Ide qualifier;
    private JooSymbol symDot;

    public QualifiedIde(Ide qualifier, JooSymbol symDot, JooSymbol symIde) {
        super(symIde);
        this.qualifier = qualifier;
        this.symDot = symDot;
        qualifier.setQualified(this);
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(new Object[]{super.getChildren(), this.qualifier});
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitQualifiedIde(this);
    }

    @Override
    public Ide getQualifier() {
        return this.qualifier;
    }

    public JooSymbol getSymDot() {
        return this.symDot;
    }

    @Override
    public String[] getQualifiedName() {
        return QualifiedIde.append(this.qualifier.getQualifiedName(), this.getIde().getText());
    }

    static String[] append(String[] prefixName, String ideText) {
        String[] result = new String[prefixName.length + 1];
        System.arraycopy(prefixName, 0, result, 0, prefixName.length);
        result[prefixName.length] = ideText;
        return result;
    }

    @Override
    public String getQualifiedNameStr() {
        return QualifiedIde.constructQualifiedNameStr(this.getQualifiedName(), ".");
    }

    @Override
    public JooSymbol getSymbol() {
        return this.qualifier.getSymbol();
    }

    public static String constructQualifiedNameStr(String[] qualifiedName, String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < qualifiedName.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(qualifiedName[i]);
        }
        return sb.toString();
    }

    @Override
    public Ide qualify(JooSymbol symQualifier, JooSymbol symDot) {
        return this.qualifier.qualify(symQualifier, symDot);
    }

    @Override
    public boolean addExternalUsage() {
        return this.qualifier.addExternalUsage() || super.addExternalUsage();
    }

    @Override
    public void scope(Scope scope) {
        this.qualifier.scope(scope);
        super.scope(scope);
    }

    @Override
    public void analyze(AstNode parentNode) {
        this.qualifier.analyze(this);
        super.analyze(parentNode);
    }

    @Override
    public void analyzeAsExpr(AstNode exprParent, Expr parentExpr) {
        TypedIdeDeclaration memberDeclaration;
        this.qualifier.analyzeAsExpr(exprParent, parentExpr);
        super.analyzeAsExpr(exprParent, parentExpr);
        IdeDeclaration qualifierDeclaration = this.qualifier.getDeclaration(false);
        if (qualifierDeclaration != null && qualifierDeclaration instanceof ClassDeclaration && (memberDeclaration = ((ClassDeclaration)qualifierDeclaration).getStaticMemberDeclaration(this.getName())) == null) {
            throw Jooc.error(this.getIde(), new StringBuffer().append("unresolved static member ").append(this.getIde().getText()).toString());
        }
    }

    @Override
    public IdeDeclaration resolveDeclaration() {
        IdeDeclaration result = super.resolveDeclaration();
        return result == null ? this.resolveQualifiedIdeDeclaration() : result;
    }

    @Override
    public IdeDeclaration getMemberDeclaration() {
        return this.resolveQualifiedIdeDeclaration();
    }

    private IdeDeclaration resolveQualifiedIdeDeclaration() {
        IdeDeclaration prefixDeclaration = this.getQualifier().resolveDeclaration();
        return prefixDeclaration != null ? prefixDeclaration.resolvePropertyDeclaration(this.getName()) : null;
    }

    @Override
    public void generateCodeAsExpr(JsWriter out) throws IOException {
        boolean commentOutQualifierCode = false;
        IdeDeclaration memberDeclaration = null;
        IdeDeclaration qualifierDeclaration = this.qualifier.getDeclaration(false);
        if (qualifierDeclaration != null && qualifierDeclaration.isConstructor()) {
            qualifierDeclaration = qualifierDeclaration.getClassDeclaration();
        }
        if (qualifierDeclaration != null && qualifierDeclaration.equals(this.getScope().getClassDeclaration())) {
            memberDeclaration = ((ClassDeclaration)qualifierDeclaration).getStaticMemberDeclaration(this.getName());
            boolean bl = commentOutQualifierCode = memberDeclaration != null && memberDeclaration.isPrivateStatic();
        }
        if (memberDeclaration == null) {
            IdeDeclaration type = this.qualifier.resolveDeclaration();
            memberDeclaration = Ide.resolveMember(type, this);
        }
        if (this.isBound()) {
            this.writeBoundMethodAccess(out, this.qualifier, this.symDot, memberDeclaration);
            return;
        }
        if (commentOutQualifierCode) {
            out.beginComment();
        }
        this.qualifier.generateCodeAsExpr(out);
        if (commentOutQualifierCode) {
            out.endComment();
        }
        QualifiedIde.writeMemberAccess(memberDeclaration, this.symDot, this, true, out);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        QualifiedIde that = (QualifiedIde)o;
        return this.qualifier == null ? that.qualifier == null : this.qualifier.equals(that.qualifier);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.qualifier != null ? this.qualifier.hashCode() : 0);
        return result;
    }
}

