/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.jangaroo.jooc.DeclarationScope;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.LabelScope;
import net.jangaroo.jooc.ast.Statement;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeImplBase
implements AstNode {
    @Override
    public void generate(JsWriter out, boolean first) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return Collections.EMPTY_LIST;
    }

    public List<AstNode> makeChildren(Object[] objects) {
        ArrayList<AstNode> result = new ArrayList<AstNode>();
        for (Object object : objects) {
            if (object instanceof AstNode) {
                result.add((AstNode)object);
                continue;
            }
            if (!(object instanceof Collection)) continue;
            Collection subobjects = (Collection)object;
            for (Object subobject : subobjects) {
                if (!(subobject instanceof AstNode)) continue;
                result.add((AstNode)subobject);
            }
        }
        return result;
    }

    @Override
    public void analyze(AstNode parentNode) {
    }

    public <N extends AstNode> void scope(List<N> nodes, Scope scope) {
        for (AstNode node : nodes) {
            node.scope(scope);
        }
    }

    public <N extends AstNode> void analyze(AstNode parent, List<N> nodes) {
        for (AstNode node : nodes) {
            node.analyze(parent);
        }
    }

    public void withNewDeclarationScope(AstNode definingNode, Scope scope, Scoped scoped) {
        scoped.run(new DeclarationScope(definingNode, scope));
    }

    public void withNewLabelScope(Statement statement, Scope scope, Scoped scoped) {
        scoped.run(new LabelScope(statement, scope));
    }

    public static interface Scoped {
        public void run(Scope var1);
    }
}

