/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import java.util.List;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.ConditionalLoopStatement;
import net.jangaroo.jooc.ast.Expr;
import net.jangaroo.jooc.ast.ForInitializer;
import net.jangaroo.jooc.ast.Statement;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForStatement
extends ConditionalLoopStatement {
    private JooSymbol lParen;
    private ForInitializer forInit;
    private JooSymbol symSemicolon1;
    private JooSymbol symSemicolon2;
    private Expr optStep;
    private JooSymbol rParen;

    public ForStatement(JooSymbol symFor, JooSymbol lParen, ForInitializer forInit, JooSymbol symSemicolon1, Expr optCond, JooSymbol symSemicolon2, Expr optStep, JooSymbol rParen, Statement body) {
        super(symFor, optCond, body);
        this.lParen = lParen;
        this.forInit = forInit;
        this.symSemicolon1 = symSemicolon1;
        this.symSemicolon2 = symSemicolon2;
        this.optStep = optStep;
        this.rParen = rParen;
    }

    @Override
    public List<? extends AstNode> getChildren() {
        return this.makeChildren(new Object[]{super.getChildren(), this.forInit, this.optStep});
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitForStatement(this);
    }

    @Override
    public void scope(Scope scope) {
        if (this.getForInit() != null) {
            this.getForInit().scope(scope);
        }
        super.scope(scope);
        if (this.getOptStep() != null) {
            this.getOptStep().scope(scope);
        }
    }

    @Override
    protected void analyzeLoopHeader() {
        this.checkNonVirtualSemicolon(this.getSymSemicolon1());
        this.checkNonVirtualSemicolon(this.getSymSemicolon2());
        if (this.getForInit() != null) {
            this.getForInit().analyze(this);
        }
        super.analyzeLoopHeader();
        if (this.getOptStep() != null) {
            this.getOptStep().analyze(this);
        }
    }

    private void checkNonVirtualSemicolon(JooSymbol semi) {
        if (semi.isVirtual()) {
            throw Jooc.error(semi, "missing ';'(automatic semicolon insertion would become one of the two semicolons in the header of a for statement)");
        }
    }

    public JooSymbol getLParen() {
        return this.lParen;
    }

    public ForInitializer getForInit() {
        return this.forInit;
    }

    public JooSymbol getSymSemicolon1() {
        return this.symSemicolon1;
    }

    public JooSymbol getSymSemicolon2() {
        return this.symSemicolon2;
    }

    public Expr getOptStep() {
        return this.optStep;
    }

    public JooSymbol getRParen() {
        return this.rParen;
    }
}

