/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.utils;

import java.io.File;
import java.io.IOException;
import java.util.Locale;

public final class CompilerUtils {
    private CompilerUtils() {
    }

    public static String qName(String packageName, String className) {
        return packageName.length() == 0 ? className : packageName + "." + className;
    }

    public static String packageName(String qName) {
        int lastDotPos = qName.lastIndexOf(46);
        return lastDotPos == -1 ? "" : qName.substring(0, lastDotPos);
    }

    public static String uncapitalize(String name) {
        int capitalCount;
        if (name == null) {
            return name;
        }
        for (capitalCount = 0; capitalCount < name.length() && Character.isUpperCase(name.charAt(capitalCount)); ++capitalCount) {
        }
        int toLowerCount = capitalCount <= 1 || capitalCount == name.length() ? capitalCount : capitalCount - 1;
        return new StringBuffer(name.length()).append(name.substring(0, toLowerCount).toLowerCase(Locale.ROOT)).append(name.substring(toLowerCount)).toString();
    }

    public static String className(String qName) {
        int lastDotPos = qName.lastIndexOf(46);
        return lastDotPos == -1 ? qName : qName.substring(lastDotPos + 1);
    }

    public static File fileFromQName(String packageName, String className, File baseDirectory, String extension) {
        return CompilerUtils.fileFromQName(CompilerUtils.qName(packageName, className), baseDirectory, extension);
    }

    public static File fileFromQName(String qName, File baseDirectory, String extension) {
        char separatorChar = File.separatorChar;
        return new File(baseDirectory, CompilerUtils.fileNameFromQName(qName, separatorChar, extension));
    }

    public static String fileNameFromQName(String qName, char separatorChar, String extension) {
        return qName.replace('.', separatorChar) + extension;
    }

    public static String qNameFromFile(File baseDirectory, File file) {
        int lastDotPos;
        String relativePath = CompilerUtils.getRelativePath(baseDirectory, file);
        if (relativePath != null && (lastDotPos = relativePath.lastIndexOf(46)) != -1 && lastDotPos > relativePath.lastIndexOf(File.separatorChar)) {
            return relativePath.substring(0, lastDotPos).replace(File.separatorChar, '.');
        }
        return null;
    }

    public static String getRelativePath(File baseDirectory, File file) {
        String relativePath = null;
        try {
            String canonicalBasePath = baseDirectory.getCanonicalPath() + File.separator;
            String canonicalPath = file.getCanonicalPath();
            if (canonicalPath.length() > canonicalBasePath.length() && canonicalPath.startsWith(canonicalBasePath)) {
                relativePath = canonicalPath.substring(canonicalBasePath.length());
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("could not determine qualified name from file; the strange file is called " + file + " in " + baseDirectory, e);
        }
        return relativePath;
    }

    public static String dirname(String filename) {
        int i = filename.lastIndexOf(File.separator);
        return i >= 0 ? filename.substring(0, i) : "";
    }

    public static String removeExtension(String filename) {
        String ext = CompilerUtils.extension(filename);
        if ("".equals(ext)) {
            return filename;
        }
        int index = filename.lastIndexOf(ext) - 1;
        return filename.substring(0, index);
    }

    public static String extension(String filename) {
        int lastDot;
        int lastSep = filename.lastIndexOf(File.separatorChar);
        if (lastSep < 0) {
            lastDot = filename.lastIndexOf(46);
        } else {
            lastDot = filename.substring(lastSep + 1).lastIndexOf(46);
            if (lastDot >= 0) {
                lastDot += lastSep + 1;
            }
        }
        if (lastDot >= 0 && lastDot > lastSep) {
            return filename.substring(lastDot + 1);
        }
        return "";
    }
}

