/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.IOException;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.Directive;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.QualifiedIde;

public class ImportDirective
extends Directive {
    private static final JooSymbol IMPORT_SYMBOL = new JooSymbol(19, "import");
    private static final JooSymbol DOT_SYMBOL = new JooSymbol(73, ".");
    private JooSymbol importKeyword;
    private Ide ide;
    private JooSymbol symSemicolon;
    private final boolean explicit;

    public ImportDirective(Ide packageIde, String typeName) {
        this(IMPORT_SYMBOL, ImportDirective.createIde(packageIde, new JooSymbol(typeName)), false);
    }

    public ImportDirective(JooSymbol importKeyword, Ide ide, JooSymbol symSemicolon) {
        this(importKeyword, ide, true);
        this.symSemicolon = symSemicolon;
    }

    private ImportDirective(JooSymbol importKeyword, Ide ide, boolean explicit) {
        this.importKeyword = importKeyword;
        this.ide = ide;
        this.explicit = explicit;
    }

    private static Ide createIde(Ide prefix, JooSymbol symIde) {
        return prefix == null ? new Ide(symIde) : new QualifiedIde(prefix, DOT_SYMBOL, symIde);
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitImportDirective(this);
    }

    @Override
    public void scope(Scope scope) {
        this.getIde().scope(scope);
        scope.addImport(this);
    }

    public String getQualifiedName() {
        return this.getIde().getQualifiedNameStr();
    }

    @Override
    public JooSymbol getSymbol() {
        return this.getImportKeyword();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImportDirective that = (ImportDirective)o;
        if (this.isExplicit() != that.isExplicit()) {
            return false;
        }
        return !(this.getIde() != null ? !this.getIde().equals(that.getIde()) : that.getIde() != null);
    }

    public int hashCode() {
        int result = this.getIde() != null ? this.getIde().hashCode() : 0;
        result = 31 * result + (this.isExplicit() ? 1 : 0);
        return result;
    }

    public JooSymbol getImportKeyword() {
        return this.importKeyword;
    }

    public Ide getIde() {
        return this.ide;
    }

    public JooSymbol getSymSemicolon() {
        return this.symSemicolon;
    }

    public boolean isExplicit() {
        return this.explicit;
    }
}

