/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.config;

import java.io.File;
import net.jangaroo.jooc.config.DebugMode;
import net.jangaroo.jooc.config.JoocOptions;
import net.jangaroo.jooc.config.ParserOptions;
import net.jangaroo.jooc.config.SemicolonInsertionMode;
import net.jangaroo.utils.FileLocations;
import org.kohsuke.args4j.Option;

public class JoocConfiguration
extends FileLocations
implements JoocOptions,
ParserOptions {
    private SemicolonInsertionMode semicolonInsertionMode = SemicolonInsertionMode.WARN;
    private DebugMode debugMode;
    private boolean help;
    private boolean version;
    private boolean verbose;
    private boolean enableAssertions;
    private boolean allowDuplicateLocalVariables;
    private File apiOutputDirectory;
    private boolean mergeOutput = false;
    private String outputFileName;

    @Override
    public SemicolonInsertionMode getSemicolonInsertionMode() {
        return this.semicolonInsertionMode;
    }

    @Option(name="-autosemicolon", usage="automatic semicolon insertion mode, possible modes: error, warn (default), quirk (no warnings)")
    public void setSemicolonInsertionMode(SemicolonInsertionMode semicolonInsertionMode) {
        this.semicolonInsertionMode = semicolonInsertionMode;
    }

    public boolean isMergeOutput() {
        return this.mergeOutput;
    }

    public void setMergeOutput(boolean mergeOutput) {
        this.mergeOutput = mergeOutput;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    public File getOutputFile() {
        return new File(this.outputFileName);
    }

    @Override
    public DebugMode getDebugMode() {
        return this.debugMode;
    }

    @Option(name="-g", usage="generate debuggable output (possible modes: source, lines, none)")
    public void setDebugMode(DebugMode debugMode) {
        this.debugMode = debugMode;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Option(name="-v", aliases={"--verbose"}, usage="be extra verbose")
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public boolean isGenerateApi() {
        return this.apiOutputDirectory != null;
    }

    public boolean isHelp() {
        return this.help;
    }

    @Option(name="-h", aliases={"--help"}, usage="print this message")
    public void setHelp(boolean help) {
        this.help = help;
    }

    public boolean isVersion() {
        return this.version;
    }

    @Option(name="-version", usage="print version information and exit")
    public void setVersion(boolean version2) {
        this.version = version2;
    }

    @Override
    public boolean isEnableAssertions() {
        return this.enableAssertions;
    }

    @Option(name="-ea", aliases={"--enableassertions"}, usage="enable assertions")
    public void setEnableAssertions(boolean enableAssertions) {
        this.enableAssertions = enableAssertions;
    }

    public boolean isAllowDuplicateLocalVariables() {
        return this.allowDuplicateLocalVariables;
    }

    @Option(name="-ad", aliases={"--allowduplicatelocalvariables"}, usage="allow multiple declarations of local variables")
    public void setAllowDuplicateLocalVariables(boolean allowDuplicateLocalVariables) {
        this.allowDuplicateLocalVariables = allowDuplicateLocalVariables;
    }

    public File getApiOutputDirectory() {
        return this.apiOutputDirectory;
    }

    @Option(name="-api", aliases={"--apiDir"}, usage="destination directory where to generate ActionScript API stubs")
    public void setApiOutputDirectory(File apiOutputDirectory) {
        this.apiOutputDirectory = apiOutputDirectory;
    }
}

