/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.config;

import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import net.jangaroo.jooc.config.CommandLineParseException;
import net.jangaroo.jooc.config.JoocConfiguration;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.ExampleMode;

public class JoocCommandLineParser {
    public JoocConfiguration parse(String[] args) throws CommandLineParseException {
        JoocConfiguration config = new JoocConfiguration();
        CmdLineParser parser2 = new CmdLineParser((Object)config);
        try {
            parser2.parseArgument(args);
        }
        catch (CmdLineException e) {
            StringBuilder msg = new StringBuilder();
            msg.append(e.getMessage());
            msg.append("\n");
            msg.append("java Jooc [options...] source files...\n");
            StringWriter writer = new StringWriter();
            parser2.printUsage((Writer)writer, null);
            msg.append(writer.getBuffer());
            msg.append("\n");
            msg.append("  Example: java Jooc").append(parser2.printExample(ExampleMode.REQUIRED));
            msg.append("\n");
            throw new CommandLineParseException(msg.toString(), -1);
        }
        if (config.isHelp()) {
            parser2.printUsage((OutputStream)System.out);
            return null;
        }
        if (!config.getOutputDirectory().exists()) {
            throw new IllegalArgumentException("destination directory does not exist: " + config.getOutputDirectory().getAbsolutePath());
        }
        if (config.getApiOutputDirectory() != null && !config.getApiOutputDirectory().exists()) {
            throw new IllegalArgumentException("destination directory for API stubs does not exist: " + config.getApiOutputDirectory().getAbsolutePath());
        }
        if (config.isVerbose()) {
            System.out.println("-genarateapi: " + config.isGenerateApi());
            System.out.println("-g option values:");
            System.out.println("debugMode=" + (Object)((Object)config.getDebugMode()));
        }
        return config;
    }
}

