/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j;

import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.ClassParser;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.ExampleMode;
import org.kohsuke.args4j.IllegalAnnotationError;
import org.kohsuke.args4j.Messages;
import org.kohsuke.args4j.NamedOptionDef;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.BooleanOptionHandler;
import org.kohsuke.args4j.spi.ByteOptionHandler;
import org.kohsuke.args4j.spi.CharOptionHandler;
import org.kohsuke.args4j.spi.DoubleOptionHandler;
import org.kohsuke.args4j.spi.EnumOptionHandler;
import org.kohsuke.args4j.spi.FileOptionHandler;
import org.kohsuke.args4j.spi.FloatOptionHandler;
import org.kohsuke.args4j.spi.IntOptionHandler;
import org.kohsuke.args4j.spi.LongOptionHandler;
import org.kohsuke.args4j.spi.MapOptionHandler;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;
import org.kohsuke.args4j.spi.ShortOptionHandler;
import org.kohsuke.args4j.spi.StringOptionHandler;
import org.kohsuke.args4j.spi.URIOptionHandler;
import org.kohsuke.args4j.spi.URLOptionHandler;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdLineParser {
    private final List<OptionHandler> options = new ArrayList<OptionHandler>();
    private final List<OptionHandler> arguments = new ArrayList<OptionHandler>();
    private boolean parsingOptions = true;
    private OptionHandler currentOptionHandler = null;
    private int usageWidth = 80;
    private static final Map<Class, Constructor<? extends OptionHandler>> handlerClasses;
    private static final Logger LOGGER;
    static /* synthetic */ Class class$org$kohsuke$args4j$spi$Setter;
    static /* synthetic */ Class class$org$kohsuke$args4j$OptionDef;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$org$kohsuke$args4j$spi$URLOptionHandler;
    static /* synthetic */ Class class$java$lang$Enum;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$org$kohsuke$args4j$spi$URIOptionHandler;
    static /* synthetic */ Class class$org$kohsuke$args4j$spi$OptionHandler;
    static /* synthetic */ Class class$org$kohsuke$args4j$spi$FloatOptionHandler;
    static /* synthetic */ Class class$org$kohsuke$args4j$spi$MapOptionHandler;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$org$kohsuke$args4j$spi$StringOptionHandler;
    static /* synthetic */ Class class$org$kohsuke$args4j$spi$CharOptionHandler;
    static /* synthetic */ Class class$org$kohsuke$args4j$spi$IntOptionHandler;
    static /* synthetic */ Class class$org$kohsuke$args4j$spi$DoubleOptionHandler;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$org$kohsuke$args4j$spi$ShortOptionHandler;
    static /* synthetic */ Class class$org$kohsuke$args4j$spi$BooleanOptionHandler;
    static /* synthetic */ Class class$org$kohsuke$args4j$CmdLineParser;
    static /* synthetic */ Class class$org$kohsuke$args4j$spi$ByteOptionHandler;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$net$URI;
    static /* synthetic */ Class class$org$kohsuke$args4j$spi$FileOptionHandler;
    static /* synthetic */ Class class$org$kohsuke$args4j$spi$LongOptionHandler;
    static /* synthetic */ Class class$java$lang$Integer;

    public CmdLineParser(Object bean) {
        if (bean == null) {
            return;
        }
        new ClassParser().parse(bean, this);
        Collections.sort(this.options, new Comparator<OptionHandler>(){

            @Override
            public int compare(OptionHandler o1, OptionHandler o2) {
                return o1.option.toString().compareTo(o2.option.toString());
            }

            @Override
            public /* synthetic */ int compare(Object x0, Object x1) {
                return this.compare((OptionHandler)x0, (OptionHandler)x1);
            }
        });
    }

    public void addArgument(Setter setter, Argument a) {
        OptionHandler h = this.createOptionHandler(new OptionDef(a, setter.isMultiValued()), setter);
        int index = a.index();
        while (index >= this.arguments.size()) {
            this.arguments.add(null);
        }
        if (this.arguments.get(index) != null) {
            throw new IllegalAnnotationError(new StringBuffer().append("Argument with index ").append(index).append(" is used more than once").toString());
        }
        this.arguments.set(index, h);
    }

    public void addOption(Setter setter, Option o) {
        this.checkOptionNotInMap(o.name());
        for (String alias : o.aliases()) {
            this.checkOptionNotInMap(alias);
        }
        this.options.add(this.createOptionHandler(new NamedOptionDef(o, setter.isMultiValued()), setter));
    }

    public List<OptionHandler> getArguments() {
        return this.arguments;
    }

    private void checkOptionNotInMap(String name) throws IllegalAnnotationError {
        if (this.findOptionByName(name) != null) {
            throw new IllegalAnnotationError(new StringBuffer().append("Option name ").append(name).append(" is used more than once").toString());
        }
    }

    protected OptionHandler createOptionHandler(OptionDef o, Setter setter) {
        Constructor<? extends OptionHandler> handlerType;
        Class<? extends OptionHandler> h = o.handler();
        Class<?> clazz = class$org$kohsuke$args4j$spi$OptionHandler;
        if (clazz == null) {
            clazz = class$org$kohsuke$args4j$spi$OptionHandler = new OptionHandler[0].getClass().getComponentType();
        }
        if (h == clazz) {
            Class t = setter.getType();
            Class clazz2 = class$java$lang$Enum;
            if (clazz2 == null) {
                clazz2 = class$java$lang$Enum = new Enum[0].getClass().getComponentType();
            }
            if (clazz2.isAssignableFrom(t)) {
                return new EnumOptionHandler(this, o, setter, t);
            }
            handlerType = handlerClasses.get(t);
            if (handlerType == null) {
                throw new IllegalAnnotationError(new StringBuffer().append("No OptionHandler is registered to handle ").append(t).toString());
            }
        } else {
            handlerType = CmdLineParser.getConstructor(h);
        }
        try {
            return handlerType.newInstance(this, o, setter);
        }
        catch (InstantiationException e) {
            throw new IllegalAnnotationError(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAnnotationError(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalAnnotationError(e);
        }
    }

    public String printExample(ExampleMode mode) {
        return this.printExample(mode, null);
    }

    public String printExample(ExampleMode mode, ResourceBundle rb) {
        StringBuffer buf = new StringBuffer();
        for (OptionHandler h : this.options) {
            OptionDef option = h.option;
            if (option.usage().length() == 0 || !mode.print(option)) continue;
            buf.append(' ');
            buf.append(h.getNameAndMeta(rb));
        }
        return buf.toString();
    }

    public void printUsage(OutputStream out) {
        this.printUsage(new OutputStreamWriter(out), null);
    }

    public void printUsage(Writer out, ResourceBundle rb) {
        int curLen;
        PrintWriter w = new PrintWriter(out);
        int len = 0;
        for (OptionHandler h : this.arguments) {
            curLen = this.getPrefixLen(h, rb);
            len = Math.max(len, curLen);
        }
        for (OptionHandler h : this.options) {
            curLen = this.getPrefixLen(h, rb);
            len = Math.max(len, curLen);
        }
        for (OptionHandler h : this.arguments) {
            this.printOption(w, h, len, rb);
        }
        for (OptionHandler h : this.options) {
            this.printOption(w, h, len, rb);
        }
        w.flush();
    }

    private void printOption(PrintWriter out, OptionHandler handler, int len, ResourceBundle rb) {
        if (handler.option.usage() == null || handler.option.usage().length() == 0) {
            return;
        }
        int widthMetadata = Math.min(len, (this.usageWidth - 4) / 2);
        int widthUsage = this.usageWidth - 4 - widthMetadata;
        List<String> namesAndMetas = this.wrapLines(handler.getNameAndMeta(rb), widthMetadata);
        List<String> usages = this.wrapLines(this.localize(handler.option.usage(), rb), widthUsage);
        for (int i = 0; i < Math.max(namesAndMetas.size(), usages.size()); ++i) {
            String nameAndMeta = i >= namesAndMetas.size() ? "" : namesAndMetas.get(i);
            String usage = i >= usages.size() ? "" : usages.get(i);
            String format = nameAndMeta.length() > 0 ? new StringBuffer().append(" %1$-").append(widthMetadata).append("s : %2$-1s").toString() : new StringBuffer().append(" %1$-").append(widthMetadata).append("s   %2$-1s").toString();
            String output = String.format(format, nameAndMeta, usage);
            out.println(output);
        }
    }

    private String localize(String s, ResourceBundle rb) {
        if (rb != null) {
            return rb.getString(s);
        }
        return s;
    }

    private List<String> wrapLines(String line, int maxLength) {
        ArrayList<String> rv = new ArrayList<String>();
        for (String restOfLine : line.split("\\n")) {
            while (restOfLine.length() > maxLength) {
                String candidate = restOfLine.substring(0, maxLength);
                int sp = candidate.lastIndexOf(32);
                int lineLength = sp > maxLength * 3 / 4 ? sp : maxLength;
                rv.add(restOfLine.substring(0, lineLength));
                restOfLine = restOfLine.substring(lineLength).trim();
            }
            rv.add(restOfLine);
        }
        return rv;
    }

    private int getPrefixLen(OptionHandler h, ResourceBundle rb) {
        if (h.option.usage().length() == 0) {
            return 0;
        }
        return h.getNameAndMeta(rb).length();
    }

    private String getOptionName() {
        return this.currentOptionHandler.option.toString();
    }

    public void parseArgument(Collection<String> args) throws CmdLineException {
        this.parseArgument(args.toArray(new String[args.size()]));
    }

    public void parseArgument(String[] args) throws CmdLineException {
        CmdLineImpl cmdLine = new CmdLineImpl(args);
        HashSet<OptionHandler> present = new HashSet<OptionHandler>();
        int argIndex = 0;
        while (cmdLine.hasMore()) {
            String arg = cmdLine.getCurrentToken();
            if (this.isOption(arg)) {
                boolean isKeyValuePair = arg.indexOf(61) != -1;
                OptionHandler optionHandler = this.currentOptionHandler = isKeyValuePair ? this.findOptionHandler(arg) : this.findOptionByName(arg);
                if (this.currentOptionHandler == null) {
                    throw new CmdLineException(this, Messages.UNDEFINED_OPTION.format(new Object[]{arg}));
                }
                cmdLine.proceed(1);
            } else {
                if (argIndex >= this.arguments.size()) {
                    Messages msg = this.arguments.size() == 0 ? Messages.NO_ARGUMENT_ALLOWED : Messages.TOO_MANY_ARGUMENTS;
                    throw new CmdLineException(this, msg.format(new Object[]{arg}));
                }
                this.currentOptionHandler = this.arguments.get(argIndex);
                if (!this.currentOptionHandler.option.isMultiValued()) {
                    ++argIndex;
                }
            }
            int diff = this.currentOptionHandler.parseArguments(cmdLine);
            cmdLine.proceed(diff);
            present.add(this.currentOptionHandler);
        }
        for (OptionHandler handler : this.options) {
            if (!handler.option.required() || present.contains(handler)) continue;
            throw new CmdLineException(this, Messages.REQUIRED_OPTION_MISSING.format(new Object[]{handler.option.toString()}));
        }
        for (OptionHandler handler : this.arguments) {
            if (!handler.option.required() || present.contains(handler)) continue;
            throw new CmdLineException(this, Messages.REQUIRED_ARGUMENT_MISSING.format(new Object[]{handler.option.toString()}));
        }
    }

    private OptionHandler findOptionHandler(String name) {
        OptionHandler handler = this.findOptionByName(name);
        if (handler == null) {
            for (int i = name.length(); i > 1; --i) {
                String prefix = name.substring(0, i);
                Map<String, OptionHandler> possibleHandlers = this.filter(this.options, prefix);
                handler = possibleHandlers.get(prefix);
                if (handler == null) continue;
                return handler;
            }
        }
        return handler;
    }

    private OptionHandler findOptionByName(String name) {
        for (OptionHandler h : this.options) {
            NamedOptionDef option = (NamedOptionDef)h.option;
            if (name.equals(option.name())) {
                return h;
            }
            for (String alias : option.aliases()) {
                if (!name.equals(alias)) continue;
                return h;
            }
        }
        return null;
    }

    private Map<String, OptionHandler> filter(List<OptionHandler> opt, String keyFilter) {
        TreeMap<String, OptionHandler> rv = new TreeMap<String, OptionHandler>();
        for (OptionHandler h : opt) {
            if (!opt.toString().startsWith(keyFilter)) continue;
            rv.put(opt.toString(), h);
        }
        return rv;
    }

    protected boolean isOption(String arg) {
        return this.parsingOptions && arg.startsWith("-");
    }

    public static void registerHandler(Class valueType, Class<? extends OptionHandler> handlerClass) {
        if (valueType == null || handlerClass == null) {
            throw new IllegalArgumentException();
        }
        Class<? extends OptionHandler> clazz = class$org$kohsuke$args4j$spi$OptionHandler;
        if (clazz == null) {
            clazz = class$org$kohsuke$args4j$spi$OptionHandler = new OptionHandler[0].getClass().getComponentType();
        }
        if (!clazz.isAssignableFrom(handlerClass)) {
            throw new IllegalArgumentException("Not an OptionHandler class");
        }
        Constructor<? extends OptionHandler> c = CmdLineParser.getConstructor(handlerClass);
        handlerClasses.put(valueType, c);
    }

    private static Constructor<? extends OptionHandler> getConstructor(Class<? extends OptionHandler> handlerClass) {
        try {
            Class<?> clazz;
            Class clazz2;
            Class[] classArray = new Class[3];
            Class clazz3 = class$org$kohsuke$args4j$CmdLineParser;
            if (clazz3 == null) {
                clazz3 = classArray[0] = (class$org$kohsuke$args4j$CmdLineParser = new CmdLineParser[0].getClass().getComponentType());
            }
            if ((clazz2 = class$org$kohsuke$args4j$OptionDef) == null) {
                clazz2 = classArray[1] = (class$org$kohsuke$args4j$OptionDef = new OptionDef[0].getClass().getComponentType());
            }
            if ((clazz = class$org$kohsuke$args4j$spi$Setter) == null) {
                clazz = class$org$kohsuke$args4j$spi$Setter = new Setter[0].getClass().getComponentType();
            }
            classArray[2] = clazz;
            return handlerClass.getConstructor(classArray);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(new StringBuffer().append(handlerClass).append(" does not have the proper constructor").toString());
        }
    }

    public void setUsageWidth(int usageWidth) {
        this.usageWidth = usageWidth;
    }

    public void stopOptionParsing() {
        this.parsingOptions = false;
    }

    public void printSingleLineUsage(OutputStream out) {
        this.printSingleLineUsage(new OutputStreamWriter(out), null);
    }

    public void printSingleLineUsage(Writer w, ResourceBundle rb) {
        PrintWriter pw = new PrintWriter(w);
        for (OptionHandler h : this.arguments) {
            this.printSingleLineOption(pw, h, rb);
        }
        for (OptionHandler h : this.options) {
            this.printSingleLineOption(pw, h, rb);
        }
        pw.flush();
    }

    private void printSingleLineOption(PrintWriter pw, OptionHandler h, ResourceBundle rb) {
        pw.print(' ');
        if (!h.option.required()) {
            pw.print('[');
        }
        pw.print(h.getNameAndMeta(rb));
        if (h.option.isMultiValued()) {
            pw.print(" ...");
        }
        if (!h.option.required()) {
            pw.print(']');
        }
    }

    static {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        Class<?> clazz5;
        Class<?> clazz6;
        Class<?> clazz7;
        Class<?> clazz8;
        Class<?> clazz9;
        Class<?> clazz10;
        Class<?> clazz11;
        Class<?> clazz12;
        Class<?> clazz13;
        handlerClasses = Collections.synchronizedMap(new HashMap());
        Class<?> clazz14 = class$java$lang$Boolean;
        if (clazz14 == null) {
            clazz14 = class$java$lang$Boolean = new Boolean[0].getClass().getComponentType();
        }
        if ((clazz13 = class$org$kohsuke$args4j$spi$BooleanOptionHandler) == null) {
            clazz13 = class$org$kohsuke$args4j$spi$BooleanOptionHandler = new BooleanOptionHandler[0].getClass().getComponentType();
        }
        CmdLineParser.registerHandler(clazz14, (Class<? extends OptionHandler>)clazz13);
        Class<?> clazz15 = class$org$kohsuke$args4j$spi$BooleanOptionHandler;
        if (clazz15 == null) {
            clazz15 = class$org$kohsuke$args4j$spi$BooleanOptionHandler = new BooleanOptionHandler[0].getClass().getComponentType();
        }
        CmdLineParser.registerHandler(Boolean.TYPE, (Class<? extends OptionHandler>)clazz15);
        Class<?> clazz16 = class$java$io$File;
        if (clazz16 == null) {
            clazz16 = class$java$io$File = new File[0].getClass().getComponentType();
        }
        if ((clazz12 = class$org$kohsuke$args4j$spi$FileOptionHandler) == null) {
            clazz12 = class$org$kohsuke$args4j$spi$FileOptionHandler = new FileOptionHandler[0].getClass().getComponentType();
        }
        CmdLineParser.registerHandler(clazz16, (Class<? extends OptionHandler>)clazz12);
        Class<?> clazz17 = class$java$net$URL;
        if (clazz17 == null) {
            clazz17 = class$java$net$URL = new URL[0].getClass().getComponentType();
        }
        if ((clazz11 = class$org$kohsuke$args4j$spi$URLOptionHandler) == null) {
            clazz11 = class$org$kohsuke$args4j$spi$URLOptionHandler = new URLOptionHandler[0].getClass().getComponentType();
        }
        CmdLineParser.registerHandler(clazz17, (Class<? extends OptionHandler>)clazz11);
        Class<?> clazz18 = class$java$net$URI;
        if (clazz18 == null) {
            clazz18 = class$java$net$URI = new URI[0].getClass().getComponentType();
        }
        if ((clazz10 = class$org$kohsuke$args4j$spi$URIOptionHandler) == null) {
            clazz10 = class$org$kohsuke$args4j$spi$URIOptionHandler = new URIOptionHandler[0].getClass().getComponentType();
        }
        CmdLineParser.registerHandler(clazz18, (Class<? extends OptionHandler>)clazz10);
        Class<?> clazz19 = class$java$lang$Integer;
        if (clazz19 == null) {
            clazz19 = class$java$lang$Integer = new Integer[0].getClass().getComponentType();
        }
        if ((clazz9 = class$org$kohsuke$args4j$spi$IntOptionHandler) == null) {
            clazz9 = class$org$kohsuke$args4j$spi$IntOptionHandler = new IntOptionHandler[0].getClass().getComponentType();
        }
        CmdLineParser.registerHandler(clazz19, (Class<? extends OptionHandler>)clazz9);
        Class<?> clazz20 = class$org$kohsuke$args4j$spi$IntOptionHandler;
        if (clazz20 == null) {
            clazz20 = class$org$kohsuke$args4j$spi$IntOptionHandler = new IntOptionHandler[0].getClass().getComponentType();
        }
        CmdLineParser.registerHandler(Integer.TYPE, (Class<? extends OptionHandler>)clazz20);
        Class<?> clazz21 = class$java$lang$Double;
        if (clazz21 == null) {
            clazz21 = class$java$lang$Double = new Double[0].getClass().getComponentType();
        }
        if ((clazz8 = class$org$kohsuke$args4j$spi$DoubleOptionHandler) == null) {
            clazz8 = class$org$kohsuke$args4j$spi$DoubleOptionHandler = new DoubleOptionHandler[0].getClass().getComponentType();
        }
        CmdLineParser.registerHandler(clazz21, (Class<? extends OptionHandler>)clazz8);
        Class<?> clazz22 = class$org$kohsuke$args4j$spi$DoubleOptionHandler;
        if (clazz22 == null) {
            clazz22 = class$org$kohsuke$args4j$spi$DoubleOptionHandler = new DoubleOptionHandler[0].getClass().getComponentType();
        }
        CmdLineParser.registerHandler(Double.TYPE, (Class<? extends OptionHandler>)clazz22);
        Class<?> clazz23 = class$java$lang$String;
        if (clazz23 == null) {
            clazz23 = class$java$lang$String = new String[0].getClass().getComponentType();
        }
        if ((clazz7 = class$org$kohsuke$args4j$spi$StringOptionHandler) == null) {
            clazz7 = class$org$kohsuke$args4j$spi$StringOptionHandler = new StringOptionHandler[0].getClass().getComponentType();
        }
        CmdLineParser.registerHandler(clazz23, (Class<? extends OptionHandler>)clazz7);
        Class<?> clazz24 = class$java$lang$Byte;
        if (clazz24 == null) {
            clazz24 = class$java$lang$Byte = new Byte[0].getClass().getComponentType();
        }
        if ((clazz6 = class$org$kohsuke$args4j$spi$ByteOptionHandler) == null) {
            clazz6 = class$org$kohsuke$args4j$spi$ByteOptionHandler = new ByteOptionHandler[0].getClass().getComponentType();
        }
        CmdLineParser.registerHandler(clazz24, (Class<? extends OptionHandler>)clazz6);
        Class<?> clazz25 = class$org$kohsuke$args4j$spi$ByteOptionHandler;
        if (clazz25 == null) {
            clazz25 = class$org$kohsuke$args4j$spi$ByteOptionHandler = new ByteOptionHandler[0].getClass().getComponentType();
        }
        CmdLineParser.registerHandler(Byte.TYPE, (Class<? extends OptionHandler>)clazz25);
        Class<?> clazz26 = class$java$lang$Character;
        if (clazz26 == null) {
            clazz26 = class$java$lang$Character = new Character[0].getClass().getComponentType();
        }
        if ((clazz5 = class$org$kohsuke$args4j$spi$CharOptionHandler) == null) {
            clazz5 = class$org$kohsuke$args4j$spi$CharOptionHandler = new CharOptionHandler[0].getClass().getComponentType();
        }
        CmdLineParser.registerHandler(clazz26, (Class<? extends OptionHandler>)clazz5);
        Class<?> clazz27 = class$org$kohsuke$args4j$spi$CharOptionHandler;
        if (clazz27 == null) {
            clazz27 = class$org$kohsuke$args4j$spi$CharOptionHandler = new CharOptionHandler[0].getClass().getComponentType();
        }
        CmdLineParser.registerHandler(Character.TYPE, (Class<? extends OptionHandler>)clazz27);
        Class<?> clazz28 = class$java$lang$Float;
        if (clazz28 == null) {
            clazz28 = class$java$lang$Float = new Float[0].getClass().getComponentType();
        }
        if ((clazz4 = class$org$kohsuke$args4j$spi$FloatOptionHandler) == null) {
            clazz4 = class$org$kohsuke$args4j$spi$FloatOptionHandler = new FloatOptionHandler[0].getClass().getComponentType();
        }
        CmdLineParser.registerHandler(clazz28, (Class<? extends OptionHandler>)clazz4);
        Class<?> clazz29 = class$org$kohsuke$args4j$spi$FloatOptionHandler;
        if (clazz29 == null) {
            clazz29 = class$org$kohsuke$args4j$spi$FloatOptionHandler = new FloatOptionHandler[0].getClass().getComponentType();
        }
        CmdLineParser.registerHandler(Float.TYPE, (Class<? extends OptionHandler>)clazz29);
        Class<?> clazz30 = class$java$lang$Long;
        if (clazz30 == null) {
            clazz30 = class$java$lang$Long = new Long[0].getClass().getComponentType();
        }
        if ((clazz3 = class$org$kohsuke$args4j$spi$LongOptionHandler) == null) {
            clazz3 = class$org$kohsuke$args4j$spi$LongOptionHandler = new LongOptionHandler[0].getClass().getComponentType();
        }
        CmdLineParser.registerHandler(clazz30, (Class<? extends OptionHandler>)clazz3);
        Class<?> clazz31 = class$org$kohsuke$args4j$spi$LongOptionHandler;
        if (clazz31 == null) {
            clazz31 = class$org$kohsuke$args4j$spi$LongOptionHandler = new LongOptionHandler[0].getClass().getComponentType();
        }
        CmdLineParser.registerHandler(Long.TYPE, (Class<? extends OptionHandler>)clazz31);
        Class<?> clazz32 = class$java$lang$Short;
        if (clazz32 == null) {
            clazz32 = class$java$lang$Short = new Short[0].getClass().getComponentType();
        }
        if ((clazz2 = class$org$kohsuke$args4j$spi$ShortOptionHandler) == null) {
            clazz2 = class$org$kohsuke$args4j$spi$ShortOptionHandler = new ShortOptionHandler[0].getClass().getComponentType();
        }
        CmdLineParser.registerHandler(clazz32, (Class<? extends OptionHandler>)clazz2);
        Class<?> clazz33 = class$org$kohsuke$args4j$spi$ShortOptionHandler;
        if (clazz33 == null) {
            clazz33 = class$org$kohsuke$args4j$spi$ShortOptionHandler = new ShortOptionHandler[0].getClass().getComponentType();
        }
        CmdLineParser.registerHandler(Short.TYPE, (Class<? extends OptionHandler>)clazz33);
        Class<?> clazz34 = class$java$util$Map;
        if (clazz34 == null) {
            clazz34 = class$java$util$Map = new Map[0].getClass().getComponentType();
        }
        if ((clazz = class$org$kohsuke$args4j$spi$MapOptionHandler) == null) {
            clazz = class$org$kohsuke$args4j$spi$MapOptionHandler = new MapOptionHandler[0].getClass().getComponentType();
        }
        CmdLineParser.registerHandler(clazz34, (Class<? extends OptionHandler>)clazz);
        Class<?> clazz35 = class$org$kohsuke$args4j$CmdLineParser;
        if (clazz35 == null) {
            clazz35 = class$org$kohsuke$args4j$CmdLineParser = new CmdLineParser[0].getClass().getComponentType();
        }
        LOGGER = Logger.getLogger(clazz35.getName());
    }

    private class CmdLineImpl
    implements Parameters {
        private final String[] args;
        private int pos;

        CmdLineImpl(String[] args) {
            this.args = args;
            this.pos = 0;
        }

        protected boolean hasMore() {
            return this.pos < this.args.length;
        }

        protected String getCurrentToken() {
            return this.args[this.pos];
        }

        private void proceed(int n) {
            this.pos += n;
        }

        public String getParameter(int idx) throws CmdLineException {
            if (this.pos + idx >= this.args.length) {
                throw new CmdLineException(CmdLineParser.this, Messages.MISSING_OPERAND.format(new Object[]{CmdLineParser.this.getOptionName()}));
            }
            return this.args[this.pos + idx];
        }

        public int size() {
            return this.args.length - this.pos;
        }
    }
}

