/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ast;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.jangaroo.jooc.JangarooParser;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.ast.AstNode;
import net.jangaroo.jooc.ast.AstVisitor;
import net.jangaroo.jooc.ast.ClassDeclaration;
import net.jangaroo.jooc.ast.Ide;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.ast.NodeImplBase;
import net.jangaroo.jooc.ast.PackageDeclaration;
import net.jangaroo.jooc.input.InputSource;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationUnit
extends NodeImplBase {
    private PackageDeclaration packageDeclaration;
    private JooSymbol lBrace;
    private IdeDeclaration primaryDeclaration;
    private JooSymbol rBrace;
    private Set<String> dependencies = new LinkedHashSet<String>();
    private InputSource source;
    private JangarooParser compiler;

    public CompilationUnit(PackageDeclaration packageDeclaration, JooSymbol lBrace, IdeDeclaration primaryDeclaration, JooSymbol rBrace, List<IdeDeclaration> secondaryDeclarations) {
        this.packageDeclaration = packageDeclaration;
        this.lBrace = lBrace;
        this.primaryDeclaration = primaryDeclaration;
        if (primaryDeclaration instanceof ClassDeclaration) {
            ((ClassDeclaration)primaryDeclaration).setSecondaryDeclarations(secondaryDeclarations);
        }
        this.rBrace = rBrace;
    }

    @Override
    public void visit(AstVisitor visitor) throws IOException {
        visitor.visitCompilationUnit(this);
    }

    @Override
    public void scope(Scope scope) {
        this.withNewDeclarationScope(this, scope, new NodeImplBase.Scoped(){

            public void run(Scope scope) {
                Ide packageIde = CompilationUnit.this.packageDeclaration.getIde();
                if (CompilationUnit.this.primaryDeclaration instanceof ClassDeclaration) {
                    ((ClassDeclaration)CompilationUnit.this.primaryDeclaration).scopeDirectives(scope, packageIde);
                }
                CompilationUnit.this.packageDeclaration.scope(scope);
                CompilationUnit.this.withNewDeclarationScope(CompilationUnit.this.packageDeclaration, scope, new NodeImplBase.Scoped(){

                    public void run(Scope scope) {
                        CompilationUnit.this.primaryDeclaration.scope(scope);
                    }
                });
            }
        });
    }

    public PackageDeclaration getPackageDeclaration() {
        return this.packageDeclaration;
    }

    public IdeDeclaration getPrimaryDeclaration() {
        return this.primaryDeclaration;
    }

    public JooSymbol getLBrace() {
        return this.lBrace;
    }

    public JooSymbol getRBrace() {
        return this.rBrace;
    }

    public Set<String> getDependencies() {
        return this.dependencies;
    }

    public JangarooParser getCompiler() {
        return this.compiler;
    }

    public void setCompiler(JangarooParser compiler) {
        this.compiler = compiler;
    }

    public void setSource(InputSource source) {
        this.source = source;
    }

    public InputSource getSource() {
        return this.source;
    }

    @Override
    public void analyze(AstNode parentNode) {
        super.analyze(parentNode);
        this.packageDeclaration.analyze(this);
        this.primaryDeclaration.analyze(this);
    }

    @Override
    public JooSymbol getSymbol() {
        return this.packageDeclaration.getSymbol();
    }

    public void addDependency(CompilationUnit otherUnit) {
        IdeDeclaration otherUnitPrimaryDeclaration;
        if (otherUnit != null && otherUnit != this && (otherUnitPrimaryDeclaration = otherUnit.getPrimaryDeclaration()) instanceof ClassDeclaration && !otherUnitPrimaryDeclaration.isNative()) {
            String qname = otherUnitPrimaryDeclaration.getQualifiedNameStr();
            this.dependencies.add(qname);
        }
    }

    public String addResourceDependency(String relativePath) {
        String path;
        String string = path = relativePath.startsWith("/") || relativePath.startsWith("\\") ? relativePath : new File(this.source.getParent().getRelativePath(), relativePath).getPath().replace('\\', '/');
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        this.dependencies.add(new StringBuffer().append("resource:").append(path).toString());
        return path;
    }

    public String toString() {
        return new StringBuffer().append(this.getClass().getSimpleName()).append("(").append(this.getPrimaryDeclaration().getQualifiedNameStr()).append(")").toString();
    }
}

