/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public abstract class SubstitutingWriter
extends FilterWriter {
    public SubstitutingWriter(Writer out) {
        super(out);
    }

    protected abstract String substitute(char var1);

    protected void writeReplacement(String replacement) throws IOException {
        this.out.write(replacement);
    }

    public void write(int c) throws IOException {
        char ch = (char)c;
        String replacement = this.substitute(ch);
        if (replacement == null) {
            this.out.write(c);
        } else {
            this.writeReplacement(replacement);
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        int nextToWrite = off;
        int guard = off + len;
        while (off < guard) {
            String replacement = this.substitute(cbuf[off]);
            if (replacement != null) {
                if (nextToWrite < off) {
                    this.out.write(cbuf, nextToWrite, off - nextToWrite);
                }
                this.writeReplacement(replacement);
                nextToWrite = off + 1;
            }
            ++off;
        }
        if (nextToWrite < off) {
            this.out.write(cbuf, nextToWrite, off - nextToWrite);
        }
    }

    public void write(String str, int off, int len) throws IOException {
        int nextToWrite = off;
        int guard = off + len;
        while (off < guard) {
            String replacement = this.substitute(str.charAt(off));
            if (replacement != null) {
                if (nextToWrite < off) {
                    this.out.write(str, nextToWrite, off - nextToWrite);
                }
                this.writeReplacement(replacement);
                nextToWrite = off + 1;
            }
            ++off;
        }
        if (nextToWrite < off) {
            this.out.write(str, nextToWrite, off - nextToWrite);
        }
    }
}

