/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import net.jangaroo.jooc.CompileLog;
import net.jangaroo.jooc.JooSymbol;

public abstract class AbstractCompileLog
implements CompileLog {
    protected boolean errors = false;

    String formatError(String fileName, int line, int column, String debugLevel, String message) {
        StringBuffer m = new StringBuffer();
        m.append(fileName);
        m.append("(");
        m.append(line);
        m.append("): ");
        m.append(debugLevel);
        m.append(": ");
        m.append("in column ");
        m.append(column);
        m.append(": ");
        m.append(message);
        return m.toString();
    }

    public void error(JooSymbol sym2, String msg) {
        this.error(this.formatError(sym2.getFileName(), sym2.getLine(), sym2.getColumn(), "Error", msg));
    }

    public void warning(JooSymbol sym2, String msg) {
        this.warning(this.formatError(sym2.getFileName(), sym2.getLine(), sym2.getColumn(), "Warning", msg));
    }

    public boolean hasErrors() {
        return this.errors;
    }

    public void error(String msg) {
        this.doLogError(msg);
        this.errors = true;
    }

    protected abstract void doLogError(String var1);
}

