/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.utils.log;

import java.io.File;
import net.jangaroo.utils.log.LogHandler;

public abstract class AbstractLogHandler
implements LogHandler {
    private File currentFile;

    @Override
    public void setCurrentFile(File file) {
        this.currentFile = file;
    }

    protected String format(String logLevel, String message, int lineNumber, int columnNumber) {
        return String.format("%s in %s, line %s, column %s: %s", logLevel, this.currentFile, lineNumber, columnNumber, message);
    }

    @Override
    public void error(String message, int lineNumber, int columnNumber) {
        this.error(this.formatError(message, lineNumber, columnNumber));
    }

    protected String formatError(String message, int lineNumber, int columnNumber) {
        return this.format("ERROR", message, lineNumber, columnNumber);
    }

    @Override
    public void warning(String message, int lineNumber, int columnNumber) {
        this.warning(this.formatWarning(message, lineNumber, columnNumber));
    }

    protected String formatWarning(String message, int lineNumber, int columnNumber) {
        return this.format("WARNING", message, lineNumber, columnNumber);
    }
}

