/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.utils;

import java.io.File;
import java.io.IOException;

public final class CompilerUtils {
    private CompilerUtils() {
    }

    public static String qName(String packageName, String className) {
        return packageName.length() == 0 ? className : packageName + "." + className;
    }

    public static String packageName(String qName) {
        int lastDotPos = qName.lastIndexOf(46);
        return lastDotPos == -1 ? "" : qName.substring(0, lastDotPos);
    }

    public static String className(String qName) {
        int lastDotPos = qName.lastIndexOf(46);
        return lastDotPos == -1 ? qName : qName.substring(lastDotPos + 1);
    }

    public static File fileFromQName(String packageName, String className, File baseDirectory, String extension) {
        return CompilerUtils.fileFromQName(CompilerUtils.qName(packageName, className), baseDirectory, extension);
    }

    public static File fileFromQName(String qName, File baseDirectory, String extension) {
        char separatorChar = File.separatorChar;
        return new File(baseDirectory, CompilerUtils.fileNameFromQName(qName, separatorChar, extension));
    }

    public static String fileNameFromQName(String qName, char separatorChar, String extension) {
        return qName.replace('.', separatorChar) + extension;
    }

    public static String qNameFromFile(File baseDirectory, File file) {
        try {
            String relativePath;
            int lastDotPos;
            String canonicalBasePath = baseDirectory.getCanonicalPath() + File.separator;
            String canonicalPath = file.getCanonicalPath();
            if (canonicalPath.length() > canonicalBasePath.length() && canonicalPath.startsWith(canonicalBasePath) && (lastDotPos = (relativePath = canonicalPath.substring(canonicalBasePath.length())).lastIndexOf(46)) != -1 && lastDotPos > relativePath.lastIndexOf(File.separatorChar)) {
                return relativePath.substring(0, lastDotPos).replace(File.separatorChar, '.');
            }
            return null;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("could not determine qualified name from file; the strange file is called " + file + " in " + baseDirectory, e);
        }
    }
}

