/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Calendar;
import java.util.Date;
import net.jangaroo.jooc.Debug;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.JsStringLiteralWriter;
import net.jangaroo.jooc.ast.IdeDeclaration;
import net.jangaroo.jooc.config.JoocOptions;

public final class JsWriter
extends FilterWriter {
    private JsStringLiteralWriter stringLiteralWriter;
    private JoocOptions options;
    private boolean commentStartWritten = false;
    private int nOpenBeginComments = 0;
    private char lastChar = (char)32;
    private boolean inString = false;
    private int nOpenStrings = 0;

    public JsWriter(Writer target) {
        super(target);
        this.stringLiteralWriter = new JsStringLiteralWriter(target, false);
    }

    public void setOptions(JoocOptions options) {
        this.options = options;
    }

    public JoocOptions getOptions() {
        return this.options;
    }

    public boolean getKeepSource() {
        return this.options.isDebug() && this.options.isDebugSource();
    }

    public boolean getKeepLines() {
        return this.options.isDebug() && this.options.isDebugLines();
    }

    public void writeInt(int value) throws IOException {
        if (this.shouldWrite()) {
            this.write(String.valueOf(value));
        }
    }

    public void writeString(String value) throws IOException {
        if (this.shouldWrite()) {
            if (value == null) {
                this.write("null");
            } else {
                this.stringLiteralWriter.beginString();
                this.stringLiteralWriter.write(value);
                this.stringLiteralWriter.endString();
            }
        }
    }

    public void writeDate(Date value) throws IOException {
        if (this.shouldWrite()) {
            this.writeString("new Date(" + value.getTime() + ")");
        }
    }

    public void writeDate(Calendar value) throws IOException {
        this.writeDate(value.getTime());
    }

    public void writeObject(Object o) throws IOException {
        if (this.shouldWrite()) {
            if (o instanceof String) {
                this.writeString((String)o);
            } else if (o instanceof Integer) {
                this.writeInt((Integer)o);
            } else if (o instanceof Date) {
                this.writeDate((Date)o);
            } else if (o instanceof Calendar) {
                this.writeDate((Calendar)o);
            } else if (o instanceof Object[]) {
                this.writeArray((Object[])o);
            } else {
                throw new IOException(this.getClass().getName() + ": cannot write object: " + o.getClass().getName());
            }
        }
    }

    public void writeArray(Object[] items) throws IOException {
        if (this.shouldWrite()) {
            this.write("[");
            int n = items.length;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    this.write(44);
                }
                this.writeObject(items[i]);
            }
            this.write("]");
        }
    }

    public void beginComment() throws IOException {
        ++this.nOpenBeginComments;
    }

    private boolean shouldWrite() throws IOException {
        boolean result;
        boolean bl = result = this.getKeepSource() || this.nOpenBeginComments == 0;
        if (result) {
            if (this.nOpenBeginComments > 0 && !this.commentStartWritten) {
                this.out.write("/*");
                this.lastChar = (char)42;
                this.commentStartWritten = true;
            } else if (this.nOpenBeginComments == 0 && this.commentStartWritten) {
                this.out.write("*/");
                this.lastChar = (char)47;
                this.commentStartWritten = false;
            }
        }
        return result;
    }

    public void endComment() throws IOException {
        Debug.assertTrue(this.nOpenBeginComments > 0, "missing beginComment() for endComment()");
        --this.nOpenBeginComments;
    }

    public void beginCommentWriteSymbol(JooSymbol symbol2) throws IOException {
        this.beginComment();
        this.writeSymbol(symbol2);
    }

    public void beginString() throws IOException {
        ++this.nOpenStrings;
    }

    private void checkOpenString() throws IOException {
        if (this.nOpenStrings > 0 && !this.inString) {
            this.out.write(34);
            this.lastChar = (char)34;
            this.inString = true;
        }
    }

    private boolean checkCloseString() throws IOException {
        if (this.inString) {
            this.out.write(34);
            this.inString = false;
            return true;
        }
        return false;
    }

    public void endString() throws IOException {
        Debug.assertTrue(this.nOpenStrings > 0, "missing beginString() for endString()");
        --this.nOpenStrings;
        if (this.nOpenStrings == 0) {
            this.checkCloseString();
        }
    }

    private void writeLinesInsideString(String ws) throws IOException {
        String[] lines = ws.split("\n", -1);
        for (int i = 0; i < lines.length - 1; ++i) {
            String line = lines[i];
            if (line.length() > 1) {
                this.checkOpenString();
                this.write(line.substring(0, line.length() - 1));
                this.write("\\n");
            }
            if (this.checkCloseString()) {
                this.write("+");
            }
            this.write("\n");
        }
        String line = lines[lines.length - 1];
        if (line.length() > 0) {
            this.checkOpenString();
            this.write(line);
        }
    }

    public void writeSymbolWhitespace(JooSymbol symbol2) throws IOException {
        String ws = symbol2.getWhitespace();
        if (this.getKeepSource()) {
            if (this.inString) {
                this.writeLinesInsideString(ws);
            } else {
                this.write(ws);
            }
        } else if (this.getKeepLines()) {
            this.writeLines(ws);
        } else {
            this.writeLine(ws);
        }
    }

    private void writeLine(String ws) throws IOException {
        if (ws.indexOf(10) != -1) {
            this.writeNewline();
        }
    }

    protected void writeLines(String s) throws IOException {
        this.writeLines(s, 0, s.length());
    }

    protected void writeLines(String s, int off, int len) throws IOException {
        int pos = off;
        while ((pos = s.indexOf(10, pos) + 1) > 0 && pos < off + len + 1) {
            this.writeNewline();
        }
    }

    private void writeNewline() throws IOException {
        if (this.inString) {
            this.write("\\n");
            this.checkCloseString();
            this.write(43);
        }
        this.write(10);
    }

    public void writeToken(String token) throws IOException {
        if (this.shouldWrite()) {
            char firstSymbolChar = token.charAt(0);
            if (this.isIdeChar(this.lastChar) && this.isIdeChar(firstSymbolChar) || this.lastChar == firstSymbolChar && "=><!&|+-*/&|^%".indexOf(this.lastChar) >= 0 || firstSymbolChar == '=' && "=><!&|+-*/&|^%".indexOf(this.lastChar) >= 0) {
                this.write(32);
            }
            this.checkOpenString();
            this.write(token);
        }
    }

    private boolean isIdeChar(char ch) {
        return ch == '$' || ch == '_' || Character.isLetterOrDigit(ch);
    }

    public void writeSymbol(JooSymbol symbol2) throws IOException {
        this.writeSymbol(symbol2, true);
    }

    public void writeSymbol(JooSymbol symbol2, boolean withWhitespace) throws IOException {
        if (withWhitespace) {
            this.writeSymbolWhitespace(symbol2);
        }
        this.writeSymbolToken(symbol2);
    }

    public void writeSymbolToken(JooSymbol symbol2) throws IOException {
        this.writeToken(symbol2.getText());
    }

    public void write(int c) throws IOException {
        if (this.getKeepLines() && c == 10 || this.shouldWrite()) {
            if (this.lastChar == '*' && c == 47) {
                super.write(32);
            }
            super.write(c);
            this.lastChar = (char)c;
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (len > 0) {
            if (this.shouldWrite()) {
                if (this.commentStartWritten) {
                    for (int i = 0; i < len; ++i) {
                        char c = cbuf[off + i];
                        this.write(c);
                    }
                } else {
                    super.write(cbuf, off, len);
                }
                this.lastChar = cbuf[off + len - 1];
            } else if (this.getKeepLines()) {
                for (int i = 0; i < len; ++i) {
                    char c = cbuf[off + i];
                    if (c != '\n') continue;
                    super.write(c);
                    this.lastChar = c;
                }
            }
        }
    }

    public void write(String str, int off, int len) throws IOException {
        if (len > 0) {
            if (this.shouldWrite()) {
                if (this.commentStartWritten) {
                    for (int i = 0; i < len; ++i) {
                        char c = str.charAt(off + i);
                        this.write(c);
                    }
                } else {
                    super.write(str, off, len);
                }
                this.lastChar = str.charAt(off + len - 1);
            } else if (this.getKeepLines()) {
                this.writeLines(str, off, len);
            }
        }
    }

    private static String qualifiedNameToIde(String[] qn) {
        StringBuffer result = new StringBuffer(20);
        for (int i = 0; i < qn.length; ++i) {
            if (i > 0) {
                result.append('$');
            }
            result.append(qn[i]);
        }
        return result.toString();
    }

    public String getQualifiedNameAsIde(IdeDeclaration ideDeclaration) {
        return JsWriter.qualifiedNameToIde(ideDeclaration.getQualifiedName());
    }

    public void close() throws IOException {
        this.shouldWrite();
        Debug.assertTrue(this.nOpenBeginComments == 0, "" + this.nOpenBeginComments + " endComment() missing");
        super.close();
    }

    public boolean isWritingComment() {
        return this.nOpenBeginComments > 0;
    }
}

