/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.utils.log;

import java.io.File;
import net.jangaroo.utils.log.LogHandler;
import net.jangaroo.utils.log.StandardOutLogHandler;

public final class Log {
    private static LogHandler logHandler = new StandardOutLogHandler();

    private Log() {
    }

    public static void setLogHandler(LogHandler handler) {
        logHandler = handler;
    }

    public static void setCurrentFile(File currentFile) {
        Log.getLogHandler().setCurrentFile(currentFile);
    }

    private static LogHandler getLogHandler() {
        return logHandler;
    }

    public static void e(String message, int lineNumber, int columnNumber) {
        Log.getLogHandler().error(message, lineNumber, columnNumber);
    }

    public static void e(String message, Exception exception) {
        Log.getLogHandler().error(message, exception);
    }

    public static void e(String message) {
        Log.getLogHandler().error(message);
    }

    public static void w(String message) {
        Log.getLogHandler().warning(message);
    }

    public static void w(String message, int lineNumber, int columnNumber) {
        Log.getLogHandler().warning(message, lineNumber, columnNumber);
    }

    public static void i(String message) {
        Log.getLogHandler().info(message);
    }

    public static void d(String message) {
        Log.getLogHandler().debug(message);
    }
}

