/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.IOException;
import net.jangaroo.jooc.AnalyzeContext;
import net.jangaroo.jooc.AstNode;
import net.jangaroo.jooc.Debug;
import net.jangaroo.jooc.Ide;
import net.jangaroo.jooc.IdeDeclaration;
import net.jangaroo.jooc.IdeExpr;
import net.jangaroo.jooc.Initializer;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.TypeRelation;

public class Parameter
extends IdeDeclaration {
    JooSymbol optSymConstOrRest;
    TypeRelation optTypeRelation;
    Initializer optInitializer;

    public Parameter(JooSymbol optSymConst, Ide ide, TypeRelation optTypeRelation, Initializer optInitializer) {
        super(new JooSymbol[0], 0, ide);
        this.optSymConstOrRest = optSymConst;
        this.optTypeRelation = optTypeRelation;
        this.optInitializer = optInitializer;
    }

    public void scope(Scope scope) {
        super.scope(scope);
        if (this.optTypeRelation != null) {
            this.optTypeRelation.scope(scope);
        }
        if (this.optInitializer != null) {
            this.optInitializer.scope(scope);
        }
    }

    public AstNode analyze(AstNode parentNode, AnalyzeContext context) {
        super.analyze(parentNode, context);
        if (this.optTypeRelation != null) {
            this.optTypeRelation.analyze(this, context);
            if (this.isRest() && !"Array".equals(this.optTypeRelation.getType().getSymbol().getText())) {
                throw Jooc.error(this.optTypeRelation.getSymbol(), "Rest parameter must have Array type.");
            }
        }
        if (this.optInitializer != null) {
            this.optInitializer.analyze(this, context);
        }
        return this;
    }

    public boolean isRest() {
        return this.optSymConstOrRest != null && this.optSymConstOrRest.sym == 43;
    }

    protected void generateAsApiCode(JsWriter out) throws IOException {
        if (this.optSymConstOrRest != null) {
            out.writeSymbol(this.optSymConstOrRest);
        }
        this.ide.generateCode(out);
        if (this.optTypeRelation != null) {
            this.optTypeRelation.generateCode(out);
        }
        if (this.optInitializer != null) {
            this.optInitializer.generateCode(out);
        }
    }

    protected void generateJsCode(JsWriter out) throws IOException {
        Debug.assertTrue(this.getModifiers() == 0, "Parameters must not have any modifiers");
        boolean isRest = this.isRest();
        if (this.optSymConstOrRest != null) {
            out.beginCommentWriteSymbol(this.optSymConstOrRest);
            if (isRest) {
                this.ide.generateCode(out);
            }
            out.endComment();
        }
        if (!isRest) {
            this.ide.generateCode(out);
        }
        if (this.optTypeRelation != null) {
            this.optTypeRelation.generateCode(out);
        }
        if (this.optInitializer != null) {
            out.beginComment();
            this.optInitializer.generateCode(out);
            out.endComment();
        }
    }

    public boolean hasInitializer() {
        return this.optInitializer != null && (!(this.optInitializer.value instanceof IdeExpr) || !((IdeExpr)this.optInitializer.value).ide.getName().equals("undefined"));
    }

    void generateBodyInitializerCode(JsWriter out) throws IOException {
        out.writeToken(this.getName());
        this.optInitializer.generateCode(out);
        out.write(";");
    }

    void generateRestParamCode(JsWriter out, int paramIndex) throws IOException {
        String paramName = this.getName();
        if (!(paramName == null || paramName.equals("arguments") && paramIndex == 0)) {
            out.write("var " + paramName + "=Array.prototype.slice.call(arguments" + (paramIndex == 0 ? "" : "," + paramIndex) + ");");
        }
    }

    public IdeDeclaration resolveDeclaration() {
        return this.optTypeRelation == null ? null : this.optTypeRelation.getType().resolveDeclaration();
    }
}

