/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.IOException;
import net.jangaroo.jooc.Ide;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.Type;

public class IdeWithTypeParam
extends Ide {
    private JooSymbol originalIde;
    private JooSymbol symDotLt;
    private Type type;
    private JooSymbol symGt;

    public IdeWithTypeParam(JooSymbol ide, JooSymbol symDotLt, Type type, JooSymbol symGt) {
        super(IdeWithTypeParam.withTypeParam(ide, type));
        this.originalIde = ide;
        this.symDotLt = symDotLt;
        this.type = type;
        this.symGt = symGt;
    }

    private static JooSymbol withTypeParam(JooSymbol ide, Type type) {
        return new JooSymbol(ide.sym, ide.getFileName(), ide.getLine(), ide.getColumn(), ide.getWhitespace(), ide.getText() + "$object", ide.getJooValue());
    }

    protected void generateJsCode(JsWriter out) throws IOException {
        super.generateJsCode(out);
        this.writeTypeParamAsComment(out);
    }

    protected void generateCodeAsExpr(JsWriter out) throws IOException {
        super.generateCodeAsExpr(out);
        this.writeTypeParamAsComment(out);
    }

    protected void generateAsApiCode(JsWriter out) throws IOException {
        out.writeSymbol(this.originalIde);
        this.writeTypeParam(out);
    }

    private void writeTypeParamAsComment(JsWriter out) throws IOException {
        out.beginComment();
        this.writeTypeParam(out);
        out.endComment();
    }

    private void writeTypeParam(JsWriter out) throws IOException {
        out.writeSymbol(this.symDotLt);
        this.type.generateAsApiCode(out);
        out.writeSymbol(this.symGt);
    }
}

