/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.IOException;
import net.jangaroo.jooc.AstNode;
import net.jangaroo.jooc.ClassDeclaration;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.NodeImplBase;
import net.jangaroo.jooc.Scope;

abstract class Declaration
extends NodeImplBase {
    protected JooSymbol[] symModifiers;
    protected JooSymbol[] symInheritedModifiers = new JooSymbol[0];
    protected AstNode parentDeclaration = null;
    protected ClassDeclaration classDeclaration = null;
    private int modifiers = -1;
    protected int allowedModifiers = -1;
    protected static final int MODIFIER_PUBLIC = 1;
    protected static final int MODIFIER_PROTECTED = 2;
    protected static final int MODIFIER_PRIVATE = 4;
    protected static final int MODIFIER_INTERNAL = 8;
    protected static final int MODIFIER_STATIC = 16;
    protected static final int MODIFIER_ABSTRACT = 32;
    protected static final int MODIFIER_FINAL = 64;
    protected static final int MODIFIER_OVERRIDE = 128;
    protected static final int MODIFIER_DYNAMIC = 256;
    protected static final int MODIFIER_NAMESPACE = 512;
    protected static final int MODIFIER_NATIVE = 1024;
    protected static final int MODIFIER_VIRTUAL = 2048;
    protected static final int MODIFIERS_SCOPE = 527;

    public JooSymbol[] getSymModifiers() {
        return this.symModifiers;
    }

    protected Declaration(JooSymbol[] modifiers, int allowedModifiers) {
        this.symModifiers = (JooSymbol[])modifiers.clone();
        this.allowedModifiers = allowedModifiers;
        this.computeModifiers();
    }

    public AstNode getParentDeclaration() {
        return this.parentDeclaration;
    }

    public ClassDeclaration getClassDeclaration() {
        return this.classDeclaration;
    }

    protected void setInheritedModifiers(JooSymbol[] modifiers) {
        this.symInheritedModifiers = (JooSymbol[])modifiers.clone();
        this.computeModifiers();
    }

    protected void computeModifiers() {
        JooSymbol modifier;
        int i$;
        this.modifiers = 0;
        JooSymbol[] arr$ = this.symModifiers;
        int len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            modifier = arr$[i$];
            this.computeModifier(modifier);
        }
        arr$ = this.symInheritedModifiers;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            modifier = arr$[i$];
            this.computeModifier(modifier);
        }
    }

    private void computeModifier(JooSymbol modifier) {
        int flag = this.getModifierFlag(modifier);
        if ((this.allowedModifiers & flag) == 0) {
            throw Jooc.error(modifier, "modifier '" + modifier.getText() + "' not allowed here");
        }
        if ((flag & this.modifiers) != 0) {
            throw Jooc.error(modifier, "duplicate modifier '" + modifier.getText() + "'");
        }
        if ((flag & 0x20F) != 0 && (this.modifiers & 0x20F) != 0) {
            throw Jooc.error(modifier, "duplicate scope modifier '" + modifier.getText() + "'");
        }
        this.modifiers |= flag;
    }

    protected int getModifierFlag(JooSymbol modifier) {
        switch (modifier.sym) {
            case 29: {
                return 1;
            }
            case 28: {
                return 2;
            }
            case 27: {
                return 4;
            }
            case 23: {
                return 8;
            }
            case 100: {
                return modifier.getText().equals("dynamic") ? 256 : (modifier.getText().equals("static") ? 16 : (modifier.getText().equals("final") ? 64 : (modifier.getText().equals("native") ? 1024 : (modifier.getText().equals("override") ? 128 : (modifier.getText().equals("virtual") ? 2048 : 512)))));
            }
        }
        throw Jooc.error(modifier, "internal compiler error: invalid modifier '" + modifier.getText() + "'");
    }

    protected int getModifiers() {
        return this.modifiers;
    }

    public boolean isPublic() {
        return (this.getModifiers() & 1) != 0;
    }

    public boolean isProtected() {
        return (this.getModifiers() & 2) != 0;
    }

    public boolean isPrivate() {
        return (this.getModifiers() & 4) != 0;
    }

    public boolean isOverride() {
        return (this.getModifiers() & 0x80) != 0;
    }

    public boolean isPrivateStatic() {
        return this.isPrivate() && this.isStatic();
    }

    public boolean isStatic() {
        return (this.getModifiers() & 0x10) != 0;
    }

    public boolean isAbstract() {
        return (this.getModifiers() & 0x20) != 0;
    }

    public boolean isFinal() {
        return (this.getModifiers() & 0x40) != 0;
    }

    public boolean isNative() {
        return (this.getModifiers() & 0x400) != 0;
    }

    protected void writeModifiers(JsWriter out) throws IOException {
        JooSymbol[] arr$ = this.symModifiers;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            JooSymbol modifier = arr$[i$];
            out.writeSymbol(modifier);
        }
    }

    public void scope(Scope scope) {
        this.parentDeclaration = scope.getDefiningNode();
        this.classDeclaration = scope.getClassDeclaration();
    }
}

