/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc;

import java.io.IOException;
import net.jangaroo.jooc.AnalyzeContext;
import net.jangaroo.jooc.AstNode;
import net.jangaroo.jooc.Debug;
import net.jangaroo.jooc.Ide;
import net.jangaroo.jooc.IdeDeclaration;
import net.jangaroo.jooc.Initializer;
import net.jangaroo.jooc.JooSymbol;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.JsWriter;
import net.jangaroo.jooc.Scope;
import net.jangaroo.jooc.TypeRelation;
import net.jangaroo.jooc.TypedIdeDeclaration;

abstract class AbstractVariableDeclaration
extends TypedIdeDeclaration {
    JooSymbol optSymConstOrVar;
    Initializer optInitializer;
    AbstractVariableDeclaration optNextVariableDeclaration;
    private boolean hasPreviousVariableDeclaration = false;
    JooSymbol optSymSemicolon;

    protected AbstractVariableDeclaration(JooSymbol[] modifiers, int allowedModifiers, JooSymbol optSymConstOrVar, Ide ide, TypeRelation optTypeRelation, Initializer optInitializer, AbstractVariableDeclaration optNextVariableDeclaration, JooSymbol optSymSemicolon) {
        super(modifiers, allowedModifiers, ide, optTypeRelation);
        this.optSymConstOrVar = optSymConstOrVar;
        this.optInitializer = optInitializer;
        this.optNextVariableDeclaration = optNextVariableDeclaration;
        this.optSymSemicolon = optSymSemicolon;
    }

    public void scope(Scope scope) {
        super.scope(scope);
        if (this.optInitializer != null) {
            this.optInitializer.scope(scope);
        }
        if (this.optNextVariableDeclaration != null) {
            this.optNextVariableDeclaration.scope(scope);
        }
    }

    protected void generateAsApiCode(JsWriter out) throws IOException {
        if (!this.isPrivate()) {
            this.writeModifiers(out);
            out.writeSymbol(this.optSymConstOrVar);
            this.ide.generateCode(out);
            if (this.optTypeRelation != null) {
                this.optTypeRelation.generateCode(out);
            }
            if (this.optInitializer != null) {
                out.writeSymbol(this.optInitializer.symEq);
                this.optInitializer.value.generateCode(out);
            }
            if (this.optNextVariableDeclaration != null) {
                this.optNextVariableDeclaration.generateCode(out);
            }
            if (this.optSymSemicolon != null) {
                out.writeSymbol(this.optSymSemicolon);
            }
        }
    }

    protected void generateJsCode(JsWriter out) throws IOException {
        if (this.hasPreviousVariableDeclaration()) {
            Debug.assertTrue(this.optSymConstOrVar != null && this.optSymConstOrVar.sym == 73, "Additional variable declarations must start with a COMMA.");
            out.writeSymbol(this.optSymConstOrVar);
        } else {
            this.generateStartCode(out);
        }
        this.ide.generateCode(out);
        if (this.optTypeRelation != null) {
            this.optTypeRelation.generateCode(out);
        }
        this.generateInitializerCode(out);
        if (this.optNextVariableDeclaration != null) {
            this.optNextVariableDeclaration.generateCode(out);
        }
        this.generateEndCode(out);
    }

    protected abstract void generateStartCode(JsWriter var1) throws IOException;

    protected void generateInitializerCode(JsWriter out) throws IOException {
        if (this.optInitializer != null) {
            this.optInitializer.generateCode(out);
        }
    }

    protected void generateEndCode(JsWriter out) throws IOException {
        if (this.optSymSemicolon != null) {
            out.writeSymbol(this.optSymSemicolon);
        }
    }

    protected boolean hasPreviousVariableDeclaration() {
        return this.hasPreviousVariableDeclaration;
    }

    protected AbstractVariableDeclaration getPreviousVariableDeclaration() {
        return (AbstractVariableDeclaration)this.parentNode;
    }

    protected AbstractVariableDeclaration getFirstVariableDeclaration() {
        AbstractVariableDeclaration firstVariableDeclaration = this;
        while (firstVariableDeclaration.hasPreviousVariableDeclaration()) {
            firstVariableDeclaration = firstVariableDeclaration.getPreviousVariableDeclaration();
        }
        return firstVariableDeclaration;
    }

    protected int getModifiers() {
        return this.hasPreviousVariableDeclaration() ? this.getFirstVariableDeclaration().getModifiers() : super.getModifiers();
    }

    public boolean isConst() {
        AbstractVariableDeclaration firstVariableDeclaration = this.getFirstVariableDeclaration();
        return firstVariableDeclaration.optSymConstOrVar != null && firstVariableDeclaration.optSymConstOrVar.sym == 7;
    }

    public AstNode analyze(AstNode parentNode, AnalyzeContext context) {
        super.analyze(parentNode, context);
        if (this.optInitializer == null && this.isConst()) {
            throw Jooc.error(this.optSymConstOrVar, "constant must be initialized");
        }
        if (this.optInitializer != null) {
            this.optInitializer.analyze(this, context);
        }
        if (this.optNextVariableDeclaration != null) {
            this.optNextVariableDeclaration.analyze(this, context);
        }
        this.hasPreviousVariableDeclaration = parentNode instanceof AbstractVariableDeclaration;
        return this;
    }

    public IdeDeclaration resolveDeclaration() {
        return this.optTypeRelation == null ? null : this.optTypeRelation.getType().resolveDeclaration();
    }
}

