/* The following code was generated by JFlex 1.4.3 on 4/6/11 2:11 PM */

/*
 * Copyright 2008-2010 CoreMedia AG
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

/*
 * JangarooScript lexical scanner definition for the JFlex scanner generator
 *
 * Author: Andreas Gawecki
 */

/*
From http://livedocs.adobe.com/specs/actionscript/3/as3_specification118.html:

13.1 Lexical

Lexical keywords are removed from the available program namespace during scanning. It is a syntax error to use any of
these names except as indicated by the grammar. Syntactic keywords appear to the lexical scanner as identifier tokens,
but are given special meaning in certain contexts by the parser.

The following list contains all keywords:

as break case catch class const continue default delete do else extends false finally for function if implements import
in instanceof interface internal is new null package private protected public return super switch this throw
true try typeof use var void while with

The following list contains all identifiers that are syntactic keywords:

each get set to namespace include dynamic final native override static

Former Jangaroo keywords:

abstract assert enum final goto namespace override static synchronized throws transient volatile


13.2 Syntactic

Identifiers with special meaning become keywords in certain syntactic contexts:

    * In a for-each-in statement between the 'for' token and the '(' token:
      each
    * In a function definition between the 'function' token and an identifier token:
      get set
    * As the first word of a directive:
      namespace include
    * In an attribute list or wherever an attribute list can be used:
      dynamic final native override static

It is a syntax error to use a syntactic keyword in a context where it is treated as a keyword:

namespace = "hello"
namespace()

In these cases, the grammar requires an identifier after the namespace keyword.


*/

package net.jangaroo.jooc;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4.3
 * on 4/6/11 2:11 PM from the specification file
 * <tt>/home/mohlendo/gitorious/jangaroo-tools/target/checkout/jangaroo-core/jangaroo-compiler/src/main/jflex/net/jangaroo/jooc/joo.flex</tt>
 */
class Scanner extends ScannerBase implements sym, java_cup.runtime.Scanner {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int STRING_DQ = 4;
  public static final int REGEXP_REST = 10;
  public static final int YYINITIAL = 0;
  public static final int REGEXP_FIRST = 8;
  public static final int REGEXP_START = 6;
  public static final int VECTOR_TYPE = 12;
  public static final int STRING_SQ = 2;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6, 6
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\3\1\75\1\0\1\3\1\2\22\0\1\31\1\63\1\32"+
    "\1\0\1\6\1\72\1\66\1\74\1\52\1\53\1\5\1\70\1\57"+
    "\1\15\1\13\1\4\1\10\11\11\1\65\1\56\1\62\1\60\1\61"+
    "\1\64\1\6\4\21\1\14\1\21\24\6\1\16\1\17\1\20\1\71"+
    "\1\6\1\0\1\33\1\35\1\24\1\27\1\30\1\43\1\50\1\41"+
    "\1\22\1\6\1\37\1\25\1\45\1\23\1\42\1\46\1\6\1\36"+
    "\1\34\1\40\1\26\1\51\1\47\1\12\1\44\1\6\1\54\1\67"+
    "\1\55\1\73\53\0\1\6\12\0\1\6\4\0\1\6\5\0\27\6"+
    "\1\0\37\6\1\0\u013f\6\31\0\162\6\4\0\14\6\16\0\5\6"+
    "\11\0\1\6\213\0\1\6\13\0\1\6\1\0\3\6\1\0\1\6"+
    "\1\0\24\6\1\0\54\6\1\0\46\6\1\0\5\6\4\0\202\6"+
    "\10\0\105\6\1\0\46\6\2\0\2\6\6\0\20\6\41\0\46\6"+
    "\2\0\1\6\7\0\47\6\110\0\33\6\5\0\3\6\56\0\32\6"+
    "\5\0\13\6\25\0\12\7\4\0\2\6\1\0\143\6\1\0\1\6"+
    "\17\0\2\6\7\0\2\6\12\7\3\6\2\0\1\6\20\0\1\6"+
    "\1\0\36\6\35\0\3\6\60\0\46\6\13\0\1\6\u0152\0\66\6"+
    "\3\0\1\6\22\0\1\6\7\0\12\6\4\0\12\7\25\0\10\6"+
    "\2\0\2\6\2\0\26\6\1\0\7\6\1\0\1\6\3\0\4\6"+
    "\3\0\1\6\36\0\2\6\1\0\3\6\4\0\12\7\2\6\23\0"+
    "\6\6\4\0\2\6\2\0\26\6\1\0\7\6\1\0\2\6\1\0"+
    "\2\6\1\0\2\6\37\0\4\6\1\0\1\6\7\0\12\7\2\0"+
    "\3\6\20\0\11\6\1\0\3\6\1\0\26\6\1\0\7\6\1\0"+
    "\2\6\1\0\5\6\3\0\1\6\22\0\1\6\17\0\2\6\4\0"+
    "\12\7\25\0\10\6\2\0\2\6\2\0\26\6\1\0\7\6\1\0"+
    "\2\6\1\0\5\6\3\0\1\6\36\0\2\6\1\0\3\6\4\0"+
    "\12\7\1\0\1\6\21\0\1\6\1\0\6\6\3\0\3\6\1\0"+
    "\4\6\3\0\2\6\1\0\1\6\1\0\2\6\3\0\2\6\3\0"+
    "\3\6\3\0\10\6\1\0\3\6\55\0\11\7\25\0\10\6\1\0"+
    "\3\6\1\0\27\6\1\0\12\6\1\0\5\6\46\0\2\6\4\0"+
    "\12\7\25\0\10\6\1\0\3\6\1\0\27\6\1\0\12\6\1\0"+
    "\5\6\3\0\1\6\40\0\1\6\1\0\2\6\4\0\12\7\25\0"+
    "\10\6\1\0\3\6\1\0\27\6\1\0\20\6\46\0\2\6\4\0"+
    "\12\7\25\0\22\6\3\0\30\6\1\0\11\6\1\0\1\6\2\0"+
    "\7\6\72\0\60\6\1\0\2\6\14\0\7\6\11\0\12\7\47\0"+
    "\2\6\1\0\1\6\2\0\2\6\1\0\1\6\2\0\1\6\6\0"+
    "\4\6\1\0\7\6\1\0\3\6\1\0\1\6\1\0\1\6\2\0"+
    "\2\6\1\0\4\6\1\0\2\6\11\0\1\6\2\0\5\6\1\0"+
    "\1\6\11\0\12\7\2\0\2\6\42\0\1\6\37\0\12\7\26\0"+
    "\10\6\1\0\42\6\35\0\4\6\164\0\42\6\1\0\5\6\1\0"+
    "\2\6\25\0\12\7\6\0\6\6\112\0\46\6\12\0\51\6\7\0"+
    "\132\6\5\0\104\6\5\0\122\6\6\0\7\6\1\0\77\6\1\0"+
    "\1\6\1\0\4\6\2\0\7\6\1\0\1\6\1\0\4\6\2\0"+
    "\47\6\1\0\1\6\1\0\4\6\2\0\37\6\1\0\1\6\1\0"+
    "\4\6\2\0\7\6\1\0\1\6\1\0\4\6\2\0\7\6\1\0"+
    "\7\6\1\0\27\6\1\0\37\6\1\0\1\6\1\0\4\6\2\0"+
    "\7\6\1\0\47\6\1\0\23\6\16\0\11\7\56\0\125\6\14\0"+
    "\u026c\6\2\0\10\6\12\0\32\6\5\0\113\6\25\0\15\6\1\0"+
    "\4\6\16\0\22\6\16\0\22\6\16\0\15\6\1\0\3\6\17\0"+
    "\64\6\43\0\1\6\4\0\1\6\3\0\12\7\46\0\12\7\6\0"+
    "\130\6\10\0\51\6\127\0\35\6\51\0\12\7\36\6\2\0\5\6"+
    "\u038b\0\154\6\224\0\234\6\4\0\132\6\6\0\26\6\2\0\6\6"+
    "\2\0\46\6\2\0\6\6\2\0\10\6\1\0\1\6\1\0\1\6"+
    "\1\0\1\6\1\0\37\6\2\0\65\6\1\0\7\6\1\0\1\6"+
    "\3\0\3\6\1\0\7\6\3\0\4\6\2\0\6\6\4\0\15\6"+
    "\5\0\3\6\1\0\7\6\53\0\2\1\107\0\1\6\15\0\1\6"+
    "\202\0\1\6\4\0\1\6\2\0\12\6\1\0\1\6\3\0\5\6"+
    "\6\0\1\6\1\0\1\6\1\0\1\6\1\0\4\6\1\0\3\6"+
    "\1\0\7\6\3\0\3\6\5\0\5\6\u0ebb\0\2\6\52\0\5\6"+
    "\5\0\2\6\4\0\126\6\6\0\3\6\1\0\132\6\1\0\4\6"+
    "\5\0\50\6\4\0\136\6\21\0\30\6\70\0\20\6\u0200\0\u19b6\6"+
    "\112\0\u51a6\6\132\0\u048d\6\u0773\0\u2ba4\6\u215c\0\u012e\6\2\0\73\6"+
    "\225\0\7\6\14\0\5\6\5\0\1\6\1\0\12\6\1\0\15\6"+
    "\1\0\5\6\1\0\1\6\1\0\2\6\1\0\2\6\1\0\154\6"+
    "\41\0\u016b\6\22\0\100\6\2\0\66\6\50\0\14\6\164\0\5\6"+
    "\1\0\207\6\23\0\12\7\7\0\32\6\6\0\32\6\13\0\131\6"+
    "\3\0\6\6\2\0\6\6\2\0\6\6\2\0\3\6\43\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\7\0\1\1\1\2\1\3\1\4\1\5\2\6\1\7"+
    "\1\10\1\11\1\12\6\5\1\13\11\5\1\14\1\15"+
    "\1\16\1\17\1\20\1\21\1\22\1\23\1\24\1\25"+
    "\1\26\1\27\1\30\1\31\1\32\1\33\1\34\1\35"+
    "\1\36\1\37\1\40\1\0\1\41\1\37\1\1\1\42"+
    "\1\43\1\44\1\45\1\46\3\43\1\47\2\43\2\50"+
    "\1\7\1\51\1\2\1\0\1\52\1\53\1\54\1\0"+
    "\1\54\2\0\1\55\1\56\1\57\1\60\1\61\1\62"+
    "\10\5\1\63\2\5\1\64\22\5\1\65\1\66\1\67"+
    "\1\70\1\71\1\72\1\73\1\74\1\75\1\76\1\77"+
    "\1\100\1\101\1\102\1\103\1\104\2\105\1\106\1\107"+
    "\1\105\1\110\1\111\1\112\1\113\1\114\1\115\6\0"+
    "\1\116\1\0\1\117\1\54\1\0\1\120\5\5\1\121"+
    "\4\5\1\122\11\5\1\123\6\5\1\124\6\5\1\125"+
    "\1\5\1\126\1\127\1\130\1\131\1\132\1\133\1\134"+
    "\2\0\5\5\1\135\1\5\1\136\6\5\1\137\4\5"+
    "\1\140\1\141\11\5\1\142\1\5\1\143\1\144\1\145"+
    "\1\0\5\5\1\146\1\147\1\150\4\5\1\151\1\5"+
    "\1\152\1\5\1\153\3\5\1\154\4\5\1\155\5\5"+
    "\1\156\1\5\1\157\2\5\1\160\1\161\1\162\2\5"+
    "\1\163\11\5\1\164\1\165\1\166\1\5\1\167\1\170"+
    "\1\5\1\0\1\5\1\171\2\5\1\172\1\173\1\5"+
    "\1\0\1\5\1\174\1\5\1\175\1\176\1\177\1\200";

  private static int [] zzUnpackAction() {
    int [] result = new int[313];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\76\0\174\0\272\0\370\0\u0136\0\u0174\0\u01b2"+
    "\0\u01b2\0\u01f0\0\u022e\0\u026c\0\u02aa\0\u02e8\0\u0326\0\u0364"+
    "\0\u01b2\0\u01b2\0\u03a2\0\u03e0\0\u041e\0\u045c\0\u049a\0\u04d8"+
    "\0\u01b2\0\u0516\0\u0554\0\u0592\0\u05d0\0\u060e\0\u064c\0\u068a"+
    "\0\u06c8\0\u0706\0\u01b2\0\u01b2\0\u01b2\0\u01b2\0\u01b2\0\u01b2"+
    "\0\u0744\0\u0782\0\u07c0\0\u07fe\0\u01b2\0\u083c\0\u087a\0\u08b8"+
    "\0\u08f6\0\u0934\0\u0972\0\u01b2\0\u01b2\0\u09b0\0\u01b2\0\u09ee"+
    "\0\u01b2\0\u0a2c\0\u09ee\0\u01b2\0\u01b2\0\u01b2\0\u01b2\0\u01b2"+
    "\0\u0a6a\0\u0aa8\0\u0ae6\0\u0b24\0\u0b62\0\u0ba0\0\u01b2\0\u0bde"+
    "\0\u0c1c\0\u01b2\0\u0c5a\0\u0c98\0\u01b2\0\u01b2\0\u0cd6\0\u0d14"+
    "\0\u0d52\0\u0d90\0\u0dce\0\u01b2\0\u01b2\0\u01b2\0\u0e0c\0\u026c"+
    "\0\u026c\0\u0e4a\0\u0e88\0\u0ec6\0\u0f04\0\u0f42\0\u0f80\0\u0fbe"+
    "\0\u0ffc\0\u026c\0\u103a\0\u1078\0\u026c\0\u10b6\0\u10f4\0\u1132"+
    "\0\u1170\0\u11ae\0\u11ec\0\u122a\0\u1268\0\u12a6\0\u12e4\0\u1322"+
    "\0\u1360\0\u139e\0\u13dc\0\u141a\0\u1458\0\u1496\0\u14d4\0\u1512"+
    "\0\u01b2\0\u1550\0\u01b2\0\u158e\0\u15cc\0\u01b2\0\u01b2\0\u01b2"+
    "\0\u160a\0\u01b2\0\u1648\0\u01b2\0\u01b2\0\u01b2\0\u01b2\0\u01b2"+
    "\0\u1686\0\u01b2\0\u01b2\0\u16c4\0\u01b2\0\u01b2\0\u01b2\0\u01b2"+
    "\0\u01b2\0\u01b2\0\u0a6a\0\u1702\0\u0ae6\0\u0b62\0\u0ba0\0\u1740"+
    "\0\u01b2\0\u177e\0\u0d14\0\u17bc\0\u17bc\0\u01b2\0\u17fa\0\u1838"+
    "\0\u1876\0\u18b4\0\u18f2\0\u026c\0\u1930\0\u196e\0\u19ac\0\u19ea"+
    "\0\u026c\0\u1a28\0\u1a66\0\u1aa4\0\u1ae2\0\u1b20\0\u1b5e\0\u1b9c"+
    "\0\u1bda\0\u1c18\0\u026c\0\u1c56\0\u1c94\0\u1cd2\0\u1d10\0\u1d4e"+
    "\0\u1d8c\0\u026c\0\u1dca\0\u1e08\0\u1e46\0\u1e84\0\u1ec2\0\u1f00"+
    "\0\u026c\0\u1f3e\0\u01b2\0\u01b2\0\u1f7c\0\u01b2\0\u01b2\0\u01b2"+
    "\0\u01b2\0\u1fba\0\u1ff8\0\u2036\0\u2074\0\u20b2\0\u20f0\0\u212e"+
    "\0\u026c\0\u216c\0\u026c\0\u21aa\0\u21e8\0\u2226\0\u2264\0\u22a2"+
    "\0\u22e0\0\u026c\0\u231e\0\u235c\0\u239a\0\u23d8\0\u026c\0\u026c"+
    "\0\u2416\0\u2454\0\u2492\0\u24d0\0\u250e\0\u254c\0\u258a\0\u25c8"+
    "\0\u2606\0\u026c\0\u2644\0\u026c\0\u01b2\0\u01b2\0\u1686\0\u2682"+
    "\0\u26c0\0\u26fe\0\u273c\0\u277a\0\u026c\0\u026c\0\u026c\0\u27b8"+
    "\0\u27f6\0\u2834\0\u2872\0\u026c\0\u28b0\0\u026c\0\u28ee\0\u026c"+
    "\0\u292c\0\u296a\0\u29a8\0\u026c\0\u29e6\0\u2a24\0\u2a62\0\u2aa0"+
    "\0\u026c\0\u2ade\0\u2b1c\0\u2b5a\0\u2b98\0\u2bd6\0\u026c\0\u2c14"+
    "\0\u026c\0\u2c52\0\u2c90\0\u026c\0\u026c\0\u026c\0\u2cce\0\u2d0c"+
    "\0\u026c\0\u2d4a\0\u2d88\0\u2dc6\0\u2e04\0\u2e42\0\u2e80\0\u2ebe"+
    "\0\u2efc\0\u2f3a\0\u026c\0\u026c\0\u026c\0\u2f78\0\u026c\0\u026c"+
    "\0\u2fb6\0\u2ff4\0\u3032\0\u026c\0\u3070\0\u30ae\0\u026c\0\u026c"+
    "\0\u30ec\0\u312a\0\u3168\0\u026c\0\u31a6\0\u026c\0\u01b2\0\u026c"+
    "\0\u026c";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[313];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\10\3\11\1\12\1\13\1\14\1\10\1\15\1\16"+
    "\1\14\1\17\1\14\1\20\1\21\1\10\1\22\1\14"+
    "\1\23\1\24\1\25\1\14\1\26\1\27\1\30\1\11"+
    "\1\31\1\32\1\33\1\34\1\35\1\14\1\36\2\14"+
    "\1\37\2\14\1\40\1\41\1\14\1\42\1\43\1\44"+
    "\1\45\1\46\1\47\1\50\1\51\1\52\1\53\1\54"+
    "\1\55\1\56\1\57\1\60\1\61\1\62\1\63\1\64"+
    "\1\65\1\11\2\66\1\67\14\66\1\70\54\66\1\71"+
    "\1\67\2\72\1\67\14\72\1\73\12\72\1\74\42\72"+
    "\1\67\4\75\1\76\71\75\1\77\2\100\1\77\2\75"+
    "\10\77\1\101\1\102\55\77\1\100\1\103\2\100\1\103"+
    "\1\104\11\103\1\105\1\106\55\103\1\100\1\107\3\11"+
    "\1\110\1\107\1\14\3\107\1\14\1\111\1\14\4\107"+
    "\10\14\1\11\1\107\17\14\7\107\1\112\13\107\1\11"+
    "\102\0\1\113\1\114\52\0\1\115\75\0\1\116\23\0"+
    "\5\14\1\0\1\14\4\0\10\14\2\0\17\14\34\0"+
    "\2\117\1\120\1\121\1\122\13\0\1\122\55\0\2\16"+
    "\1\0\1\121\1\122\13\0\1\122\55\0\2\121\1\0"+
    "\1\123\46\0\1\124\30\0\1\125\42\0\1\126\23\0"+
    "\5\14\1\0\1\14\4\0\2\14\1\127\5\14\2\0"+
    "\1\14\1\130\6\14\1\131\1\14\1\132\4\14\32\0"+
    "\5\14\1\0\1\14\4\0\5\14\1\133\1\14\1\134"+
    "\2\0\17\14\32\0\5\14\1\0\1\14\4\0\4\14"+
    "\1\135\3\14\2\0\1\136\6\14\1\137\7\14\32\0"+
    "\5\14\1\0\1\14\4\0\10\14\2\0\1\14\1\140"+
    "\15\14\32\0\5\14\1\0\1\14\4\0\7\14\1\141"+
    "\2\0\7\14\1\142\7\14\32\0\4\14\1\143\1\0"+
    "\1\14\4\0\4\14\1\144\3\14\2\0\17\14\32\0"+
    "\5\14\1\0\1\14\4\0\10\14\2\0\1\14\1\145"+
    "\15\14\32\0\5\14\1\0\1\14\4\0\5\14\1\146"+
    "\2\14\2\0\14\14\1\147\2\14\32\0\5\14\1\0"+
    "\1\14\4\0\10\14\2\0\3\14\1\150\13\14\32\0"+
    "\5\14\1\0\1\14\4\0\7\14\1\151\2\0\17\14"+
    "\32\0\5\14\1\0\1\14\4\0\10\14\2\0\3\14"+
    "\1\152\2\14\1\153\2\14\1\154\5\14\32\0\5\14"+
    "\1\0\1\14\4\0\1\14\1\155\3\14\1\156\2\14"+
    "\2\0\1\157\6\14\1\160\7\14\32\0\5\14\1\0"+
    "\1\14\4\0\5\14\1\161\2\14\2\0\1\162\2\14"+
    "\1\163\13\14\32\0\5\14\1\0\1\14\4\0\1\14"+
    "\1\164\6\14\2\0\6\14\1\165\10\14\32\0\5\14"+
    "\1\0\1\14\4\0\10\14\2\0\1\166\6\14\1\167"+
    "\7\14\104\0\1\170\75\0\1\171\1\172\74\0\1\173"+
    "\1\0\1\174\73\0\1\175\22\0\1\176\57\0\1\177"+
    "\70\0\1\200\5\0\1\201\67\0\1\202\6\0\1\203"+
    "\66\0\1\204\7\0\1\205\65\0\1\206\75\0\1\207"+
    "\15\0\2\66\1\0\14\66\1\0\54\66\2\0\12\210"+
    "\1\211\4\210\1\212\3\210\1\213\2\210\1\214\3\210"+
    "\1\215\2\210\1\216\1\217\1\210\1\220\2\210\1\221"+
    "\30\210\1\222\1\0\2\72\1\0\14\72\1\0\12\72"+
    "\1\0\42\72\1\0\1\223\2\0\14\223\1\224\1\77"+
    "\54\223\1\0\1\77\2\0\72\77\1\0\1\225\2\0"+
    "\1\225\1\104\11\225\1\226\1\227\55\225\7\0\1\104"+
    "\3\0\1\104\1\0\1\104\4\0\10\104\2\0\17\104"+
    "\24\0\1\226\2\0\14\226\1\230\1\225\54\226\1\0"+
    "\1\225\2\0\72\225\5\0\1\113\1\114\152\0\1\231"+
    "\13\0\2\113\1\11\72\113\1\11\5\114\1\232\70\114"+
    "\10\0\2\117\1\0\1\121\1\122\13\0\1\122\55\0"+
    "\2\233\2\0\1\233\4\0\1\233\2\0\1\233\2\0"+
    "\2\233\2\0\1\233\1\0\1\233\5\0\1\233\42\0"+
    "\2\121\2\0\1\122\13\0\1\122\55\0\2\234\3\0"+
    "\1\235\52\0\1\235\20\0\1\236\70\0\5\14\1\0"+
    "\1\14\4\0\3\14\1\237\4\14\2\0\1\14\1\240"+
    "\3\14\1\241\11\14\32\0\5\14\1\0\1\14\4\0"+
    "\10\14\2\0\13\14\1\242\3\14\32\0\5\14\1\0"+
    "\1\14\4\0\4\14\1\243\3\14\2\0\17\14\32\0"+
    "\5\14\1\0\1\14\4\0\10\14\2\0\14\14\1\244"+
    "\2\14\32\0\5\14\1\0\1\14\4\0\10\14\2\0"+
    "\1\245\16\14\32\0\5\14\1\0\1\14\4\0\10\14"+
    "\2\0\1\14\1\246\3\14\1\247\11\14\32\0\5\14"+
    "\1\0\1\14\4\0\2\14\1\250\5\14\2\0\17\14"+
    "\32\0\5\14\1\0\1\14\4\0\7\14\1\251\2\0"+
    "\17\14\32\0\5\14\1\0\1\14\4\0\4\14\1\252"+
    "\3\14\2\0\10\14\1\253\6\14\32\0\5\14\1\0"+
    "\1\14\4\0\10\14\2\0\5\14\1\254\11\14\32\0"+
    "\5\14\1\0\1\14\4\0\10\14\2\0\1\14\1\255"+
    "\15\14\32\0\5\14\1\0\1\14\4\0\10\14\2\0"+
    "\13\14\1\256\3\14\32\0\5\14\1\0\1\14\4\0"+
    "\1\14\1\257\6\14\2\0\17\14\32\0\5\14\1\0"+
    "\1\14\4\0\7\14\1\260\2\0\17\14\32\0\5\14"+
    "\1\0\1\14\4\0\10\14\2\0\5\14\1\261\11\14"+
    "\32\0\5\14\1\0\1\14\4\0\5\14\1\262\2\14"+
    "\2\0\11\14\1\263\5\14\32\0\5\14\1\0\1\14"+
    "\4\0\1\14\1\264\6\14\2\0\3\14\1\265\13\14"+
    "\32\0\5\14\1\0\1\14\4\0\10\14\2\0\13\14"+
    "\1\266\3\14\32\0\5\14\1\0\1\14\4\0\2\14"+
    "\1\267\5\14\2\0\17\14\32\0\5\14\1\0\1\14"+
    "\4\0\2\14\1\270\5\14\2\0\17\14\32\0\5\14"+
    "\1\0\1\14\4\0\4\14\1\271\3\14\2\0\17\14"+
    "\32\0\5\14\1\0\1\14\4\0\10\14\2\0\3\14"+
    "\1\272\13\14\32\0\5\14\1\0\1\14\4\0\10\14"+
    "\2\0\2\14\1\273\14\14\32\0\5\14\1\0\1\14"+
    "\4\0\3\14\1\274\4\14\2\0\17\14\32\0\5\14"+
    "\1\0\1\14\4\0\1\14\1\275\6\14\2\0\7\14"+
    "\1\276\7\14\32\0\5\14\1\0\1\14\4\0\10\14"+
    "\2\0\5\14\1\277\11\14\32\0\5\14\1\0\1\14"+
    "\4\0\1\14\1\300\6\14\2\0\17\14\32\0\5\14"+
    "\1\0\1\14\4\0\10\14\2\0\3\14\1\301\13\14"+
    "\32\0\5\14\1\0\1\14\4\0\1\14\1\302\6\14"+
    "\2\0\17\14\104\0\1\303\75\0\1\304\1\305\74\0"+
    "\1\306\75\0\1\307\75\0\1\310\75\0\1\311\25\0"+
    "\2\312\2\0\1\312\4\0\1\312\2\0\1\312\2\0"+
    "\2\312\2\0\1\312\1\0\1\312\5\0\1\312\42\0"+
    "\2\313\2\0\1\313\4\0\1\313\2\0\1\313\2\0"+
    "\2\313\2\0\1\313\1\0\1\313\5\0\1\313\32\0"+
    "\1\223\2\0\72\223\1\0\1\226\2\0\72\226\1\0"+
    "\4\114\1\11\1\232\70\114\10\0\2\234\72\0\5\14"+
    "\1\0\1\14\4\0\4\14\1\314\3\14\2\0\17\14"+
    "\32\0\5\14\1\0\1\14\4\0\10\14\2\0\5\14"+
    "\1\315\11\14\32\0\5\14\1\0\1\14\4\0\7\14"+
    "\1\316\2\0\17\14\32\0\5\14\1\0\1\14\4\0"+
    "\4\14\1\317\3\14\2\0\7\14\1\320\7\14\32\0"+
    "\5\14\1\0\1\14\4\0\4\14\1\321\3\14\2\0"+
    "\17\14\32\0\5\14\1\0\1\14\4\0\10\14\2\0"+
    "\1\14\1\322\15\14\32\0\5\14\1\0\1\14\4\0"+
    "\7\14\1\323\2\0\17\14\32\0\5\14\1\0\1\14"+
    "\4\0\3\14\1\324\4\14\2\0\17\14\32\0\5\14"+
    "\1\0\1\14\4\0\10\14\2\0\1\14\1\325\3\14"+
    "\1\326\11\14\32\0\5\14\1\0\1\14\4\0\7\14"+
    "\1\327\2\0\17\14\32\0\5\14\1\0\1\14\4\0"+
    "\10\14\2\0\1\330\16\14\32\0\5\14\1\0\1\14"+
    "\4\0\7\14\1\331\2\0\17\14\32\0\5\14\1\0"+
    "\1\14\4\0\7\14\1\332\2\0\17\14\32\0\5\14"+
    "\1\0\1\14\4\0\7\14\1\333\2\0\17\14\32\0"+
    "\5\14\1\0\1\14\4\0\10\14\2\0\5\14\1\334"+
    "\11\14\32\0\5\14\1\0\1\14\4\0\10\14\2\0"+
    "\1\335\16\14\32\0\5\14\1\0\1\14\4\0\5\14"+
    "\1\336\2\14\2\0\17\14\32\0\5\14\1\0\1\14"+
    "\4\0\7\14\1\337\2\0\17\14\32\0\5\14\1\0"+
    "\1\14\4\0\10\14\2\0\1\14\1\340\15\14\32\0"+
    "\5\14\1\0\1\14\4\0\10\14\2\0\7\14\1\341"+
    "\7\14\32\0\5\14\1\0\1\14\4\0\7\14\1\342"+
    "\2\0\17\14\32\0\5\14\1\0\1\14\4\0\10\14"+
    "\2\0\1\343\16\14\32\0\5\14\1\0\1\14\4\0"+
    "\3\14\1\344\4\14\2\0\17\14\32\0\5\14\1\0"+
    "\1\14\4\0\10\14\2\0\1\14\1\345\15\14\32\0"+
    "\5\14\1\0\1\14\4\0\4\14\1\346\3\14\2\0"+
    "\17\14\32\0\5\14\1\0\1\14\4\0\10\14\2\0"+
    "\4\14\1\347\12\14\32\0\5\14\1\0\1\14\4\0"+
    "\10\14\2\0\16\14\1\350\32\0\5\14\1\0\1\14"+
    "\4\0\10\14\2\0\5\14\1\351\11\14\32\0\5\14"+
    "\1\0\1\14\4\0\10\14\2\0\6\14\1\352\10\14"+
    "\32\0\5\14\1\0\1\14\4\0\4\14\1\353\3\14"+
    "\2\0\17\14\32\0\5\14\1\0\1\14\4\0\6\14"+
    "\1\354\1\14\2\0\17\14\104\0\1\355\25\0\2\356"+
    "\2\0\1\356\4\0\1\356\2\0\1\356\2\0\2\356"+
    "\2\0\1\356\1\0\1\356\5\0\1\356\42\0\2\357"+
    "\2\0\1\357\4\0\1\357\2\0\1\357\2\0\2\357"+
    "\2\0\1\357\1\0\1\357\5\0\1\357\40\0\5\14"+
    "\1\0\1\14\4\0\5\14\1\360\2\14\2\0\17\14"+
    "\32\0\5\14\1\0\1\14\4\0\10\14\2\0\1\361"+
    "\16\14\32\0\5\14\1\0\1\14\4\0\10\14\2\0"+
    "\3\14\1\362\13\14\32\0\5\14\1\0\1\14\4\0"+
    "\7\14\1\363\2\0\17\14\32\0\5\14\1\0\1\14"+
    "\4\0\10\14\2\0\3\14\1\364\13\14\32\0\5\14"+
    "\1\0\1\14\4\0\10\14\2\0\1\14\1\365\15\14"+
    "\32\0\5\14\1\0\1\14\4\0\10\14\2\0\6\14"+
    "\1\366\10\14\32\0\5\14\1\0\1\14\4\0\10\14"+
    "\2\0\5\14\1\367\11\14\32\0\5\14\1\0\1\14"+
    "\4\0\1\14\1\370\6\14\2\0\17\14\32\0\5\14"+
    "\1\0\1\14\4\0\10\14\2\0\5\14\1\371\11\14"+
    "\32\0\5\14\1\0\1\14\4\0\5\14\1\372\2\14"+
    "\2\0\17\14\32\0\5\14\1\0\1\14\4\0\2\14"+
    "\1\373\5\14\2\0\17\14\32\0\5\14\1\0\1\14"+
    "\4\0\10\14\2\0\3\14\1\374\13\14\32\0\5\14"+
    "\1\0\1\14\4\0\3\14\1\375\4\14\2\0\17\14"+
    "\32\0\5\14\1\0\1\14\4\0\10\14\2\0\4\14"+
    "\1\376\12\14\32\0\5\14\1\0\1\14\4\0\10\14"+
    "\2\0\3\14\1\377\13\14\32\0\5\14\1\0\1\14"+
    "\4\0\10\14\2\0\14\14\1\u0100\2\14\32\0\5\14"+
    "\1\0\1\14\4\0\10\14\2\0\7\14\1\u0101\7\14"+
    "\32\0\5\14\1\0\1\14\4\0\4\14\1\u0102\3\14"+
    "\2\0\17\14\32\0\5\14\1\0\1\14\4\0\10\14"+
    "\2\0\5\14\1\u0103\11\14\32\0\5\14\1\0\1\14"+
    "\4\0\7\14\1\u0104\2\0\17\14\32\0\5\14\1\0"+
    "\1\14\4\0\1\14\1\u0105\6\14\2\0\17\14\32\0"+
    "\5\14\1\0\1\14\4\0\10\14\2\0\1\u0106\16\14"+
    "\32\0\5\14\1\0\1\14\4\0\10\14\2\0\1\u0107"+
    "\16\14\32\0\5\14\1\0\1\14\4\0\7\14\1\u0108"+
    "\2\0\17\14\32\0\5\14\1\0\1\14\4\0\7\14"+
    "\1\u0109\2\0\17\14\32\0\5\14\1\0\1\14\4\0"+
    "\6\14\1\u010a\1\14\2\0\17\14\32\0\5\14\1\0"+
    "\1\14\4\0\2\14\1\u010b\5\14\2\0\17\14\32\0"+
    "\5\14\1\0\1\14\4\0\2\14\1\u010c\5\14\2\0"+
    "\10\14\1\u010d\6\14\32\0\5\14\1\0\1\14\4\0"+
    "\10\14\2\0\12\14\1\u010e\4\14\32\0\5\14\1\0"+
    "\1\14\4\0\10\14\2\0\5\14\1\u010f\11\14\32\0"+
    "\5\14\1\0\1\14\4\0\2\14\1\u0110\5\14\2\0"+
    "\17\14\32\0\5\14\1\0\1\14\4\0\7\14\1\u0111"+
    "\2\0\17\14\32\0\5\14\1\0\1\14\4\0\4\14"+
    "\1\u0112\3\14\2\0\17\14\32\0\5\14\1\0\1\14"+
    "\4\0\6\14\1\u0113\1\14\2\0\17\14\32\0\5\14"+
    "\1\0\1\14\4\0\10\14\2\0\6\14\1\u0114\10\14"+
    "\32\0\5\14\1\0\1\14\4\0\2\14\1\u0115\5\14"+
    "\2\0\17\14\32\0\5\14\1\0\1\14\4\0\10\14"+
    "\2\0\10\14\1\u0116\6\14\32\0\5\14\1\0\1\14"+
    "\4\0\4\14\1\u0117\3\14\2\0\17\14\32\0\5\14"+
    "\1\0\1\14\4\0\1\14\1\u0118\6\14\2\0\17\14"+
    "\32\0\5\14\1\0\1\14\4\0\3\14\1\u0119\4\14"+
    "\2\0\17\14\32\0\5\14\1\0\1\14\4\0\10\14"+
    "\2\0\15\14\1\u011a\1\14\32\0\5\14\1\0\1\14"+
    "\4\0\10\14\2\0\5\14\1\u011b\11\14\32\0\5\14"+
    "\1\0\1\14\4\0\3\14\1\u011c\4\14\2\0\17\14"+
    "\32\0\5\14\1\0\1\14\4\0\7\14\1\u011d\2\0"+
    "\17\14\32\0\5\14\1\0\1\14\4\0\3\14\1\u011e"+
    "\4\14\2\0\17\14\32\0\5\14\1\0\1\14\4\0"+
    "\10\14\2\0\1\u011f\16\14\32\0\5\14\1\0\1\14"+
    "\4\0\10\14\2\0\1\u0120\16\14\32\0\5\14\1\0"+
    "\1\14\4\0\7\14\1\u0121\2\0\17\14\32\0\5\14"+
    "\1\0\1\14\4\0\5\14\1\u0122\2\14\2\0\17\14"+
    "\32\0\5\14\1\0\1\14\4\0\10\14\2\0\5\14"+
    "\1\u0123\11\14\32\0\5\14\1\0\1\14\4\0\10\14"+
    "\2\0\1\14\1\u0124\15\14\32\0\5\14\1\0\1\14"+
    "\4\0\10\14\2\0\11\14\1\u0125\5\14\32\0\5\14"+
    "\1\0\1\14\4\0\10\14\2\0\7\14\1\u0126\7\14"+
    "\32\0\5\14\1\0\1\14\4\0\7\14\1\u0127\2\0"+
    "\17\14\32\0\5\14\1\0\1\14\4\0\7\14\1\u0128"+
    "\2\0\17\14\32\0\5\14\1\0\1\14\4\0\10\14"+
    "\2\0\5\14\1\u0129\11\14\32\0\5\14\1\0\1\14"+
    "\4\0\10\14\1\u012a\1\0\17\14\32\0\5\14\1\0"+
    "\1\14\4\0\7\14\1\u012b\2\0\17\14\32\0\5\14"+
    "\1\0\1\14\4\0\4\14\1\u012c\3\14\2\0\17\14"+
    "\32\0\5\14\1\0\1\14\4\0\3\14\1\u012d\4\14"+
    "\2\0\17\14\32\0\5\14\1\0\1\14\4\0\2\14"+
    "\1\u012e\5\14\2\0\17\14\32\0\5\14\1\0\1\14"+
    "\4\0\7\14\1\u012f\2\0\17\14\32\0\5\14\1\0"+
    "\1\14\4\0\2\14\1\u0130\5\14\2\0\17\14\32\0"+
    "\5\14\1\0\1\14\4\0\7\14\1\u0131\2\0\17\14"+
    "\56\0\1\u0132\51\0\5\14\1\0\1\14\4\0\10\14"+
    "\2\0\7\14\1\u0133\7\14\32\0\5\14\1\0\1\14"+
    "\4\0\7\14\1\u0134\2\0\17\14\32\0\5\14\1\0"+
    "\1\14\4\0\10\14\2\0\5\14\1\u0135\11\14\32\0"+
    "\5\14\1\0\1\14\4\0\6\14\1\u0136\1\14\2\0"+
    "\17\14\24\0\32\u0132\1\u0137\43\u0132\6\0\5\14\1\0"+
    "\1\14\4\0\10\14\2\0\10\14\1\u0138\6\14\32\0"+
    "\5\14\1\0\1\14\4\0\10\14\2\0\1\14\1\u0139"+
    "\15\14\24\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[12772];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\7\0\2\11\7\1\2\11\6\1\1\11\11\1\6\11"+
    "\4\1\1\11\6\1\2\11\1\1\1\11\1\0\1\11"+
    "\2\1\5\11\6\1\1\11\2\1\1\11\1\1\1\0"+
    "\2\11\1\1\1\0\1\1\2\0\3\11\42\1\1\11"+
    "\1\1\1\11\2\1\3\11\1\1\1\11\1\1\5\11"+
    "\1\1\2\11\1\1\6\11\6\0\1\11\1\0\2\1"+
    "\1\0\1\11\44\1\2\11\1\1\4\11\2\0\41\1"+
    "\2\11\1\0\72\1\1\0\7\1\1\0\4\1\1\11"+
    "\2\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[313];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;
  
  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /** the stack of open (nested) input streams to read from */
  private java.util.Stack zzStreams = new java.util.Stack();

  /**
   * inner class used to store info for nested
   * input streams
   */
  private static final class ZzFlexStreamInfo {
    java.io.Reader zzReader;
    int zzEndRead;
    int zzStartRead;
    int zzCurrentPos;
    int zzMarkedPos;
    int yyline;
    int yycolumn;
    char [] zzBuffer;
    boolean zzAtEOF;
    boolean zzEOFDone;

    /** sets all values stored in this class */
    ZzFlexStreamInfo(java.io.Reader zzReader, int zzEndRead, int zzStartRead,
                  int zzCurrentPos, int zzMarkedPos, 
                  char [] zzBuffer, boolean zzAtEOF, boolean zzEOFDone, int yyline, int yycolumn) {
      this.zzReader      = zzReader;
      this.zzEndRead     = zzEndRead;
      this.zzStartRead   = zzStartRead;
      this.zzCurrentPos  = zzCurrentPos;
      this.zzMarkedPos   = zzMarkedPos;
      this.zzBuffer      = zzBuffer;
      this.zzAtEOF       = zzAtEOF;
      this.zzEOFDone     = zzEOFDone;
      this.yyline         = yyline;
      this.yycolumn       = yycolumn;
    }
  }

  /* user code: */

  protected JooSymbol symbol(int sym) {
    JooSymbol result = new JooSymbol(sym, fileName, yyline + 1, yycolumn + 1, whitespace, yytext());
    whitespace = "";
    return result;
  }

  protected JooSymbol symbol(int sym, Object value) {
    JooSymbol result = new JooSymbol(sym, fileName, yyline + 1, yycolumn + 1, whitespace, yytext(), value);
    whitespace = "";
    return result;
  }

  protected JooSymbol multiStateSymbol(int sym, Object value) {
    JooSymbol result = new JooSymbol(sym, fileName, yyline + 1, yycolumn + 1, whitespace, multiStateText, value);
    whitespace = "";
    return result;
  }

  protected void startRegexp(JooSymbol regexpStart) {
    multiStateText = "";
    string.setLength(0);
    whitespace = regexpStart.getWhitespace();
    assert(regexpStart.sym == sym.DIV || regexpStart.sym == sym.DIVEQ);
    pushback(regexpStart.sym == sym.DIVEQ ? 2 : 1);
    yybegin(REGEXP_START);
  }

  // workaround for bug in jflex column counting, works only if no newline is in these n characters 
  private void pushback(int n) {
    yypushback(n);
    yycolumn -= n;
  }



  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  Scanner(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  Scanner(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 1318) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }
    
    // numRead < 0) 
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Stores the current input stream on a stack, and
   * reads from a new stream. Lexical state, line,
   * char, and column counting remain untouched.
   *
   * The current input stream can be restored with
   * yypopstream (usually in an <<EOF>> action).
   *
   * @param reader the new input stream to read from
   *
   * @see #yypopStream()
   */
  public final void yypushStream(java.io.Reader reader) {
    zzStreams.push(
      new ZzFlexStreamInfo(zzReader, zzEndRead, zzStartRead, zzCurrentPos,
                        zzMarkedPos, zzBuffer, zzAtEOF, zzEOFDone,
                        yyline, yycolumn)
    );
    zzAtEOF  = false;
    zzBuffer = new char[ZZ_BUFFERSIZE];
    zzReader = reader;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yycolumn = 0;
  }
    

  /**
   * Closes the current input stream and continues to
   * read from the one on top of the stream stack. 
   *
   * @throws java.util.EmptyStackException
   *         if there is no further stream to read from.
   *
   * @throws java.io.IOException
   *         if there was an error in closing the stream.
   *
   * @see #yypushStream(java.io.Reader)
   */
  public final void yypopStream() throws java.io.IOException {
    zzReader.close();
    ZzFlexStreamInfo s = (ZzFlexStreamInfo) zzStreams.pop();
    zzBuffer      = s.zzBuffer;
    zzReader      = s.zzReader;
    zzEndRead     = s.zzEndRead;
    zzStartRead   = s.zzStartRead;
    zzCurrentPos  = s.zzCurrentPos;
    zzMarkedPos   = s.zzMarkedPos ;
    zzAtEOF       = s.zzAtEOF;
    zzEOFDone     = s.zzEOFDone;
    yyline         = s.yyline;
    yycolumn       = s.yycolumn;
  }


  /**
   * Returns true iff there are still streams left 
   * to read from on the stream stack.
   */
  public final boolean yymoreStreams() {
    return !zzStreams.isEmpty();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   *
   * @see #yypushStream(java.io.Reader)
   * @see #yypopStream()
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() throws java.io.IOException {
    if (!zzEOFDone) {
      zzEOFDone = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public java_cup.runtime.Symbol scan() throws java.io.IOException {
    int zzInput;
    int zzAction;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      // cached fields:
      int zzCurrentPosL;
      int zzMarkedPosL = zzMarkedPos;
      int zzEndReadL = zzEndRead;
      char [] zzBufferL = zzBuffer;
      char [] zzCMapL = ZZ_CMAP;

      boolean zzR = false;
      for (zzCurrentPosL = zzStartRead; zzCurrentPosL < zzMarkedPosL;
                                                             zzCurrentPosL++) {
        switch (zzBufferL[zzCurrentPosL]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn++;
        }
      }

      if (zzR) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof) 
            zzPeek = false;
          else 
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          int zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 54: 
          { return symbol(GTEQ);
          }
        case 129: break;
        case 27: 
          { return symbol(XOR);
          }
        case 130: break;
        case 19: 
          { return symbol(GT);
          }
        case 131: break;
        case 96: 
          { return symbol(BOOL_LITERAL, new Boolean(true));
          }
        case 132: break;
        case 85: 
          { return symbol(VAR);
          }
        case 133: break;
        case 5: 
          { return symbol(IDE, yytext());
          }
        case 134: break;
        case 58: 
          { return symbol(NOTEQ);
          }
        case 135: break;
        case 14: 
          { return symbol(LBRACE);
          }
        case 136: break;
        case 18: 
          { return symbol(EQ);
          }
        case 137: break;
        case 46: 
          { return symbol(MINUSMINUS);
          }
        case 138: break;
        case 93: 
          { return symbol(NULL_LITERAL, null);
          }
        case 139: break;
        case 122: 
          { return symbol(CONTINUE);
          }
        case 140: break;
        case 82: 
          { return symbol(USE);
          }
        case 141: break;
        case 51: 
          { return symbol(DO);
          }
        case 142: break;
        case 74: 
          { multiStateText += yytext(); string.append( '\r' );
          }
        case 143: break;
        case 49: 
          { return symbol(IS);
          }
        case 144: break;
        case 66: 
          { return symbol(PLUSPLUS);
          }
        case 145: break;
        case 73: 
          { multiStateText += yytext(); string.append( '\b' );
          }
        case 146: break;
        case 37: 
          { multiStateText += yytext(); string.append(yytext()); yybegin(REGEXP_REST);
          }
        case 147: break;
        case 20: 
          { return symbol(LT);
          }
        case 148: break;
        case 117: 
          { return symbol(EXTENDS);
          }
        case 149: break;
        case 91: 
          { return symbol(ANDANDEQ);
          }
        case 150: break;
        case 61: 
          { return symbol(ANDEQ);
          }
        case 151: break;
        case 115: 
          { return symbol(PUBLIC);
          }
        case 152: break;
        case 72: 
          { multiStateText += yytext(); string.append( '\"' );
          }
        case 153: break;
        case 68: 
          { return symbol(MODEQ);
          }
        case 154: break;
        case 77: 
          { multiStateText += yytext(); string.append( '\'' );
          }
        case 155: break;
        case 2: 
          { whitespace += yytext();
          }
        case 156: break;
        case 70: 
          { multiStateText += yytext(); string.append( '\\' );
          }
        case 157: break;
        case 107: 
          { return symbol(THROW);
          }
        case 158: break;
        case 48: 
          { return symbol(IN);
          }
        case 159: break;
        case 31: 
          { multiStateText += yytext(); string.append( yytext() );
          }
        case 160: break;
        case 53: 
          { return symbol(EQEQ);
          }
        case 161: break;
        case 128: 
          { return symbol(IMPLEMENTS);
          }
        case 162: break;
        case 98: 
          { return symbol(WITH);
          }
        case 163: break;
        case 35: 
          { error("invalid regular expression literal");
          }
        case 164: break;
        case 108: 
          { return symbol(BOOL_LITERAL, new Boolean(false));
          }
        case 165: break;
        case 25: 
          { return symbol(OR);
          }
        case 166: break;
        case 26: 
          { return symbol(PLUS);
          }
        case 167: break;
        case 13: 
          { return symbol(RPAREN);
          }
        case 168: break;
        case 104: 
          { return symbol(CONST);
          }
        case 169: break;
        case 38: 
          { error("unterminated regular expression at end of line");
          }
        case 170: break;
        case 55: 
          { return symbol(RSHIFT);
          }
        case 171: break;
        case 102: 
          { return symbol(CLASS);
          }
        case 172: break;
        case 97: 
          { return symbol(THIS);
          }
        case 173: break;
        case 76: 
          { multiStateText += yytext(); string.append( '\f' );
          }
        case 174: break;
        case 11: 
          { multiStateText = yytext(); yybegin(STRING_DQ); string.setLength(0);
          }
        case 175: break;
        case 43: 
          { return symbol(MULTEQ);
          }
        case 176: break;
        case 120: 
          { return symbol(PRIVATE);
          }
        case 177: break;
        case 60: 
          { return symbol(NAMESPACESEP);
          }
        case 178: break;
        case 88: 
          { return symbol(URSHIFT);
          }
        case 179: break;
        case 40: 
          { error("invalid Vector type");
          }
        case 180: break;
        case 118: 
          { return symbol(FINALLY);
          }
        case 181: break;
        case 100: 
          { return symbol(URSHIFTEQ);
          }
        case 182: break;
        case 84: 
          { return symbol(FOR);
          }
        case 183: break;
        case 4: 
          { return symbol(MUL);
          }
        case 184: break;
        case 41: 
          { if (--vectorNestingLevel == 0) { yybegin(YYINITIAL); } return symbol(GT);
          }
        case 185: break;
        case 81: 
          { return symbol(NEW);
          }
        case 186: break;
        case 42: 
          { return symbol(DIVEQ);
          }
        case 187: break;
        case 33: 
          { multiStateText += yytext(); yybegin(YYINITIAL); return multiStateSymbol(STRING_LITERAL, string.toString());
          }
        case 188: break;
        case 116: 
          { return symbol(DEFAULT);
          }
        case 189: break;
        case 22: 
          { return symbol(QUESTION);
          }
        case 190: break;
        case 3: 
          { return symbol(DIV);
          }
        case 191: break;
        case 50: 
          { return symbol(IF);
          }
        case 192: break;
        case 6: 
          { return symbol(INT_LITERAL, new Long(yytext()));
          }
        case 193: break;
        case 126: 
          { yypushStream(createIncludeReader(yytext()));
          }
        case 194: break;
        case 119: 
          { return symbol(PACKAGE);
          }
        case 195: break;
        case 78: 
          { ++vectorNestingLevel; return symbol(DOTLT);
          }
        case 196: break;
        case 67: 
          { return symbol(XOREQ);
          }
        case 197: break;
        case 39: 
          { multiStateText += yytext();
                                    string.append(yytext());
                                    yybegin(YYINITIAL);
                                    return multiStateSymbol(REGEXP_LITERAL, string.toString());
          }
        case 198: break;
        case 112: 
          { return symbol(SWITCH);
          }
        case 199: break;
        case 89: 
          { return symbol(LSHIFTEQ);
          }
        case 200: break;
        case 28: 
          { return symbol(MOD);
          }
        case 201: break;
        case 12: 
          { return symbol(LPAREN);
          }
        case 202: break;
        case 57: 
          { return symbol(LSHIFT);
          }
        case 203: break;
        case 106: 
          { return symbol(BREAK);
          }
        case 204: break;
        case 47: 
          { return symbol(MINUSEQ);
          }
        case 205: break;
        case 92: 
          { return symbol(OROREQ);
          }
        case 206: break;
        case 32: 
          { error("Unterminated string at end of line");
          }
        case 207: break;
        case 111: 
          { return symbol(DELETE);
          }
        case 208: break;
        case 83: 
          { return symbol(TRY);
          }
        case 209: break;
        case 63: 
          { return symbol(OREQ);
          }
        case 210: break;
        case 44: 
          { return symbol(FLOAT_LITERAL, new Double(yytext()));
          }
        case 211: break;
        case 127: 
          { return symbol(INSTANCEOF);
          }
        case 212: break;
        case 10: 
          { return symbol(RBRACK);
          }
        case 213: break;
        case 16: 
          { return symbol(SEMICOLON);
          }
        case 214: break;
        case 36: 
          { multiStateText += yytext(); string.append(yytext()); yybegin(REGEXP_FIRST);
          }
        case 215: break;
        case 110: 
          { return symbol(IMPORT);
          }
        case 216: break;
        case 59: 
          { return symbol(ANYTYPE);
          }
        case 217: break;
        case 105: 
          { return symbol(SUPER);
          }
        case 218: break;
        case 94: 
          { return symbol(CASE);
          }
        case 219: break;
        case 90: 
          { return symbol(NOTEQEQ);
          }
        case 220: break;
        case 8: 
          { return symbol(MINUS);
          }
        case 221: break;
        case 75: 
          { multiStateText += yytext(); string.append( '\t' );
          }
        case 222: break;
        case 7: 
          { return symbol(DOT);
          }
        case 223: break;
        case 34: 
          { multiStateText += yytext(); yybegin(YYINITIAL);
                                    return multiStateSymbol(STRING_LITERAL, string.toString());
          }
        case 224: break;
        case 87: 
          { return symbol(RSHIFTEQ);
          }
        case 225: break;
        case 125: 
          { return symbol(PROTECTED);
          }
        case 226: break;
        case 24: 
          { return symbol(AND);
          }
        case 227: break;
        case 30: 
          { multiStateText = yytext(); yybegin(STRING_SQ); string.setLength(0);
          }
        case 228: break;
        case 86: 
          { return symbol(EQEQEQ);
          }
        case 229: break;
        case 23: 
          { return symbol(COLON);
          }
        case 230: break;
        case 56: 
          { return symbol(LTEQ);
          }
        case 231: break;
        case 79: 
          { return symbol(INT_LITERAL, Long.parseLong(yytext().substring(2),16));
          }
        case 232: break;
        case 123: 
          { return symbol(FUNCTION);
          }
        case 233: break;
        case 99: 
          { return symbol(VOID);
          }
        case 234: break;
        case 29: 
          { return symbol(BITNOT);
          }
        case 235: break;
        case 45: 
          { ++vectorNestingLevel; yybegin(VECTOR_TYPE); return symbol(DOTLT);
          }
        case 236: break;
        case 80: 
          { return symbol(REST);
          }
        case 237: break;
        case 21: 
          { return symbol(NOT);
          }
        case 238: break;
        case 15: 
          { return symbol(RBRACE);
          }
        case 239: break;
        case 71: 
          { multiStateText += yytext(); string.append( '\n' );
          }
        case 240: break;
        case 101: 
          { multiStateText += yytext();
                                   char val = (char) Integer.parseInt(yytext().substring(2),16);
                        	   string.append(val);
          }
        case 241: break;
        case 9: 
          { return symbol(LBRACK);
          }
        case 242: break;
        case 69: 
          { multiStateText += yytext(); string.append(yytext().substring(1));
          }
        case 243: break;
        case 64: 
          { return symbol(OROR);
          }
        case 244: break;
        case 52: 
          { return symbol(AS);
          }
        case 245: break;
        case 124: 
          { return symbol(INTERFACE);
          }
        case 246: break;
        case 114: 
          { return symbol(TYPEOF);
          }
        case 247: break;
        case 62: 
          { return symbol(ANDAND);
          }
        case 248: break;
        case 109: 
          { return symbol(WHILE);
          }
        case 249: break;
        case 121: 
          { return symbol(INTERNAL);
          }
        case 250: break;
        case 65: 
          { return symbol(PLUSEQ);
          }
        case 251: break;
        case 95: 
          { return symbol(ELSE);
          }
        case 252: break;
        case 103: 
          { return symbol(CATCH);
          }
        case 253: break;
        case 17: 
          { return symbol(COMMA);
          }
        case 254: break;
        case 1: 
          { error("unrecognized input token");
          }
        case 255: break;
        case 113: 
          { return symbol(RETURN);
          }
        case 256: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
              {
                if (yymoreStreams()) yypopStream(); else return symbol(EOF);
              }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
