/*
 * Decompiled with CFR 0.152.
 */
package net.jangaroo.jooc.ant;

import java.io.File;
import java.util.Vector;
import net.jangaroo.jooc.Jooc;
import net.jangaroo.jooc.ant.AntCompileLog;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class JoocTask
extends MatchingTask {
    private static final String FAIL_MSG = "Compile failed; see the compiler error output for details.";
    private Path src;
    private String classpath;
    private File destDir;
    private String sourcepath;
    private File apiDestDir;
    private boolean debug = false;
    private String debugLevel = null;
    private boolean enableAssertions = false;
    private boolean verbose = false;
    protected boolean failOnError = true;
    private boolean allowduplicatelocalvariables;
    protected File[] compileList = new File[0];
    private String autoSemicolon = null;

    public boolean getEnableassertions() {
        return this.enableAssertions;
    }

    public void setEnableassertions(boolean enableAssertions) {
        this.enableAssertions = enableAssertions;
    }

    public File getApiDestDir() {
        return this.apiDestDir;
    }

    public void setApiDestDir(File apiDestDir) {
        this.apiDestDir = apiDestDir;
    }

    public Path createSrc() {
        if (this.src == null) {
            this.src = new Path(this.getProject());
        }
        return this.src.createPath();
    }

    protected Path recreateSrc() {
        this.src = null;
        return this.createSrc();
    }

    public void setSrcdir(Path srcDir) {
        if (this.src == null) {
            this.src = srcDir;
        } else {
            this.src.append(srcDir);
        }
    }

    public Path getSrcdir() {
        return this.src;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public File getDestdir() {
        return this.destDir;
    }

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public boolean getFailonerror() {
        return this.failOnError;
    }

    public boolean isAllowduplicatelocalvariables() {
        return this.allowduplicatelocalvariables;
    }

    public void setAllowduplicatelocalvariables(boolean allowduplicatelocalvariables) {
        this.allowduplicatelocalvariables = allowduplicatelocalvariables;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public String getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebugLevel(String debugLevel) {
        this.debugLevel = debugLevel;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public String getAutoSemicolon() {
        return this.autoSemicolon;
    }

    public void setAutoSemicolon(String autoSemicolon) {
        this.autoSemicolon = autoSemicolon;
    }

    public void execute() throws BuildException {
        String[] list;
        this.checkParameters();
        this.resetFileLists();
        this.sourcepath = "";
        String[] arr$ = list = this.src.list();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String aList = arr$[i$];
            File srcDir = this.getProject().resolveFile(aList);
            if (!srcDir.exists()) {
                throw new BuildException("srcdir \"" + srcDir.getPath() + "\" does not exist!", this.getLocation());
            }
            if (!this.sourcepath.isEmpty()) {
                this.sourcepath = this.sourcepath + File.pathSeparator;
            }
            this.sourcepath = this.sourcepath + srcDir.getAbsolutePath();
            DirectoryScanner ds = this.getDirectoryScanner(srcDir);
            String[] files = ds.getIncludedFiles();
            this.scanDir(srcDir, this.destDir != null ? this.destDir : srcDir, files);
        }
        this.compile();
    }

    protected void resetFileLists() {
        this.compileList = new File[0];
    }

    protected void scanDir(File srcDir, File destDir, String[] files) {
        GlobPatternMapper m = new GlobPatternMapper();
        m.setFrom("*.as");
        m.setTo("*.js");
        SourceFileScanner sfs = new SourceFileScanner(this);
        File[] newFiles = sfs.restrictAsFiles(files, srcDir, destDir, m);
        if (newFiles.length > 0) {
            File[] newCompileList = new File[this.compileList.length + newFiles.length];
            System.arraycopy(this.compileList, 0, newCompileList, 0, this.compileList.length);
            System.arraycopy(newFiles, 0, newCompileList, this.compileList.length, newFiles.length);
            this.compileList = newCompileList;
        }
    }

    public File[] getFileList() {
        return this.compileList;
    }

    protected void checkParameters() throws BuildException {
        if (this.src == null) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.src.size() == 0) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.destDir != null && !this.destDir.isDirectory()) {
            throw new BuildException("destination directory \"" + this.destDir + "\" does not exist " + "or is not a directory", this.getLocation());
        }
    }

    protected void compile() {
        if (this.compileList.length > 0) {
            this.log("Compiling " + this.compileList.length + " joo source file" + (this.compileList.length == 1 ? "" : "s") + (this.destDir != null ? " to " + this.destDir : ""));
            String[] joocArgs = this.getJoocArgs();
            Jooc jooc = new Jooc(new AntCompileLog(this.getProject()));
            this.log("configured AntCompileLog");
            if (this.verbose) {
                StringBuffer cmdLine = new StringBuffer(100);
                cmdLine.append("jooc ");
                String[] arr$ = joocArgs;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String joocArg = arr$[i$];
                    cmdLine.append(" ");
                    cmdLine.append(joocArg);
                }
                this.getProject().log(cmdLine.toString());
            }
            if (jooc.run(joocArgs) != 0) {
                if (this.failOnError) {
                    throw new BuildException(FAIL_MSG, this.getLocation());
                }
                this.log(FAIL_MSG, 0);
            }
        } else {
            this.log("no *.as files to compile");
        }
    }

    protected String[] getJoocArgs() {
        Vector<String> args = new Vector<String>(this.compileList.length + 10);
        if (this.debug) {
            args.add("-g");
            if (this.debugLevel != null) {
                args.add(this.debugLevel);
            }
        }
        if (this.autoSemicolon != null) {
            args.add("-autosemicolon");
            args.add(this.autoSemicolon);
        }
        if (this.verbose) {
            args.add("-v");
        }
        if (this.enableAssertions) {
            args.add("-ea");
        }
        if (this.allowduplicatelocalvariables) {
            args.add("-ad");
        }
        if (this.destDir != null) {
            args.add("-d");
            args.add(this.destDir.getAbsolutePath());
        }
        if (this.apiDestDir != null) {
            args.add("-api");
            args.add(this.apiDestDir.getAbsolutePath());
        }
        args.add("-sourcepath");
        args.add(this.sourcepath);
        if (this.classpath != null && !this.classpath.isEmpty()) {
            args.add("-classpath");
            args.add(this.classpath);
        }
        File[] arr$ = this.compileList;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            File aCompileList = arr$[i$];
            String filename = aCompileList.getAbsolutePath();
            args.add(filename);
        }
        return args.toArray(new String[args.size()]);
    }
}

